/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.cegar;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;
import de.uni_freiburg.informatik.ultimate.boogie.annotation.LTLPropertyCheck;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainExceptionWrapper;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.BuchiProgramAcceptingStateAnnotation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction.IInitialAbstractionProvider;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction.NwaInitialAbstractionProvider;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction.Petri2FiniteAutomatonAbstractionProvider;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction.PetriInitialAbstractionProvider;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction.PetriLbeInitialAbstractionProvider;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.petrinetlbe.IcfgCompositionFactory;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.petrinetlbe.PetriNetLargeBlockEncoding;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.BuchiCegarLoopBenchmarkGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.RankVarConstructor;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.cegar.AbstractBuchiCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.cegar.BuchiAutomatonCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.cegar.BuchiPetriNetCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.preferences.BuchiAutomizerPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopStatisticsDefinitions;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.IWitnessTransformer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryRefinement;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.WitnessAutomatonAbstractionProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public class BuchiCegarLoopFactory<L extends IIcfgTransition<?>> {
    private final IUltimateServiceProvider mServices;
    private final TAPreferences mPrefs;
    private final BuchiCegarLoopBenchmarkGenerator mCegarLoopBenchmark;
    private final Class<L> mTransitionClazz;
    private int mNumberOfConstructions;

    public BuchiCegarLoopFactory(IUltimateServiceProvider iUltimateServiceProvider, TAPreferences tAPreferences, Class<L> clazz, BuchiCegarLoopBenchmarkGenerator buchiCegarLoopBenchmarkGenerator) {
        this.mServices = iUltimateServiceProvider;
        this.mPrefs = tAPreferences;
        this.mTransitionClazz = clazz;
        this.mCegarLoopBenchmark = buchiCegarLoopBenchmarkGenerator;
        this.mNumberOfConstructions = 0;
    }

    public AbstractBuchiCegarLoop<L, ?> constructCegarLoop(IIcfg<?> iIcfg, IWitnessTransformer<L> iWitnessTransformer) {
        String string = this.mNumberOfConstructions > 0 ? Integer.toString(this.mNumberOfConstructions) : "";
        ++this.mNumberOfConstructions;
        RankVarConstructor rankVarConstructor = new RankVarConstructor(iIcfg.getCfgSmtToolkit(), string);
        PredicateFactory predicateFactory = new PredicateFactory(this.mServices, iIcfg.getCfgSmtToolkit().getManagedScript(), rankVarConstructor.getCsToolkitWithRankVariables().getSymbolTable());
        PredicateFactoryRefinement predicateFactoryRefinement = new PredicateFactoryRefinement(this.mServices, rankVarConstructor.getCsToolkitWithRankVariables().getManagedScript(), predicateFactory, false, Collections.emptySet());
        if (!IcfgUtils.isConcurrent(iIcfg)) {
            NwaInitialAbstractionProvider nwaInitialAbstractionProvider = new NwaInitialAbstractionProvider(this.mServices, (IEmptyStackStateFactory)predicateFactoryRefinement, true, predicateFactory, this.mPrefs.getHoareSettings());
            return this.createBuchiAutomatonCegarLoop(iIcfg, rankVarConstructor, predicateFactory, iWitnessTransformer, predicateFactoryRefinement, (IInitialAbstractionProvider<L, ? extends INwaOutgoingLetterAndTransitionProvider<L, IPredicate>>)nwaInitialAbstractionProvider);
        }
        IInitialAbstractionProvider<L, BoundedPetriNet<L, IPredicate>> iInitialAbstractionProvider = this.constructPetriNetProvider(predicateFactory, iIcfg);
        BuchiAutomizerPreferenceInitializer.AutomatonTypeConcurrent automatonTypeConcurrent = (BuchiAutomizerPreferenceInitializer.AutomatonTypeConcurrent)this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getEnum("Automaton type for concurrent programs", BuchiAutomizerPreferenceInitializer.AutomatonTypeConcurrent.class);
        switch (automatonTypeConcurrent) {
            case BUCHI_AUTOMATON: {
                Petri2FiniteAutomatonAbstractionProvider.Lazy lazy = new Petri2FiniteAutomatonAbstractionProvider.Lazy(this.mServices, iInitialAbstractionProvider, (IPetriNet2FiniteAutomatonStateFactory)predicateFactoryRefinement);
                return this.createBuchiAutomatonCegarLoop(iIcfg, rankVarConstructor, predicateFactory, iWitnessTransformer, predicateFactoryRefinement, (IInitialAbstractionProvider<L, ? extends INwaOutgoingLetterAndTransitionProvider<L, IPredicate>>)lazy);
            }
            case BUCHI_PETRI_NET: {
                return new BuchiPetriNetCegarLoop<L>(iIcfg, rankVarConstructor, predicateFactory, this.mPrefs, this.mServices, this.mTransitionClazz, (IPetriNet)this.constructInitialAbstraction(iInitialAbstractionProvider, iIcfg), this.mCegarLoopBenchmark);
            }
        }
        throw new UnsupportedOperationException("The type " + String.valueOf((Object)automatonTypeConcurrent) + " is currently not supported.");
    }

    private IInitialAbstractionProvider<L, BoundedPetriNet<L, IPredicate>> constructPetriNetProvider(PredicateFactory predicateFactory, IIcfg<?> iIcfg) {
        PetriInitialAbstractionProvider petriInitialAbstractionProvider = new PetriInitialAbstractionProvider(this.mServices, predicateFactory, true);
        if (!this.mPrefs.applyOneShotLbe()) {
            return petriInitialAbstractionProvider;
        }
        return new PetriLbeInitialAbstractionProvider(this.mServices, (IInitialAbstractionProvider)petriInitialAbstractionProvider, this.mTransitionClazz, this.mPrefs.lbeIndependenceSettings(), (PetriNetLargeBlockEncoding.IPLBECompositionFactory)new IcfgCompositionFactory(this.mServices, iIcfg.getCfgSmtToolkit()));
    }

    private BuchiAutomatonCegarLoop<L> createBuchiAutomatonCegarLoop(IIcfg<?> iIcfg, RankVarConstructor rankVarConstructor, PredicateFactory predicateFactory, IWitnessTransformer<L> iWitnessTransformer, PredicateFactoryRefinement predicateFactoryRefinement, IInitialAbstractionProvider<L, ? extends INwaOutgoingLetterAndTransitionProvider<L, IPredicate>> witnessAutomatonAbstractionProvider) {
        if (iWitnessTransformer != null) {
            witnessAutomatonAbstractionProvider = new WitnessAutomatonAbstractionProvider(predicateFactory, witnessAutomatonAbstractionProvider, iWitnessTransformer);
        }
        return new BuchiAutomatonCegarLoop<L>(iIcfg, rankVarConstructor, predicateFactory, this.mPrefs, this.mServices, this.mTransitionClazz, (INwaOutgoingLetterAndTransitionProvider)this.constructInitialAbstraction((IInitialAbstractionProvider)witnessAutomatonAbstractionProvider, iIcfg), predicateFactoryRefinement, this.mCegarLoopBenchmark);
    }

    private static Set<IcfgLocation> getAcceptingStates(IIcfg<?> iIcfg) {
        Set<IcfgLocation> set = iIcfg.getProgramPoints().values().stream().flatMap(map -> map.values().stream()).collect(Collectors.toSet());
        if (LTLPropertyCheck.getAnnotation(iIcfg) == null) {
            return set;
        }
        return set.stream().filter(icfgLocation -> BuchiProgramAcceptingStateAnnotation.getAnnotation((IElement)icfgLocation) != null).collect(Collectors.toSet());
    }

    private <A extends IAutomaton<L, IPredicate>> A constructInitialAbstraction(IInitialAbstractionProvider<L, A> iInitialAbstractionProvider, IIcfg<?> iIcfg) {
        this.mCegarLoopBenchmark.start(CegarLoopStatisticsDefinitions.OverallTime);
        this.mCegarLoopBenchmark.start(CegarLoopStatisticsDefinitions.InitialAbstractionConstructionTime);
        try {
            IAutomaton iAutomaton = iInitialAbstractionProvider.getInitialAbstraction(iIcfg, BuchiCegarLoopFactory.getAcceptingStates(iIcfg));
            return (A)iAutomaton;
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), "constructing initial abstraction");
            automataOperationCanceledException.addRunningTaskInfo(runningTaskInfo);
            throw new ToolchainExceptionWrapper(Activator.PLUGIN_ID, (Throwable)automataOperationCanceledException);
        }
        catch (ToolchainCanceledException toolchainCanceledException) {
            RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), "constructing initial abstraction");
            toolchainCanceledException.addRunningTaskInfo(runningTaskInfo);
            throw toolchainCanceledException;
        }
        catch (AutomataLibraryException automataLibraryException) {
            throw new ToolchainExceptionWrapper(Activator.PLUGIN_ID, (Throwable)automataLibraryException);
        }
        finally {
            this.mCegarLoopBenchmark.stop(CegarLoopStatisticsDefinitions.InitialAbstractionConstructionTime);
            this.mCegarLoopBenchmark.stop(CegarLoopStatisticsDefinitions.OverallTime);
        }
    }
}

