/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.StringFactory;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.Set;

public final class GetRandomDfa
extends GeneralOperation<String, String, IStateFactory<String>> {
    public static final int NO_STATE = -1;
    public static final int PERC_FULL = 100;
    public static final int PERC_TOTALITY_BOUND_LOWER = 0;
    public static final int PERC_TOTALITY_BOUND_UPPER = 100;
    public static final String PREFIX_NODE = "q";
    public static final String PREFIX_TRANSITION = "a";
    private static final long DEFAULT_SEED = 0L;
    private static BigInteger[][] sPermutationsTable;
    private final int mAlphabetSize;
    private final boolean mEnableCaching;
    private final boolean mEnsureIsConnected;
    private final boolean mEnsureIsUniform;
    private final boolean mEnsureStatesReachFinal;
    private final Set<Integer> mFlags;
    private final int mNumOfAccStates;
    private final int mPercOfTotality;
    private final Random mRandom;
    private final INestedWordAutomaton<String, String> mResult;
    private final int mSize;

    public GetRandomDfa(AutomataLibraryServices automataLibraryServices, int n, int n2, int n3) {
        this(automataLibraryServices, n, n2, n3, 100, 0L, true, false, true, true);
    }

    public GetRandomDfa(AutomataLibraryServices automataLibraryServices, int n, int n2, int n3, int n4, long l, boolean bl) {
        this(automataLibraryServices, n, n2, n3, n4, l, bl, false, true, true);
    }

    public GetRandomDfa(AutomataLibraryServices automataLibraryServices, int n, int n2, int n3, int n4, long l, boolean bl, boolean bl2, boolean bl3) {
        this(automataLibraryServices, n, n2, n3, n4, l, bl, bl2, bl3, true);
    }

    public GetRandomDfa(AutomataLibraryServices automataLibraryServices, int n, int n2, int n3, int n4, long l, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(automataLibraryServices);
        this.mSize = n;
        this.mAlphabetSize = n2;
        this.mNumOfAccStates = n3;
        this.mPercOfTotality = n4;
        this.mEnsureIsConnected = bl;
        this.mEnsureStatesReachFinal = bl2;
        this.mEnsureIsUniform = bl3;
        this.mEnableCaching = bl4;
        this.mFlags = new HashSet<Integer>(this.mSize - 1);
        this.mRandom = new Random(l);
        int[] nArray = this.generatePackedRandomDfa();
        Set<Integer> set = this.calcTransitionsToDelete(nArray);
        Set<Integer> set2 = this.calcAccStates(nArray, set);
        this.mResult = this.extractPackedDfa(nArray, set2, set);
    }

    @Override
    public INestedWordAutomaton<String, String> getResult() {
        return this.mResult;
    }

    @Override
    public String startMessage() {
        return MessageFormat.format("Start {0}. Alphabet size {1} Number of states {2} Number of accepting states {3} Perc of totality {4} Ensure states reach final {5} Ensure is uniform {6} Is caching enabled {7}", this.getOperationName(), this.mAlphabetSize, this.mSize, this.mNumOfAccStates, this.mPercOfTotality, this.mEnsureStatesReachFinal, this.mEnsureIsUniform, this.mEnableCaching);
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + " Result " + this.mResult.sizeInformation() + ".";
    }

    private int[] generatePackedRandomDfa() {
        if (this.mSize < 1 || this.mAlphabetSize < 1) {
            throw new IllegalArgumentException("Neither 'size' nor 'alphabetSize' must be less than one.");
        }
        if (this.mNumOfAccStates < 0 || this.mNumOfAccStates > this.mSize) {
            throw new IllegalArgumentException("'numOfAccStates' must not exceed 'size' or be less than zero.");
        }
        int n = this.mSize * this.mAlphabetSize;
        int[] nArray = new int[n];
        int n2 = 0;
        if (this.mSize == 1) {
            int n3 = 0;
            while (n3 < this.mAlphabetSize) {
                nArray[n2] = 0;
                ++n2;
                ++n3;
            }
            return nArray;
        }
        Random random = new Random();
        if (this.mEnsureIsUniform) {
            this.preCalcPermutationsTable(n);
        }
        int n4 = -1;
        int n5 = 1;
        while (n5 <= this.mSize - 1) {
            int n6 = this.generateFlag(n5, n4 + 1);
            this.mFlags.add(n6);
            int n7 = n4 + 1;
            while (n7 <= n6 - 1) {
                nArray[n2] = random.nextInt(n5);
                ++n2;
                ++n7;
            }
            nArray[n2] = n5++;
            ++n2;
            n4 = n6;
        }
        n5 = n4 + 1;
        while (n5 <= n - 1) {
            nArray[n2] = random.nextInt(this.mSize);
            ++n2;
            ++n5;
        }
        if (!this.mEnableCaching) {
            GetRandomDfa.setTable(null);
        }
        return nArray;
    }

    private static void setTable(BigInteger[][] bigIntegerArray) {
        sPermutationsTable = bigIntegerArray;
    }

    private static BigInteger nextRandomBigInteger(BigInteger bigInteger, Random random) {
        BigInteger bigInteger2 = new BigInteger(bigInteger.bitLength(), random);
        while (bigInteger2.compareTo(bigInteger) >= 0) {
            bigInteger2 = new BigInteger(bigInteger.bitLength(), random);
        }
        return bigInteger2;
    }

    private Set<Integer> calcAccStates(int[] nArray, Set<Integer> set) {
        int n;
        int n2;
        int n3;
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>(this.mNumOfAccStates);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.mSize);
        int n4 = 0;
        while (n4 < this.mSize) {
            arrayList.add(n4);
            ++n4;
        }
        Collections.shuffle(arrayList, this.mRandom);
        n4 = 0;
        while (n4 < this.mNumOfAccStates) {
            linkedHashSet.add((Integer)arrayList.get(n4));
            ++n4;
        }
        if (!this.mEnsureStatesReachFinal) {
            return linkedHashSet;
        }
        ArrayList<Set<Integer>> arrayList2 = new ArrayList<Set<Integer>>(this.mSize);
        int n5 = 0;
        while (n5 < this.mSize) {
            arrayList2.add(new HashSet(this.mAlphabetSize));
            ++n5;
        }
        n5 = 0;
        while (n5 < this.mSize) {
            n3 = n5 * this.mAlphabetSize;
            n2 = 0;
            while (n2 < this.mAlphabetSize) {
                if (!set.contains(n3 + n2)) {
                    n = nArray[n3 + n2];
                    ((Set)arrayList2.get(n)).add(n5);
                }
                ++n2;
            }
            ++n5;
        }
        LinkedHashSet<Integer> linkedHashSet2 = new LinkedHashSet<Integer>(this.mSize);
        n3 = 0;
        while (n3 < this.mSize) {
            linkedHashSet2.add(n3);
            ++n3;
        }
        do {
            GetRandomDfa.removeLiveStates(linkedHashSet, arrayList2, linkedHashSet2);
            Iterator iterator = linkedHashSet2.iterator();
            if (linkedHashSet2.isEmpty()) continue;
            n2 = -1;
            n = this.mRandom.nextInt(linkedHashSet2.size());
            while (n >= 0) {
                n2 = (Integer)iterator.next();
                --n;
            }
            if (n2 == -1) continue;
            linkedHashSet.add(n2);
        } while (!linkedHashSet2.isEmpty());
        return linkedHashSet;
    }

    private static void removeLiveStates(LinkedHashSet<Integer> linkedHashSet, List<Set<Integer>> list, LinkedHashSet<Integer> linkedHashSet2) {
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!linkedHashSet2.contains(n)) continue;
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            linkedList.add(n);
            while (!linkedList.isEmpty()) {
                GetRandomDfa.removeLiveStatesHelper(list, linkedHashSet2, linkedList);
            }
        }
    }

    private static void removeLiveStatesHelper(List<Set<Integer>> list, LinkedHashSet<Integer> linkedHashSet, Queue<Integer> queue) {
        int n = queue.poll();
        linkedHashSet.remove(n);
        Set<Integer> set = list.get(n);
        for (int n2 : set) {
            if (!linkedHashSet.contains(n2)) continue;
            queue.add(n2);
        }
    }

    private Set<Integer> calcTransitionsToDelete(int[] nArray) {
        int n;
        if (this.mPercOfTotality < 0 || this.mPercOfTotality > 100) {
            throw new IllegalArgumentException("'percOfTotality' must not exceed '100' or be less than 0.");
        }
        if (this.mPercOfTotality == 100) {
            return Collections.emptySet();
        }
        int n2 = nArray.length;
        if (this.mEnsureIsConnected) {
            double d = ((double)this.mFlags.size() + 0.0) / (double)n2;
            n = (int)Math.round((1.0 - d) * (double)n2);
        } else {
            n = n2;
        }
        int n3 = (int)Math.round(((double)(100 - this.mPercOfTotality) + 0.0) / 100.0 * (double)n2);
        int n4 = Math.min(n, n3);
        int n5 = nArray.length / 2;
        int n6 = (int)((double)nArray.length * 2.0);
        boolean bl = n4 > n5;
        HashSet<Integer> hashSet = null;
        if (!bl) {
            hashSet = new HashSet<Integer>(n4);
            bl = this.generateRandomIndices(nArray, n4, hashSet, n6);
        }
        if (bl) {
            hashSet = new HashSet(n4);
            this.permuteListAndSelectFirstValid(nArray, n4, hashSet);
        }
        assert (hashSet != null);
        return hashSet;
    }

    private boolean generateRandomIndices(int[] nArray, int n, Set<Integer> set, int n2) {
        int n3 = 0;
        while (set.size() < n) {
            Integer n4 = this.mRandom.nextInt(nArray.length);
            if (this.mEnsureIsConnected) {
                if (!this.mFlags.contains(n4)) {
                    set.add(n4);
                }
            } else {
                set.add(n4);
            }
            if (++n3 <= n2) continue;
            return true;
        }
        return false;
    }

    private INestedWordAutomaton<String, String> extractPackedDfa(int[] nArray, Set<Integer> set, Set<Integer> set2) {
        int n;
        int n2;
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>(this.mSize);
        int n3 = 0;
        while (n3 < this.mSize) {
            arrayList.add((CallSite)((Object)(PREFIX_NODE + n3)));
            ++n3;
        }
        String string = (String)arrayList.get(0);
        ArrayList<CallSite> arrayList2 = new ArrayList<CallSite>(this.mAlphabetSize);
        int n4 = 0;
        while (n4 < this.mAlphabetSize) {
            arrayList2.add((CallSite)((Object)(PREFIX_TRANSITION + n4)));
            ++n4;
        }
        NestedWordAutomaton<String, String> nestedWordAutomaton = new NestedWordAutomaton<String, String>(this.mServices, new VpAlphabet(new HashSet(arrayList2)), new StringFactory());
        int n5 = 0;
        while (n5 < this.mSize) {
            String string2 = (String)arrayList.get(n5);
            n2 = set.contains(n5);
            n = string2.equals(string);
            nestedWordAutomaton.addState(n != 0, n2 != 0, string2);
            ++n5;
        }
        n5 = 0;
        while (n5 < nArray.length) {
            if (!set2.contains(n5)) {
                int n6 = (int)Math.floor(((double)n5 + 0.0) / (double)this.mAlphabetSize);
                n2 = n5 % this.mAlphabetSize;
                n = nArray[n5];
                String string3 = (String)arrayList.get(n6);
                String string4 = (String)arrayList2.get(n2);
                String string5 = (String)arrayList.get(n);
                nestedWordAutomaton.addInternalTransition(string3, string4, string5);
            }
            ++n5;
        }
        return nestedWordAutomaton;
    }

    private int generateFlag(int n, int n2) {
        int n3 = n * this.mAlphabetSize;
        if (!this.mEnsureIsUniform) {
            return this.mRandom.nextInt(n3 - n2) + n2;
        }
        BigInteger bigInteger = BigInteger.ZERO;
        BigInteger[] bigIntegerArray = new BigInteger[n3 - n2];
        int n4 = 0;
        int n5 = n2;
        while (n5 <= n3 - 1) {
            bigIntegerArray[n4] = sPermutationsTable[n][n5].multiply(BigInteger.valueOf(n).pow(n5 - n2));
            bigInteger = bigInteger.add(bigIntegerArray[n4]);
            ++n4;
            ++n5;
        }
        BigInteger bigInteger2 = GetRandomDfa.nextRandomBigInteger(bigInteger.add(BigInteger.ONE), this.mRandom);
        n4 = 0;
        int n6 = n2;
        while (n6 <= n3 - 1) {
            if (bigInteger2.compareTo(bigIntegerArray[n4]) < 0) {
                return n6;
            }
            bigInteger2 = bigInteger2.subtract(bigIntegerArray[n4]);
            ++n4;
            ++n6;
        }
        return n3 - 1;
    }

    private void permuteListAndSelectFirstValid(int[] nArray, int n, Set<Integer> set) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length - this.mFlags.size());
        int n2 = 0;
        while (n2 < nArray.length) {
            if (this.mEnsureIsConnected) {
                if (!this.mFlags.contains(n2)) {
                    arrayList.add(n2);
                }
            } else {
                arrayList.add(n2);
            }
            ++n2;
        }
        Collections.shuffle(arrayList, this.mRandom);
        n2 = 0;
        while (n2 < n) {
            set.add((Integer)arrayList.get(n2));
            ++n2;
        }
    }

    private void preCalcPermutationsTable(int n) {
        boolean bl;
        boolean bl2 = bl = this.mEnableCaching && sPermutationsTable != null && sPermutationsTable[0] != null && sPermutationsTable.length == this.mSize;
        if (bl && sPermutationsTable[0].length == n) {
            return;
        }
        BigInteger[][] bigIntegerArray = new BigInteger[this.mSize][n];
        int n2 = (this.mSize - 1) * this.mAlphabetSize - 1;
        while (n2 >= this.mSize - 2) {
            bigIntegerArray[this.mSize - 1][n2] = bl && n2 < sPermutationsTable[0].length && sPermutationsTable[this.mSize - 1] != null && sPermutationsTable[this.mSize - 1][n2] != null ? sPermutationsTable[this.mSize - 1][n2] : BigInteger.valueOf(this.mSize).pow(n - 1 - n2);
            --n2;
        }
        n2 = this.mSize - 2;
        while (n2 >= 1) {
            int n3 = n2 * this.mAlphabetSize;
            BigInteger bigInteger = BigInteger.ZERO;
            int n4 = n2 + 1;
            int n5 = 0;
            while (n5 <= this.mAlphabetSize - 1) {
                bigInteger = bigInteger.add(bigIntegerArray[n4][n3 + n5].multiply(BigInteger.valueOf(n4).pow(n5)));
                ++n5;
            }
            bigIntegerArray[n2][n3 - 1] = bigInteger;
            n5 = n3 - 2;
            while (n5 >= n2 - 1) {
                bigIntegerArray[n2][n5] = BigInteger.valueOf(n4).multiply(bigIntegerArray[n2][n5 + 1]).add(bigIntegerArray[n4][n5 + 1]);
                --n5;
            }
            --n2;
        }
        GetRandomDfa.setTable(bigIntegerArray);
    }
}

