/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.IDfsOrder;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.IPersistentSetChoice;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IMLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.ExtendedConcurrencyInformation;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.AbstractRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.scc.SccComputation;
import de.uni_freiburg.informatik.ultimate.util.scc.SccComputationNonRecursive;
import de.uni_freiburg.informatik.ultimate.util.scc.StronglyConnectedComponent;
import de.uni_freiburg.informatik.ultimate.util.statistics.AbstractStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.KeyType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class ThreadBasedPersistentSets<LOC extends IcfgLocation>
implements IPersistentSetChoice<IcfgEdge, IPredicate> {
    private final ILogger mLogger;
    private final IIcfg<LOC> mIcfg;
    private final ExtendedConcurrencyInformation<LOC> mInfo;
    private final IIndependenceRelation<?, IcfgEdge> mIndependence;
    private final IDfsOrder<IcfgEdge, IPredicate> mOrder;
    private final Collection<? extends IcfgLocation> mErrorLocs;
    private final ThreadBasedPersistentSetStatistics mStatistics;
    private final PartialRelation<IcfgLocation, IcfgLocation> mCommutativityConflicts = new PartialRelation();
    private final PartialRelation<String, IcfgLocation> mErrorConflicts = new PartialRelation();
    private final PartialRelation<IcfgLocation, String> mJoinConflicts = new PartialRelation();
    private final PartialRelation<IcfgLocation, String> mForkCache = new PartialRelation();
    private final Map<IcfgLocation, Boolean> mReachErrorCache = new HashMap<IcfgLocation, Boolean>();

    public ThreadBasedPersistentSets(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<LOC> iIcfg, IIndependenceRelation<?, IcfgEdge> iIndependenceRelation) {
        this(iUltimateServiceProvider, iIcfg, iIndependenceRelation, null, null);
    }

    public ThreadBasedPersistentSets(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<LOC> iIcfg, IIndependenceRelation<?, IcfgEdge> iIndependenceRelation, IDfsOrder<IcfgEdge, IPredicate> iDfsOrder, Collection<? extends IcfgLocation> set) {
        assert (!iIndependenceRelation.isConditional()) : "Conditional independence currently not supported";
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(ThreadBasedPersistentSets.class);
        this.mIcfg = iIcfg;
        this.mInfo = new ExtendedConcurrencyInformation<LOC>(iIcfg);
        this.mIndependence = iIndependenceRelation;
        this.mOrder = iDfsOrder;
        this.mErrorLocs = set == null ? IcfgUtils.getErrorLocations(iIcfg) : set;
        this.mStatistics = new ThreadBasedPersistentSetStatistics(iIndependenceRelation);
    }

    public Set<IcfgEdge> persistentSet(IPredicate iPredicate) {
        this.mStatistics.beginComputation();
        IMLPredicate iMLPredicate = (IMLPredicate)iPredicate;
        HashRelation<IcfgLocation, IcfgEdge> hashRelation = ThreadBasedPersistentSets.getEnabledActions(iMLPredicate);
        Set set = hashRelation.getDomain();
        if (set.size() <= 1) {
            this.mStatistics.reportTrivialQuery();
            return null;
        }
        Set<IcfgLocation> set2 = Set.of(iMLPredicate.getProgramPoints());
        Set<IcfgLocation> set3 = this.pickMaximalScc(set2, this.getActiveConflicts(iMLPredicate, set2, hashRelation), set);
        assert (set3.size() <= set2.size()) : "Non-active locs must not be base for persistent set";
        if (set3.containsAll(set)) {
            this.mStatistics.reportTrivialQuery();
            return null;
        }
        Set set4 = hashRelation.projectToRange(set3);
        this.mStatistics.reportQuery();
        if (set4.isEmpty()) {
            throw new AssertionError((Object)"Non-trivial persistent set must never be empty");
        }
        return set4;
    }

    public IStatisticsDataProvider getStatistics() {
        return this.mStatistics;
    }

    public boolean ensuresCompatibility(IDfsOrder<IcfgEdge, IPredicate> iDfsOrder) {
        return iDfsOrder == this.mOrder;
    }

    private Map<String, IcfgLocation> getCurrentThreadLocs(IMLPredicate iMLPredicate) {
        Map map;
        HashMap<String, IcfgLocation> hashMap = new HashMap<String, IcfgLocation>();
        IcfgLocation[] icfgLocationArray = iMLPredicate.getProgramPoints();
        int n = icfgLocationArray.length;
        int n2 = 0;
        while (n2 < n) {
            map = icfgLocationArray[n2];
            assert (!hashMap.containsKey(map.getProcedure())) : "Duplicate location for same thread";
            hashMap.put(map.getProcedure(), (IcfgLocation)map);
            ++n2;
        }
        map = this.mIcfg.getProcedureEntryNodes();
        for (String string : IcfgUtils.getAllThreadInstances(this.mIcfg)) {
            hashMap.putIfAbsent(string, (IcfgLocation)map.get(string));
        }
        return hashMap;
    }

    private static HashRelation<IcfgLocation, IcfgEdge> getEnabledActions(IMLPredicate iMLPredicate) {
        HashRelation hashRelation = new HashRelation();
        Set<IcfgLocation> set = Set.of(iMLPredicate.getProgramPoints());
        for (IcfgLocation icfgLocation : set) {
            for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                if (!IcfgUtils.isEnabled(set, (IcfgEdge)icfgEdge)) continue;
                hashRelation.addPair((Object)icfgLocation, (Object)icfgEdge);
            }
        }
        return hashRelation;
    }

    private <N> Set<N> pickMaximalScc(Set<N> set, SccComputation.ISuccessorProvider<N> iSuccessorProvider, Set<N> set2) {
        assert (!set.isEmpty()) : "Cannot compute SCCs of empty graph";
        SccComputationNonRecursive sccComputationNonRecursive = new SccComputationNonRecursive(this.mLogger, iSuccessorProvider, StronglyConnectedComponent::new, set.size(), set);
        Optional<StronglyConnectedComponent> optional = this.getLeafsWithRequired(sccComputationNonRecursive, set2).stream().min(Comparator.comparingInt(StronglyConnectedComponent::getNumberOfStates).thenComparing(Comparator.comparing(StronglyConnectedComponent::toString)));
        assert (optional.isPresent()) : "There must be always at least one leaf SCC";
        return optional.get().getNodes();
    }

    private <N, COMP extends StronglyConnectedComponent<N>> Set<COMP> getLeafsWithRequired(SccComputationNonRecursive<N, COMP> sccComputationNonRecursive, Set<N> set) {
        SccComputation.ISuccessorProvider iSuccessorProvider = sccComputationNonRecursive.getComponentsSuccessorsProvider();
        HashSet<StronglyConnectedComponent> hashSet = new HashSet<StronglyConnectedComponent>();
        for (StronglyConnectedComponent stronglyConnectedComponent : sccComputationNonRecursive.getRootComponents()) {
            hashSet.addAll(this.getLeafsWithRequired(iSuccessorProvider, set, stronglyConnectedComponent));
        }
        return hashSet;
    }

    private <N, COMP extends StronglyConnectedComponent<N>> Set<COMP> getLeafsWithRequired(SccComputation.ISuccessorProvider<COMP> iSuccessorProvider, Set<N> set, COMP COMP) {
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator = iSuccessorProvider.getSuccessors(COMP);
        while (iterator.hasNext()) {
            hashSet.addAll(this.getLeafsWithRequired(iSuccessorProvider, set, (StronglyConnectedComponent)iterator.next()));
        }
        if (hashSet.isEmpty() && DataStructureUtils.haveNonEmptyIntersection((Set)COMP.getNodes(), set)) {
            hashSet.add(COMP);
        }
        return hashSet;
    }

    private SccComputation.ISuccessorProvider<IcfgLocation> getActiveConflicts(IMLPredicate iMLPredicate, Set<IcfgLocation> set, HashRelation<IcfgLocation, IcfgEdge> hashRelation) {
        HashRelation<IcfgLocation, IcfgLocation> hashRelation2 = this.computeAllConflicts(iMLPredicate, hashRelation);
        return icfgLocation -> {
            assert (set.contains(icfgLocation)) : "Only conflicts between active locations should be considered";
            return hashRelation2.getImage(icfgLocation).stream().filter(set::contains).iterator();
        };
    }

    private HashRelation<IcfgLocation, IcfgLocation> computeAllConflicts(IMLPredicate iMLPredicate, HashRelation<IcfgLocation, IcfgEdge> hashRelation) {
        Map<String, IcfgLocation> map = this.getCurrentThreadLocs(iMLPredicate);
        HashRelation<IcfgLocation, IcfgLocation> hashRelation2 = this.getDirectConflicts(iMLPredicate, map.values(), hashRelation);
        this.saturateForkConflicts(hashRelation2, map.values());
        return hashRelation2;
    }

    private HashRelation<IcfgLocation, IcfgLocation> getDirectConflicts(IMLPredicate iMLPredicate, Collection<IcfgLocation> collection, HashRelation<IcfgLocation, IcfgEdge> hashRelation) {
        HashRelation hashRelation2 = new HashRelation();
        this.collectCompatibilityConflicts((IPredicate)iMLPredicate, hashRelation, (HashRelation<IcfgLocation, IcfgLocation>)hashRelation2);
        for (IcfgLocation icfgLocation : collection) {
            for (IcfgLocation icfgLocation2 : collection) {
                if (!this.hasCommutativityConflict(icfgLocation, icfgLocation2) && !this.hasErrorConflict(icfgLocation, icfgLocation2) && !this.hasJoinConflict(icfgLocation, icfgLocation2)) continue;
                hashRelation2.addPair((Object)icfgLocation, (Object)icfgLocation2);
            }
        }
        return hashRelation2;
    }

    private void saturateForkConflicts(HashRelation<IcfgLocation, IcfgLocation> hashRelation, Collection<IcfgLocation> collection) {
        HashRelation hashRelation2;
        boolean bl;
        do {
            hashRelation2 = new HashRelation();
            for (Map.Entry entry : hashRelation) {
                Collection<IcfgLocation> collection2 = this.propagateConflict((IcfgLocation)entry.getKey(), (IcfgLocation)entry.getValue(), hashRelation, collection);
                hashRelation2.addAllPairs((Object)((IcfgLocation)entry.getKey()), collection2);
            }
        } while (bl = hashRelation.addAll((AbstractRelation)hashRelation2));
    }

    private Collection<IcfgLocation> propagateConflict(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, HashRelation<IcfgLocation, IcfgLocation> hashRelation, Collection<IcfgLocation> collection) {
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        for (IcfgLocation icfgLocation3 : collection) {
            if (hashRelation.containsPair((Object)icfgLocation, (Object)icfgLocation3) || !this.canFork(icfgLocation3, icfgLocation2.getProcedure())) continue;
            hashSet.add(icfgLocation3);
        }
        return hashSet;
    }

    private void collectCompatibilityConflicts(IPredicate iPredicate, HashRelation<IcfgLocation, IcfgEdge> hashRelation, HashRelation<IcfgLocation, IcfgLocation> hashRelation2) {
        if (this.mOrder == null) {
            return;
        }
        Comparator comparator = this.mOrder.getOrder((Object)iPredicate);
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : hashRelation.entrySet()) {
            arrayList.addAll((Collection)entry.getValue());
        }
        arrayList.sort(comparator);
        int n = 0;
        while (n < arrayList.size() - 1) {
            IcfgLocation icfgLocation;
            IcfgLocation icfgLocation2 = (IcfgLocation)((IcfgEdge)arrayList.get(n)).getSource();
            if (icfgLocation2 != (icfgLocation = (IcfgLocation)((IcfgEdge)arrayList.get(n + 1)).getSource())) {
                hashRelation2.addPair((Object)icfgLocation, (Object)icfgLocation2);
            }
            ++n;
        }
    }

    private boolean hasCommutativityConflict(IcfgLocation icfgLocation, IcfgLocation icfgLocation2) {
        if (icfgLocation == icfgLocation2) {
            return false;
        }
        String string = icfgLocation.getProcedure();
        return ThreadBasedPersistentSets.canReachConflict(icfgLocation, icfgLocation2, icfgEdge -> icfgLocation.getOutgoingEdges().stream().anyMatch(icfgEdge2 -> this.mIndependence.isIndependent(null, icfgEdge, icfgEdge2) != IIndependenceRelation.Dependence.INDEPENDENT), icfgEdge -> !ExtendedConcurrencyInformation.isThreadLocal(icfgEdge) || this.mInfo.mustBeJoinOf(string, (IcfgEdge)icfgEdge), this.mCommutativityConflicts);
    }

    private boolean hasJoinConflict(IcfgLocation icfgLocation2, IcfgLocation icfgLocation3) {
        String string = icfgLocation3.getProcedure();
        if (string.equals(icfgLocation2.getProcedure())) {
            return false;
        }
        return IcfgUtils.canReachCached((IcfgLocation)icfgLocation2, icfgEdge -> this.mInfo.mayBeJoinOf(string, (IcfgEdge)icfgEdge) && this.canReachError(icfgLocation2.getProcedure(), (IcfgLocation)icfgEdge.getTarget()), icfgEdge -> !ExtendedConcurrencyInformation.isThreadLocal(icfgEdge), icfgLocation -> this.mJoinConflicts.contains((IcfgLocation)icfgLocation, string), (icfgLocation, bl) -> this.mJoinConflicts.set((IcfgLocation)icfgLocation, string, (boolean)bl));
    }

    private boolean canReachError(String string, IcfgLocation icfgLocation2) {
        return IcfgUtils.canReachCached((IcfgLocation)icfgLocation2, icfgEdge -> this.mErrorLocs.contains(icfgEdge.getTarget()), icfgEdge -> false, icfgLocation -> {
            Boolean bl = this.mReachErrorCache.get(icfgLocation);
            if (bl != null) {
                return bl != false ? Script.LBool.SAT : Script.LBool.UNSAT;
            }
            Script.LBool lBool = this.mErrorConflicts.contains(string, (IcfgLocation)icfgLocation);
            return lBool == Script.LBool.SAT ? Script.LBool.SAT : Script.LBool.UNKNOWN;
        }, (icfgLocation, bl) -> {
            Boolean bl2 = this.mReachErrorCache.put((IcfgLocation)icfgLocation, (Boolean)bl);
        });
    }

    private boolean hasErrorConflict(IcfgLocation icfgLocation, IcfgLocation icfgLocation2) {
        String string = icfgLocation.getProcedure();
        if (string.equals(icfgLocation2.getProcedure())) {
            return false;
        }
        return ThreadBasedPersistentSets.canReachConflict(string, icfgLocation2, icfgEdge -> this.mErrorLocs.contains(icfgEdge.getTarget()), icfgEdge -> !ExtendedConcurrencyInformation.isThreadLocal(icfgEdge) || this.mInfo.mustBeJoinOf(string, (IcfgEdge)icfgEdge), this.mErrorConflicts);
    }

    private static <X> boolean canReachConflict(X x, IcfgLocation icfgLocation2, Predicate<IcfgEdge> predicate, Predicate<IcfgEdge> predicate2, PartialRelation<X, IcfgLocation> partialRelation) {
        return IcfgUtils.canReachCached((IcfgLocation)icfgLocation2, predicate, predicate2, icfgLocation -> partialRelation.contains(x, (IcfgLocation)icfgLocation), (icfgLocation, bl) -> partialRelation.set(x, (IcfgLocation)icfgLocation, (boolean)bl));
    }

    private boolean canFork(IcfgLocation icfgLocation2, String string) {
        return IcfgUtils.canReachCached((IcfgLocation)icfgLocation2, icfgEdge -> this.mInfo.mayBeForkOf(string, (IcfgEdge)icfgEdge), icfgEdge -> !ExtendedConcurrencyInformation.isThreadLocal(icfgEdge), icfgLocation -> this.mForkCache.contains((IcfgLocation)icfgLocation, string), (icfgLocation, bl) -> this.mForkCache.set((IcfgLocation)icfgLocation, string, (boolean)bl));
    }

    private static class PartialRelation<X, Y> {
        private final Map<X, Map<Y, Boolean>> mRelation = new HashMap<X, Map<Y, Boolean>>();

        private PartialRelation() {
        }

        private Script.LBool contains(X x, Y y) {
            Map<Y, Boolean> map = this.mRelation.get(x);
            if (map == null) {
                return Script.LBool.UNKNOWN;
            }
            Boolean bl = map.get(y);
            if (bl == null) {
                return Script.LBool.UNKNOWN;
            }
            return bl != false ? Script.LBool.SAT : Script.LBool.UNSAT;
        }

        private void set(X x, Y y, boolean bl) {
            this.mRelation.computeIfAbsent(x, object -> new HashMap()).put(y, bl);
        }
    }

    private static final class ThreadBasedPersistentSetStatistics
    extends AbstractStatisticsDataProvider {
        public static final String COMPUTATION_TIME = "Persistent set computation time";
        public static final String PERSISTENT_SET_COMPUTATIONS = "Number of persistent set computation";
        public static final String TRIVIAL_SETS = "Number of trivial persistent sets";
        public static final String UNDERLYING_INDEPENDENCE = "Underlying independence relation";
        private long mComputationTime;
        private int mTrivialSets;
        private int mQueries;
        private long mComputationStart = -1L;

        private ThreadBasedPersistentSetStatistics(IIndependenceRelation<?, IcfgEdge> iIndependenceRelation) {
            this.declare(COMPUTATION_TIME, () -> this.mComputationTime, KeyType.TIMER);
            this.declare(PERSISTENT_SET_COMPUTATIONS, () -> this.mQueries, KeyType.COUNTER);
            this.declare(TRIVIAL_SETS, () -> this.mTrivialSets, KeyType.COUNTER);
            this.forward(UNDERLYING_INDEPENDENCE, () -> iIndependenceRelation.getStatistics());
        }

        private void beginComputation() {
            assert (this.mComputationStart == -1L) : "Computation timer already running";
            this.mComputationStart = System.nanoTime();
        }

        private void reportTrivialQuery() {
            ++this.mTrivialSets;
            this.reportQuery();
        }

        private void reportQuery() {
            assert (this.mComputationStart >= 0L) : "Computation timer was not running";
            this.mComputationTime += System.nanoTime() - this.mComputationStart;
            this.mComputationStart = -1L;
            ++this.mQueries;
        }
    }
}

