/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array.ArrayDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array.ArrayDomainToolkit;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array.Segmentation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array.SegmentationMap;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.util.typeutils.TypeUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.TemporaryBoogieVar;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class ArrayDomainExpressionProcessor<STATE extends IAbstractState<STATE>> {
    private final ArrayDomainToolkit<STATE> mToolkit;

    public ArrayDomainExpressionProcessor(ArrayDomainToolkit<STATE> arrayDomainToolkit) {
        this.mToolkit = arrayDomainToolkit;
    }

    public Pair<ArrayDomainState<STATE>, Expression> processExpression(ArrayDomainState<STATE> arrayDomainState, Expression expression) {
        Pair<ArrayDomainState<STATE>, Term> pair = this.processTerm(arrayDomainState, this.mToolkit.getTerm(expression));
        return new Pair((Object)((ArrayDomainState)pair.getFirst()), (Object)this.mToolkit.getExpression((Term)pair.getSecond()));
    }

    private Pair<ArrayDomainState<STATE>, Term> processTerm(ArrayDomainState<STATE> arrayDomainState, Term term) {
        MultiDimensionalSelect multiDimensionalSelect2;
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        ArrayList<TemporaryBoogieVar> arrayList = new ArrayList<TemporaryBoogieVar>();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        ArrayDomainState<MultiDimensionalSelect> arrayDomainState2 = arrayDomainState;
        Script script = this.mToolkit.getScript();
        for (MultiDimensionalSelect multiDimensionalSelect2 : MultiDimensionalSelect.extractSelectShallow((Term)term)) {
            Term term2 = multiDimensionalSelect2.toTerm(script);
            Term term3 = multiDimensionalSelect2.getArray();
            for (Term term4 : multiDimensionalSelect2.getIndex()) {
                Pair<ArrayDomainState<STATE>, Segmentation> pair = arrayDomainState2.getSegmentation(this.mToolkit.getExpression(term3));
                arrayDomainState2 = (ArrayDomainState<MultiDimensionalSelect>)pair.getFirst();
                Segmentation segmentation = (Segmentation)pair.getSecond();
                Pair<Integer, Integer> pair2 = arrayDomainState2.getContainedBoundIndices(segmentation, term4);
                int n = (Integer)pair2.getFirst();
                int n2 = (Integer)pair2.getSecond();
                TemporaryBoogieVar temporaryBoogieVar = this.mToolkit.createAuxVar(TypeUtils.getValueSort(term3.getSort()));
                Sort sort = temporaryBoogieVar.getSort();
                if (sort.isArraySort()) {
                    var21_21 = new ArrayList<Segmentation>();
                    int n3 = n;
                    while (n3 < n2) {
                        var21_21.add(arrayDomainState2.getSegmentation((IProgramVarOrConst)segmentation.getValue(n3)));
                        ++n3;
                    }
                    Pair pair3 = arrayDomainState2.unionSegmentations(var21_21, sort);
                    SegmentationMap segmentationMap = ((ArrayDomainState)pair3.getSecond()).getSegmentationMap();
                    segmentationMap.put((IProgramVarOrConst)temporaryBoogieVar, (Segmentation)pair3.getFirst());
                    arrayDomainState2 = ((ArrayDomainState)pair3.getSecond()).updateState(segmentationMap);
                } else {
                    arrayList.add(temporaryBoogieVar);
                    var21_21 = new ArrayList();
                    int n4 = n;
                    while (n4 < n2) {
                        var21_21.add((Segmentation)this.mToolkit.connstructEquivalentConstraint((IProgramVarOrConst)temporaryBoogieVar, segmentation.getValue(n4), arrayDomainState2.getSubTerm()));
                        ++n4;
                    }
                    arrayList2.add(SmtUtils.or((Script)script, var21_21));
                }
                term3 = temporaryBoogieVar.getTermVariable();
            }
            hashMap.put(term2, term3);
        }
        multiDimensionalSelect2 = this.mToolkit.handleAssumptionBySubdomain(arrayDomainState2.getSubState().addVariables(arrayList), SmtUtils.and((Script)script, arrayList2));
        Term term5 = Substitution.apply((ManagedScript)this.mToolkit.getManagedScript(), hashMap, (Term)term);
        return new Pair(arrayDomainState2.updateState(multiDimensionalSelect2), (Object)term5);
    }

    public ArrayDomainState<STATE> processAssume(ArrayDomainState<STATE> arrayDomainState, Expression expression) {
        Term term = this.mToolkit.getTerm(expression);
        if (SmtUtils.isArrayFree((Term)term)) {
            return arrayDomainState.updateState(this.mToolkit.handleAssumptionBySubdomain(arrayDomainState.getSubState(), term));
        }
        ArrayDomainState<STATE> arrayDomainState2 = arrayDomainState;
        Term term2 = SmtUtils.toCnf((IUltimateServiceProvider)this.mToolkit.getServices(), (ManagedScript)this.mToolkit.getManagedScript(), (Term)term);
        Term[] termArray = SmtUtils.getConjuncts((Term)term2);
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term3 = termArray[n2];
            if (arrayDomainState2.isBottom()) break;
            arrayDomainState2 = this.processAssumeTerm(arrayDomainState2, term3);
            ++n2;
        }
        return arrayDomainState2;
    }

    private ArrayDomainState<STATE> processAssumeTerm(ArrayDomainState<STATE> arrayDomainState, Term term) {
        Object object;
        Object object2;
        Object object3;
        assert (!SmtUtils.isFunctionApplication((Term)term, (String)"and"));
        Script script = this.mToolkit.getScript();
        if (SmtUtils.isFunctionApplication((Term)term, (String)"or")) {
            Object object4;
            ArrayDomainState<STATE> arrayDomainState2 = this.mToolkit.createBottomState();
            ArrayList<Term> arrayList = new ArrayList<Term>();
            Term[] termArray = ((ApplicationTerm)term).getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                object4 = termArray[n2];
                if (SmtUtils.isArrayFree((Term)object4)) {
                    arrayList.add((Term)object4);
                } else {
                    ArrayDomainState<STATE> arrayDomainState3 = this.processAssumeTerm(arrayDomainState, (Term)object4).simplify();
                    arrayDomainState2 = arrayDomainState2.union(arrayDomainState3);
                }
                ++n2;
            }
            if (arrayList.isEmpty()) {
                return arrayDomainState2;
            }
            object4 = arrayDomainState.updateState(this.mToolkit.handleAssumptionBySubdomain(arrayDomainState.getSubState(), SmtUtils.or((Script)script, arrayList)));
            return arrayDomainState2.union((ArrayDomainState<STATE>)object4);
        }
        if (SmtUtils.isFunctionApplication((Term)term, (String)"=")) {
            object3 = ((ApplicationTerm)term).getParameters();
            assert (((Term[])object3).length == 2);
            object2 = object3[0].getSort();
            if (object2.isArraySort()) {
                Expression expression = this.mToolkit.getExpression((Term)object3[0]);
                Expression expression2 = this.mToolkit.getExpression((Term)object3[1]);
                SegmentationMap segmentationMap = arrayDomainState.getSegmentationMap();
                if (expression instanceof IdentifierExpression && expression2 instanceof IdentifierExpression) {
                    IProgramVarOrConst iProgramVarOrConst = this.mToolkit.getBoogieVar((IdentifierExpression)expression);
                    IProgramVarOrConst iProgramVarOrConst2 = this.mToolkit.getBoogieVar((IdentifierExpression)expression2);
                    Segmentation segmentation = segmentationMap.getSegmentation(iProgramVarOrConst);
                    Segmentation segmentation2 = segmentationMap.getSegmentation(iProgramVarOrConst2);
                    Pair<Segmentation, ArrayDomainState<STATE>> pair = arrayDomainState.intersectSegmentations(segmentation, segmentation2, (Sort)object2);
                    SegmentationMap segmentationMap2 = ((ArrayDomainState)pair.getSecond()).getSegmentationMap();
                    segmentationMap2.union(iProgramVarOrConst, iProgramVarOrConst2, (Segmentation)pair.getFirst());
                    return ((ArrayDomainState)pair.getSecond()).updateState(segmentationMap2);
                }
                if (expression instanceof IdentifierExpression) {
                    IProgramVarOrConst iProgramVarOrConst = this.mToolkit.getBoogieVar((IdentifierExpression)expression);
                    Segmentation segmentation = segmentationMap.getSegmentation(iProgramVarOrConst);
                    Pair<ArrayDomainState<STATE>, Segmentation> pair = arrayDomainState.getSegmentation(expression2);
                    Segmentation segmentation3 = (Segmentation)pair.getSecond();
                    Pair pair2 = ((ArrayDomainState)pair.getFirst()).intersectSegmentations(segmentation, segmentation3, (Sort)object2);
                    SegmentationMap segmentationMap3 = ((ArrayDomainState)pair2.getSecond()).getSegmentationMap();
                    segmentationMap3.put(iProgramVarOrConst, (Segmentation)pair2.getFirst());
                    return ((ArrayDomainState)pair2.getSecond()).updateState(segmentationMap3);
                }
                if (expression2 instanceof IdentifierExpression) {
                    Pair<ArrayDomainState<STATE>, Segmentation> pair = arrayDomainState.getSegmentation(expression);
                    Segmentation segmentation = (Segmentation)pair.getSecond();
                    IProgramVarOrConst iProgramVarOrConst = this.mToolkit.getBoogieVar((IdentifierExpression)expression2);
                    Segmentation segmentation4 = segmentationMap.getSegmentation(iProgramVarOrConst);
                    Pair pair3 = ((ArrayDomainState)pair.getFirst()).intersectSegmentations(segmentation, segmentation4, (Sort)object2);
                    SegmentationMap segmentationMap4 = ((ArrayDomainState)pair3.getSecond()).getSegmentationMap();
                    segmentationMap4.put(iProgramVarOrConst, (Segmentation)pair3.getFirst());
                    return ((ArrayDomainState)pair3.getSecond()).updateState(segmentationMap4);
                }
                return arrayDomainState;
            }
        }
        if (this.isInvalidArrayInequality(arrayDomainState, term)) {
            return this.mToolkit.createBottomState();
        }
        object3 = MultiDimensionalSelect.extractSelectShallow((Term)term);
        if (object3.isEmpty()) {
            object2 = this.mToolkit.handleAssumptionBySubdomain(arrayDomainState.getSubState(), term);
            return arrayDomainState.updateState(object2);
        }
        object2 = new ArrayList();
        HashMap<Term, TermVariable> hashMap = new HashMap<Term, TermVariable>();
        ArrayDomainState<Object> arrayDomainState4 = arrayDomainState;
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            object = (MultiDimensionalSelect)iterator.next();
            Expression expression = this.mToolkit.getExpression(object.getArray());
            if (!(expression instanceof IdentifierExpression)) continue;
            Term term2 = object.toTerm(script);
            Pair<ArrayDomainState<STATE>, Term> pair = this.processTerm(arrayDomainState4, term2);
            Term term3 = (Term)pair.getSecond();
            TemporaryBoogieVar temporaryBoogieVar = this.mToolkit.createAuxVar(term2.getSort());
            TermVariable termVariable = temporaryBoogieVar.getTermVariable();
            hashMap.put(term2, termVariable);
            object2.add(SmtUtils.binaryEquality((Script)script, (Term)termVariable, (Term)term3));
            Expression expression3 = this.mToolkit.getExpression(SmtUtils.multiDimensionalStore((Script)script, (Term)object.getArray(), (ArrayIndex)object.getIndex(), (Term)termVariable));
            ArrayDomainState arrayDomainState5 = ((ArrayDomainState)pair.getFirst()).addAuxVar((IProgramVarOrConst)temporaryBoogieVar);
            Pair pair4 = arrayDomainState5.getSegmentation(expression3);
            arrayDomainState4 = (ArrayDomainState<Object>)pair4.getFirst();
            IProgramVarOrConst iProgramVarOrConst = this.mToolkit.getBoogieVar((IdentifierExpression)expression);
            SegmentationMap segmentationMap = arrayDomainState4.getSegmentationMap();
            segmentationMap.put(iProgramVarOrConst, (Segmentation)pair4.getSecond());
            arrayDomainState4 = arrayDomainState4.updateState(segmentationMap);
        }
        if (hashMap.isEmpty()) {
            object2.add(term);
        } else {
            object2.add(Substitution.apply((ManagedScript)this.mToolkit.getManagedScript(), hashMap, (Term)term));
        }
        object = this.mToolkit.handleAssumptionBySubdomain(arrayDomainState4.getSubState(), SmtUtils.and((Script)script, (Collection)object2));
        return arrayDomainState4.updateState(object);
    }

    private boolean isInvalidArrayInequality(ArrayDomainState<STATE> arrayDomainState, Term term) {
        if (!SmtUtils.isFunctionApplication((Term)term, (String)"not")) {
            return false;
        }
        Term term2 = ((ApplicationTerm)term).getParameters()[0];
        if (!SmtUtils.isFunctionApplication((Term)term2, (String)"=")) {
            return false;
        }
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        assert (termArray.length == 2);
        if (!termArray[0].getSort().isArraySort()) {
            return false;
        }
        Expression expression = this.mToolkit.getExpression(termArray[0]);
        Expression expression2 = this.mToolkit.getExpression(termArray[1]);
        if (!(expression instanceof IdentifierExpression) || !(expression2 instanceof IdentifierExpression)) {
            return false;
        }
        IProgramVarOrConst iProgramVarOrConst = this.mToolkit.getBoogieVar((IdentifierExpression)expression);
        IProgramVarOrConst iProgramVarOrConst2 = this.mToolkit.getBoogieVar((IdentifierExpression)expression2);
        return arrayDomainState.getSegmentationMap().getEquivalenceClass(iProgramVarOrConst).contains((Object)iProgramVarOrConst2);
    }
}

