/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IGeneralizedNwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiIntersectStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GeneralizedBuchiIntersectNwa<LETTER, STATE>
implements IGeneralizedNwaOutgoingLetterAndTransitionProvider<LETTER, STATE> {
    private final IGeneralizedNwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mFstOperand;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mSndOperand;
    private final IBuchiIntersectStateFactory<STATE> mStateFactory;
    private final STATE mEmptyStackState;
    private final Map<STATE, ProductState> mRes2prod = new HashMap<STATE, ProductState>();
    private final Map<STATE, Map<STATE, ProductState>> mFst2snd2res = new HashMap<STATE, Map<STATE, ProductState>>();
    private Set<STATE> mInitialStates;
    private final int mAcceptanceSize;

    public <FACTORY extends IBuchiIntersectStateFactory<STATE> & IEmptyStackStateFactory<STATE>> GeneralizedBuchiIntersectNwa(IGeneralizedNwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iGeneralizedNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, FACTORY FACTORY) throws AutomataLibraryException {
        this.mFstOperand = iGeneralizedNwaOutgoingLetterAndTransitionProvider;
        this.mSndOperand = iNwaOutgoingLetterAndTransitionProvider;
        if (!NestedWordAutomataUtils.sameAlphabet(this.mFstOperand, this.mSndOperand)) {
            throw new AutomataLibraryException(this.getClass(), "Unable to apply operation to automata with different alphabets.");
        }
        this.mStateFactory = FACTORY;
        this.mEmptyStackState = FACTORY.createEmptyStackState();
        this.mAcceptanceSize = this.mFstOperand.getAcceptanceSize() + 1;
    }

    private Set<STATE> constructInitialState() {
        HashSet hashSet = new HashSet();
        for (Object STATE : this.mFstOperand.getInitialStates()) {
            for (Object STATE2 : this.mSndOperand.getInitialStates()) {
                Object STATE3 = this.getOrConstructState(STATE, STATE2);
                hashSet.add(STATE3);
            }
        }
        return hashSet;
    }

    private STATE getOrConstructState(STATE STATE, STATE STATE2) {
        ProductState productState;
        Map<STATE, ProductState> map = this.mFst2snd2res.get(STATE);
        if (map == null) {
            map = new HashMap<STATE, ProductState>();
            this.mFst2snd2res.put(STATE, map);
        }
        if ((productState = map.get(STATE2)) == null) {
            STATE STATE3 = this.mStateFactory.intersectBuchi(STATE, STATE2, 1);
            productState = new ProductState(STATE, STATE2, STATE3);
            productState.setAcceptanceSet(this.computeAcceptance(STATE, STATE2));
            map.put(STATE2, productState);
            this.mRes2prod.put(STATE3, productState);
        }
        return productState.getRes();
    }

    private Set<Integer> computeAcceptance(STATE STATE, STATE STATE2) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Set<Integer> set = this.mFstOperand.getAcceptanceLabels(STATE);
        hashSet.addAll(set);
        int n = this.mFstOperand.getAcceptanceSize();
        if (this.mSndOperand.isFinal(STATE2)) {
            hashSet.add(n);
        }
        if (hashSet.isEmpty()) {
            return Collections.emptySet();
        }
        return hashSet;
    }

    @Override
    public Iterable<STATE> getInitialStates() {
        if (this.mInitialStates == null) {
            this.mInitialStates = this.constructInitialState();
        }
        return this.mInitialStates;
    }

    @Override
    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mFstOperand.getVpAlphabet();
    }

    @Override
    public IStateFactory<STATE> getStateFactory() {
        return this.mStateFactory;
    }

    @Override
    public boolean isInitial(STATE STATE) {
        return this.mInitialStates.contains(STATE);
    }

    @Override
    public STATE getEmptyStackState() {
        return this.mEmptyStackState;
    }

    @Override
    public Set<LETTER> lettersInternal(STATE STATE) {
        Object STATE2 = this.mRes2prod.get(STATE).getFst();
        return this.mFstOperand.lettersInternal(STATE2);
    }

    @Override
    public Set<LETTER> lettersCall(STATE STATE) {
        Object STATE2 = this.mRes2prod.get(STATE).getFst();
        return this.mFstOperand.lettersCall(STATE2);
    }

    @Override
    public Set<LETTER> lettersReturn(STATE STATE, STATE STATE2) {
        Object STATE3 = this.mRes2prod.get(STATE).getFst();
        Object STATE4 = this.mRes2prod.get(STATE2).getFst();
        return this.mFstOperand.lettersReturn(STATE3, STATE4);
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE, LETTER LETTER) {
        ProductState productState = this.mRes2prod.get(STATE);
        return this.internalSuccessors(this.mFstOperand.internalSuccessors(productState.getFst(), LETTER), productState);
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE) {
        ProductState productState = this.mRes2prod.get(STATE);
        return this.internalSuccessors(this.mFstOperand.internalSuccessors(productState.getFst()), productState);
    }

    @Override
    private Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(Iterable<OutgoingInternalTransition<LETTER, STATE>> iterable, ProductState productState) {
        ArrayList<OutgoingInternalTransition<LETTER, STATE>> arrayList = new ArrayList<OutgoingInternalTransition<LETTER, STATE>>();
        for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : iterable) {
            LETTER LETTER = outgoingInternalTransition.getLetter();
            for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition2 : this.mSndOperand.internalSuccessors(productState.getSnd(), LETTER)) {
                STATE STATE = outgoingInternalTransition.getSucc();
                STATE STATE2 = outgoingInternalTransition2.getSucc();
                STATE STATE3 = this.getOrConstructState(STATE, STATE2);
                arrayList.add(new OutgoingInternalTransition<LETTER, STATE>(LETTER, STATE3));
            }
        }
        return arrayList;
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE, LETTER LETTER) {
        ProductState productState = this.mRes2prod.get(STATE);
        return this.callSuccessors(this.mFstOperand.callSuccessors(productState.getFst(), LETTER), productState);
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE) {
        ProductState productState = this.mRes2prod.get(STATE);
        return this.callSuccessors(this.mFstOperand.callSuccessors(productState.getFst()), productState);
    }

    @Override
    private Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(Iterable<OutgoingCallTransition<LETTER, STATE>> iterable, ProductState productState) {
        ArrayList<OutgoingCallTransition<LETTER, STATE>> arrayList = new ArrayList<OutgoingCallTransition<LETTER, STATE>>();
        for (OutgoingCallTransition<LETTER, STATE> outgoingCallTransition : iterable) {
            LETTER LETTER = outgoingCallTransition.getLetter();
            for (OutgoingCallTransition<LETTER, STATE> outgoingCallTransition2 : this.mSndOperand.callSuccessors(productState.getSnd(), LETTER)) {
                STATE STATE = outgoingCallTransition.getSucc();
                STATE STATE2 = outgoingCallTransition2.getSucc();
                STATE STATE3 = this.getOrConstructState(STATE, STATE2);
                arrayList.add(new OutgoingCallTransition<LETTER, STATE>(LETTER, STATE3));
            }
        }
        return arrayList;
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE STATE, STATE STATE2, LETTER LETTER) {
        ProductState productState = this.mRes2prod.get(STATE);
        ProductState productState2 = this.mRes2prod.get(STATE2);
        Object STATE3 = productState2.getFst();
        Object STATE4 = productState2.getSnd();
        return this.returnSuccessors(this.mFstOperand.returnSuccessors(productState.getFst(), STATE3, LETTER), productState, STATE2, STATE4);
    }

    private Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(Iterable<OutgoingReturnTransition<LETTER, STATE>> iterable, ProductState productState, STATE STATE, STATE STATE2) {
        ArrayList<OutgoingReturnTransition<LETTER, STATE>> arrayList = new ArrayList<OutgoingReturnTransition<LETTER, STATE>>();
        for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : iterable) {
            LETTER LETTER = outgoingReturnTransition.getLetter();
            for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition2 : this.mSndOperand.returnSuccessors(productState.getSnd(), STATE2, LETTER)) {
                STATE STATE3 = outgoingReturnTransition.getSucc();
                STATE STATE4 = outgoingReturnTransition2.getSucc();
                STATE STATE5 = this.getOrConstructState(STATE3, STATE4);
                arrayList.add(new OutgoingReturnTransition<LETTER, STATE>(STATE, LETTER, STATE5));
            }
        }
        return arrayList;
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessorsGivenHier(STATE STATE, STATE STATE2) {
        ProductState productState = this.mRes2prod.get(STATE);
        ProductState productState2 = this.mRes2prod.get(STATE2);
        Object STATE3 = productState2.getFst();
        Object STATE4 = productState2.getSnd();
        return this.returnSuccessors(this.mFstOperand.returnSuccessorsGivenHier(productState.getFst(), STATE3), productState, STATE2, STATE4);
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public String sizeInformation() {
        return this.mRes2prod.size() + " states";
    }

    @Override
    public boolean isFinal(STATE STATE, int n) {
        Set<Integer> set = this.mRes2prod.get(STATE).getAcceptanceSet();
        if (set.isEmpty()) {
            return false;
        }
        return set.contains(n);
    }

    @Override
    public int getAcceptanceSize() {
        return this.mAcceptanceSize;
    }

    @Override
    public Set<Integer> getAcceptanceLabels(STATE STATE) {
        return this.mRes2prod.get(STATE).getAcceptanceSet();
    }

    private class ProductState {
        private final STATE mFst;
        private final STATE mSnd;
        private final STATE mRes;
        private Set<Integer> mAcceptanceSet;

        ProductState(STATE STATE, STATE STATE2, STATE STATE3) {
            this.mFst = STATE;
            this.mSnd = STATE2;
            this.mRes = STATE3;
        }

        public STATE getFst() {
            return this.mFst;
        }

        public STATE getSnd() {
            return this.mSnd;
        }

        public STATE getRes() {
            return this.mRes;
        }

        public void setAcceptanceSet(Set<Integer> set) {
            this.mAcceptanceSet = set;
        }

        public Set<Integer> getAcceptanceSet() {
            return this.mAcceptanceSet;
        }

        public String toString() {
            return "<" + this.mFst.toString() + "," + this.mSnd.toString() + "," + this.mAcceptanceSet.toString() + ">";
        }
    }
}

