/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.AbstractMaxSatSolver;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.ClauseStatus;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.FalseClauseCondition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.IClauseCondition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.PseudoUnitClauseCondition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.TrueClauseCondition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.UndeterminedClauseCondition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.VariableStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Arrays;
import java.util.Iterator;

class Clause<V> {
    public static int trues = 0;
    public static int falses = 0;
    public static int neithers = 0;
    private static final TrueClauseCondition TRUE_CLAUSE_CONDITION = new TrueClauseCondition();
    private static final FalseClauseCondition FALSE_CLAUSE_CONDITION = new FalseClauseCondition();
    private static final UndeterminedClauseCondition UNDETERMINED_CLAUSE_CONDITION = new UndeterminedClauseCondition();
    protected final V[] mPositiveAtoms;
    protected final V[] mNegativeAtoms;
    protected IClauseCondition mClauseCondition;
    private boolean mIsHorn;
    private final int mHashCode;

    public Clause(AbstractMaxSatSolver<V> abstractMaxSatSolver, V[] VArray, V[] VArray2) {
        this.mPositiveAtoms = VArray;
        this.mNegativeAtoms = VArray2;
        this.mHashCode = this.computeHashCode();
        this.updateClauseCondition(abstractMaxSatSolver);
    }

    private int computeHashCode() {
        return Arrays.hashCode(this.mPositiveAtoms) + 31 * Arrays.hashCode(this.mNegativeAtoms);
    }

    void updateClauseCondition(AbstractMaxSatSolver<V> abstractMaxSatSolver) {
        this.mClauseCondition = this.computeClauseCondition(abstractMaxSatSolver);
    }

    public IClauseCondition computeClauseCondition(AbstractMaxSatSolver<V> abstractMaxSatSolver) {
        VariableStatus variableStatus;
        V v;
        ClauseStatus clauseStatus = ClauseStatus.NEITHER;
        int n = 0;
        int n2 = -1;
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.mPositiveAtoms.length) {
            v = this.mPositiveAtoms[n3];
            variableStatus = abstractMaxSatSolver.getCurrentVariableStatus(v);
            switch (variableStatus) {
                case FALSE: {
                    break;
                }
                case TRUE: {
                    clauseStatus = ClauseStatus.TRUE;
                    break;
                }
                case UNSET: {
                    ++n;
                    n2 = n3;
                    bl = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            ++n3;
        }
        boolean bl2 = this.mIsHorn = n <= 1;
        if (clauseStatus == ClauseStatus.NEITHER) {
            n3 = 0;
            while (n3 < this.mNegativeAtoms.length) {
                v = this.mNegativeAtoms[n3];
                variableStatus = abstractMaxSatSolver.getCurrentVariableStatus(v);
                switch (variableStatus) {
                    case FALSE: {
                        clauseStatus = ClauseStatus.TRUE;
                        break;
                    }
                    case TRUE: {
                        break;
                    }
                    case UNSET: {
                        ++n;
                        n2 = n3;
                        bl = false;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                ++n3;
            }
        }
        assert (n >= 0 && n <= this.mPositiveAtoms.length + this.mNegativeAtoms.length);
        if (clauseStatus == ClauseStatus.TRUE) {
            ++trues;
            return TRUE_CLAUSE_CONDITION;
        }
        if (n == 0 || clauseStatus == ClauseStatus.FALSE) {
            assert (clauseStatus != ClauseStatus.TRUE);
            ++falses;
            return FALSE_CLAUSE_CONDITION;
        }
        assert (clauseStatus == ClauseStatus.NEITHER);
        ++neithers;
        if (n == 1) {
            return new PseudoUnitClauseCondition(n2, bl);
        }
        return UNDETERMINED_CLAUSE_CONDITION;
    }

    public Pair<V, Boolean> getPropagatee() {
        int n = this.mClauseCondition.getUnitIndex();
        boolean bl = n >= 0;
        V v = bl ? this.mPositiveAtoms[n] : this.mNegativeAtoms[-(n + 1)];
        return new Pair(v, (Object)bl);
    }

    public boolean isEquivalentToFalse() {
        return this.mClauseCondition.getClauseStatus() == ClauseStatus.FALSE;
    }

    public boolean isEquivalentToTrue() {
        return this.mClauseCondition.getClauseStatus() == ClauseStatus.TRUE;
    }

    public boolean isPseudoUnit() {
        return this.mClauseCondition.isPseudoUnit();
    }

    public V[] getPositiveAtoms() {
        return this.mPositiveAtoms;
    }

    public V[] getNegativeAtoms() {
        return this.mNegativeAtoms;
    }

    public ClauseStatus getClauseStatus() {
        return this.mClauseCondition.getClauseStatus();
    }

    public Pair<V, Boolean> getUnsetAtom(AbstractMaxSatSolver<V> abstractMaxSatSolver) {
        VariableStatus variableStatus;
        V v;
        if (!this.mClauseCondition.isPseudoUnit()) {
            throw new IllegalArgumentException("not only one unset Atom");
        }
        V[] VArray = this.mPositiveAtoms;
        int n = this.mPositiveAtoms.length;
        int n2 = 0;
        while (n2 < n) {
            v = VArray[n2];
            variableStatus = abstractMaxSatSolver.getCurrentVariableStatus(v);
            switch (variableStatus) {
                case TRUE: 
                case FALSE: {
                    break;
                }
                case UNSET: {
                    return new Pair(v, (Object)true);
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            ++n2;
        }
        VArray = this.mNegativeAtoms;
        n = this.mNegativeAtoms.length;
        n2 = 0;
        while (n2 < n) {
            v = VArray[n2];
            variableStatus = abstractMaxSatSolver.getCurrentVariableStatus(v);
            switch (variableStatus) {
                case TRUE: 
                case FALSE: {
                    break;
                }
                case UNSET: {
                    return new Pair(v, (Object)false);
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            ++n2;
        }
        throw new AssertionError((Object)"did not find unset atom");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<V> iterator = Arrays.asList(this.mNegativeAtoms).iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" /\\ ");
        }
        if (this.mNegativeAtoms.length > 0) {
            stringBuilder.append(" --> ");
        }
        if (this.mPositiveAtoms.length == 0) {
            stringBuilder.append("false");
        } else {
            iterator = Arrays.asList(this.mPositiveAtoms).iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(" \\/ ");
            }
        }
        return stringBuilder.toString();
    }

    public boolean isHorn() {
        return this.mIsHorn;
    }

    @Deprecated
    public boolean isHornCurrent(AbstractMaxSatSolver<V> abstractMaxSatSolver) {
        boolean bl = false;
        V[] VArray = this.mPositiveAtoms;
        int n = this.mPositiveAtoms.length;
        int n2 = 0;
        while (n2 < n) {
            V v = VArray[n2];
            VariableStatus variableStatus = abstractMaxSatSolver.getCurrentVariableStatus(v);
            switch (variableStatus) {
                case UNSET: {
                    if (bl) {
                        return false;
                    }
                    bl = true;
                    break;
                }
                case FALSE: {
                    break;
                }
                case TRUE: {
                    throw new IllegalArgumentException("Do not call this method for clauses which are equivalent to 'true'.");
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Clause clause = (Clause)object;
        if (!Arrays.equals(this.mNegativeAtoms, clause.mNegativeAtoms)) {
            return false;
        }
        return Arrays.equals(this.mPositiveAtoms, clause.mPositiveAtoms);
    }
}

