/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICPossibleIncompleteType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class CStructOrUnion
implements ICType,
ICPossibleIncompleteType<CStructOrUnion> {
    private final StructOrUnion mIsStructOrUnion;
    private String[] mFieldNames;
    private ICType[] mFieldTypes;
    private final String mStructName;
    private List<Integer> mBitFieldWidths;
    private boolean mIsComplete;

    public CStructOrUnion(StructOrUnion structOrUnion, String string, List<String> list, List<ICType> list2, List<Integer> list3) {
        this(structOrUnion, string, (String[])list.toArray(String[]::new), (ICType[])list2.toArray(ICType[]::new), list3);
    }

    public CStructOrUnion(StructOrUnion structOrUnion, String string, String[] stringArray, ICType[] iCTypeArray, List<Integer> list) {
        assert (string != null);
        assert (stringArray.length == list.size());
        this.mIsStructOrUnion = structOrUnion;
        this.mFieldNames = stringArray;
        this.mFieldTypes = iCTypeArray;
        this.mBitFieldWidths = Collections.unmodifiableList(list);
        this.mStructName = Objects.requireNonNull(string);
        this.mIsComplete = true;
    }

    public CStructOrUnion(StructOrUnion structOrUnion, String string) {
        assert (string != null && !string.isEmpty());
        this.mIsStructOrUnion = structOrUnion;
        this.mFieldNames = new String[0];
        this.mFieldTypes = new ICType[0];
        this.mBitFieldWidths = Collections.emptyList();
        this.mStructName = Objects.requireNonNull(string);
        this.mIsComplete = false;
    }

    @Override
    public boolean isIncomplete() {
        return !this.mIsComplete;
    }

    public int getFieldCount() {
        return this.mFieldNames.length;
    }

    public ICType getFieldType(String string) {
        assert (!this.isIncomplete()) : "Cannot get a field type in an incomplete struct type.";
        int n = Arrays.asList(this.mFieldNames).indexOf(string);
        if (n < 0) {
            throw new IllegalArgumentException("Field not in struct: " + string);
        }
        return this.mFieldTypes[n];
    }

    public ICType[] getFieldTypes() {
        return this.mFieldTypes;
    }

    public String[] getFieldIds() {
        return (String[])this.mFieldNames.clone();
    }

    @Override
    public String getName() {
        return this.mStructName;
    }

    public StructOrUnion isStructOrUnion() {
        return this.mIsStructOrUnion;
    }

    @Override
    public String toString() {
        String string = CStructOrUnion.getPrefix(this.mIsStructOrUnion);
        if (this.isIncomplete()) {
            return string + "~incomplete~" + this.getName();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append('~');
        stringBuilder.append(this.getName());
        int n = 0;
        while (n < this.getFieldCount()) {
            stringBuilder.append("?");
            stringBuilder.append(this.mFieldNames[n]);
            stringBuilder.append("~");
            stringBuilder.append(this.mFieldTypes[n].toString());
            ++n;
        }
        stringBuilder.append("#");
        return stringBuilder.toString();
    }

    @Override
    public CStructOrUnion complete(CStructOrUnion cStructOrUnion) {
        if (!this.isIncomplete()) {
            throw new AssertionError((Object)"only incomplete structs can be completed");
        }
        assert (cStructOrUnion.mFieldNames.length == cStructOrUnion.getBitFieldWidths().size());
        return new CStructOrUnion(cStructOrUnion.isStructOrUnion(), this.mStructName, cStructOrUnion.mFieldNames, cStructOrUnion.mFieldTypes, cStructOrUnion.getBitFieldWidths());
    }

    public void complete(List<String> list, List<ICType> list2, List<Integer> list3) {
        assert (list.size() == list3.size());
        this.mFieldNames = (String[])list.toArray(String[]::new);
        this.mFieldTypes = (ICType[])list2.toArray(ICType[]::new);
        this.mBitFieldWidths = list3;
        this.mIsComplete = true;
    }

    public List<Integer> getBitFieldWidths() {
        return this.mBitFieldWidths;
    }

    public int getBitfieldWidth(String string) {
        assert (!this.isIncomplete()) : "Cannot get a field type in an incomplete struct type.";
        int n = Arrays.asList(this.mFieldNames).indexOf(string);
        if (n < 0) {
            throw new IllegalArgumentException("Field not in struct: " + string);
        }
        if (this.getBitFieldWidths().size() < n) {
            return -1;
        }
        return this.getBitFieldWidths().get(n);
    }

    public static boolean isUnion(ICType iCType) {
        if (iCType instanceof CStructOrUnion) {
            return ((CStructOrUnion)iCType).isStructOrUnion() == StructOrUnion.UNION;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.mStructName.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    public static String getPrefix(StructOrUnion structOrUnion) {
        return switch (structOrUnion) {
            case StructOrUnion.STRUCT -> "STRUCT~";
            case StructOrUnion.UNION -> "UNION~";
            default -> throw new MatchException(null, null);
        };
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    public static enum StructOrUnion {
        STRUCT,
        UNION;

    }
}

