/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ArraySortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.BitVectorInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.NumericSortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SharedTermEvaluator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ArrayTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCBaseTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.DataTypeTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ComputeSCC;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModelBuilder {
    Model mModel;
    SharedTermEvaluator mEvaluator;
    Map<CCTerm, Term> mModelValues = new HashMap<CCTerm, Term>();
    Theory mTheory;

    public ModelBuilder(CClosure cClosure, List<CCTerm> list, Model model, Theory theory, SharedTermEvaluator sharedTermEvaluator, ArrayTheory arrayTheory, DataTypeTheory dataTypeTheory, CCTerm cCTerm, CCTerm cCTerm2) {
        List<CCTerm> list2;
        Object object;
        this.mModel = model;
        this.mEvaluator = sharedTermEvaluator;
        this.mTheory = theory;
        LinkedHashMap<Sort, List<CCTerm>> linkedHashMap = new LinkedHashMap<Sort, List<CCTerm>>();
        for (CCTerm object22 : list) {
            if (object22.getRepresentative() != object22 || object22.getFlatTerm() == null) continue;
            object = object22.getFlatTerm().getSort();
            list2 = (List)linkedHashMap.get(object);
            if (list2 == null) {
                list2 = new ArrayList<CCTerm>();
                linkedHashMap.put((Sort)object, list2);
            }
            list2.add(object22);
        }
        ComputeSCC.ComputeSuccessor<Sort> computeSuccessor = sort -> {
            if (sort.isArraySort()) {
                return Arrays.asList(sort.getArguments()).iterator();
            }
            if (sort.getSortSymbol().isDatatype()) {
                final Sort[] sortArray = sort.getArguments();
                final DataType.Constructor[] constructorArray = ((DataType)sort.getSortSymbol()).getConstructors();
                return new Iterator<Sort>(theory){
                    int mConstructorIdx = 0;
                    int mSortIdx = 0;
                    Sort[] mSorts;
                    {
                        this.mSorts = new Sort[]{theory.getBooleanSort()};
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.mSortIdx >= this.mSorts.length) {
                            if (this.mConstructorIdx == constructorArray.length) {
                                return false;
                            }
                            this.mSorts = constructorArray[this.mConstructorIdx++].getArgumentSorts();
                            this.mSortIdx = 0;
                        }
                        return true;
                    }

                    @Override
                    public Sort next() {
                        while (this.mSortIdx >= this.mSorts.length) {
                            this.mSorts = constructorArray[this.mConstructorIdx++].getArgumentSorts();
                            this.mSortIdx = 0;
                        }
                        Sort sort = this.mSorts[this.mSortIdx++];
                        return sortArray == null ? sort : sort.mapSort(sortArray);
                    }
                };
            }
            if (sort.isBitVecSort()) {
                return Collections.singleton(sort.getTheory().getNumericSort()).iterator();
            }
            return Collections.emptyListIterator();
        };
        List<List<Sort>> list3 = new ComputeSCC<Sort>(computeSuccessor).getSCCs(linkedHashMap.keySet().iterator());
        list2 = list3.iterator();
        while (list2.hasNext()) {
            object = (List)list2.next();
            if (((Sort)object.get(0)).getSortSymbol().isDatatype()) {
                dataTypeTheory.fillInModel(this, (List<Sort>)object, linkedHashMap);
                continue;
            }
            assert (object.size() == 1);
            Sort sort2 = (Sort)object.get(0);
            if (!linkedHashMap.containsKey(sort2)) continue;
            if (sort2.isArraySort()) {
                arrayTheory.fillInModel(this, linkedHashMap.get(sort2));
                continue;
            }
            this.fillInTermValues(linkedHashMap.get(sort2), cCTerm, cCTerm2);
        }
        this.fillInFunctions(list, model, theory);
    }

    public Model getModel() {
        return this.mModel;
    }

    public Theory getTheory() {
        return this.mTheory;
    }

    public SharedTermEvaluator getEvaluator() {
        return this.mEvaluator;
    }

    public Term getModelValue(CCTerm cCTerm) {
        return this.mModelValues.get(cCTerm.getRepresentative());
    }

    public void setModelValue(CCTerm cCTerm, Term term) {
        assert (cCTerm == cCTerm.getRepresentative());
        Term term2 = this.mModelValues.put(cCTerm, term);
        this.mModel.provideSortInterpretation(term.getSort()).register(term);
        assert (term2 == null || term2 == term);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void fillInTermValues(List<CCTerm> var1_1, CCTerm var2_2, CCTerm var3_3) {
        var4_4 = new HashSet<CCTerm>();
        for (CCTerm var5_6 : var1_1) {
            if (var5_6 != var5_6.mRepStar || var5_6.isFunc()) continue;
            var8_8 = var5_6.getFlatTerm();
            var9_9 = var8_8.getSort();
            if (!var9_9.isNumericSort()) ** GOTO lbl16
            if (var5_6.getSharedTerm() != null) {
                var10_10 = this.mEvaluator.evaluate(var5_6.getSharedTerm().getFlatTerm(), this.mTheory);
                if (var8_8.getSort().getName().equals("Int") && !var10_10.isIntegral()) {
                    throw new AssertionError((Object)"Int term has non-integral value");
                }
                var7_7 = var10_10.toTerm(var9_9);
            } else {
                var4_4.add(var5_6);
                continue;
lbl16:
                // 1 sources

                if (var5_6.getFlatTerm().getSort().isBitVecSort()) {
                    var7_7 = null;
                    for (Object var10_10 : var5_6.mRepStar.mMembers) {
                        var12_12 = var10_10.getFlatTerm();
                        if (!(var12_12 instanceof ApplicationTerm) || !((ApplicationTerm)var12_12).getFunction().getName().equals("nat2bv")) continue;
                        var13_13 = ((ApplicationTerm)var12_12).getParameters()[0];
                        var14_14 = this.mEvaluator.evaluate(var13_13, this.mTheory);
                        if (!ModelBuilder.$assertionsDisabled && !var14_14.isIntegral()) {
                            throw new AssertionError();
                        }
                        var15_15 = var14_14.numerator();
                        var16_16 = Integer.parseInt(var12_12.getSort().getIndices()[0]);
                        var15_15 = var15_15.mod(BigInteger.ONE.shiftLeft(var16_16));
                        var7_7 = BitVectorInterpretation.BV(var15_15, var12_12.getSort());
                        break;
                    }
                    if (!ModelBuilder.$assertionsDisabled && var7_7 == null) {
                        throw new AssertionError();
                    }
                } else if (var5_6 == var2_2.mRepStar) {
                    var7_7 = var9_9.getTheory().mTrue;
                } else if (var9_9.isInternal() && var9_9.getName().equals("Bool")) {
                    var7_7 = var9_9.getTheory().mFalse;
                } else {
                    if (!ModelBuilder.$assertionsDisabled && (var9_9.isArraySort() || var9_9.getSortSymbol().isDatatype())) {
                        throw new AssertionError();
                    }
                    var7_7 = this.mModel.extendFresh(var9_9);
                }
            }
            this.setModelValue(var5_6, var7_7);
        }
        for (CCTerm var5_6 : var4_4) {
            var7_7 = this.mModel.extendFresh(var5_6.getFlatTerm().getSort());
            this.setModelValue(var5_6, var7_7);
        }
    }

    public void fillInFunctions(List<CCTerm> list, Model model, Theory theory) {
        for (CCTerm cCTerm : list) {
            if (cCTerm.isFunc()) continue;
            this.add(model, cCTerm, this.mModelValues.get(cCTerm.getRepresentative()), theory);
        }
    }

    private void add(Model model, CCTerm cCTerm, Term term, Theory theory) {
        assert (!cCTerm.isFunc());
        if (cCTerm instanceof CCBaseTerm) {
            ApplicationTerm applicationTerm;
            FunctionSymbol functionSymbol;
            CCBaseTerm cCBaseTerm = (CCBaseTerm)cCTerm;
            Term term2 = cCBaseTerm.getFlatTerm();
            if (term2 instanceof ApplicationTerm && !(functionSymbol = (applicationTerm = (ApplicationTerm)term2).getFunction()).isIntern() && applicationTerm.getParameters().length == 0) {
                model.map(functionSymbol, term);
            }
        } else {
            CCAppTerm cCAppTerm = (CCAppTerm)cCTerm;
            this.addApp(model, cCAppTerm, term, theory);
        }
    }

    private static boolean isDivision(FunctionSymbol functionSymbol) {
        String string = functionSymbol.getName();
        return string == "/" || string == "div" || string == "mod";
    }

    private boolean isUndefinedFor(FunctionSymbol functionSymbol, ArrayDeque<Term> arrayDeque) {
        if (functionSymbol.isSelector()) {
            ApplicationTerm applicationTerm;
            DataType dataType = (DataType)functionSymbol.getParameterSorts()[0].getSortSymbol();
            DataType.Constructor constructor = dataType.getConstructor((applicationTerm = (ApplicationTerm)arrayDeque.getFirst()).getFunction().getName());
            return !Arrays.asList(constructor.getSelectors()).contains(functionSymbol.getName());
        }
        if (ModelBuilder.isDivision(functionSymbol)) {
            return NumericSortInterpretation.toRational(arrayDeque.getLast()) == Rational.ZERO;
        }
        return false;
    }

    private void addApp(Model model, CCAppTerm cCAppTerm, Term term, Theory theory) {
        CCTerm cCTerm;
        ArrayDeque<Term> arrayDeque = new ArrayDeque<Term>();
        CCTerm cCTerm2 = cCAppTerm;
        while (cCTerm2 instanceof CCAppTerm) {
            cCTerm = cCTerm2;
            arrayDeque.addFirst(this.mModelValues.get(((CCAppTerm)cCTerm).getArg().getRepresentative()));
            cCTerm2 = ((CCAppTerm)cCTerm).getFunc();
        }
        cCTerm = (CCBaseTerm)cCTerm2;
        if (((CCBaseTerm)cCTerm).isFunctionSymbol()) {
            FunctionSymbol functionSymbol = ((CCBaseTerm)cCTerm).getFunctionSymbol();
            if (!functionSymbol.isIntern() || this.isUndefinedFor(functionSymbol, arrayDeque)) {
                model.map(functionSymbol, arrayDeque.toArray(new Term[arrayDeque.size()]), term);
            } else if (functionSymbol.getName() == "@diff") {
                ArraySortInterpretation arraySortInterpretation = (ArraySortInterpretation)model.provideSortInterpretation(functionSymbol.getParameterSorts()[0]);
                assert (arrayDeque.size() == 2);
                arraySortInterpretation.addDiff(arrayDeque.getFirst(), arrayDeque.getLast(), term);
            }
        }
    }
}

