/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AnnotationToProofTerm {
    private static final Annotation TRICHOTOMY = new Annotation(":trichotomy", null);

    private Rational computeGcd(LAAnnotation lAAnnotation) {
        Rational rational = null;
        Iterator<Rational> iterator = lAAnnotation.getCoefficients().values().iterator();
        if (iterator.hasNext()) {
            rational = iterator.next();
        }
        while (iterator.hasNext()) {
            rational = rational.gcd(iterator.next());
        }
        iterator = lAAnnotation.getAuxAnnotations().values().iterator();
        if (rational == null && iterator.hasNext()) {
            rational = iterator.next();
        }
        while (iterator.hasNext()) {
            rational = rational.gcd(iterator.next());
        }
        assert (rational != null);
        return rational;
    }

    private void computeLiterals(LAAnnotation lAAnnotation, Theory theory, AnnotationInfo annotationInfo) {
        MutableAffineTerm mutableAffineTerm = new MutableAffineTerm();
        mutableAffineTerm.add(Rational.ONE, lAAnnotation.getLinVar());
        mutableAffineTerm.add(lAAnnotation.getBound().negate());
        if (!lAAnnotation.isUpper()) {
            mutableAffineTerm.add(lAAnnotation.getLinVar().getEpsilon());
        }
        Term term = mutableAffineTerm.toSMTLibLeq0(theory);
        annotationInfo.mLiteral = new ProofLiteral(term, lAAnnotation.isUpper());
    }

    public Term convert(LAAnnotation lAAnnotation, ProofRules proofRules) {
        Object object;
        Object object2;
        assert (lAAnnotation.getLinVar() == null);
        Theory theory = proofRules.getTheory();
        HashMap<LAAnnotation, Object> hashMap = new HashMap<LAAnnotation, Object>();
        ArrayDeque<LAAnnotation> arrayDeque = new ArrayDeque<LAAnnotation>();
        arrayDeque.add(lAAnnotation);
        while (!arrayDeque.isEmpty()) {
            object2 = (LAAnnotation)arrayDeque.removeFirst();
            object = (AnnotationInfo)hashMap.get(object2);
            if (object == null) {
                object = new AnnotationInfo();
                hashMap.put((LAAnnotation)object2, object);
                if (object2.getLinVar() != null) {
                    this.computeLiterals((LAAnnotation)object2, theory, (AnnotationInfo)object);
                }
                arrayDeque.addAll(object2.getAuxAnnotations().keySet());
            }
            ++((AnnotationInfo)object).mCount;
        }
        object2 = null;
        arrayDeque.add(lAAnnotation);
        while (!arrayDeque.isEmpty()) {
            Object object3;
            object = (LAAnnotation)arrayDeque.removeFirst();
            AnnotationInfo annotationInfo = (AnnotationInfo)hashMap.get(object);
            ++annotationInfo.mVisited;
            if (annotationInfo.mVisited < annotationInfo.mCount) continue;
            arrayDeque.addAll(((LAAnnotation)object).getAuxAnnotations().keySet());
            Rational rational = this.computeGcd((LAAnnotation)object);
            int n = ((LAAnnotation)object).getCoefficients().size() + ((LAAnnotation)object).getAuxAnnotations().size() + (annotationInfo.mLiteral == null ? 0 : 1);
            int n2 = 0;
            ProofLiteral[] proofLiteralArray = new ProofLiteral[n];
            Term[] termArray = new Term[n];
            if (annotationInfo.mLiteral != null) {
                Rational rational2 = ((LAAnnotation)object).isUpper() ? Rational.MONE : Rational.ONE;
                proofLiteralArray[n2] = annotationInfo.mLiteral;
                termArray[n2] = rational2.div(rational).toTerm(this.getSort(theory));
                ++n2;
            }
            boolean bl = false;
            for (Map.Entry<Literal, Rational> entry : ((LAAnnotation)object).getCoefficients().entrySet()) {
                object3 = entry.getKey();
                if (object3 instanceof LAEquality) {
                    bl = true;
                }
                proofLiteralArray[n2] = new ProofLiteral(((Literal)object3).getAtom().getSMTFormula(theory), object3 == ((Literal)object3).getAtom());
                termArray[n2] = entry.getValue().div(rational).toTerm(this.getSort(theory));
                ++n2;
            }
            for (Map.Entry<Object, Rational> entry : ((LAAnnotation)object).getAuxAnnotations().entrySet()) {
                object3 = (AnnotationInfo)hashMap.get(entry.getKey());
                proofLiteralArray[n2] = ((AnnotationInfo)object3).mLiteral.negate();
                termArray[n2] = entry.getValue().div(rational).toTerm(this.getSort(theory));
                ++n2;
            }
            if (proofLiteralArray.length == 2 && proofLiteralArray[0].equals(proofLiteralArray[1].negate())) continue;
            Annotation[] annotationArray = new Annotation[]{bl ? TRICHOTOMY : new Annotation(":LA", (Object)termArray)};
            Iterator<Map.Entry<Object, Rational>> iterator = proofRules.oracle(proofLiteralArray, annotationArray);
            object2 = object2 == null ? iterator : proofRules.resolutionRule(annotationInfo.mLiteral.getAtom(), (Term)(annotationInfo.mLiteral.getPolarity() ? iterator : object2), (Term)(annotationInfo.mLiteral.getPolarity() ? object2 : iterator));
        }
        return object2;
    }

    private Sort getSort(Theory theory) {
        Sort sort = theory.getSort("Int", new Sort[0]);
        return sort == null ? theory.getSort("Real", new Sort[0]) : sort;
    }

    class AnnotationInfo {
        int mCount;
        int mVisited;
        ProofLiteral mLiteral;

        AnnotationInfo() {
        }
    }
}

