/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.multireduction.ISleepMapStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.multireduction.SleepMap;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IMLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.SleepMapPredicate;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

class SleepMapStateFactory<L>
implements ISleepMapStateFactory<L, IPredicate, IPredicate> {
    private final IPredicate mEmptyStack;
    private final Map<SleepMapPredicate<L>, SleepMapPredicate<L>> mUnifyingMap = new HashMap<SleepMapPredicate<L>, SleepMapPredicate<L>>();

    public SleepMapStateFactory(PredicateFactory predicateFactory) {
        this.mEmptyStack = predicateFactory.newEmptyStackPredicate();
    }

    public IPredicate createEmptyStackState() {
        return this.mEmptyStack;
    }

    public IPredicate createSleepMapState(IPredicate iPredicate, SleepMap<L, IPredicate> sleepMap, int n) {
        SleepMapPredicate<L> sleepMapPredicate = new SleepMapPredicate<L>((IMLPredicate)iPredicate, sleepMap, n);
        return (IPredicate)this.mUnifyingMap.computeIfAbsent(sleepMapPredicate, Function.identity());
    }

    public IPredicate getOriginalState(IPredicate iPredicate) {
        return ((SleepMapPredicate)iPredicate).getUnderlying();
    }

    public SleepMap<L, IPredicate> getSleepMap(IPredicate iPredicate) {
        return ((SleepMapPredicate)iPredicate).getSleepMap();
    }

    public int getBudget(IPredicate iPredicate) {
        return ((SleepMapPredicate)iPredicate).getBudget();
    }

    public void reset() {
        this.mUnifyingMap.clear();
    }
}

