/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.mapelim.monniaux;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import java.util.HashSet;
import java.util.Set;

public final class StoreSelectEqualityCollector
extends TermTransformer {
    private final Set<Term> mStoreTerms = new HashSet<Term>();
    private final Set<Term> mSelectTerms = new HashSet<Term>();
    private final Set<Term> mEqualityTerms = new HashSet<Term>();
    private boolean mMultDim = false;

    protected void convert(Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            String string = applicationTerm.getFunction().getName();
            if (string.equals("=")) {
                if (!this.checkAndAddIfParamIsStoreTerm(applicationTerm) && applicationTerm.getParameters()[0].getSort().isArraySort() && applicationTerm.getParameters()[1].getSort().isArraySort()) {
                    this.mEqualityTerms.add(term);
                }
            } else if (string.equals("select")) {
                Term[] termArray;
                boolean bl = false;
                Term[] termArray2 = termArray = applicationTerm.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term2 = termArray2[n2];
                    if (term2 instanceof ApplicationTerm) {
                        this.mMultDim = true;
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    this.mSelectTerms.add((Term)applicationTerm);
                }
            } else {
                this.checkAndAddIfParamIsStoreTerm(applicationTerm);
            }
        }
        super.convert(term);
    }

    private boolean checkAndAddIfParamIsStoreTerm(ApplicationTerm applicationTerm) {
        Term[] termArray;
        Term[] termArray2 = termArray = applicationTerm.getParameters();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            ApplicationTerm applicationTerm2;
            Term term = termArray2[n2];
            if (term instanceof ApplicationTerm && StoreSelectEqualityCollector.isStore(applicationTerm2 = (ApplicationTerm)term)) {
                this.mStoreTerms.add((Term)applicationTerm);
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isStore(ApplicationTerm applicationTerm) {
        return "store".equals(applicationTerm.getFunction().getName());
    }

    protected boolean isEmpty() {
        return this.mSelectTerms.isEmpty() && this.mStoreTerms.isEmpty() && this.mEqualityTerms.isEmpty();
    }

    protected boolean hasNoStoEqu() {
        return this.mStoreTerms.isEmpty() && this.mEqualityTerms.isEmpty();
    }

    public boolean hasMultDim() {
        return this.mMultDim;
    }

    public String toString() {
        return "Store " + String.valueOf(this.mStoreTerms) + " Select " + String.valueOf(this.mSelectTerms) + " Equals " + String.valueOf(this.mEqualityTerms);
    }

    public Set<Term> getStoreTerms() {
        return this.mStoreTerms;
    }

    public Set<Term> getSelectTerms() {
        return this.mSelectTerms;
    }

    public Set<Term> getEqualityTerms() {
        return this.mEqualityTerms;
    }
}

