/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.buchiprogramproduct;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataSizeBenchmark;
import de.uni_freiburg.informatik.ultimate.boogie.annotation.LTLPropertyCheck;
import de.uni_freiburg.informatik.ultimate.buchiprogramproduct.Activator;
import de.uni_freiburg.informatik.ultimate.buchiprogramproduct.ProductBacktranslator;
import de.uni_freiburg.informatik.ultimate.buchiprogramproduct.productgenerator.ProductGenerator;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.ltl2aut.never2nwa.NWAContainer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.util.IcfgSizeBenchmark;

public class BuchiProductObserver
implements IUnmanagedObserver {
    private static final SmtUtils.SimplificationTechnique SIMPLIFICATION_TECHNIQUE = SmtUtils.SimplificationTechnique.SIMPLIFY_DDA;
    private final ILogger mLogger;
    private BoogieIcfgContainer mRcfg;
    private NWAContainer mNeverClaimNWAContainer;
    private BoogieIcfgContainer mProduct;
    private final IUltimateServiceProvider mServices;
    private final ProductBacktranslator mBacktranslator;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;

    public BuchiProductObserver(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, ProductBacktranslator productBacktranslator) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        this.mRcfg = null;
        this.mProduct = null;
        this.mNeverClaimNWAContainer = null;
        this.mBacktranslator = productBacktranslator;
        this.mSimplificationTechnique = SIMPLIFICATION_TECHNIQUE;
    }

    public void init(ModelType modelType, int n, int n2) {
    }

    public void finish() throws Throwable {
        if (this.mNeverClaimNWAContainer == null || this.mRcfg == null) {
            return;
        }
        this.reportSizeBenchmark("Initial property automaton", (INestedWordAutomaton<CodeBlock, String>)((INestedWordAutomaton)this.mNeverClaimNWAContainer.getValue()));
        this.reportSizeBenchmark("Initial RCFG", this.mRcfg);
        this.mLogger.info((Object)"Beginning generation of product automaton");
        LTLPropertyCheck lTLPropertyCheck = LTLPropertyCheck.getAnnotation((IElement)this.mNeverClaimNWAContainer);
        this.mProduct = new ProductGenerator((INestedWordAutomaton<CodeBlock, String>)((INestedWordAutomaton)this.mNeverClaimNWAContainer.getValue()), this.mRcfg, lTLPropertyCheck, this.mServices, this.mBacktranslator, this.mSimplificationTechnique).getProductRcfg();
        this.mLogger.info((Object)"Finished generation of product automaton successfully");
        this.reportSizeBenchmark("BuchiProgram size", this.mProduct);
    }

    private void reportSizeBenchmark(String string, INestedWordAutomaton<CodeBlock, String> iNestedWordAutomaton) {
        NestedWordAutomataSizeBenchmark nestedWordAutomataSizeBenchmark = new NestedWordAutomataSizeBenchmark(iNestedWordAutomaton, string);
        this.mLogger.info((Object)(string + " " + String.valueOf(nestedWordAutomataSizeBenchmark)));
        nestedWordAutomataSizeBenchmark.reportBenchmarkResult(this.mServices.getResultService(), Activator.PLUGIN_ID, string);
    }

    private void reportSizeBenchmark(String string, BoogieIcfgContainer boogieIcfgContainer) {
        IcfgSizeBenchmark icfgSizeBenchmark = new IcfgSizeBenchmark((IIcfg)boogieIcfgContainer, string);
        this.mLogger.info((Object)(string + " " + String.valueOf(icfgSizeBenchmark)));
        icfgSizeBenchmark.reportBenchmarkResult(this.mServices.getResultService(), Activator.PLUGIN_ID, string);
    }

    public boolean performedChanges() {
        return false;
    }

    public IElement getModel() {
        return this.mProduct;
    }

    public boolean process(IElement iElement) throws Exception {
        if (iElement instanceof NWAContainer) {
            this.mLogger.debug((Object)"Collecting NWA representing NeverClaim");
            this.mNeverClaimNWAContainer = (NWAContainer)iElement;
            return false;
        }
        if (iElement instanceof BoogieIcfgContainer) {
            this.mLogger.debug((Object)"Collecting RCFG RootNode");
            this.mRcfg = (BoogieIcfgContainer)iElement;
            return false;
        }
        return true;
    }
}

