/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions;

import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.Ordinal;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class NestedRankingFunction
extends RankingFunction {
    private static final long serialVersionUID = 380153194719949843L;
    private final AffineFunction[] mRanking;
    public final int mFunctions;

    public NestedRankingFunction(AffineFunction[] affineFunctionArray) {
        this.mRanking = affineFunctionArray;
        this.mFunctions = affineFunctionArray.length;
        assert (this.mFunctions > 0);
    }

    @Override
    public String getName() {
        return this.mRanking.length + "-nested";
    }

    @Override
    public Set<IProgramVar> getVariables() {
        LinkedHashSet<IProgramVar> linkedHashSet = new LinkedHashSet<IProgramVar>();
        AffineFunction[] affineFunctionArray = this.mRanking;
        int n = this.mRanking.length;
        int n2 = 0;
        while (n2 < n) {
            AffineFunction affineFunction = affineFunctionArray[n2];
            linkedHashSet.addAll(affineFunction.getVariables());
            ++n2;
        }
        return linkedHashSet;
    }

    public AffineFunction[] getComponents() {
        return this.mRanking;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.mRanking.length);
        stringBuilder.append("-nested ranking function:\n");
        int n = 0;
        while (n < this.mFunctions) {
            stringBuilder.append("  f" + n);
            stringBuilder.append(" = ");
            stringBuilder.append(this.mRanking[n]);
            if (n < this.mFunctions - 1) {
                stringBuilder.append("\n");
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    @Override
    public Term[] asLexTerm(Script script) throws SMTLIBException {
        BigInteger bigInteger = BigInteger.ZERO;
        Term term = SmtUtils.constructIntValue((Script)script, (BigInteger)bigInteger);
        Term term2 = this.mRanking[this.mRanking.length - 1].asTerm(script);
        int n = this.mRanking.length - 2;
        while (n >= 0) {
            bigInteger = bigInteger.add(BigInteger.ONE);
            Term term3 = this.mRanking[n].asTerm(script);
            Term term4 = script.term(">", new Term[]{term3, SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO)});
            term = script.term("ite", new Term[]{term4, SmtUtils.constructIntValue((Script)script, (BigInteger)bigInteger), term});
            term2 = script.term("ite", new Term[]{term4, term3, term2});
            --n;
        }
        return new Term[]{term, term2};
    }

    @Override
    public Ordinal evaluate(Map<IProgramVar, Rational> map) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Ordinal codomain() {
        return Ordinal.fromInteger(BigInteger.valueOf(this.mRanking.length)).mult(Ordinal.OMEGA);
    }
}

