/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctConjunction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctTerm;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonSubstitution;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonSubstitutionTerm;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.ParametricOctValue;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OctagonCalculator
extends NonRecursive {
    private final FastUPRUtils mUtils;
    private final ManagedScript mManagedScript;

    public OctagonCalculator(FastUPRUtils fastUPRUtils, ManagedScript managedScript) {
        this.mUtils = fastUPRUtils;
        this.mManagedScript = managedScript;
    }

    public OctConjunction removeInOutVars(OctConjunction octConjunction, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        OctConjunction octConjunction2 = octConjunction;
        for (Map.Entry<IProgramVar, TermVariable> entry : map.entrySet()) {
            if (!map2.containsValue(entry.getValue())) continue;
            Sort sort = this.mManagedScript.getScript().sort("Int", new Sort[0]);
            String string = "oct_" + entry.getKey().toString() + "_in";
            TermVariable termVariable = this.mManagedScript.constructFreshTermVariable(string, sort);
            String string2 = "oct_" + entry.getKey().toString() + "_out";
            TermVariable termVariable2 = this.mManagedScript.constructFreshTermVariable(string2, sort);
            octConjunction2 = OctagonCalculator.replaceInOutVars(octConjunction2, entry.getValue(), termVariable);
            octConjunction2 = OctagonCalculator.getInOutVarTerms(octConjunction2, termVariable, termVariable2);
            map.put(entry.getKey(), termVariable);
            map2.put(entry.getKey(), termVariable2);
        }
        return octConjunction2;
    }

    private static OctConjunction getInOutVarTerms(OctConjunction octConjunction, TermVariable termVariable, TermVariable termVariable2) {
        OctConjunction octConjunction2 = octConjunction;
        octConjunction2.addTerm(OctagonFactory.createTwoVarOctTerm(BigDecimal.ZERO, termVariable, false, termVariable2, true));
        octConjunction2.addTerm(OctagonFactory.createTwoVarOctTerm(BigDecimal.ZERO, termVariable, true, termVariable2, false));
        return octConjunction2;
    }

    private static OctConjunction replaceInOutVars(OctConjunction octConjunction, TermVariable termVariable, TermVariable termVariable2) {
        OctConjunction octConjunction2 = new OctConjunction();
        for (OctTerm octTerm : octConjunction.getTerms()) {
            if (octTerm.isOneVar() && octTerm.getFirstVar().equals(termVariable)) {
                octConjunction2.addTerm(OctagonFactory.createOneVarOctTerm(octTerm.getValue(), termVariable2, octTerm.isFirstNegative()));
                continue;
            }
            if (octTerm.getFirstVar().equals(termVariable)) {
                octConjunction2.addTerm(OctagonFactory.createTwoVarOctTerm(octTerm.getValue(), termVariable2, octTerm.isFirstNegative(), octTerm.getSecondVar(), octTerm.isSecondNegative()));
                continue;
            }
            if (octTerm.getSecondVar().equals(termVariable)) {
                octConjunction2.addTerm(OctagonFactory.createTwoVarOctTerm(octTerm.getValue(), octTerm.getFirstVar(), octTerm.isFirstNegative(), termVariable2, octTerm.isSecondNegative()));
                continue;
            }
            octConjunction2.addTerm(octTerm);
        }
        return octConjunction2;
    }

    public OctConjunction normalizeVarNames(OctConjunction octConjunction, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        TermVariable termVariable;
        String string;
        this.mUtils.debug("Normalizing VarNames for:");
        this.mUtils.debug(octConjunction.toString());
        OctConjunction octConjunction2 = octConjunction;
        Sort sort = this.mManagedScript.getScript().sort("Int", new Sort[0]);
        for (IProgramVar iProgramVar : map.keySet()) {
            if (map2.containsKey(iProgramVar) && map2.get(iProgramVar).equals(map.get(iProgramVar))) {
                string = "oct_" + iProgramVar.toString() + "_inout";
                termVariable = this.mManagedScript.constructFreshTermVariable(string, sort);
                octConjunction2 = this.replaceVars(octConjunction2, map.get(iProgramVar), termVariable);
                map.put(iProgramVar, termVariable);
                map2.put(iProgramVar, termVariable);
            } else {
                string = "oct_" + iProgramVar.toString() + "_in";
                termVariable = this.mManagedScript.constructFreshTermVariable(string, sort);
                octConjunction2 = this.replaceVars(octConjunction2, map.get(iProgramVar), termVariable);
                map.put(iProgramVar, termVariable);
            }
            this.mUtils.debug(map.toString());
        }
        for (IProgramVar iProgramVar : map2.keySet()) {
            if (!map2.containsKey(iProgramVar) || map2.get(iProgramVar).equals(map.get(iProgramVar))) continue;
            string = "oct_" + iProgramVar.toString() + "_out";
            termVariable = this.mManagedScript.constructFreshTermVariable(string, sort);
            octConjunction2 = this.replaceVars(octConjunction2, map2.get(iProgramVar), termVariable);
            map2.put(iProgramVar, termVariable);
        }
        this.mUtils.debug(octConjunction2.toString());
        return octConjunction2;
    }

    private OctConjunction replaceVars(OctConjunction octConjunction, TermVariable termVariable, TermVariable termVariable2) {
        this.mUtils.debug("Replacing " + termVariable.toString() + " with " + termVariable2.toString());
        OctConjunction octConjunction2 = new OctConjunction();
        for (OctTerm octTerm : octConjunction.getTerms()) {
            this.mUtils.debug("Replacing in:");
            this.mUtils.debug(octTerm.toString());
            boolean bl = false;
            boolean bl2 = false;
            if (octTerm.getFirstVar().equals(termVariable)) {
                this.mUtils.debug(octTerm.getFirstVar().toString() + " = " + termVariable.toString());
                bl = true;
            }
            if (octTerm.getSecondVar().equals(termVariable)) {
                this.mUtils.debug(octTerm.getSecondVar().toString() + " = " + termVariable.toString());
                bl2 = true;
            }
            if (octTerm.isOneVar()) {
                var9_9 = OctagonFactory.createOneVarOctTerm(octTerm.getValue(), bl ? termVariable2 : octTerm.getFirstVar(), octTerm.isFirstNegative());
                octConjunction2.addTerm(var9_9);
                this.mUtils.debug(var9_9.toString());
            } else {
                var9_9 = OctagonFactory.createTwoVarOctTerm(octTerm.getValue(), bl ? termVariable2 : octTerm.getFirstVar(), octTerm.isFirstNegative(), bl2 ? termVariable2 : octTerm.getSecondVar(), octTerm.isSecondNegative());
                octConjunction2.addTerm(var9_9);
                this.mUtils.debug(var9_9.toString());
            }
            this.mUtils.debug(">> replaced.");
        }
        this.mUtils.debug(">>> All replaced.");
        return octConjunction2;
    }

    public OctConjunction sequentialize(OctConjunction octConjunction, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2, int n) {
        this.mUtils.debug("Sequentializing " + n + " times:" + octConjunction.toString());
        LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>();
        LinkedHashSet<TermVariable> linkedHashSet2 = new LinkedHashSet<TermVariable>();
        LinkedHashSet<TermVariable> linkedHashSet3 = new LinkedHashSet<TermVariable>();
        OctagonCalculator.getVariableSets(linkedHashSet2, linkedHashSet3, linkedHashSet, map, map2);
        OctConjunction octConjunction2 = octConjunction;
        this.mUtils.debug("> Getting Variable Mapping:");
        this.mUtils.debug("inVars: " + map.toString());
        this.mUtils.debug("outVars: " + map2.toString());
        Map<TermVariable, TermVariable> map3 = OctagonCalculator.getTermMapping(map, map2);
        Map<TermVariable, TermVariable> map4 = OctagonCalculator.getReverseTermMapping(map3);
        this.mUtils.debug(map3.toString());
        int n2 = 0;
        while (n2 < n - 1) {
            this.mUtils.debug("Binary Sequentialize > " + (n2 + 1));
            octConjunction2 = this.binarySequentialize(octConjunction2, octConjunction, linkedHashSet2, linkedHashSet3, map4);
            this.mUtils.debug(octConjunction2.toString());
            ++n2;
        }
        this.mUtils.debug("Result: " + octConjunction2.toString());
        return octConjunction2;
    }

    private static void getVariableSets(Set<TermVariable> set, Set<TermVariable> set2, Set<TermVariable> set3, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        TermVariable termVariable;
        assert (set3.isEmpty() && set.isEmpty() && set2.isEmpty());
        for (Map.Entry<IProgramVar, TermVariable> entry : map.entrySet()) {
            termVariable = entry.getValue();
            set3.add(termVariable);
            set.add(termVariable);
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : map2.entrySet()) {
            termVariable = entry.getValue();
            set3.add(termVariable);
            if (set.contains(termVariable)) {
                set.remove(termVariable);
                continue;
            }
            set2.add(termVariable);
        }
    }

    public OctConjunction binarySequentialize(OctConjunction octConjunction, OctConjunction octConjunction2, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>();
        LinkedHashSet<TermVariable> linkedHashSet2 = new LinkedHashSet<TermVariable>();
        LinkedHashSet<TermVariable> linkedHashSet3 = new LinkedHashSet<TermVariable>();
        OctagonCalculator.getVariableSets(linkedHashSet2, linkedHashSet3, linkedHashSet, map, map2);
        Map<TermVariable, TermVariable> map3 = OctagonCalculator.getTermMapping(map, map2);
        Map<TermVariable, TermVariable> map4 = OctagonCalculator.getReverseTermMapping(map3);
        return this.binarySequentialize(octConjunction, octConjunction2, linkedHashSet2, linkedHashSet3, map4);
    }

    private OctConjunction binarySequentialize(OctConjunction octConjunction, OctConjunction octConjunction2, Set<TermVariable> set, Set<TermVariable> set2, Map<TermVariable, TermVariable> map) {
        LinkedHashMap<TermVariable, OctagonSubstitution> linkedHashMap = new LinkedHashMap<TermVariable, OctagonSubstitution>();
        for (TermVariable object2 : set2) {
            linkedHashMap.put(object2, OctagonCalculator.getSubstitution(object2, octConjunction));
        }
        this.mUtils.debug(((Object)linkedHashMap).toString());
        Set<SubstitutionTermContainer> set3 = this.substituteInVars(this.getContainers(octConjunction2), set, map);
        this.mUtils.debug("> Result:");
        this.mUtils.debug(set3.toString());
        OctConjunction octConjunction3 = this.substitute(set3, set2, linkedHashMap);
        this.mUtils.debug(octConjunction2.toString());
        this.mUtils.debug(">> Substitutions finished.");
        OctConjunction octConjunction4 = OctagonCalculator.getInputConstraints(octConjunction, set);
        OctConjunction octConjunction5 = OctagonCalculator.getOutputConstraints(octConjunction2, set2);
        this.mUtils.debug(octConjunction4.toString());
        OctConjunction octConjunction6 = OctagonCalculator.conjunction(octConjunction4, octConjunction5);
        return OctagonCalculator.conjunction(octConjunction3, octConjunction6);
    }

    private static OctConjunction getOutputConstraints(OctConjunction octConjunction, Set<TermVariable> set) {
        OctConjunction octConjunction2 = new OctConjunction();
        for (OctTerm octTerm : octConjunction.getTerms()) {
            if (!set.contains(octTerm.getFirstVar()) || !set.contains(octTerm.getSecondVar())) continue;
            octConjunction2.addTerm(octTerm);
        }
        return octConjunction2;
    }

    private static OctConjunction getInputConstraints(OctConjunction octConjunction, Set<TermVariable> set) {
        OctConjunction octConjunction2 = new OctConjunction();
        for (OctTerm octTerm : octConjunction.getTerms()) {
            if (!set.contains(octTerm.getFirstVar()) || !set.contains(octTerm.getSecondVar())) continue;
            octConjunction2.addTerm(octTerm);
        }
        return octConjunction2;
    }

    private Set<SubstitutionTermContainer> getContainers(OctConjunction octConjunction) {
        LinkedHashSet<SubstitutionTermContainer> linkedHashSet = new LinkedHashSet<SubstitutionTermContainer>();
        for (OctTerm octTerm : octConjunction.getTerms()) {
            linkedHashSet.add(new SubstitutionTermContainer(octTerm));
        }
        return linkedHashSet;
    }

    private Set<SubstitutionTermContainer> substituteInVars(Set<SubstitutionTermContainer> set, Set<TermVariable> set2, Map<TermVariable, TermVariable> map) {
        this.mUtils.debug("> Subsituting inVars with outVars");
        this.mUtils.debug("Variable Set: " + set2.toString());
        this.mUtils.debug("Variable Mapping: " + map.toString());
        LinkedHashSet<SubstitutionTermContainer> linkedHashSet = new LinkedHashSet<SubstitutionTermContainer>();
        this.mUtils.debug(set.toString());
        for (SubstitutionTermContainer substitutionTermContainer : set) {
            SubstitutionTermContainer substitutionTermContainer2;
            OctTerm octTerm = substitutionTermContainer.getTerm();
            this.mUtils.debug("Replacing in Term:" + octTerm.toString());
            if (octTerm.isOneVar()) {
                var10_10 = octTerm.getFirstVar();
                if (set2.contains(var10_10)) {
                    var10_10 = map.get(var10_10);
                }
                var9_9 = OctagonFactory.createOneVarOctTerm(octTerm.getValue(), var10_10, octTerm.isFirstNegative());
                this.mUtils.debug("New Term:" + var9_9.toString());
                substitutionTermContainer2 = new SubstitutionTermContainer(var9_9, false);
            } else {
                var10_10 = octTerm.getFirstVar();
                TermVariable termVariable = octTerm.getSecondVar();
                boolean bl = true;
                boolean bl2 = true;
                if (set2.contains(var10_10)) {
                    var10_10 = map.get(var10_10);
                    bl = false;
                }
                if (set2.contains(termVariable)) {
                    termVariable = map.get(termVariable);
                    bl2 = false;
                }
                var9_9 = OctagonFactory.createTwoVarOctTerm(octTerm.getValue(), var10_10, octTerm.isFirstNegative(), termVariable, octTerm.isSecondNegative());
                this.mUtils.debug("New Term:" + var9_9.toString());
                substitutionTermContainer2 = new SubstitutionTermContainer(var9_9, bl, bl2);
            }
            linkedHashSet.add(substitutionTermContainer2);
        }
        this.mUtils.debug("InVars substituted.");
        return linkedHashSet;
    }

    private OctConjunction substitute(Set<SubstitutionTermContainer> set, Set<TermVariable> set2, Map<TermVariable, OctagonSubstitution> map) {
        this.mUtils.debug("> Substituting a set of variables.");
        this.mUtils.debug("varSet:" + set2.toString());
        OctConjunction octConjunction = new OctConjunction();
        LinkedHashSet<OctTerm> linkedHashSet = new LinkedHashSet<OctTerm>();
        for (SubstitutionTermContainer object : set) {
            OctTerm octTerm = object.getTerm();
            this.mUtils.debug("-Substituting in: " + octTerm.toString());
            this.mUtils.debug(object.isFirstLocked());
            if (set2.contains(octTerm.getFirstVar()) && !object.isFirstLocked()) {
                if (!octTerm.isOneVar() && set2.contains(octTerm.getSecondVar()) && !object.isSecondLocked()) {
                    linkedHashSet.addAll(this.getTermSubstitutions(octTerm, map, 0));
                    continue;
                }
                linkedHashSet.addAll(this.getTermSubstitutions(octTerm, map, 1));
                continue;
            }
            if (set2.contains(octTerm.getSecondVar()) && !object.isSecondLocked()) {
                linkedHashSet.addAll(this.getTermSubstitutions(octTerm, map, 2));
                continue;
            }
            linkedHashSet.add(octTerm);
        }
        for (OctTerm octTerm : linkedHashSet) {
            octConjunction.addTerm(octTerm);
        }
        return octConjunction;
    }

    private Set<OctTerm> getTermSubstitutions(OctTerm octTerm, Map<TermVariable, OctagonSubstitution> map, int n) {
        LinkedHashSet<OctTerm> linkedHashSet = new LinkedHashSet<OctTerm>();
        if (n != 0) {
            TermVariable termVariable = n == 1 ? octTerm.getFirstVar() : octTerm.getSecondVar();
            boolean bl = n == 1 ? octTerm.isFirstNegative() : octTerm.isSecondNegative();
            this.mUtils.debug("Variable " + n + ": " + termVariable.toString());
            Set<OctagonSubstitutionTerm> set = bl ? map.get(termVariable).getLesserSubsitutions() : map.get(termVariable).getGreaterSubsitutions();
            this.mUtils.debug("Substitutions: " + set.toString());
            for (OctagonSubstitutionTerm octagonSubstitutionTerm : set) {
                OctTerm octTerm2 = this.getTermFromSubsitution(octTerm, octagonSubstitutionTerm, n);
                if (octTerm2 == null) continue;
                linkedHashSet.add(octTerm2);
            }
        } else {
            TermVariable termVariable = octTerm.getFirstVar();
            TermVariable termVariable2 = octTerm.getSecondVar();
            boolean bl = octTerm.isFirstNegative();
            boolean bl2 = octTerm.isSecondNegative();
            this.mUtils.debug(termVariable.toString() + " and " + termVariable2.toString());
            LinkedHashSet<OctTerm> linkedHashSet2 = new LinkedHashSet<OctTerm>();
            Set<OctagonSubstitutionTerm> set = bl ? map.get(termVariable).getLesserSubsitutions() : map.get(termVariable).getGreaterSubsitutions();
            for (OctagonSubstitutionTerm object : set) {
                OctTerm octTerm2 = this.getTermFromSubsitution(octTerm, object, 1);
                if (octTerm2 == null) continue;
                linkedHashSet2.add(octTerm2);
            }
            set = bl2 ? map.get(termVariable2).getLesserSubsitutions() : map.get(termVariable2).getGreaterSubsitutions();
            for (OctTerm octTerm3 : linkedHashSet2) {
                for (OctagonSubstitutionTerm octagonSubstitutionTerm : set) {
                    OctTerm octTerm4 = this.getTermFromSubsitution(octTerm3, octagonSubstitutionTerm, octTerm3.getFirstVar().equals(termVariable2) ? 1 : 2);
                    if (octTerm4 == null) continue;
                    linkedHashSet.add(octTerm4);
                }
            }
        }
        return linkedHashSet;
    }

    private OctTerm getTermFromSubsitution(OctTerm octTerm, OctagonSubstitutionTerm octagonSubstitutionTerm, int n) {
        this.mUtils.debug("-Building new substituted Term from " + octTerm.toString() + " with substitution " + octagonSubstitutionTerm.toString());
        OctTerm octTerm2 = octTerm.isOneVar() ? (octagonSubstitutionTerm.isZeroVar() ? null : OctagonFactory.createOneVarOctTerm(this.getSubsitutionValue(octTerm.getValue(), octagonSubstitutionTerm.getValue(), 0), octagonSubstitutionTerm.getVar(), octagonSubstitutionTerm.isVarNegative())) : (octagonSubstitutionTerm.isZeroVar() ? OctagonFactory.createOneVarOctTerm(this.getSubsitutionValue(octTerm.getValue(), octagonSubstitutionTerm.getValue(), 1), n == 1 ? octTerm.getSecondVar() : octTerm.getFirstVar(), n == 1 ? octTerm.isSecondNegative() : octTerm.isFirstNegative()) : OctagonFactory.createTwoVarOctTerm(this.getSubsitutionValue(octTerm.getValue(), octagonSubstitutionTerm.getValue(), 2), n == 1 ? octTerm.getSecondVar() : octTerm.getFirstVar(), n == 1 ? octTerm.isSecondNegative() : octTerm.isFirstNegative(), octagonSubstitutionTerm.getVar(), octagonSubstitutionTerm.isVarNegative()));
        this.mUtils.debug("-Result: " + (octTerm2 != null ? octTerm2.toString() : "null"));
        return octTerm2;
    }

    private Object getSubsitutionValue(Object object, Object object2, int n) {
        if (n == 2) {
            return OctagonCalculator.addValues(object, object2);
        }
        if (n == 1) {
            return OctagonCalculator.addValues(object, object2, new BigDecimal(2), BigDecimal.ONE);
        }
        return OctagonCalculator.addValues(object, object2, BigDecimal.ONE, new BigDecimal(2));
    }

    private static Object addValues(Object object, Object object2) {
        return OctagonCalculator.addValues(object, object2, BigDecimal.ONE, BigDecimal.ONE);
    }

    private static Object addValues(Object object, Object object2, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Object object3 = object;
        Object object4 = object2;
        if (object3 instanceof ParametricOctValue) {
            object3 = ((ParametricOctValue)object3).multipy(bigDecimal);
            object4 = object4 instanceof ParametricOctValue ? ((ParametricOctValue)object4).multipy(bigDecimal2) : ((BigDecimal)object4).multiply(bigDecimal2);
            return ((ParametricOctValue)object3).add(object4);
        }
        if (object4 instanceof ParametricOctValue) {
            object4 = ((ParametricOctValue)object4).multipy(bigDecimal2);
            object3 = object3 instanceof ParametricOctValue ? ((ParametricOctValue)object3).multipy(bigDecimal) : ((BigDecimal)object3).multiply(bigDecimal);
            return ((ParametricOctValue)object4).add(object3);
        }
        object3 = ((BigDecimal)object3).multiply(bigDecimal);
        object4 = ((BigDecimal)object4).multiply(bigDecimal2);
        return ((BigDecimal)object3).add((BigDecimal)object4);
    }

    private static OctConjunction conjunction(OctConjunction octConjunction, OctConjunction octConjunction2) {
        OctConjunction octConjunction3 = new OctConjunction();
        for (OctTerm octTerm : octConjunction.getTerms()) {
            octConjunction3.addTerm(octTerm);
        }
        for (OctTerm octTerm : octConjunction2.getTerms()) {
            octConjunction3.addTerm(octTerm);
        }
        return octConjunction3;
    }

    private static Map<TermVariable, TermVariable> getTermMapping(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        LinkedHashMap<TermVariable, TermVariable> linkedHashMap = new LinkedHashMap<TermVariable, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> entry : map2.entrySet()) {
            TermVariable termVariable = entry.getValue();
            TermVariable termVariable2 = map.get(entry.getKey());
            if (termVariable == null || termVariable2 == null) continue;
            linkedHashMap.put(termVariable, termVariable2);
        }
        return linkedHashMap;
    }

    public static Map<TermVariable, TermVariable> getReverseTermMapping(Map<TermVariable, TermVariable> map) {
        LinkedHashMap<TermVariable, TermVariable> linkedHashMap = new LinkedHashMap<TermVariable, TermVariable>();
        for (TermVariable termVariable : map.keySet()) {
            linkedHashMap.put(map.get(termVariable), termVariable);
        }
        return linkedHashMap;
    }

    private static OctagonSubstitution getSubstitution(TermVariable termVariable, OctConjunction octConjunction) {
        OctagonSubstitution octagonSubstitution = new OctagonSubstitution(termVariable);
        for (OctTerm octTerm : octConjunction.getTerms()) {
            octagonSubstitution.addSubstitution(octTerm);
        }
        return octagonSubstitution;
    }

    public List<TermVariable> getSortedVariables(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        Object object2;
        LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>();
        LinkedHashSet<TermVariable> linkedHashSet2 = new LinkedHashSet<TermVariable>();
        LinkedHashSet<TermVariable> linkedHashSet3 = new LinkedHashSet<TermVariable>();
        for (Object object2 : map.keySet()) {
            linkedHashSet.add(map.get(object2));
        }
        for (Object object2 : map2.keySet()) {
            if (!linkedHashSet.contains(map2.get(object2))) {
                linkedHashSet2.add(map2.get(object2));
                continue;
            }
            linkedHashSet.remove(map2.get(object2));
            linkedHashSet3.add(map2.get(object2));
        }
        object2 = Comparator.comparing(TermVariable::toString);
        ArrayList arrayList = new ArrayList(linkedHashSet);
        ArrayList arrayList2 = new ArrayList(linkedHashSet2);
        ArrayList arrayList3 = new ArrayList(linkedHashSet3);
        Collections.sort(arrayList, object2);
        Collections.sort(arrayList3, object2);
        Collections.sort(arrayList2, object2);
        arrayList.addAll(arrayList3);
        arrayList.addAll(arrayList2);
        ArrayList<TermVariable> arrayList4 = new ArrayList<TermVariable>(arrayList);
        return arrayList4;
    }

    public FastUPRUtils getUtils() {
        return this.mUtils;
    }

    public boolean isTrivial(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        for (Map.Entry<IProgramVar, TermVariable> entry : map.entrySet()) {
            if (map2.containsValue(entry.getValue())) continue;
            return false;
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : map2.entrySet()) {
            if (map.containsValue(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private static class SubstitutionTermContainer {
        private final OctTerm mTerm;
        private final boolean mFirstLocked;
        private final boolean mSecondLocked;

        SubstitutionTermContainer(OctTerm octTerm) {
            this(octTerm, true, true);
        }

        SubstitutionTermContainer(OctTerm octTerm, boolean bl) {
            this(octTerm, bl, true);
        }

        SubstitutionTermContainer(OctTerm octTerm, boolean bl, boolean bl2) {
            this.mTerm = octTerm;
            this.mFirstLocked = bl;
            this.mSecondLocked = bl2;
        }

        public String toString() {
            return this.mTerm.toString();
        }

        OctTerm getTerm() {
            return this.mTerm;
        }

        boolean isFirstLocked() {
            return this.mFirstLocked;
        }

        boolean isSecondLocked() {
            return this.mSecondLocked;
        }
    }
}

