/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaBasis;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.GetRandomNestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.multipebble.InitialPartitionProcessor;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IOutgoingTransitionlet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.util.datastructures.FilteredIterable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.IsContained;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap4;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.TransformIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class NestedWordAutomataUtils {
    private NestedWordAutomataUtils() {
    }

    public static <LETTER, STATE> void applyToReachableSuccessors(IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, STATE STATE, Consumer<STATE> consumer) {
        for (OutgoingInternalTransition iOutgoingTransitionlet : iDoubleDeckerAutomaton.internalSuccessors(STATE)) {
            consumer.accept(iOutgoingTransitionlet.getSucc());
        }
        for (OutgoingCallTransition outgoingCallTransition : iDoubleDeckerAutomaton.callSuccessors(STATE)) {
            consumer.accept(outgoingCallTransition.getSucc());
        }
        for (OutgoingReturnTransition outgoingReturnTransition : iDoubleDeckerAutomaton.returnSuccessors(STATE)) {
            if (!iDoubleDeckerAutomaton.isDoubleDecker(STATE, outgoingReturnTransition.getHierPred())) continue;
            consumer.accept(outgoingReturnTransition.getSucc());
        }
    }

    public static <LETTER, STATE> boolean hasOutgoingReturnTransition(IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, STATE STATE, STATE STATE2, LETTER LETTER) {
        return iDoubleDeckerAutomaton.returnSuccessors(STATE, STATE2, LETTER).iterator().hasNext();
    }

    public static <E extends IOutgoingTransitionlet<LETTER, STATE>, LETTER, STATE> Set<STATE> constructSuccessorSet(Iterable<E> iterable) {
        HashSet hashSet = new HashSet();
        for (IOutgoingTransitionlet iOutgoingTransitionlet : iterable) {
            hashSet.add(iOutgoingTransitionlet.getSucc());
        }
        return hashSet;
    }

    public static <STATE> int computeSizeOfLargestEquivalenceClass(Collection<Set<STATE>> collection) {
        int n = 0;
        for (Set<STATE> set : collection) {
            n = Math.max(n, set.size());
        }
        return n;
    }

    public static <STATE> long computeNumberOfPairsInPartition(Collection<Set<STATE>> collection) {
        int n = 0;
        for (Set<STATE> set : collection) {
            n += set.size() * set.size();
        }
        return n;
    }

    public static <STATE> HashRelation<STATE, STATE> constructHashRelation(AutomataLibraryServices automataLibraryServices, Collection<Set<STATE>> collection) throws AutomataOperationCanceledException {
        final HashRelation hashRelation = new HashRelation();
        InitialPartitionProcessor initialPartitionProcessor = new InitialPartitionProcessor<STATE>(automataLibraryServices){

            @Override
            public boolean shouldBeProcessed(STATE STATE, STATE STATE2) {
                return true;
            }

            @Override
            public void doProcess(STATE STATE, STATE STATE2) {
                hashRelation.addPair(STATE, STATE2);
            }
        };
        initialPartitionProcessor.process(collection);
        return hashRelation;
    }

    public static <LETTER, STATE> String generateGenericMinimizationRunningTaskDescription(String string, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, Collection<Set<STATE>> collection) {
        int n = NestedWordAutomataUtils.computeSizeOfLargestEquivalenceClass(collection);
        return NestedWordAutomataUtils.generateGenericMinimizationRunningTaskDescription(string, iNestedWordAutomaton, collection.size(), n);
    }

    public static <LETTER, STATE> String generateGenericMinimizationRunningTaskDescription(String string, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, PartitionBackedSetOfPairs.PartitionSizeInformation partitionSizeInformation) {
        return "applying " + string + " to NWA with " + iNestedWordAutomaton.size() + " states (initial partition has " + partitionSizeInformation.toString() + ")";
    }

    public static <LETTER, STATE> String generateGenericMinimizationRunningTaskDescription(String string, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, int n, int n2) {
        return "applying " + string + " to NWA with " + iNestedWordAutomaton.size() + " states (initial partition has " + n + " blocks, largest block has " + n2 + " states)";
    }

    public static <STATE, T> Set<STATE> getStates(Iterable<T> iterable, Function<T, STATE> function) {
        return StreamSupport.stream(iterable.spliterator(), false).map(function).collect(Collectors.toSet());
    }

    public static <LETTER, STATE> Set<STATE> constructInternalSuccessors(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, STATE STATE, LETTER LETTER) {
        if (iNwaOutgoingLetterAndTransitionProvider instanceof NestedWordAutomaton) {
            return ((NestedWordAutomaton)iNwaOutgoingLetterAndTransitionProvider).succInternal(STATE, LETTER);
        }
        Function<OutgoingInternalTransition, Object> function = outgoingInternalTransition -> outgoingInternalTransition.getSucc();
        return NestedWordAutomataUtils.getStates(iNwaOutgoingLetterAndTransitionProvider.internalSuccessors(STATE, LETTER), function);
    }

    public static <LETTER, STATE> Set<STATE> constructCallSuccessors(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, STATE STATE, LETTER LETTER) {
        if (iNwaOutgoingLetterAndTransitionProvider instanceof NestedWordAutomaton) {
            return ((NestedWordAutomaton)iNwaOutgoingLetterAndTransitionProvider).succCall(STATE, LETTER);
        }
        Function<OutgoingCallTransition, Object> function = outgoingCallTransition -> outgoingCallTransition.getSucc();
        return NestedWordAutomataUtils.getStates(iNwaOutgoingLetterAndTransitionProvider.callSuccessors(STATE, LETTER), function);
    }

    public static <LETTER, STATE> Set<STATE> constructReturnSuccessors(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, STATE STATE, STATE STATE2, LETTER LETTER) {
        if (iNwaOutgoingLetterAndTransitionProvider instanceof NestedWordAutomaton) {
            return ((NestedWordAutomaton)iNwaOutgoingLetterAndTransitionProvider).succReturn(STATE, STATE2, LETTER);
        }
        Function<OutgoingReturnTransition, Object> function = outgoingReturnTransition -> outgoingReturnTransition.getSucc();
        return NestedWordAutomataUtils.getStates(iNwaOutgoingLetterAndTransitionProvider.returnSuccessors(STATE, STATE2, LETTER), function);
    }

    public static <LETTER, STATE> boolean isFiniteAutomaton(INwaBasis<LETTER, STATE> iNwaBasis) {
        return iNwaBasis.getVpAlphabet().getCallAlphabet().isEmpty() && iNwaBasis.getVpAlphabet().getReturnAlphabet().isEmpty();
    }

    public static <LETTER, STATE> boolean sameAlphabet(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider2) {
        boolean bl = iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet().equals(iNwaOutgoingLetterAndTransitionProvider2.getVpAlphabet());
        return bl;
    }

    public static <LETTER, STATE> NestedLassoWord<LETTER> getRandomNestedLassoWord(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, int n, long l) {
        Object object = new GetRandomNestedWord<LETTER, STATE>(null, iNwaOutgoingLetterAndTransitionProvider, n, l).getResult();
        Object object2 = new GetRandomNestedWord<LETTER, STATE>(null, iNwaOutgoingLetterAndTransitionProvider, n, l).getResult();
        return new NestedLassoWord(object, object2);
    }

    private static <LETTER, STATE> boolean isNondeterministicInternal(STATE STATE, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) {
        for (LETTER LETTER : iNwaOutgoingLetterAndTransitionProvider.lettersInternal(STATE)) {
            int n = 0;
            Iterator<OutgoingInternalTransition<LETTER, STATE>> iterator = iNwaOutgoingLetterAndTransitionProvider.internalSuccessors(STATE, LETTER).iterator();
            while (iterator.hasNext()) {
                ++n;
                iterator.next();
            }
            if (n <= 1) continue;
            return true;
        }
        return false;
    }

    private static <LETTER, STATE> boolean isNondeterministicCall(STATE STATE, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) {
        for (LETTER LETTER : iNwaOutgoingLetterAndTransitionProvider.lettersCall(STATE)) {
            int n = 0;
            Iterator<OutgoingCallTransition<LETTER, STATE>> iterator = iNwaOutgoingLetterAndTransitionProvider.callSuccessors(STATE, LETTER).iterator();
            while (iterator.hasNext()) {
                if (++n > 1) {
                    return true;
                }
                iterator.next();
            }
        }
        return false;
    }

    private static <LETTER, STATE> boolean isNondeterministicReturn(STATE STATE, STATE STATE2, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) {
        for (LETTER LETTER : iNwaOutgoingLetterAndTransitionProvider.lettersReturn(STATE, STATE2)) {
            int n = 0;
            Iterator<OutgoingReturnTransition<LETTER, STATE>> iterator = iNwaOutgoingLetterAndTransitionProvider.returnSuccessors(STATE, STATE2, LETTER).iterator();
            while (iterator.hasNext()) {
                if (++n > 1) {
                    return true;
                }
                iterator.next();
            }
        }
        return false;
    }

    public static <LETTER, STATE> boolean isNondeterministic(STATE STATE, STATE STATE2, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton) {
        boolean bl = NestedWordAutomataUtils.isNondeterministicInternal(STATE, iDoubleDeckerAutomaton);
        if (bl) {
            return true;
        }
        boolean bl2 = NestedWordAutomataUtils.isNondeterministicCall(STATE, iDoubleDeckerAutomaton);
        if (bl2) {
            return true;
        }
        boolean bl3 = NestedWordAutomataUtils.isNondeterministicReturn(STATE, STATE2, iDoubleDeckerAutomaton);
        return bl3;
    }

    public static <LETTER, STATE> Set<STATE> hierarchicalPredecessorsOutgoing(STATE STATE, LETTER LETTER, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        HashSet<STATE> hashSet = new HashSet<STATE>();
        for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : iNestedWordAutomaton.returnSuccessors(STATE)) {
            if (!LETTER.equals(outgoingReturnTransition.getLetter())) continue;
            hashSet.add(outgoingReturnTransition.getHierPred());
        }
        return hashSet;
    }

    public static <LETTER, STATE> Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessors(STATE STATE, LETTER LETTER, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        Iterable<OutgoingReturnTransition<LETTER, STATE>> iterable = iNestedWordAutomaton.returnSuccessors(STATE);
        Predicate<OutgoingReturnTransition> predicate = outgoingReturnTransition -> outgoingReturnTransition.getLetter().equals(LETTER);
        return new FilteredIterable(iterable, predicate);
    }

    public static <LETTER, STATE> Iterable<OutgoingInternalTransition<LETTER, STATE>> constructInternalTransitionIteratorFromNestedMap(STATE STATE, LETTER LETTER, NestedMap3<STATE, LETTER, STATE, IsContained> nestedMap3) {
        Function<Object, OutgoingInternalTransition> function = object2 -> new OutgoingInternalTransition<Object, Object>(LETTER, object2);
        return () -> new TransformIterator(NestedWordAutomataUtils.keySetOrEmpty(nestedMap3.get(STATE, LETTER)).iterator(), function);
    }

    public static <LETTER, STATE> Iterable<OutgoingCallTransition<LETTER, STATE>> constructCallTransitionIteratorFromNestedMap(STATE STATE, LETTER LETTER, NestedMap3<STATE, LETTER, STATE, IsContained> nestedMap3) {
        Function<Object, OutgoingCallTransition> function = object2 -> new OutgoingCallTransition<Object, Object>(LETTER, object2);
        return () -> new TransformIterator(NestedWordAutomataUtils.keySetOrEmpty(nestedMap3.get(STATE, LETTER)).iterator(), function);
    }

    public static <LETTER, STATE> Iterable<OutgoingReturnTransition<LETTER, STATE>> constructReturnTransitionIteratorFromNestedMap(STATE STATE, STATE STATE2, LETTER LETTER, NestedMap4<STATE, STATE, LETTER, STATE, IsContained> nestedMap4) {
        return () -> new TransformIterator(NestedWordAutomataUtils.keySetOrEmpty(nestedMap4.get(STATE, STATE2, LETTER)).iterator(), object3 -> new OutgoingReturnTransition<Object, Object>(STATE2, LETTER, object3));
    }

    private static <STATE> Iterable<STATE> keySetOrEmpty(Map<STATE, IsContained> map) {
        if (map == null) {
            return Collections.emptySet();
        }
        return map.keySet();
    }

    public static <LETTER> VpAlphabet<LETTER> getVpAlphabet(IAutomaton<LETTER, ?> iAutomaton) {
        if (iAutomaton instanceof INwaBasis) {
            return ((INwaBasis)iAutomaton).getVpAlphabet();
        }
        return new VpAlphabet<LETTER>(iAutomaton.getAlphabet());
    }

    public static <LETTER, STATE> STATE getSuccessorState(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, STATE STATE, LETTER LETTER) {
        Iterator<OutgoingInternalTransition<LETTER, STATE>> iterator = iNwaOutgoingLetterAndTransitionProvider.internalSuccessors(STATE, LETTER).iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("No successor for state " + String.valueOf(STATE) + " and letter " + String.valueOf(LETTER));
        }
        STATE STATE2 = iterator.next().getSucc();
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("Multiple successors for state " + String.valueOf(STATE) + " and letter " + String.valueOf(LETTER));
        }
        return STATE2;
    }
}

