/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex;

import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Concatenation;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.EmptySet;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Epsilon;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.IRegex;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.IRegexVisitor;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Literal;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Star;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Union;

public class RegexToCompactTgf<L>
implements IRegexVisitor<L, RegexToCompactTgf<L>, Arg> {
    protected int mNextNodeId;
    protected final StringBuilder mNodeList = new StringBuilder();
    protected final StringBuilder mEdgeList = new StringBuilder();

    public static <L> String apply(IRegex<L> iRegex) {
        return ((RegexToCompactTgf)iRegex.accept(new RegexToCompactTgf<L>())).toString();
    }

    protected int addNodeLinkedToParent(String string, Arg arg) {
        this.linkNextNodeToParent(arg);
        this.mNodeList.append(this.mNextNodeId).append(' ').append(string).append('\n');
        return this.mNextNodeId++;
    }

    protected void linkNextNodeToParent(Arg arg) {
        if (arg == null) {
            return;
        }
        this.addEdge(arg.mParentId, this.mNextNodeId, arg.mChildOffset);
        ++arg.mChildOffset;
    }

    protected void addEdge(int n, int n2, int n3) {
        this.mEdgeList.append(n).append(' ').append(n2).append(' ').append(n3).append('\n');
    }

    private final RegexToCompactTgf<L> visitAndCompact(String string, IRegex<L> iRegex, Arg arg, IRegex<L> iRegex2, IRegex<L> iRegex3) {
        if (arg == null || iRegex.getClass() != arg.mParentClass) {
            int n = this.addNodeLinkedToParent(string, arg);
            arg = new Arg(n, iRegex);
        }
        iRegex2.accept(this, arg);
        iRegex3.accept(this, arg);
        return this;
    }

    @Override
    public RegexToCompactTgf<L> visit(Union<L> union, Arg arg) {
        return this.visitAndCompact("\u222a", union, arg, union.getFirst(), union.getSecond());
    }

    @Override
    public RegexToCompactTgf<L> visit(Concatenation<L> concatenation, Arg arg) {
        return this.visitAndCompact("\u00b7", concatenation, arg, concatenation.getFirst(), concatenation.getSecond());
    }

    @Override
    public RegexToCompactTgf<L> visit(Star<L> star, Arg arg) {
        int n = this.addNodeLinkedToParent("*", arg);
        star.getInner().accept(this, new Arg(n, star));
        return this;
    }

    @Override
    public RegexToCompactTgf<L> visit(Literal<L> literal, Arg arg) {
        this.addNodeLinkedToParent(literal.getLetter().toString(), arg);
        return this;
    }

    @Override
    public RegexToCompactTgf<L> visit(Epsilon<L> epsilon, Arg arg) {
        this.addNodeLinkedToParent("\u03b5", arg);
        return this;
    }

    @Override
    public RegexToCompactTgf<L> visit(EmptySet<L> emptySet, Arg arg) {
        this.addNodeLinkedToParent("\u2205", arg);
        return this;
    }

    public String toString() {
        return String.valueOf(this.mNodeList) + "#\n" + String.valueOf(this.mEdgeList);
    }

    protected static class Arg {
        protected final int mParentId;
        protected final Class<?> mParentClass;
        protected int mChildOffset;

        public Arg(int n, IRegex<?> iRegex) {
            this.mParentId = n;
            this.mParentClass = iRegex.getClass();
        }
    }
}

