/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class Procedure
extends Declaration {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(Procedure.class);
    String identifier;
    String[] typeParams;
    VarList[] inParams;
    VarList[] outParams;
    Specification[] specification;
    Body body;

    public Procedure(ILocation iLocation, Attribute[] attributeArray, String string, String[] stringArray, VarList[] varListArray, VarList[] varListArray2, Specification[] specificationArray, Body body) {
        super(iLocation, attributeArray);
        this.identifier = string;
        this.typeParams = stringArray;
        this.inParams = varListArray;
        this.outParams = varListArray2;
        this.specification = specificationArray;
        this.body = body;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Procedure: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Procedure").append('[');
        stringBuffer.append(this.identifier);
        stringBuffer.append(',');
        if (this.typeParams == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.typeParams.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.typeParams[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',');
        if (this.inParams == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.inParams.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.inParams[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',');
        if (this.outParams == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.outParams.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.outParams[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',');
        if (this.specification == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.specification.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.specification[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',').append((Object)this.body);
        return stringBuffer.append(']').toString();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String[] getTypeParams() {
        return this.typeParams;
    }

    public VarList[] getInParams() {
        return this.inParams;
    }

    public VarList[] getOutParams() {
        return this.outParams;
    }

    public Specification[] getSpecification() {
        return this.specification;
    }

    public Body getBody() {
        return this.body;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.inParams != null) {
            list.addAll(Arrays.asList(this.inParams));
        }
        if (this.outParams != null) {
            list.addAll(Arrays.asList(this.outParams));
        }
        if (this.specification != null) {
            list.addAll(Arrays.asList(this.specification));
        }
        list.add(this.body);
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Declaration)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this)) {
            BoogieASTNode boogieASTNode;
            int n;
            int n2;
            BoogieASTNode[] boogieASTNodeArray;
            if (this.inParams != null) {
                boogieASTNodeArray = this.inParams;
                n2 = this.inParams.length;
                n = 0;
                while (n < n2) {
                    boogieASTNode = boogieASTNodeArray[n];
                    ((VarList)boogieASTNode).accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
            if (this.outParams != null) {
                boogieASTNodeArray = this.outParams;
                n2 = this.outParams.length;
                n = 0;
                while (n < n2) {
                    boogieASTNode = boogieASTNodeArray[n];
                    ((VarList)boogieASTNode).accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
            if (this.specification != null) {
                boogieASTNodeArray = this.specification;
                n2 = this.specification.length;
                n = 0;
                while (n < n2) {
                    boogieASTNode = boogieASTNodeArray[n];
                    ((Specification)boogieASTNode).accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
            if (this.body != null) {
                this.body.accept(generatedBoogieAstVisitor);
            }
            if (this.attributes != null) {
                boogieASTNodeArray = this.attributes;
                n2 = this.attributes.length;
                n = 0;
                while (n < n2) {
                    boogieASTNode = boogieASTNodeArray[n];
                    ((Attribute)boogieASTNode).accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
        }
    }

    @Override
    public Declaration accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Object object;
        Object object2;
        Object object3;
        int n;
        Object object4;
        Declaration declaration = generatedBoogieAstTransformer.transform(this);
        if (declaration != this) {
            return declaration;
        }
        boolean bl = false;
        ArrayList<VarList[]> arrayList = new ArrayList<VarList[]>();
        if (this.inParams != null) {
            object4 = this.inParams;
            n = this.inParams.length;
            int n2 = 0;
            while (n2 < n) {
                object3 = object4[n2];
                object2 = ((VarList)((Object)object3)).accept(generatedBoogieAstTransformer);
                bl = bl || object2 != object3;
                arrayList.add((VarList[])object2);
                ++n2;
            }
        }
        object3 = new ArrayList();
        if (this.outParams != null) {
            object2 = this.outParams;
            int n3 = this.outParams.length;
            n = 0;
            while (n < n3) {
                VarList varList = object2[n];
                object = varList.accept(generatedBoogieAstTransformer);
                bl = bl || object != varList;
                ((ArrayList)object3).add(object);
                ++n;
            }
        }
        ArrayList<Specification> arrayList2 = new ArrayList<Specification>();
        if (this.specification != null) {
            object = this.specification;
            int n4 = this.specification.length;
            int n5 = 0;
            while (n5 < n4) {
                Specification specification = object[n5];
                Specification specification2 = specification.accept(generatedBoogieAstTransformer);
                bl = bl || specification2 != specification;
                arrayList2.add(specification2);
                ++n5;
            }
        }
        Body body = null;
        if (this.body != null) {
            body = this.body.accept(generatedBoogieAstTransformer);
        }
        object4 = new ArrayList();
        if (this.attributes != null) {
            Attribute[] attributeArray = this.attributes;
            int n6 = this.attributes.length;
            int n7 = 0;
            while (n7 < n6) {
                Attribute attribute = attributeArray[n7];
                Attribute attribute2 = attribute.accept(generatedBoogieAstTransformer);
                bl = bl || attribute2 != attribute;
                ((ArrayList)object4).add(attribute2);
                ++n7;
            }
        }
        if (bl || this.body != body) {
            return new Procedure(this.loc, ((ArrayList)object4).toArray(new Attribute[0]), this.identifier, this.typeParams, arrayList.toArray(new VarList[0]), ((ArrayList)object3).toArray(new VarList[0]), arrayList2.toArray(new Specification[0]), body);
        }
        return this;
    }
}

