/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.visitors;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.annotations.IRSDependenciesAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.annotations.UseDefSequence;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.visitors.SimpleRCFGVisitor;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.visitors.UseDefSet;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.walker.RCFGWalkerUnroller;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.utils.Utils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SequencingVisitor
extends SimpleRCFGVisitor {
    private final RCFGWalkerUnroller mWalker;
    private final HashSet<String> mInputs;
    private final HashSet<String> mOutputs;
    private final HashMap<List<IcfgEdge>, List<Tuple<Tuple<Integer>>>> mDebugZoneMap;

    public SequencingVisitor(RCFGWalkerUnroller rCFGWalkerUnroller, ILogger iLogger) {
        super(iLogger);
        this.mWalker = rCFGWalkerUnroller;
        this.mInputs = new HashSet();
        this.mOutputs = new HashSet();
        this.mInputs.add("~input1");
        this.mInputs.add("~input2");
        this.mOutputs.add("~output1");
        this.mOutputs.add("~output2");
        this.mDebugZoneMap = new HashMap();
    }

    protected List<IcfgEdge> getCurrentPrefix() {
        return this.mWalker.getCurrentPrefix();
    }

    @Override
    public void endOfTrace() {
        super.endOfTrace();
        this.RealSequencingEOT();
        this.DebugSequencingEOT();
    }

    @Override
    public void finish() {
        super.finish();
        this.DebugFinish();
    }

    public boolean performedChanges() {
        return false;
    }

    @Override
    public boolean abortCurrentBranch() {
        return false;
    }

    @Override
    public boolean abortAll() {
        return false;
    }

    private void RealSequencingEOT() {
        List<IcfgEdge> list = this.getCurrentPrefix();
        HashSet<String> hashSet = new HashSet<String>(this.mInputs);
        HashSet<String> hashSet2 = new HashSet<String>(this.mOutputs);
        IRSDependenciesAnnotation iRSDependenciesAnnotation = null;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = true;
        for (IcfgEdge icfgEdge : list) {
            UseDefSequence useDefSequence = (UseDefSequence)((Object)IRSDependenciesAnnotation.getAnnotation((IElement)icfgEdge, UseDefSequence.class));
            if (useDefSequence == null) continue;
            List<Statement> list2 = this.extractStatements(icfgEdge);
            int n = 0;
            while (n < useDefSequence.Sequence.size()) {
                UseDefSet useDefSet = useDefSequence.Sequence.get(n);
                if (bl2) {
                    if (iRSDependenciesAnnotation != null) {
                        ((ZoneAnnotation)iRSDependenciesAnnotation).EndEdge = icfgEdge;
                        ((ZoneAnnotation)iRSDependenciesAnnotation).EndStatement = list2.get(n);
                    }
                    iRSDependenciesAnnotation = new ZoneAnnotation();
                    ((ZoneAnnotation)iRSDependenciesAnnotation).StartEdge = icfgEdge;
                    ((ZoneAnnotation)iRSDependenciesAnnotation).StartStatement = list2.get(n);
                    hashSet = new HashSet<String>(this.mInputs);
                    hashSet2 = new HashSet<String>(this.mOutputs);
                    bl2 = false;
                }
                boolean bl4 = hashSet.removeAll(useDefSet.Use);
                boolean bl5 = hashSet2.removeAll(useDefSet.Def);
                if ((bl4 || bl5) && bl3) {
                    bl3 = false;
                    bl2 = true;
                }
                if (bl) {
                    Utils.intersect(useDefSet.Use, this.mInputs);
                }
                if (hashSet.isEmpty() && hashSet2.isEmpty() && !bl) {
                    bl = true;
                    bl2 = true;
                }
                ++n;
            }
            iRSDependenciesAnnotation.addAnnotation((IElement)icfgEdge);
        }
    }

    private List<Statement> extractStatements(IcfgEdge icfgEdge) {
        if (icfgEdge instanceof StatementSequence) {
            return ((StatementSequence)icfgEdge).getStatements();
        }
        if (icfgEdge instanceof Call) {
            ArrayList<Statement> arrayList = new ArrayList<Statement>();
            arrayList.add((Statement)((Call)icfgEdge).getCallStatement());
            return arrayList;
        }
        return new ArrayList<Statement>();
    }

    private void DebugSequencingEOT() {
        List<IcfgEdge> list = this.getCurrentPrefix();
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
        Tuple<Integer> tuple = new Tuple<Integer>(this, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
        Tuple<Integer> tuple2 = new Tuple<Integer>(this, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
        Tuple tuple3 = new Tuple(this, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
        HashSet<String> hashSet = new HashSet<String>(this.mInputs);
        HashSet<String> hashSet2 = new HashSet<String>(this.mOutputs);
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < list.size()) {
            UseDefSequence useDefSequence = (UseDefSequence)((Object)IRSDependenciesAnnotation.getAnnotation((IElement)list.get(n), UseDefSequence.class));
            if (useDefSequence != null) {
                int n2 = 0;
                while (n2 < useDefSequence.Sequence.size()) {
                    HashSet<String> hashSet3;
                    UseDefSet useDefSet = useDefSequence.Sequence.get(n2);
                    if (bl && !(hashSet3 = Utils.intersect(useDefSet.Use, this.mInputs)).isEmpty()) {
                        hashSet = new HashSet<String>(this.mInputs);
                        hashSet2 = new HashSet<String>(this.mOutputs);
                        tuple2 = new Tuple<Integer>(this, tuple3);
                        arrayList.add(new Tuple(this, (Comparable)tuple, tuple2));
                        tuple = new Tuple<Integer>(this, tuple2);
                        tuple2 = new Tuple(this, tuple2);
                        bl = false;
                        bl2 = false;
                    }
                    if (!bl2) {
                        bl2 = hashSet.removeAll(useDefSet.Use);
                        if (bl2) {
                            tuple.set(n, n2);
                        }
                    } else {
                        hashSet.removeAll(useDefSet.Use);
                    }
                    hashSet2.removeAll(useDefSet.Def);
                    if (hashSet.isEmpty() && hashSet2.isEmpty() && !bl) {
                        tuple2.set(n, n2);
                        bl = true;
                    }
                    tuple3.set(n, n2);
                    ++n2;
                }
            }
            ++n;
        }
        if (tuple.compareTo(tuple2) < 0) {
            arrayList.add(new Tuple(this, (Comparable)tuple, (Comparable)tuple2));
        }
        this.mDebugZoneMap.put(new ArrayList<IcfgEdge>(list), arrayList);
    }

    private void DebugFinish() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("List of zones:\n");
        for (Map.Entry<List<IcfgEdge>, List<Tuple<Tuple<Integer>>>> entry : this.mDebugZoneMap.entrySet()) {
            int n = 0;
            StringBuilder stringBuilder2 = new StringBuilder();
            for (IcfgEdge icfgEdge : entry.getKey()) {
                ZoneAnnotation zoneAnnotation = (ZoneAnnotation)((Object)IRSDependenciesAnnotation.getAnnotation((IElement)icfgEdge, ZoneAnnotation.class));
                if (zoneAnnotation != null) {
                    stringBuilder.append((Object)zoneAnnotation).append(";");
                }
                stringBuilder2.append("(").append(n).append(") ");
                stringBuilder2.append(Utils.edgeToString(icfgEdge));
                stringBuilder2.append(" ");
                ++n;
            }
            stringBuilder.append("\n");
            stringBuilder.append(Utils.insertLineBreaks(200, stringBuilder2.toString()));
            stringBuilder.append("\n");
            for (Tuple tuple : entry.getValue()) {
                stringBuilder.append(((Tuple)tuple.First).First).append(",").append(((Tuple)tuple.First).Last);
                stringBuilder.append(" - ");
                stringBuilder.append(((Tuple)tuple.Last).First).append(",").append(((Tuple)tuple.Last).Last);
                stringBuilder.append("   ");
            }
            stringBuilder.append("\n----------------------------------------\n");
        }
        this.mLogger.debug((Object)stringBuilder.toString());
    }

    private static final class Tuple<T extends Comparable<T>>
    implements Comparable<Tuple<T>> {
        T First;
        T Last;
        final /* synthetic */ SequencingVisitor this$0;

        Tuple(T t, T t2) {
            this.this$0 = var1_1;
            this.set(t, t2);
        }

        Tuple(SequencingVisitor sequencingVisitor, Tuple<T> tuple) {
            this.this$0 = sequencingVisitor;
            this.set(tuple.First, tuple.Last);
        }

        private void set(T t, T t2) {
            this.First = t;
            this.Last = t2;
        }

        public boolean equals(Object object) {
            if (object instanceof Tuple) {
                return this.First.equals(((Tuple)object).First) && this.Last.equals(((Tuple)object).Last);
            }
            return super.equals(object);
        }

        public int hashCode() {
            return Objects.hash(this.First, this.Last);
        }

        @Override
        public int compareTo(Tuple<T> tuple) {
            if (this.First.compareTo(tuple.First) == 0) {
                return this.Last.compareTo(tuple.Last);
            }
            return this.First.compareTo(tuple.First);
        }
    }

    private class ZoneAnnotation
    extends IRSDependenciesAnnotation {
        private static final long serialVersionUID = 1L;
        private IcfgEdge StartEdge;
        private Statement StartStatement;
        private IcfgEdge EndEdge;
        private Statement EndStatement;
        private boolean IsStable;

        private ZoneAnnotation() {
        }

        protected String[] getFieldNames() {
            return new String[0];
        }

        protected Object getFieldValue(String string) {
            return null;
        }

        private void addOrMergeAnnotation(IElement iElement) {
            ZoneAnnotation zoneAnnotation = (ZoneAnnotation)((Object)ZoneAnnotation.getAnnotation(iElement, ((Object)((Object)this)).getClass()));
            if (zoneAnnotation != null) {
                if (!((Object)((Object)zoneAnnotation)).equals((Object)this)) {
                    SequencingVisitor.this.mLogger.debug((Object)("Need to merge: " + String.valueOf((Object)this) + " with " + String.valueOf((Object)zoneAnnotation)));
                }
            } else {
                this.addAnnotation(iElement);
            }
        }

        public String toString() {
            if (this.StartStatement == null || this.EndStatement == null) {
                return "Invalid Zone";
            }
            if (this.IsStable) {
                return "Stable: Start " + this.StartStatement.toString() + " End " + this.EndStatement.toString();
            }
            return "Unstable: Start " + this.StartStatement.toString() + " End " + this.EndStatement.toString();
        }
    }
}

