/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.OldVarsAssignmentCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.AnnotateAndAssertConjunctsOfCodeBlocks;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.AnnotateAndAsserter;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.NestedFormulas;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class RelevantTransFormulas<L extends IAction>
extends NestedFormulas<L, UnmodifiableTransFormula, IPredicate> {
    private static final boolean COMPUTE_SUM_SIZE_FORMULAS_IN_UNSAT_CORE = false;
    private final UnmodifiableTransFormula[] mTransFormulas;
    private final Map<Integer, UnmodifiableTransFormula> mGlobalAssignmentTransFormulaAtCall;
    private final Map<Integer, UnmodifiableTransFormula> mOldVarsAssignmentTransFormulasAtCall;
    private final ManagedScript mScript;
    private int mSumSizeFormulasInUnsatCore = 0;

    public RelevantTransFormulas(Counterexample<L> counterexample, IPredicate iPredicate, IPredicate iPredicate2, SortedMap<Integer, IPredicate> sortedMap, Set<L> set, OldVarsAssignmentCache oldVarsAssignmentCache, boolean[] blArray, boolean[] blArray2, ManagedScript managedScript) {
        super(counterexample, sortedMap);
        super.setPrecondition(iPredicate);
        super.setPostcondition(iPredicate2);
        this.mTransFormulas = new UnmodifiableTransFormula[counterexample.length()];
        this.mGlobalAssignmentTransFormulaAtCall = new HashMap<Integer, UnmodifiableTransFormula>();
        this.mOldVarsAssignmentTransFormulasAtCall = new HashMap<Integer, UnmodifiableTransFormula>();
        this.mScript = managedScript;
        this.generateRelevantTransFormulas(set, blArray, blArray2, oldVarsAssignmentCache);
    }

    public RelevantTransFormulas(NestedFormulas<L, UnmodifiableTransFormula, IPredicate> nestedFormulas, IPredicate iPredicate, IPredicate iPredicate2, SortedMap<Integer, IPredicate> sortedMap, Set<Term> set, OldVarsAssignmentCache oldVarsAssignmentCache, ManagedScript managedScript, AnnotateAndAsserter<L> annotateAndAsserter, AnnotateAndAssertConjunctsOfCodeBlocks<L> annotateAndAssertConjunctsOfCodeBlocks) {
        super(nestedFormulas.getCounterexample(), sortedMap);
        super.setPrecondition(iPredicate);
        super.setPostcondition(iPredicate2);
        this.mTransFormulas = new UnmodifiableTransFormula[nestedFormulas.getTrace().length()];
        this.mGlobalAssignmentTransFormulaAtCall = new HashMap<Integer, UnmodifiableTransFormula>();
        this.mOldVarsAssignmentTransFormulasAtCall = new HashMap<Integer, UnmodifiableTransFormula>();
        this.mScript = managedScript;
        this.generateRelevantTransFormulas(set, oldVarsAssignmentCache, annotateAndAsserter, annotateAndAssertConjunctsOfCodeBlocks, nestedFormulas);
    }

    private void generateRelevantTransFormulas(Set<L> set, boolean[] blArray, boolean[] blArray2, OldVarsAssignmentCache oldVarsAssignmentCache) {
        int n = 0;
        while (n < super.getTrace().length()) {
            if (set.contains(super.getTrace().getSymbol(n))) {
                if (super.getTrace().getSymbol(n) instanceof ICallAction) {
                    ICallAction iCallAction = (ICallAction)super.getTrace().getSymbol(n);
                    this.mGlobalAssignmentTransFormulaAtCall.put(n, oldVarsAssignmentCache.getGlobalVarsAssignment(iCallAction.getSucceedingProcedure()));
                    this.mOldVarsAssignmentTransFormulasAtCall.put(n, oldVarsAssignmentCache.getOldVarsAssignment(iCallAction.getSucceedingProcedure()));
                    this.mTransFormulas[n] = blArray[n] ? iCallAction.getLocalVarsAssignment() : this.buildTransFormulaForStmtNotInUnsatCore(iCallAction.getLocalVarsAssignment());
                } else {
                    this.mTransFormulas[n] = ((IAction)super.getTrace().getSymbol(n)).getTransformula();
                }
            } else if (super.getTrace().getSymbol(n) instanceof ICallAction) {
                this.mTransFormulas[n] = blArray[n] ? ((IAction)super.getTrace().getSymbol(n)).getTransformula() : this.buildTransFormulaForStmtNotInUnsatCore(((IAction)super.getTrace().getSymbol(n)).getTransformula());
                if (blArray2[n]) {
                    this.mOldVarsAssignmentTransFormulasAtCall.put(n, oldVarsAssignmentCache.getOldVarsAssignment(((IAction)super.getTrace().getSymbol(n)).getSucceedingProcedure()));
                } else {
                    this.mOldVarsAssignmentTransFormulasAtCall.put(n, this.buildTransFormulaForStmtNotInUnsatCore(oldVarsAssignmentCache.getOldVarsAssignment(((IAction)super.getTrace().getSymbol(n)).getSucceedingProcedure())));
                }
                this.mGlobalAssignmentTransFormulaAtCall.put(n, this.buildTransFormulaForStmtNotInUnsatCore(oldVarsAssignmentCache.getGlobalVarsAssignment(((IAction)super.getTrace().getSymbol(n)).getSucceedingProcedure())));
            } else {
                this.mTransFormulas[n] = this.buildTransFormulaForStmtNotInUnsatCore(((IAction)super.getTrace().getSymbol(n)).getTransformula());
            }
            ++n;
        }
    }

    private void generateRelevantTransFormulas(Set<Term> set, OldVarsAssignmentCache oldVarsAssignmentCache, AnnotateAndAsserter<L> annotateAndAsserter, AnnotateAndAssertConjunctsOfCodeBlocks<L> annotateAndAssertConjunctsOfCodeBlocks, NestedFormulas<L, UnmodifiableTransFormula, IPredicate> nestedFormulas) {
        Map<Term, Term> map = annotateAndAssertConjunctsOfCodeBlocks.getAnnotated2Original();
        int n = 0;
        while (n < super.getTrace().length()) {
            if (super.getTrace().getSymbol(n) instanceof ICallAction) {
                var8_8 = SmtUtils.getConjuncts((Term)annotateAndAsserter.getAnnotatedSsa().getLocalVarAssignment(n));
                var9_9 = this.filterRelevantConjunctsAndRestoreEqualities(set, map, var8_8, annotateAndAssertConjunctsOfCodeBlocks.getSplitEqualityMapping());
                this.mTransFormulas[n] = this.buildTransFormulaWithRelevantConjuncts(nestedFormulas.getLocalVarAssignment(n), var9_9.toArray(new Term[var9_9.size()]));
                var8_8 = SmtUtils.getConjuncts((Term)annotateAndAsserter.getAnnotatedSsa().getGlobalVarAssignment(n));
                var9_9 = this.filterRelevantConjunctsAndRestoreEqualities(set, map, var8_8, annotateAndAssertConjunctsOfCodeBlocks.getSplitEqualityMapping());
                this.mGlobalAssignmentTransFormulaAtCall.put(n, this.buildTransFormulaWithRelevantConjuncts(oldVarsAssignmentCache.getGlobalVarsAssignment(((IAction)super.getTrace().getSymbol(n)).getSucceedingProcedure()), var9_9.toArray(new Term[var9_9.size()])));
                var8_8 = SmtUtils.getConjuncts((Term)annotateAndAsserter.getAnnotatedSsa().getOldVarAssignment(n));
                var9_9 = this.filterRelevantConjunctsAndRestoreEqualities(set, map, var8_8, annotateAndAssertConjunctsOfCodeBlocks.getSplitEqualityMapping());
                this.mOldVarsAssignmentTransFormulasAtCall.put(n, this.buildTransFormulaWithRelevantConjuncts(oldVarsAssignmentCache.getOldVarsAssignment(((IAction)super.getTrace().getSymbol(n)).getSucceedingProcedure()), var9_9.toArray(new Term[var9_9.size()])));
            } else {
                var8_8 = SmtUtils.getConjuncts((Term)annotateAndAsserter.getAnnotatedSsa().getFormulaFromNonCallPos(n));
                var9_9 = this.filterRelevantConjunctsAndRestoreEqualities(set, map, var8_8, annotateAndAssertConjunctsOfCodeBlocks.getSplitEqualityMapping());
                this.mTransFormulas[n] = this.buildTransFormulaWithRelevantConjuncts(nestedFormulas.getFormulaFromNonCallPos(n), var9_9.toArray(new Term[var9_9.size()]));
            }
            ++n;
        }
    }

    private Set<Term> filterRelevantConjunctsAndRestoreEqualities(Set<Term> set, Map<Term, Term> map, Term[] termArray, AnnotateAndAssertConjunctsOfCodeBlocks.SplitEqualityMapping splitEqualityMapping) {
        HashSet<Term> hashSet = new HashSet<Term>(termArray.length);
        HashSet<Term> hashSet2 = new HashSet<Term>();
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            if (!hashSet2.contains(term)) {
                if (splitEqualityMapping.getInequality2CorrespondingInequality().containsKey(term)) {
                    var11_11 = splitEqualityMapping.getInequality2CorrespondingInequality().get(term);
                    if (set.contains(term) && set.contains(var11_11)) {
                        hashSet2.add(term);
                        hashSet2.add(var11_11);
                        var12_12 = splitEqualityMapping.getInequality2OriginalEquality().get(term);
                        hashSet.add(var12_12);
                    } else if (set.contains(term)) {
                        var12_12 = map.get(term);
                        hashSet.add(var12_12);
                    }
                } else if (set.contains(term)) {
                    var11_11 = map.get(term);
                    hashSet.add(var11_11);
                }
            }
            ++n2;
        }
        return hashSet;
    }

    private UnmodifiableTransFormula buildTransFormulaForStmtNotInUnsatCore(UnmodifiableTransFormula unmodifiableTransFormula) {
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(null, null, true, null, unmodifiableTransFormula.getBranchEncoders().isEmpty(), (Collection)unmodifiableTransFormula.getBranchEncoders(), true);
        for (IProgramVar iProgramVar : unmodifiableTransFormula.getAssignedVars()) {
            if (!unmodifiableTransFormula.getOutVars().containsKey(iProgramVar)) continue;
            transFormulaBuilder.addOutVar(iProgramVar, (TermVariable)unmodifiableTransFormula.getOutVars().get(iProgramVar));
        }
        transFormulaBuilder.setFormula(this.mScript.getScript().term("true", new Term[0]));
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.UNPROVEABLE);
        return transFormulaBuilder.finishConstruction(this.mScript);
    }

    private UnmodifiableTransFormula buildTransFormulaWithRelevantConjuncts(UnmodifiableTransFormula unmodifiableTransFormula, Term[] termArray) {
        Object object3;
        Object object22;
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(null, null, false, null, false, null, false);
        Term term = SmtUtils.and((Script)this.mScript.getScript(), (Term[])termArray);
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, term.getFreeVars());
        for (Object object22 : unmodifiableTransFormula.getInVars().keySet()) {
            if (!hashSet.contains(unmodifiableTransFormula.getInVars().get(object22))) continue;
            transFormulaBuilder.addInVar((IProgramVar)object22, (TermVariable)unmodifiableTransFormula.getInVars().get(object22));
        }
        for (Object object22 : unmodifiableTransFormula.getOutVars().keySet()) {
            if (unmodifiableTransFormula.getOutVars().get(object22) != unmodifiableTransFormula.getInVars().get(object22)) {
                transFormulaBuilder.addOutVar((IProgramVar)object22, (TermVariable)unmodifiableTransFormula.getOutVars().get(object22));
                continue;
            }
            if (!hashSet.contains(unmodifiableTransFormula.getOutVars().get(object22))) continue;
            transFormulaBuilder.addOutVar((IProgramVar)object22, (TermVariable)unmodifiableTransFormula.getOutVars().get(object22));
        }
        object22 = new HashSet();
        for (Object object3 : unmodifiableTransFormula.getAuxVars()) {
            if (!hashSet.contains(object3)) continue;
            object22.add(object3);
        }
        object3 = unmodifiableTransFormula.getNonTheoryConsts();
        TransFormulaUtils.addConstantsIfInFormula((TransFormulaBuilder)transFormulaBuilder, (Term)term, (Set)object3);
        transFormulaBuilder.setFormula(term);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        transFormulaBuilder.addAuxVarsButRenameToFreshCopies((Set)object22, this.mScript);
        return transFormulaBuilder.finishConstruction(this.mScript);
    }

    @Override
    protected UnmodifiableTransFormula getFormulaFromValidNonCallPos(int n) {
        return this.mTransFormulas[n];
    }

    @Override
    protected UnmodifiableTransFormula getLocalVarAssignmentFromValidPos(int n) {
        return this.mTransFormulas[n];
    }

    @Override
    protected UnmodifiableTransFormula getGlobalVarAssignmentFromValidPos(int n) {
        return this.mGlobalAssignmentTransFormulaAtCall.get(n);
    }

    @Override
    protected UnmodifiableTransFormula getOldVarAssignmentFromValidPos(int n) {
        return this.mOldVarsAssignmentTransFormulasAtCall.get(n);
    }
}

