/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.preferences;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.PreferenceException;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.BaseUltimatePreferenceItem;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.KeyValueUtil;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.UltimatePreferenceItem;
import java.util.Map;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public final class RcpPreferenceBinder {
    private RcpPreferenceBinder() {
    }

    public static void initializePreferences(IEclipsePreferences iEclipsePreferences, BaseUltimatePreferenceItem[] baseUltimatePreferenceItemArray) {
        RcpPreferenceBinder.flushEclipsePreferences(iEclipsePreferences);
        for (BaseUltimatePreferenceItem baseUltimatePreferenceItem : BaseUltimatePreferenceItem.constructFlattenedList((BaseUltimatePreferenceItem[])baseUltimatePreferenceItemArray)) {
            if (!(baseUltimatePreferenceItem instanceof UltimatePreferenceItem)) continue;
            UltimatePreferenceItem ultimatePreferenceItem = (UltimatePreferenceItem)baseUltimatePreferenceItem;
            String string = ultimatePreferenceItem.getLabel();
            Object object = ultimatePreferenceItem.getDefaultValue();
            iEclipsePreferences.remove(string);
            switch (ultimatePreferenceItem.getType()) {
                case Boolean: {
                    iEclipsePreferences.putBoolean(string, ((Boolean)object).booleanValue());
                    break;
                }
                case Integer: {
                    iEclipsePreferences.putInt(string, ((Integer)object).intValue());
                    break;
                }
                case Double: {
                    iEclipsePreferences.putDouble(string, ((Double)object).doubleValue());
                    break;
                }
                case Directory: 
                case String: 
                case Combo: 
                case Radio: 
                case Path: 
                case MultilineString: 
                case File: 
                case Color: {
                    iEclipsePreferences.put(string, object.toString());
                    break;
                }
                case KeyValue: {
                    if (object instanceof Map) {
                        iEclipsePreferences.put(string, KeyValueUtil.toKeyValueString((Map)((Map)object)));
                        break;
                    }
                    throw new IllegalArgumentException(String.format("Value %s is of type %s, but must be of type Map<String,String>", object, object.getClass()));
                }
                case Label: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("You need to implement the new enum type \"" + String.valueOf(ultimatePreferenceItem.getType()) + "\" here");
                }
            }
        }
        RcpPreferenceBinder.flushEclipsePreferences(iEclipsePreferences);
    }

    public static IEclipsePreferences getInstanceStore(String string) {
        return InstanceScope.INSTANCE.getNode(string);
    }

    public static IEclipsePreferences getDefaultStore(String string) {
        return DefaultScope.INSTANCE.getNode(string);
    }

    public static void resetToDefaultPreferences(String string, BaseUltimatePreferenceItem[] baseUltimatePreferenceItemArray) {
        IEclipsePreferences iEclipsePreferences = RcpPreferenceBinder.getInstanceStore(string);
        RcpPreferenceBinder.initializePreferences(iEclipsePreferences, baseUltimatePreferenceItemArray);
    }

    public static void registerDefaultPreferences(String string, BaseUltimatePreferenceItem[] baseUltimatePreferenceItemArray) {
        IEclipsePreferences iEclipsePreferences = RcpPreferenceBinder.getDefaultStore(string);
        RcpPreferenceBinder.initializePreferences(iEclipsePreferences, baseUltimatePreferenceItemArray);
    }

    private static void flushEclipsePreferences(IEclipsePreferences iEclipsePreferences) {
        try {
            iEclipsePreferences.flush();
            iEclipsePreferences.sync();
        }
        catch (BackingStoreException backingStoreException) {
            throw new PreferenceException("de.uni_freiburg.informatik.ultimate.core", (Throwable)backingStoreException);
        }
    }
}

