/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.DefaultIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IReplacementVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IntraproceduralReplacementVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.LocalReplacementVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ReplacementVarFactory {
    private final ManagedScript mMgdScript;
    private final CfgSmtToolkit mCsToolkit;
    private final Map<Term, IReplacementVarOrConst> mRepVarMapping = new HashMap<Term, IReplacementVarOrConst>();
    private final Map<String, TermVariable> mAuxVarMapping = new HashMap<String, TermVariable>();
    private final boolean mUseIntraproceduralReplacementVar;

    public ReplacementVarFactory(CfgSmtToolkit cfgSmtToolkit, boolean bl) {
        this.mMgdScript = cfgSmtToolkit.getManagedScript();
        this.mCsToolkit = cfgSmtToolkit;
        this.mUseIntraproceduralReplacementVar = bl;
    }

    public IReplacementVarOrConst getOrConstuctReplacementVar(Term term, boolean bl) {
        return this.getOrConstuctReplacementVar(term, bl, term.getSort());
    }

    public IReplacementVarOrConst getOrConstuctReplacementVar(Term term, boolean bl, Sort sort) {
        IReplacementVarOrConst iReplacementVarOrConst;
        IReplacementVarOrConst iReplacementVarOrConst2 = this.mRepVarMapping.get(term);
        if (iReplacementVarOrConst2 != null) {
            return iReplacementVarOrConst2;
        }
        String string = "rep" + SmtUtils.removeSmtQuoteCharacters((String)term.toString());
        TermVariable termVariable = this.mMgdScript.constructFreshTermVariable(string, sort);
        if (this.mUseIntraproceduralReplacementVar) {
            iReplacementVarOrConst = new IntraproceduralReplacementVar(termVariable.getName(), term, termVariable);
            this.mRepVarMapping.put(term, iReplacementVarOrConst);
        } else {
            Pair<Set<Class<? extends IProgramVarOrConst>>, Set<String>> pair = this.analyzeDefinition(term);
            if (((Set)pair.getFirst()).contains(IProgramNonOldVar.class) && ((Set)pair.getFirst()).contains(IProgramOldVar.class)) {
                throw new UnsupportedOperationException("nonold and old");
            }
            if (((Set)pair.getFirst()).contains(ILocalProgramVar.class)) {
                if (((Set)pair.getSecond()).size() > 1) {
                    throw new UnsupportedOperationException("more than one procedure");
                }
                String string2 = (String)((Set)pair.getSecond()).iterator().next();
                iReplacementVarOrConst = this.constructLocalReplacementVar(term, termVariable, string2);
                this.mRepVarMapping.put(term, iReplacementVarOrConst);
            } else if (((Set)pair.getFirst()).contains(IProgramNonOldVar.class)) {
                ReplacementOldVar replacementOldVar = this.constructOldNonOldPairForNonOldDefinition(term, termVariable);
                ReplacementNonOldVar replacementNonOldVar = (ReplacementNonOldVar)replacementOldVar.getNonOldVar();
                this.mRepVarMapping.put(replacementOldVar.getDefinition(), replacementOldVar);
                this.mRepVarMapping.put(replacementNonOldVar.getDefinition(), replacementNonOldVar);
                iReplacementVarOrConst = replacementNonOldVar;
            } else if (((Set)pair.getFirst()).contains(IProgramOldVar.class)) {
                ReplacementOldVar replacementOldVar = this.constructOldNonOldPairForOldVarDefinition(term, termVariable);
                ReplacementNonOldVar replacementNonOldVar = (ReplacementNonOldVar)replacementOldVar.getNonOldVar();
                this.mRepVarMapping.put(replacementOldVar.getDefinition(), replacementOldVar);
                this.mRepVarMapping.put(replacementNonOldVar.getDefinition(), replacementNonOldVar);
                iReplacementVarOrConst = replacementOldVar;
            } else if (bl) {
                ReplacementOldVar replacementOldVar = this.constructOldNonOldPairForNonOldDefinition(term, termVariable);
                ReplacementNonOldVar replacementNonOldVar = (ReplacementNonOldVar)replacementOldVar.getNonOldVar();
                this.mRepVarMapping.put(replacementOldVar.getDefinition(), replacementOldVar);
                this.mRepVarMapping.put(replacementNonOldVar.getDefinition(), replacementNonOldVar);
                iReplacementVarOrConst = replacementNonOldVar;
            } else {
                iReplacementVarOrConst = this.constructReplacementConst(term, termVariable);
                this.mRepVarMapping.put(term, iReplacementVarOrConst);
            }
        }
        assert (this.checkOldVar(iReplacementVarOrConst)) : String.valueOf(iReplacementVarOrConst) + " breaks oldVar-nonOldVar relation";
        return iReplacementVarOrConst;
    }

    private boolean checkOldVar(IReplacementVarOrConst iReplacementVarOrConst) {
        if (iReplacementVarOrConst instanceof IProgramOldVar) {
            IProgramOldVar iProgramOldVar = (IProgramOldVar)((Object)iReplacementVarOrConst);
            return Objects.equals(iProgramOldVar, iProgramOldVar.getNonOldVar().getOldVar());
        }
        if (iReplacementVarOrConst instanceof IProgramNonOldVar) {
            IProgramNonOldVar iProgramNonOldVar = (IProgramNonOldVar)((Object)iReplacementVarOrConst);
            return Objects.equals(iProgramNonOldVar, iProgramNonOldVar.getOldVar().getNonOldVar());
        }
        return true;
    }

    private ReplacementOldVar constructOldNonOldPairForOldVarDefinition(Term term, TermVariable termVariable) {
        ReplacementOldVar replacementOldVar = this.constructReplacementOldVar(term, termVariable);
        Term term2 = replacementOldVar.getDefinition();
        Term term3 = ProgramVarUtils.renameOldGlobalsToNonOldGlobals(term2, this.mCsToolkit.getSymbolTable(), this.mMgdScript);
        TermVariable termVariable2 = this.mMgdScript.constructFreshTermVariable("nonold(" + replacementOldVar.getIdentifierOfNonOldVar() + ")", term2.getSort());
        this.constructReplacementNonOldVar(term3, termVariable2, replacementOldVar);
        return replacementOldVar;
    }

    private ReplacementOldVar constructOldNonOldPairForNonOldDefinition(Term term, TermVariable termVariable) {
        Term term2 = ProgramVarUtils.renameNonOldGlobalsToOldGlobals(term, this.mCsToolkit.getSymbolTable(), this.mMgdScript);
        TermVariable termVariable2 = this.mMgdScript.constructFreshTermVariable("old(" + termVariable.getName() + ")", term.getSort());
        ReplacementOldVar replacementOldVar = this.constructReplacementOldVar(term2, termVariable2);
        this.constructReplacementNonOldVar(term, termVariable, replacementOldVar);
        return replacementOldVar;
    }

    private ReplacementConst constructReplacementConst(Term term, TermVariable termVariable) {
        this.mMgdScript.lock((Object)this);
        this.mMgdScript.declareFun((Object)this, termVariable.getName(), new Sort[0], termVariable.getSort());
        ApplicationTerm applicationTerm = (ApplicationTerm)this.mMgdScript.term((Object)this, termVariable.getName(), new Term[0]);
        this.mMgdScript.unlock((Object)this);
        return new ReplacementConst(termVariable.getName(), applicationTerm, term);
    }

    private LocalReplacementVar constructLocalReplacementVar(Term term, TermVariable termVariable, String string) {
        this.mMgdScript.lock((Object)this);
        ApplicationTerm applicationTerm = ProgramVarUtils.constructDefaultConstant(this.mMgdScript, this, termVariable.getSort(), termVariable.getName());
        ApplicationTerm applicationTerm2 = ProgramVarUtils.constructPrimedConstant(this.mMgdScript, this, termVariable.getSort(), termVariable.getName());
        this.mMgdScript.unlock((Object)this);
        return new LocalReplacementVar(termVariable.getName(), string, termVariable, applicationTerm, applicationTerm2, term);
    }

    private ReplacementOldVar constructReplacementOldVar(Term term, TermVariable termVariable) {
        this.mMgdScript.lock((Object)this);
        ApplicationTerm applicationTerm = ProgramVarUtils.constructDefaultConstant(this.mMgdScript, this, termVariable.getSort(), termVariable.getName());
        ApplicationTerm applicationTerm2 = ProgramVarUtils.constructPrimedConstant(this.mMgdScript, this, termVariable.getSort(), termVariable.getName());
        this.mMgdScript.unlock((Object)this);
        return new ReplacementOldVar(termVariable.getName(), termVariable, applicationTerm, applicationTerm2, term);
    }

    private ReplacementNonOldVar constructReplacementNonOldVar(Term term, TermVariable termVariable, ReplacementOldVar replacementOldVar) {
        this.mMgdScript.lock((Object)this);
        ApplicationTerm applicationTerm = ProgramVarUtils.constructDefaultConstant(this.mMgdScript, this, termVariable.getSort(), termVariable.getName());
        ApplicationTerm applicationTerm2 = ProgramVarUtils.constructPrimedConstant(this.mMgdScript, this, termVariable.getSort(), termVariable.getName());
        this.mMgdScript.unlock((Object)this);
        ReplacementNonOldVar replacementNonOldVar = new ReplacementNonOldVar(termVariable.getName(), termVariable, applicationTerm, applicationTerm2, replacementOldVar, term);
        replacementOldVar.setNonOldVar(replacementNonOldVar);
        return replacementNonOldVar;
    }

    public TermVariable getOrConstructAuxVar(String string, Sort sort) {
        TermVariable termVariable = this.mAuxVarMapping.get(string);
        if (termVariable == null) {
            termVariable = this.mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)string), sort);
            this.mAuxVarMapping.put(string, termVariable);
        } else if (sort != termVariable.getSort()) {
            throw new AssertionError((Object)"cannot construct auxVars with same name and different sort");
        }
        return termVariable;
    }

    private Pair<Set<Class<? extends IProgramVarOrConst>>, Set<String>> analyzeDefinition(Term term) {
        Set set;
        HashSet<Class> hashSet = new HashSet<Class>();
        HashSet<String> hashSet2 = new HashSet<String>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            set = termVariableArray[n2];
            IProgramVar iProgramVar = this.mCsToolkit.getSymbolTable().getProgramVar((TermVariable)set);
            if (iProgramVar instanceof ILocalProgramVar) {
                hashSet.add(ILocalProgramVar.class);
                hashSet2.add(iProgramVar.getProcedure());
            } else if (iProgramVar instanceof IProgramNonOldVar) {
                hashSet.add(IProgramNonOldVar.class);
            } else if (iProgramVar instanceof IProgramOldVar) {
                hashSet.add(IProgramOldVar.class);
            } else {
                throw new AssertionError((Object)"unknown kind of variable");
            }
            ++n2;
        }
        set = SmtUtils.extractConstants((Term)term, (boolean)true);
        if (!set.isEmpty()) {
            hashSet.add(IProgramConst.class);
        }
        return new Pair(hashSet, hashSet2);
    }

    public IIcfgSymbolTable constructIIcfgSymbolTable() {
        DefaultIcfgSymbolTable defaultIcfgSymbolTable = new DefaultIcfgSymbolTable(this.mCsToolkit.getSymbolTable(), this.mCsToolkit.getProcedures());
        for (Map.Entry<Term, IReplacementVarOrConst> entry : this.mRepVarMapping.entrySet()) {
            if (entry.getValue() instanceof IProgramOldVar) continue;
            defaultIcfgSymbolTable.add(entry.getValue());
        }
        defaultIcfgSymbolTable.finishConstruction();
        return defaultIcfgSymbolTable;
    }

    public ModifiableGlobalsTable constructModifiableGlobalsTable() {
        Object object;
        HashRelation hashRelation = new HashRelation();
        for (String object2 : this.mCsToolkit.getProcedures()) {
            object = this.mCsToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(object2);
            Iterator<Object> iterator = object.iterator();
            while (iterator.hasNext()) {
                IProgramNonOldVar iProgramNonOldVar = iterator.next();
                hashRelation.addPair((Object)object2, (Object)iProgramNonOldVar);
            }
        }
        for (Map.Entry entry : this.mRepVarMapping.entrySet()) {
            if (!(entry.getValue() instanceof ReplacementNonOldVar)) continue;
            object = (ReplacementNonOldVar)entry.getValue();
            for (String string : this.mCsToolkit.getProcedures()) {
                hashRelation.addPair((Object)string, object);
            }
        }
        return new ModifiableGlobalsTable((HashRelation<String, IProgramNonOldVar>)hashRelation);
    }

    public boolean isUnused() {
        return this.mRepVarMapping.isEmpty() && this.mAuxVarMapping.isEmpty();
    }
}

