/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.statistics;

import de.uni_freiburg.informatik.ultimate.util.statistics.Benchmark;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class StatisticsGeneratorWithStopwatches {
    private final Map<String, Boolean> mRunningStopwatches = new HashMap<String, Boolean>(this.getStopwatches().length);
    private final Benchmark mBenchmark = new Benchmark();

    public StatisticsGeneratorWithStopwatches() {
        String[] stringArray = this.getStopwatches();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.mRunningStopwatches.put(string, false);
            this.mBenchmark.register(string);
            ++n2;
        }
    }

    public abstract String[] getStopwatches();

    public void start(Object object) {
        this.start(object.toString());
    }

    public void start(String string) {
        assert (this.mRunningStopwatches.containsKey(string)) : "no such stopwatch " + string;
        assert (!this.mRunningStopwatches.get(string).booleanValue()) : "already started " + string;
        this.mRunningStopwatches.put(string, true);
        this.mBenchmark.unpause(string);
    }

    public void stop(Object object) {
        this.stop(object.toString());
    }

    public void stop(String string) {
        assert (this.mRunningStopwatches.containsKey(string)) : "no such stopwatch " + string;
        assert (this.mRunningStopwatches.get(string).booleanValue()) : "not running " + string;
        this.mRunningStopwatches.put(string, false);
        this.mBenchmark.pause(string);
    }

    public void stopAllStopwatches() {
        this.mRunningStopwatches.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).forEach(this::stop);
    }

    protected long getElapsedTime(String string) throws StopwatchStillRunningException {
        assert (this.mRunningStopwatches.containsKey(string)) : "no such stopwatch " + string;
        if (this.mRunningStopwatches.get(string).booleanValue()) {
            throw new StopwatchStillRunningException();
        }
        return (long)this.mBenchmark.getElapsedTime(string, TimeUnit.NANOSECONDS);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = this.getStopwatches();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            stringBuilder.append(string);
            stringBuilder.append(": ");
            try {
                stringBuilder.append(StatisticsGeneratorWithStopwatches.prettyprintNanoseconds(this.getElapsedTime(string)));
            }
            catch (StopwatchStillRunningException stopwatchStillRunningException) {
                stringBuilder.append("clockStillRunning!");
            }
            if (this.mRunningStopwatches.get(string).booleanValue()) {
                stringBuilder.append("stopwatch still running!!!");
            }
            stringBuilder.append(" ");
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String prettyprintNanoseconds(long l) {
        long l2 = l / 1000000000L;
        long l3 = l / 100000000L % 10L;
        return l2 + "." + l3 + "s";
    }

    public static class StopwatchStillRunningException
    extends Exception {
        private static final long serialVersionUID = 47519007262609785L;
    }
}

