/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IBoogieSymbolTableVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.AbsIntBenchmark;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.BooleanValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalEvaluationResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.Evaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.ExpressionEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.IEvaluationResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.IEvaluatorFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.util.typeutils.TypeUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.CrossProducts;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class NonrelationalStatementProcessor<STATE extends NonrelationalState<STATE, V>, V extends INonrelationalValue<V>>
extends BoogieVisitor {
    private final IBoogieSymbolTableVariableProvider mBoogie2SmtSymbolTable;
    private final ILogger mLogger;
    private STATE mOldState;
    private List<STATE> mReturnState;
    private IProgramVarOrConst mLhsVariable;
    private Map<LeftHandSide, IProgramVarOrConst> mTemporaryVars;
    private AbsIntBenchmark<IcfgEdge> mAbsIntBenchmark;
    private final NonrelationalEvaluator<STATE, V> mEvaluator;

    public NonrelationalStatementProcessor(ILogger iLogger, IBoogieSymbolTableVariableProvider iBoogieSymbolTableVariableProvider, NonrelationalEvaluator<STATE, V> nonrelationalEvaluator) {
        this.mBoogie2SmtSymbolTable = iBoogieSymbolTableVariableProvider;
        this.mLogger = iLogger;
        this.mEvaluator = nonrelationalEvaluator;
        this.mLhsVariable = null;
    }

    public List<STATE> process(STATE STATE, Statement statement, AbsIntBenchmark<IcfgEdge> absIntBenchmark) {
        return this.process(STATE, statement, Collections.emptyMap(), absIntBenchmark);
    }

    public List<STATE> process(STATE STATE, Statement statement, Map<LeftHandSide, IProgramVarOrConst> map, AbsIntBenchmark<IcfgEdge> absIntBenchmark) {
        assert (STATE != null);
        assert (statement != null);
        assert (map != null);
        this.mReturnState = new ArrayList<STATE>();
        this.mOldState = STATE;
        this.mTemporaryVars = map;
        this.mLhsVariable = null;
        this.mAbsIntBenchmark = absIntBenchmark;
        this.processStatement(statement);
        List<STATE> list = this.mReturnState;
        assert (((NonrelationalState)STATE).getVariables().isEmpty() || !list.isEmpty());
        this.mReturnState = null;
        this.mOldState = null;
        this.mTemporaryVars = null;
        this.mLhsVariable = null;
        return list;
    }

    protected Statement processStatement(Statement statement) {
        if (statement instanceof AssignmentStatement) {
            this.handleAssignment((AssignmentStatement)statement);
            return statement;
        }
        if (statement instanceof AssumeStatement) {
            this.handleAssumeStatement((AssumeStatement)statement);
            return statement;
        }
        if (statement instanceof HavocStatement) {
            this.handleHavocStatement((HavocStatement)statement);
            return statement;
        }
        return super.processStatement(statement);
    }

    protected void addEvaluators(ExpressionEvaluator<V, STATE> expressionEvaluator, IEvaluatorFactory<V, STATE> iEvaluatorFactory, Expression expression) {
    }

    protected ILogger getLogger() {
        return this.mLogger;
    }

    private void handleAssignment(AssignmentStatement assignmentStatement) {
        LeftHandSide[] leftHandSideArray = assignmentStatement.getLhs();
        Expression[] expressionArray = assignmentStatement.getRhs();
        int n = leftHandSideArray.length;
        assert (leftHandSideArray.length == expressionArray.length && n > 0) : "Broken assignment statement";
        if (n > 1) {
            this.handleMultiAssignment(leftHandSideArray, expressionArray);
            return;
        }
        this.mReturnState.addAll(this.handleSingleAssignment(this.getLhsVariable(leftHandSideArray[0]), expressionArray[0], this.mOldState));
    }

    private void handleMultiAssignment(LeftHandSide[] leftHandSideArray, Expression[] expressionArray) {
        ArrayList<List<STATE>> arrayList = new ArrayList<List<STATE>>();
        int n = 0;
        while (n < leftHandSideArray.length) {
            IProgramVarOrConst iProgramVarOrConst = this.getLhsVariable(leftHandSideArray[n]);
            List<STATE> list2 = this.handleSingleAssignment(iProgramVarOrConst, expressionArray[n], this.mOldState);
            List<STATE> list3 = this.project(iProgramVarOrConst, (STATE)list2);
            assert (list3 != null);
            arrayList.add(list3);
            ++n;
        }
        List list4 = CrossProducts.crossProduct(arrayList);
        list4.stream().map(list -> list.stream().reduce((nonrelationalState, nonrelationalState2) -> nonrelationalState.patch(nonrelationalState2))).forEach(optional -> {
            boolean bl = this.mReturnState.add(this.mOldState.patch((NonrelationalState)((NonrelationalState)optional.get())));
        });
    }

    private List<STATE> project(IProgramVarOrConst iProgramVarOrConst, List<STATE> list) {
        return list.stream().map(nonrelationalState -> this.project(iProgramVarOrConst, nonrelationalState)).collect(Collectors.toList());
    }

    private STATE project(IProgramVarOrConst iProgramVarOrConst, STATE STATE) {
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>((Collection<IProgramVarOrConst>)((NonrelationalState)STATE).getVariables());
        hashSet.remove(iProgramVarOrConst);
        return (STATE)((NonrelationalState)STATE).removeVariables(hashSet);
    }

    private List<STATE> handleSingleAssignment(IProgramVarOrConst iProgramVarOrConst2, Expression expression, STATE STATE) {
        Collection<IEvaluationResult<V>> collection = this.mEvaluator.evaluate(STATE, expression);
        if (collection.isEmpty()) {
            throw new UnsupportedOperationException("There is supposed to be at least on evaluation result for assignment expressions.");
        }
        ArrayList<NonrelationalState> arrayList = new ArrayList<NonrelationalState>();
        for (IEvaluationResult object : collection) {
            Function<IProgramVarOrConst, NonrelationalState> function = iProgramVarOrConst -> STATE.setValue((IProgramVarOrConst)iProgramVarOrConst, (INonrelationalValue)object.getValue());
            Function<IProgramVarOrConst, NonrelationalState> function2 = iProgramVarOrConst -> STATE.setBooleanValue((IProgramVarOrConst)iProgramVarOrConst, object.getBooleanValue());
            NonrelationalState nonrelationalState = TypeUtils.applyVariableFunction(function, function2, null, iProgramVarOrConst2);
            arrayList.add(nonrelationalState);
        }
        if (this.mAbsIntBenchmark != null) {
            Evaluator<V, STATE> evaluator = this.mEvaluator.createEvaluator(expression);
            this.mAbsIntBenchmark.recordEvaluationRecursionDepth(evaluator.getEvaluationRecursionDepth());
            this.mAbsIntBenchmark.recordInverseEvaluationRecursionDepth(evaluator.getInverseEvaluationRecursionDepth());
        }
        return arrayList;
    }

    private IProgramVarOrConst getLhsVariable(LeftHandSide leftHandSide) {
        assert (this.mLhsVariable == null);
        this.processLeftHandSide(leftHandSide);
        assert (this.mLhsVariable != null) : "processLeftHandSide(...) failed";
        IProgramVarOrConst iProgramVarOrConst = this.mLhsVariable;
        this.mLhsVariable = null;
        return iProgramVarOrConst;
    }

    private void handleAssumeStatement(AssumeStatement assumeStatement) {
        Expression expression = assumeStatement.getFormula();
        if (expression instanceof BooleanLiteral) {
            BooleanLiteral booleanLiteral = (BooleanLiteral)expression;
            if (!booleanLiteral.getValue()) {
                if (!((NonrelationalState)this.mOldState).getVariables().isEmpty()) {
                    this.mReturnState.add(((NonrelationalState)this.mOldState).bottomState());
                }
            } else {
                this.mReturnState.add(this.mOldState);
            }
            return;
        }
        Evaluator<V, STATE> evaluator = this.mEvaluator.createEvaluator(expression);
        Collection<IEvaluationResult<V>> collection = this.mEvaluator.evaluate(this.mOldState, expression);
        for (IEvaluationResult<V> iEvaluationResult : collection) {
            if (((INonrelationalValue)iEvaluationResult.getValue()).isBottom() || iEvaluationResult.getBooleanValue() == BooleanValue.BOTTOM || iEvaluationResult.getBooleanValue() == BooleanValue.FALSE) {
                if (((NonrelationalState)this.mOldState).getVariables().isEmpty()) continue;
                this.mReturnState.add(((NonrelationalState)this.mOldState).bottomState());
                continue;
            }
            Collection<STATE> collection2 = evaluator.inverseEvaluate(new NonrelationalEvaluationResult<INonrelationalValue>((INonrelationalValue)iEvaluationResult.getValue(), BooleanValue.TRUE), this.mOldState, 0);
            this.mReturnState.addAll(collection2.stream().map(nonrelationalState -> nonrelationalState.intersect(this.mOldState)).collect(Collectors.toList()));
        }
        if (this.mAbsIntBenchmark != null) {
            this.mAbsIntBenchmark.recordEvaluationRecursionDepth(evaluator.getEvaluationRecursionDepth());
            this.mAbsIntBenchmark.recordInverseEvaluationRecursionDepth(evaluator.getInverseEvaluationRecursionDepth());
        }
    }

    private void handleHavocStatement(HavocStatement havocStatement) {
        Object object = this.mOldState;
        VariableLHS[] variableLHSArray = havocStatement.getIdentifiers();
        int n = variableLHSArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableLHS variableLHS = variableLHSArray[n2];
            IProgramVarOrConst iProgramVarOrConst2 = this.getBoogieVar(variableLHS);
            Object STATE = object;
            Function<IProgramVarOrConst, NonrelationalState> function = iProgramVarOrConst -> STATE.setValue((IProgramVarOrConst)iProgramVarOrConst, STATE.createTopValue());
            Function<IProgramVarOrConst, NonrelationalState> function2 = iProgramVarOrConst -> STATE.setBooleanValue((IProgramVarOrConst)iProgramVarOrConst, BooleanValue.TOP);
            object = TypeUtils.applyVariableFunction(function, function2, null, iProgramVarOrConst2);
            ++n2;
        }
        this.mReturnState.add(object);
    }

    protected void visit(VariableLHS variableLHS) {
        this.mLhsVariable = this.getBoogieVar(variableLHS);
    }

    private IProgramVarOrConst getBoogieVar(VariableLHS variableLHS) {
        IProgramVarOrConst iProgramVarOrConst = this.mTemporaryVars.get(variableLHS);
        if (iProgramVarOrConst == null) {
            iProgramVarOrConst = this.mBoogie2SmtSymbolTable.getBoogieVar(variableLHS.getIdentifier(), variableLHS.getDeclarationInformation(), false);
        }
        if (iProgramVarOrConst == null) {
            String string = variableLHS.getIdentifier().replaceAll("old\\((.*)\\)", "$1");
            iProgramVarOrConst = this.mBoogie2SmtSymbolTable.getBoogieVar(string, variableLHS.getDeclarationInformation(), false);
            iProgramVarOrConst = ((ProgramNonOldVar)iProgramVarOrConst).getOldVar();
        }
        assert (iProgramVarOrConst != null) : "Could not find boogie var";
        return iProgramVarOrConst;
    }
}

