/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking;

import de.uni_freiburg.informatik.ultimate.lib.pea.Decision;
import de.uni_freiburg.informatik.ultimate.lib.pea.Phase;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseEventAutomata;
import de.uni_freiburg.informatik.ultimate.lib.pea.Transition;
import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.TCSWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class DOTWriter
extends TCSWriter {
    protected FileWriter writer;
    protected boolean rename;
    protected PhaseEventAutomata pea2write;

    public DOTWriter(String string, PhaseEventAutomata phaseEventAutomata) {
        super(string);
        this.pea2write = phaseEventAutomata;
    }

    public DOTWriter(String string) {
        super(string);
    }

    public DOTWriter(String string, boolean bl, PhaseEventAutomata phaseEventAutomata) {
        this(string, phaseEventAutomata);
        this.rename = bl;
    }

    public void write(String string, PhaseEventAutomata phaseEventAutomata) {
        try {
            this.pea2write = phaseEventAutomata;
            this.writer = new FileWriter(string);
            this.writePreamble();
            this.writeInitialTransitions();
            this.writeTransitions();
            this.writeClose();
            this.writer.flush();
            this.writer.close();
            System.out.println("Successfully written to " + string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void write() {
        try {
            this.writer = new FileWriter(this.mFileName);
            this.writePreamble();
            this.writeInitialTransitions();
            this.writeTransitions();
            this.writeClose();
            this.writer.flush();
            this.writer.close();
            System.out.println("Successfully written to " + this.mFileName);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    protected void writeAndDelimiter(Writer writer) throws IOException {
    }

    protected void writeDecision(Decision decision, int n, Writer writer) throws IOException {
    }

    protected void writePreamble() throws IOException {
        this.writer.write("/* Preamble:\n File automatically generated via DOTWriter\n\n */ digraph G { \n");
    }

    protected void writeInitialTransitions() throws IOException {
        List<Phase> list = this.pea2write.getInit();
        for (Phase phase : list) {
            String string = phase.toString();
            string = string.replace("_", "");
            this.writer.write("null" + string + " [shape = plaintext label=\"\"] \n");
            this.writer.write("null" + string + " -> " + string + ";\n");
        }
    }

    protected void writeClose() throws IOException {
        this.writer.write("\n }");
    }

    protected void writeTransitions() throws IOException {
        List<Phase> list = this.pea2write.getPhases();
        int n = 0;
        while (n < list.size()) {
            Phase phase = list.get(n);
            String string = phase.getName();
            string = string.replace("_", "");
            String string2 = phase.getClockInvariant().toTexString();
            string2 = string2.replace("_", "");
            String string3 = phase.getStateInvariant().toTexString();
            string3 = string3.replace("\\wedge", "\\wedge \\\\");
            string3 = string3.replace("\\vee", "\\vee \\\\");
            string3 = string3.replace("_", "");
            this.writer.write(string + " [width=0.5pt, texlbl=\"$\\substack{" + string + " \\\\ " + string3 + " \\\\ " + string2 + " }$\"]; \n");
            List<Transition> list2 = phase.getTransitions();
            for (Transition transition : list2) {
                String string4 = transition.getSrc().getName();
                string4 = string4.replace("_", "");
                String string5 = transition.getDest().getName();
                string5 = string5.replace("_", "");
                String string6 = transition.getGuard().toTexString();
                string6 = string6.replace("_", "");
                string6 = string6.replace("\\wedge", "\\wedge \\\\");
                String[] stringArray = transition.getResets();
                String string7 = " ";
                int n2 = string6.length();
                while (n2 > 0) {
                    string7 = string7.concat(" ");
                    --n2;
                }
                Object object = " ";
                if (stringArray.length > 0) {
                    String[] stringArray2 = stringArray;
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String string8 = stringArray2[n4];
                        object = (String)object + string8 + " := 0 ";
                        ++n4;
                    }
                }
                object = ((String)object).replace("_", "");
                this.writer.write(" " + string4 + " -> " + string5 + " [label=\" " + string7 + " \", width =1, texlbl=\"$\\substack{" + string6 + " \\\\ " + (String)object + "}$\"]; \n");
            }
            ++n;
        }
    }

    public static class DOTString {
        public static final String DOT_NODEDEF_START = " [width=0.5pt, texlbl=\"$\\substack{";
        public static final String DOT_NODEDEF_END = " }$\"]; \n";
        public static final String TO = " -> ";
        public static final String STOP = ";";
        public static final String DOT_LABEL_START = " [label=\"                 \", width =1, texlbl=\"$\\substack{";
        public static final String DOT_LABEL_START1 = " [label=\" ";
        public static final String DOT_LABEL_START2 = " \", width =1, texlbl=\"$\\substack{";
        public static final String DOT_LABEL_END = "}$\"]; \n";
    }
}

