/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.ITreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonRule;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.isDetereministic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Determinize<LETTER extends IRankedLetter, STATE>
extends GeneralOperation<LETTER, STATE, IStateFactory<STATE>>
implements IOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final ITreeAutomatonBU<LETTER, STATE> mTreeAutomaton;
    private final IMergeStateFactory<STATE> mStateFactoryMerge;
    private final Map<Set<STATE>, STATE> mReducedStates = new HashMap<Set<STATE>, STATE>();
    protected final ITreeAutomatonBU<LETTER, STATE> mResult;

    public <SF extends IMergeStateFactory<STATE>> Determinize(AutomataLibraryServices automataLibraryServices, SF SF, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU) {
        super(automataLibraryServices);
        this.mStateFactoryMerge = SF;
        this.mTreeAutomaton = iTreeAutomatonBU;
        this.mResult = new isDetereministic<LETTER, STATE>(automataLibraryServices, iTreeAutomatonBU).getResult() != false ? iTreeAutomatonBU : this.computeDeterminize();
    }

    private STATE reduceState(Set<STATE> set) {
        if (!this.mReducedStates.containsKey(set)) {
            this.mReducedStates.put(set, this.mStateFactoryMerge.merge(set));
        }
        return this.mReducedStates.get(set);
    }

    @Override
    public String startMessage() {
        return "Starting determinization";
    }

    @Override
    public String exitMessage() {
        return "Exiting determinization";
    }

    private TreeAutomatonBU<LETTER, STATE> constructFromRules(Map<LETTER, Map<List<Set<STATE>>, Set<STATE>>> map) {
        TreeAutomatonBU treeAutomatonBU = new TreeAutomatonBU();
        treeAutomatonBU.extendAlphabet(this.mTreeAutomaton.getAlphabet());
        for (Map.Entry<LETTER, Map<List<Set<STATE>>, Set<STATE>>> entry : map.entrySet()) {
            IRankedLetter iRankedLetter = (IRankedLetter)entry.getKey();
            Map<List<Set<STATE>>, Set<STATE>> map2 = map.get(iRankedLetter);
            for (Map.Entry<List<Set<STATE>>, Set<STATE>> entry2 : map2.entrySet()) {
                Iterator<STATE> iterator2;
                STATE STATE;
                Set<STATE> set2;
                List<Set<STATE>> list = entry2.getKey();
                ArrayList<STATE> arrayList = new ArrayList<STATE>();
                for (Set<STATE> set2 : list) {
                    STATE = this.reduceState(set2);
                    arrayList.add(STATE);
                    for (Iterator<STATE> iterator2 : set2) {
                        if (!this.mTreeAutomaton.isFinalState(iterator2)) continue;
                        treeAutomatonBU.addFinalState(STATE);
                    }
                }
                set2 = entry2.getValue();
                Iterator<Set<STATE>> iterator3 = this.reduceState(set2);
                treeAutomatonBU.addRule(new TreeAutomatonRule<IRankedLetter, Iterator<Set<STATE>>>(iRankedLetter, arrayList, iterator3));
                iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    STATE = iterator2.next();
                    if (!this.mTreeAutomaton.isFinalState(STATE)) continue;
                    treeAutomatonBU.addFinalState(iterator3);
                }
            }
        }
        return treeAutomatonBU;
    }

    private Map<LETTER, Map<List<Set<STATE>>, Set<STATE>>> transformToSingletonSets() {
        HashMap<STATE, Object> hashMap = new HashMap<STATE, Object>();
        HashMap hashMap2 = new HashMap();
        for (List<STATE> list : this.mTreeAutomaton.getSourceCombinations()) {
            for (TreeAutomatonRule<List<STATE>, STATE> treeAutomatonRule : this.mTreeAutomaton.getSuccessors(list)) {
                STATE STATE2;
                if (!hashMap2.containsKey(treeAutomatonRule.getLetter())) {
                    hashMap2.put(treeAutomatonRule.getLetter(), new HashMap());
                }
                Map map = (Map)hashMap2.get(treeAutomatonRule.getLetter());
                ArrayList<Set> arrayList = new ArrayList<Set>();
                for (STATE STATE2 : treeAutomatonRule.getSource()) {
                    if (!hashMap.containsKey(STATE2)) {
                        HashSet<STATE> hashSet = new HashSet<STATE>();
                        hashSet.add(STATE2);
                        hashMap.put(STATE2, hashSet);
                    }
                    arrayList.add((Set)hashMap.get(STATE2));
                }
                STATE2 = treeAutomatonRule.getDest();
                if (!hashMap.containsKey(STATE2)) {
                    HashSet hashSet = new HashSet();
                    hashSet.add(STATE2);
                    hashMap.put(STATE2, hashSet);
                }
                if (!map.containsKey(arrayList)) {
                    map.put(arrayList, new HashSet());
                }
                ((Set)map.get(arrayList)).add(STATE2);
            }
        }
        return hashMap2;
    }

    private void addAllSubsetStates(Set<STATE> set, Map<LETTER, Map<List<Set<STATE>>, Set<Set<STATE>>>> map, LETTER LETTER, ArrayList<Set<STATE>> arrayList, Set<STATE> set2, int n) {
        if (n >= arrayList.size()) {
            assert (arrayList.size() == LETTER.getRank());
            if (!map.get(LETTER).containsKey(arrayList)) {
                map.get(LETTER).put(arrayList, new HashSet());
            }
            map.get(LETTER).get(arrayList).add(set2);
            return;
        }
        if (set.containsAll((Collection)arrayList.get(n))) {
            ArrayList arrayList2 = (ArrayList)arrayList.clone();
            arrayList2.set(n, set);
            this.addAllSubsetStates(set, map, LETTER, arrayList2, set2, n + 1);
        }
        this.addAllSubsetStates(set, map, LETTER, arrayList, set2, n + 1);
    }

    private List<Set<STATE>> determinizeOneStep(Set<STATE> set, Map<LETTER, Map<List<Set<STATE>>, Set<STATE>>> map) {
        Collection collection;
        Object object;
        Map.Entry<LETTER, Map<List<Set<STATE>>, Set<STATE>>> entry2;
        HashMap hashMap = new HashMap();
        for (Map.Entry<LETTER, Map<List<Set<STATE>>, Set<STATE>>> entry2 : map.entrySet()) {
            IRankedLetter iRankedLetter = (IRankedLetter)entry2.getKey();
            if (!hashMap.containsKey(iRankedLetter)) {
                hashMap.put(iRankedLetter, new HashMap());
            }
            object = (Map)entry2.getValue();
            for (Map.Entry entry3 : object.entrySet()) {
                ArrayList arrayList = (ArrayList)entry3.getKey();
                collection = (Set)entry3.getValue();
                this.addAllSubsetStates(set, hashMap, (LETTER)iRankedLetter, arrayList, (Set<STATE>)collection, 0);
            }
        }
        entry2 = new ArrayList();
        for (Map.Entry entry4 : hashMap.entrySet()) {
            object = (IRankedLetter)entry4.getKey();
            Map map2 = (Map)hashMap.get(object);
            for (Map.Entry entry5 : map2.entrySet()) {
                collection = (List)entry5.getKey();
                Set set2 = (Set)map2.get(collection);
                HashSet hashSet = new HashSet();
                for (Set set3 : set2) {
                    hashSet.addAll(set3);
                }
                map.get(object).put((List<Set<STATE>>)collection, hashSet);
                if (((Set)map2.get(collection)).size() <= 1) continue;
                entry2.add(hashSet);
            }
        }
        return entry2;
    }

    private ITreeAutomatonBU<LETTER, STATE> computeDeterminize() {
        Map<LETTER, Map<List<Set<STATE>>, Set<STATE>>> map = this.transformToSingletonSets();
        LinkedList<Set<STATE>> linkedList = new LinkedList<Set<STATE>>();
        for (Map.Entry<LETTER, Map<List<Set<STATE>>, Set<STATE>>> object2 : map.entrySet()) {
            Map<List<Set<STATE>>, Set<STATE>> map2 = object2.getValue();
            for (Map.Entry<List<Set<STATE>>, Set<STATE>> entry : map2.entrySet()) {
                if (entry.getValue().size() <= 1) continue;
                linkedList.add(entry.getValue());
            }
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        while (!linkedList.isEmpty()) {
            Set set = (Set)linkedList.poll();
            if (hashSet.contains(set)) continue;
            hashSet.add(set);
            linkedList.addAll(this.determinizeOneStep(set, map));
        }
        return this.constructFromRules(map);
    }

    @Override
    public ITreeAutomatonBU<LETTER, STATE> getResult() {
        assert (new isDetereministic<LETTER, STATE>(this.mServices, this.mResult).getResult().booleanValue());
        return this.mResult;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }
}

