/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.LogicSimplifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.IProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofConstants;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.bitvector.BvToIntUtils;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.bitvector.BvUtils;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.Polynomial;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.TermUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnifyHash;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TermCompiler
extends TermTransformer {
    private Map<Term, Set<String>> mNames;
    UnifyHash<Term> mCanonicalPolys = new UnifyHash();
    private IProofTracker mTracker;
    private LogicSimplifier mUtils;
    private final boolean mDealWithBvToNatAndNatToBvInPreprocessing = true;

    public void setProofTracker(IProofTracker iProofTracker) {
        this.mTracker = iProofTracker;
        this.mUtils = new LogicSimplifier(iProofTracker);
    }

    public void setAssignmentProduction(boolean bl) {
        this.mNames = bl ? new HashMap<Term, Set<String>>() : null;
    }

    public Map<Term, Set<String>> getNames() {
        return this.mNames;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public void convert(Term var1_1) {
        block24: {
            block21: {
                block23: {
                    block22: {
                        if (var1_1.getSort().isInternal()) {
                            var2_2 = var1_1.getSort().getName();
                            tmp = -1;
                            switch (var2_2.hashCode()) {
                                case 73679: {
                                    if (!var2_2.equals("Int")) break;
                                    tmp = 1;
                                    break;
                                }
                                case 2076426: {
                                    if (!var2_2.equals("Bool")) break;
                                    tmp = 1;
                                    break;
                                }
                                case 2543038: {
                                    if (!var2_2.equals("Real")) break;
                                    tmp = 1;
                                    break;
                                }
                                case 63537721: {
                                    if (!var2_2.equals("Array")) break;
                                    tmp = 1;
                                    break;
                                }
                                case 1990035303: {
                                    if (!var2_2.equals("BitVec")) break;
                                    tmp = 1;
                                    break;
                                }
                            }
                            switch (tmp) {
                                default: {
                                    throw new UnsupportedOperationException("Unsupported internal sort: " + String.valueOf(var1_1.getSort()));
                                }
                                case 1: 
                            }
                        }
                        if (!(var1_1 instanceof ApplicationTerm)) break block21;
                        var2_2 = (ApplicationTerm)var1_1;
                        var3_3 = var2_2.getFunction();
                        var4_5 = var2_2.getParameters();
                        if (!var3_3.isLeftAssoc() || var4_5.length <= 2) break block22;
                        var5_7 = var2_2.getTheory();
                        var6_10 = var3_3.getName();
                        if (var6_10 == "and" || var6_10 == "or" || var6_10 == "+" || var6_10 == "-" || var6_10 == "*") {
                            this.enqueueWalker((NonRecursive.Walker)new TermTransformer.BuildApplicationTerm((ApplicationTerm)var2_2));
                            this.pushTerms(var4_5);
                            return;
                        }
                        var7_13 = var4_5[0];
                        var8_18 = 1;
                        if (true) ** GOTO lbl80
                    }
                    if (!var3_3.isRightAssoc() || var4_5.length <= 2) break block23;
                    var5_8 = var2_2.getTheory();
                    if (var3_3 == var5_8.mImplies) {
                        this.enqueueWalker((NonRecursive.Walker)new TermTransformer.BuildApplicationTerm((ApplicationTerm)var2_2));
                        this.pushTerms(var4_5);
                        return;
                    }
                    var6_11 = var4_5[var4_5.length - 1];
                    var7_14 = var4_5.length - 2;
                    if (true) ** GOTO lbl96
                }
                if (!var3_3.isChainable() || var4_5.length <= 2 || var3_3.getName().equals("=")) break block24;
                var5_9 = var2_2.getTheory();
                var6_12 = new Term[var4_5.length - 1];
                var7_16 = 0;
                if (true) ** GOTO lbl111
            }
            if (var1_1 instanceof ConstantTerm && var1_1.getSort().isNumericSort()) {
                var2_2 = SMTAffineTerm.convertConstant((ConstantTerm)var1_1).toTerm(var1_1.getSort());
                this.setResult(this.mTracker.buildRewrite(var1_1, (Term)var2_2, ProofConstants.RW_CANONICAL_SUM));
                return;
            }
            if (var1_1 instanceof ConstantTerm && var1_1.getSort().isBitVecSort()) {
                var2_2 = var1_1.getTheory();
                var3_4 = new BvUtils((Theory)var2_2, this.mUtils);
                var4_6 = new BvToIntUtils((Theory)var2_2, this.mUtils, var3_4, this.mTracker, true);
                this.setResult(this.mTracker.buildRewrite(var1_1, var4_6.translateBvConstantTerm((ConstantTerm)var1_1), ProofConstants.RW_BVEVAL));
                return;
            }
            if (var1_1 instanceof TermVariable) {
                this.setResult(this.mTracker.reflexivity(var1_1));
                return;
            }
        }
        super.convert(var1_1);
        return;
        do {
            var7_13 = var5_7.term(var3_3, new Term[]{var7_13, var4_5[var8_18]});
            ++var8_18;
lbl80:
            // 2 sources

        } while (var8_18 < var4_5.length);
        var8_19 = this.mTracker.buildRewrite((Term)var2_2, var7_13, ProofConstants.RW_EXPAND);
        this.enqueueWalker(new TransitivityStep(var8_19));
        var9_22 = var4_5.length - 1;
        while (var9_22 > 0) {
            var10_24 = (ApplicationTerm)var7_13;
            this.enqueueWalker((NonRecursive.Walker)new TermTransformer.BuildApplicationTerm(var10_24));
            this.pushTerm(var10_24.getParameters()[1]);
            var7_13 = var10_24.getParameters()[0];
            --var9_22;
        }
        this.pushTerm(var4_5[0]);
        return;
        do {
            var6_11 = var5_8.term(var3_3, new Term[]{var4_5[var7_14], var6_11});
            --var7_14;
lbl96:
            // 2 sources

        } while (var7_14 >= 0);
        var7_15 = this.mTracker.buildRewrite((Term)var2_2, var6_11, ProofConstants.RW_EXPAND);
        this.enqueueWalker(new TransitivityStep(var7_15));
        var8_20 = var4_5.length - 1;
        while (var8_20 > 0) {
            var9_23 = (ApplicationTerm)var6_11;
            this.enqueueWalker((NonRecursive.Walker)new TermTransformer.BuildApplicationTerm(var9_23));
            var6_11 = var9_23.getParameters()[1];
            --var8_20;
        }
        this.pushTerms(var4_5);
        return;
        do {
            var6_12[var7_16] = var5_9.term(var3_3, new Term[]{var4_5[var7_16], var4_5[var7_16 + 1]});
            ++var7_16;
lbl111:
            // 2 sources

        } while (var7_16 < var4_5.length - 1);
        var7_17 = var5_9.term("and", var6_12);
        var8_21 = this.mTracker.buildRewrite((Term)var2_2, var7_17, ProofConstants.RW_EXPAND);
        this.enqueueWalker(new TransitivityStep(var8_21));
        this.enqueueWalker((NonRecursive.Walker)new TermTransformer.BuildApplicationTerm((ApplicationTerm)var7_17));
        this.pushTerms(var6_12);
    }

    private void repush(Term term) {
        this.enqueueWalker(new TransitivityStep(term));
        this.pushTerm(this.mTracker.getProvedTerm(term));
    }

    public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
        Term term;
        block239: {
            FunctionSymbol functionSymbol = applicationTerm.getFunction();
            Theory theory = applicationTerm.getTheory();
            BvUtils bvUtils = new BvUtils(theory, this.mUtils);
            BvToIntUtils bvToIntUtils = new BvToIntUtils(theory, this.mUtils, bvUtils, this.mTracker, true);
            term = this.mTracker.congruence(this.mTracker.reflexivity((Term)applicationTerm), termArray);
            if (this.mTracker.getProvedTerm(term) instanceof ConstantTerm) {
                this.setResult(term);
                return;
            }
            Term[] termArray2 = ((ApplicationTerm)this.mTracker.getProvedTerm(term)).getParameters();
            if (functionSymbol.getDefinition() != null && !functionSymbol.getName().startsWith("@skolem.") && !functionSymbol.getName().startsWith("@AUX")) {
                HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
                int n = 0;
                while (n < termArray2.length) {
                    hashMap.put(functionSymbol.getDefinitionVars()[n], termArray2[n]);
                    ++n;
                }
                FormulaUnLet formulaUnLet = new FormulaUnLet();
                formulaUnLet.addSubstitutions(hashMap);
                Term term2 = formulaUnLet.unlet(functionSymbol.getDefinition());
                Term term3 = this.mTracker.buildRewrite(this.mTracker.getProvedTerm(term), term2, ProofConstants.RW_EXPAND_DEF);
                this.repush(this.mTracker.transitivity(term, term3));
                return;
            }
            if (!functionSymbol.isIntern()) break block239;
            switch (functionSymbol.getName()) {
                case "not": {
                    this.setResult(this.mUtils.convertNot(term));
                    return;
                }
                case "and": {
                    this.setResult(this.mUtils.convertAnd(term));
                    return;
                }
                case "or": {
                    this.setResult(this.mUtils.convertOr(term));
                    return;
                }
                case "xor": {
                    this.setResult(this.mUtils.convertXor(term));
                    return;
                }
                case "=>": {
                    this.setResult(this.mUtils.convertImplies(term));
                    return;
                }
                case "ite": {
                    this.setResult(this.mUtils.convertIte(term));
                    return;
                }
                case "=": {
                    this.setResult(this.mUtils.convertEq(term));
                    return;
                }
                case "distinct": {
                    this.setResult(this.mUtils.convertDistinct(term));
                    return;
                }
                case "<=": {
                    Term term4 = this.mTracker.getProvedTerm(term);
                    Sort sort = termArray2[0].getSort();
                    Polynomial polynomial = new Polynomial(termArray2[0]);
                    polynomial.add(Rational.MONE, termArray2[1]);
                    Term term5 = theory.term("<=", new Term[]{this.unifyPolynomial(polynomial, sort), Rational.ZERO.toTerm(sort)});
                    Term term6 = this.mTracker.buildRewrite(term4, term5, ProofConstants.RW_LEQ_TO_LEQ0);
                    this.setResult(this.mUtils.convertLeq0(this.mTracker.transitivity(term, term6)));
                    return;
                }
                case ">=": {
                    Term term7 = this.mTracker.getProvedTerm(term);
                    Sort sort = termArray2[0].getSort();
                    Polynomial polynomial = new Polynomial(termArray2[1]);
                    polynomial.add(Rational.MONE, termArray2[0]);
                    Term term8 = theory.term("<=", new Term[]{this.unifyPolynomial(polynomial, sort), Rational.ZERO.toTerm(sort)});
                    Term term9 = this.mTracker.buildRewrite(term7, term8, ProofConstants.RW_GEQ_TO_LEQ0);
                    this.setResult(this.mUtils.convertLeq0(this.mTracker.transitivity(term, term9)));
                    return;
                }
                case ">": {
                    Term term10 = this.mTracker.getProvedTerm(term);
                    Sort sort = termArray2[0].getSort();
                    Polynomial polynomial = new Polynomial(termArray2[0]);
                    polynomial.add(Rational.MONE, termArray2[1]);
                    Term term11 = theory.term("<=", new Term[]{this.unifyPolynomial(polynomial, sort), Rational.ZERO.toTerm(sort)});
                    Term term12 = theory.term("not", new Term[]{term11});
                    Term term13 = this.mTracker.buildRewrite(term10, term12, ProofConstants.RW_GT_TO_LEQ0);
                    Term term14 = this.mUtils.convertLeq0(this.mTracker.reflexivity(term11));
                    term13 = this.mTracker.congruence(this.mTracker.transitivity(term, term13), new Term[]{term14});
                    this.setResult(this.mUtils.convertNot(term13));
                    return;
                }
                case "<": {
                    Term term15 = this.mTracker.getProvedTerm(term);
                    Sort sort = termArray2[0].getSort();
                    Polynomial polynomial = new Polynomial(termArray2[1]);
                    polynomial.add(Rational.MONE, termArray2[0]);
                    Term term16 = theory.term("<=", new Term[]{this.unifyPolynomial(polynomial, sort), Rational.ZERO.toTerm(sort)});
                    Term term17 = theory.term("not", new Term[]{term16});
                    Term term18 = this.mTracker.buildRewrite(term15, term17, ProofConstants.RW_LT_TO_LEQ0);
                    Term term19 = this.mUtils.convertLeq0(this.mTracker.reflexivity(term16));
                    term18 = this.mTracker.congruence(this.mTracker.transitivity(term, term18), new Term[]{term19});
                    this.setResult(this.mUtils.convertNot(term18));
                    return;
                }
                case "+": {
                    Term term20 = this.mTracker.getProvedTerm(term);
                    Polynomial polynomial = new Polynomial(termArray2[0]);
                    int n = 1;
                    while (n < termArray2.length) {
                        polynomial.add(Rational.ONE, new Polynomial(termArray2[n]));
                        ++n;
                    }
                    Term term21 = this.unifyPolynomial(polynomial, term.getSort());
                    Term term22 = this.mTracker.buildRewrite(term20, term21, ProofConstants.RW_CANONICAL_SUM);
                    this.setResult(this.mTracker.transitivity(term, term22));
                    return;
                }
                case "-": {
                    Term term23 = this.mTracker.getProvedTerm(term);
                    Polynomial polynomial = new Polynomial(termArray2[0]);
                    if (termArray2.length == 1) {
                        polynomial.mul(Rational.MONE);
                    } else {
                        int n = 1;
                        while (n < termArray2.length) {
                            polynomial.add(Rational.MONE, termArray2[n]);
                            ++n;
                        }
                    }
                    Term term24 = this.unifyPolynomial(polynomial, term.getSort());
                    Term term25 = this.mTracker.buildRewrite(term23, term24, ProofConstants.RW_CANONICAL_SUM);
                    this.setResult(this.mTracker.transitivity(term, term25));
                    return;
                }
                case "*": {
                    Term term26 = this.mTracker.getProvedTerm(term);
                    Polynomial polynomial = new Polynomial(termArray2[0]);
                    int n = 1;
                    while (n < termArray2.length) {
                        polynomial.mul(new Polynomial(termArray2[n]));
                        ++n;
                    }
                    Term term27 = this.unifyPolynomial(polynomial, term.getSort());
                    Term term28 = this.mTracker.buildRewrite(term26, term27, ProofConstants.RW_CANONICAL_SUM);
                    this.setResult(this.mTracker.transitivity(term, term28));
                    return;
                }
                case "/": {
                    Term term29 = this.mTracker.getProvedTerm(term);
                    Polynomial polynomial = new Polynomial(termArray2[0]);
                    if (termArray2[1] instanceof ConstantTerm) {
                        Rational rational = SMTAffineTerm.convertConstant((ConstantTerm)termArray2[1]);
                        if (rational.equals((Object)Rational.ZERO)) {
                            this.setResult(term);
                        } else {
                            polynomial.mul(rational.inverse());
                            Term term30 = this.unifyPolynomial(polynomial, term.getSort());
                            Term term31 = this.mTracker.buildRewrite(term29, term30, ProofConstants.RW_CANONICAL_SUM);
                            this.setResult(this.mTracker.transitivity(term, term31));
                        }
                        return;
                    }
                    this.setResult(term);
                    return;
                }
                case "div": {
                    Term term32 = this.mTracker.getProvedTerm(term);
                    Polynomial polynomial = new Polynomial(termArray2[0]);
                    if (termArray2[1] instanceof ConstantTerm) {
                        Rational rational = (Rational)((ConstantTerm)termArray2[1]).getValue();
                        assert (rational.isIntegral());
                        if (rational.equals((Object)Rational.ONE)) {
                            Term term33 = this.unifyPolynomial(polynomial, term.getSort());
                            Term term34 = this.mTracker.buildRewrite(term32, term33, ProofConstants.RW_DIV_ONE);
                            this.setResult(this.mTracker.transitivity(term, term34));
                        } else if (rational.equals((Object)Rational.MONE)) {
                            polynomial.mul(Rational.MONE);
                            Term term35 = this.unifyPolynomial(polynomial, term.getSort());
                            Term term36 = this.mTracker.buildRewrite(term32, term35, ProofConstants.RW_DIV_MONE);
                            this.setResult(this.mTracker.transitivity(term, term36));
                        } else if (polynomial.isConstant() && !rational.equals((Object)Rational.ZERO)) {
                            Rational rational2 = TermCompiler.constDiv(polynomial.getConstant(), rational);
                            Term term37 = rational2.toTerm(term.getSort());
                            Term term38 = this.mTracker.buildRewrite(term32, term37, ProofConstants.RW_DIV_CONST);
                            this.setResult(this.mTracker.transitivity(term, term38));
                        } else if (TermUtils.isApplication("div", termArray2[0]) && !rational.equals((Object)Rational.ZERO)) {
                            Term[] termArray3 = ((ApplicationTerm)termArray2[0]).getParameters();
                            assert (termArray3.length == 2);
                            if (termArray3[1] instanceof ConstantTerm && ((Rational)((ConstantTerm)termArray3[1]).getValue()).signum() > 0) {
                                Rational rational3 = (Rational)((ConstantTerm)termArray3[1]).getValue();
                                Term term39 = theory.term("div", new Term[]{termArray3[0], rational.mul(rational3).toTerm(termArray2[1].getSort())});
                                Term term40 = this.mTracker.buildRewrite(term32, term39, ProofConstants.RW_DIV_DIV);
                                this.setResult(this.mTracker.transitivity(term, term40));
                            } else {
                                this.setResult(term);
                            }
                        } else {
                            this.setResult(term);
                        }
                        return;
                    }
                    this.setResult(term);
                    return;
                }
                case "mod": {
                    Term term41 = this.mTracker.getProvedTerm(term);
                    Polynomial polynomial = new Polynomial(termArray2[0]);
                    if (termArray2[1] instanceof ConstantTerm) {
                        Rational rational = (Rational)((ConstantTerm)termArray2[1]).getValue();
                        assert (rational.isIntegral());
                        if (rational.equals((Object)Rational.ZERO)) {
                            this.setResult(term);
                        } else if (rational.equals((Object)Rational.ONE)) {
                            Term term42 = Rational.ZERO.toTerm(term.getSort());
                            Term term43 = this.mTracker.buildRewrite(term41, term42, ProofConstants.RW_MODULO_ONE);
                            this.setResult(this.mTracker.transitivity(term, term43));
                        } else if (rational.equals((Object)Rational.MONE)) {
                            Term term44 = Rational.ZERO.toTerm(term.getSort());
                            Term term45 = this.mTracker.buildRewrite(term41, term44, ProofConstants.RW_MODULO_MONE);
                            this.setResult(this.mTracker.transitivity(term, term45));
                        } else if (polynomial.isConstant()) {
                            Rational rational4 = polynomial.getConstant();
                            Rational rational5 = rational4.sub(TermCompiler.constDiv(rational4, rational).mul(rational));
                            Term term46 = rational5.toTerm(term.getSort());
                            Term term47 = this.mTracker.buildRewrite(term41, term46, ProofConstants.RW_MODULO_CONST);
                            this.setResult(this.mTracker.transitivity(term, term47));
                        } else {
                            Term term48 = theory.term("div", new Term[]{termArray2[0], termArray2[1]});
                            polynomial.add(rational.negate(), term48);
                            Term term49 = this.unifyPolynomial(polynomial, termArray2[1].getSort());
                            Term term50 = this.mTracker.buildRewrite(term41, term49, ProofConstants.RW_MODULO);
                            this.setResult(this.mTracker.transitivity(term, term50));
                        }
                        return;
                    }
                    this.setResult(term);
                    return;
                }
                case "to_real": {
                    Polynomial polynomial = new Polynomial(termArray2[0]);
                    Term term51 = this.mTracker.getProvedTerm(term);
                    Term term52 = this.unifyPolynomial(polynomial, term.getSort());
                    Term term53 = this.mTracker.buildRewrite(term51, term52, ProofConstants.RW_CANONICAL_SUM);
                    this.setResult(this.mTracker.transitivity(term, term53));
                    return;
                }
                case "to_int": {
                    if (!(termArray2[0] instanceof ConstantTerm)) break;
                    Rational rational = (Rational)((ConstantTerm)termArray2[0]).getValue();
                    Term term54 = this.mTracker.getProvedTerm(term);
                    Term term55 = rational.floor().toTerm(functionSymbol.getReturnSort());
                    Term term56 = this.mTracker.buildRewrite(term54, term55, ProofConstants.RW_TO_INT);
                    this.setResult(this.mTracker.transitivity(term, term56));
                    return;
                }
                case "divisible": {
                    Term term57;
                    ApplicationTerm applicationTerm2;
                    BigInteger bigInteger;
                    Term term58 = this.mTracker.getProvedTerm(term);
                    try {
                        bigInteger = new BigInteger(functionSymbol.getIndices()[0]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SMTLIBException("index must be numeral", (Throwable)numberFormatException);
                    }
                    Rational rational = Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE);
                    if (rational.equals((Object)Rational.ONE)) {
                        applicationTerm2 = theory.mTrue;
                    } else if (termArray2[0] instanceof ConstantTerm) {
                        term57 = (Rational)((ConstantTerm)termArray2[0]).getValue();
                        applicationTerm2 = term57.equals((Object)rational.mul(TermCompiler.constDiv((Rational)term57, rational))) ? theory.mTrue : theory.mFalse;
                    } else {
                        term57 = rational.toTerm(termArray2[0].getSort());
                        applicationTerm2 = theory.term("=", new Term[]{termArray2[0], theory.term("*", new Term[]{term57, theory.term("div", new Term[]{termArray2[0], term57})})});
                    }
                    term57 = this.mTracker.buildRewrite(term58, (Term)applicationTerm2, ProofConstants.RW_DIVISIBLE);
                    this.setResult(this.mTracker.transitivity(term, term57));
                    return;
                }
                case "store": {
                    Term term59 = this.mTracker.getProvedTerm(term);
                    Term term60 = termArray2[0];
                    Term term61 = termArray2[1];
                    Term term62 = TermCompiler.getArrayStoreIdx(term60);
                    if (term62 == null) break;
                    Polynomial polynomial = new Polynomial(term61);
                    polynomial.add(Rational.MONE, term62);
                    if (!polynomial.isConstant() || !polynomial.getConstant().equals((Object)Rational.ZERO)) break;
                    ApplicationTerm applicationTerm3 = (ApplicationTerm)term60;
                    Term term63 = theory.term("store", new Term[]{applicationTerm3.getParameters()[0], termArray2[1], termArray2[2]});
                    Term term64 = this.mTracker.buildRewrite(term59, term63, ProofConstants.RW_STORE_OVER_STORE);
                    this.setResult(this.mTracker.transitivity(term, term64));
                    return;
                }
                case "select": {
                    Term term65 = this.mTracker.getProvedTerm(term);
                    Term term66 = termArray2[0];
                    Term term67 = termArray2[1];
                    boolean bl = true;
                    while (bl) {
                        Term term68;
                        bl = false;
                        Term term69 = TermCompiler.getArrayStoreIdx(term66);
                        if (term69 == null) continue;
                        Polynomial polynomial = new Polynomial(term67);
                        polynomial.add(Rational.MONE, new Polynomial(term69));
                        if (!polynomial.isConstant()) continue;
                        ApplicationTerm applicationTerm4 = (ApplicationTerm)term66;
                        if (polynomial.getConstant().equals((Object)Rational.ZERO)) {
                            term68 = applicationTerm4.getParameters()[2];
                        } else {
                            bl = true;
                            term66 = applicationTerm4.getParameters()[0];
                            term68 = theory.term("select", new Term[]{term66, term67});
                        }
                        Term term70 = this.mTracker.buildRewrite(term65, term68, ProofConstants.RW_SELECT_OVER_STORE);
                        term65 = term68;
                        term = this.mTracker.transitivity(term, term70);
                    }
                    break;
                }
                case "const": {
                    Sort sort = this.mTracker.getProvedTerm(term).getSort();
                    assert (sort.isArraySort());
                    if (this.isInfinite(sort.getArguments()[0])) break;
                    throw new SMTLIBException("Const is only supported for infinite index sort");
                }
                case "bvmul": {
                    this.repush(bvToIntUtils.translateBvArithmetic(this.mTracker, applicationTerm.getFunction(), term));
                    return;
                }
                case "bvadd": 
                case "bvsub": {
                    this.repush(bvToIntUtils.translateBvArithmetic(this.mTracker, applicationTerm.getFunction(), term));
                    return;
                }
                case "bvneg": {
                    this.repush(bvToIntUtils.translateBvNeg(this.mTracker, applicationTerm.getFunction(), term));
                    return;
                }
                case "bvnot": {
                    this.repush(bvToIntUtils.translateBvNot(this.mTracker, applicationTerm.getFunction(), term));
                    return;
                }
                case "concat": {
                    this.repush(bvToIntUtils.translateConcat(this.mTracker, applicationTerm.getFunction(), term));
                    return;
                }
                case "bvudiv": {
                    this.repush(bvToIntUtils.translateBvudiv(this.mTracker, applicationTerm.getFunction(), term));
                    return;
                }
                case "bvurem": {
                    this.repush(bvToIntUtils.translateBvurem(this.mTracker, applicationTerm.getFunction(), term));
                    return;
                }
                case "bvlshr": {
                    this.repush(bvToIntUtils.translateBvlshr(this.mTracker, applicationTerm.getFunction(), term));
                    return;
                }
                case "bvshl": {
                    this.repush(bvToIntUtils.translateBvshl(this.mTracker, applicationTerm.getFunction(), term));
                    return;
                }
                case "bvand": {
                    this.repush(bvToIntUtils.translateBvandSum(this.mTracker, applicationTerm.getFunction(), term));
                    return;
                }
                case "bvor": {
                    this.repush(bvToIntUtils.translateBvor(this.mTracker, applicationTerm.getFunction(), term));
                    return;
                }
                case "bvxor": {
                    this.repush(bvToIntUtils.translateBvxor(this.mTracker, applicationTerm.getFunction(), term));
                    return;
                }
                case "bvsge": 
                case "bvsgt": 
                case "bvsle": 
                case "bvslt": 
                case "bvuge": 
                case "bvugt": 
                case "bvule": 
                case "bvult": {
                    this.repush(bvToIntUtils.translateRelations(this.mTracker, applicationTerm.getFunction(), term));
                    return;
                }
                case "extract": {
                    this.repush(bvToIntUtils.translateExtract(this.mTracker, applicationTerm.getFunction(), term));
                    return;
                }
                case "repeat": {
                    Term term71 = bvUtils.transformRepeat(termArray2, functionSymbol, term);
                    Term term72 = this.mTracker.buildRewrite(this.mTracker.getProvedTerm(term), term71, ProofConstants.RW_BV_EXPAND_DEF);
                    this.repush(this.mTracker.transitivity(term, term72));
                    return;
                }
                case "sign_extend": 
                case "zero_extend": {
                    this.repush(bvToIntUtils.translateExtend(this.mTracker, applicationTerm.getFunction(), term));
                    return;
                }
                case "rotate_left": {
                    Term term73 = bvUtils.transformRotateleft(termArray2, functionSymbol, term);
                    Term term74 = this.mTracker.buildRewrite(this.mTracker.getProvedTerm(term), term73, ProofConstants.RW_BVBLAST);
                    this.repush(this.mTracker.transitivity(term, term74));
                    return;
                }
                case "rotate_right": {
                    Term term75 = bvUtils.transformRotateright(termArray2, functionSymbol, term);
                    Term term76 = this.mTracker.buildRewrite(this.mTracker.getProvedTerm(term), term75, ProofConstants.RW_BVBLAST);
                    this.repush(this.mTracker.transitivity(term, term76));
                    return;
                }
                case "bvnand": {
                    Term term77 = theory.term("bvnot", new Term[]{theory.term("bvand", termArray2)});
                    Term term78 = this.mTracker.buildRewrite(this.mTracker.getProvedTerm(term), term77, ProofConstants.RW_BVBLAST);
                    this.repush(this.mTracker.transitivity(term, term78));
                    return;
                }
                case "bvnor": {
                    Term term79 = theory.term("bvnot", new Term[]{theory.term("bvor", termArray2)});
                    Term term80 = this.mTracker.buildRewrite(this.mTracker.getProvedTerm(term), term79, ProofConstants.RW_BVBLAST);
                    this.repush(this.mTracker.transitivity(term, term80));
                    return;
                }
                case "bvxnor": {
                    assert (termArray2.length == 2);
                    Term term81 = bvUtils.transformBvxnor(termArray2);
                    Term term82 = this.mTracker.buildRewrite(this.mTracker.getProvedTerm(term), term81, ProofConstants.RW_BVBLAST);
                    this.repush(this.mTracker.transitivity(term, term82));
                    return;
                }
                case "bvcomp": {
                    Term term83 = bvUtils.transformBvcomp(termArray2);
                    Term term84 = this.mTracker.buildRewrite(this.mTracker.getProvedTerm(term), term83, ProofConstants.RW_BV_EXPAND_DEF);
                    this.repush(this.mTracker.transitivity(term, term84));
                    return;
                }
                case "bvsdiv": {
                    Term term85 = bvUtils.transformBvsdiv(termArray2);
                    Term term86 = this.mTracker.buildRewrite(this.mTracker.getProvedTerm(term), term85, ProofConstants.RW_BV_EXPAND_DEF);
                    this.repush(this.mTracker.transitivity(term, term86));
                    return;
                }
                case "bvsrem": {
                    Term term87 = bvUtils.transformBvsrem(termArray2);
                    Term term88 = this.mTracker.buildRewrite(this.mTracker.getProvedTerm(term), term87, ProofConstants.RW_BV_EXPAND_DEF);
                    this.repush(this.mTracker.transitivity(term, term88));
                    return;
                }
                case "bvsmod": {
                    Term term89 = bvUtils.transformBvsmod(termArray2);
                    Term term90 = this.mTracker.buildRewrite(this.mTracker.getProvedTerm(term), term89, ProofConstants.RW_BV_EXPAND_DEF);
                    this.repush(this.mTracker.transitivity(term, term90));
                    return;
                }
                case "bvashr": {
                    Term term91 = bvUtils.transformBvashr(termArray2);
                    Term term92 = this.mTracker.buildRewrite(this.mTracker.getProvedTerm(term), term91, ProofConstants.RW_BV_EXPAND_DEF);
                    this.repush(this.mTracker.transitivity(term, term92));
                    return;
                }
                case "bv2nat": {
                    Term term93 = bvToIntUtils.bv2nat(termArray2[0], true);
                    if (term93 == this.mTracker.getProvedTerm(term)) {
                        this.setResult(term);
                    } else {
                        Term term94 = this.mTracker.buildRewrite(this.mTracker.getProvedTerm(term), term93, ProofConstants.RW_BV2NAT);
                        this.repush(this.mTracker.transitivity(term, term94));
                    }
                    return;
                }
                default: {
                    if (functionSymbol.isConstructor() || functionSymbol.isSelector() || functionSymbol.getName().startsWith("@AUX") || functionSymbol.getName().matches("@.*skolem.*")) break;
                    throw new UnsupportedOperationException("Unsupported internal function " + functionSymbol.getName());
                }
                case "intand": 
                case "nat2bv": 
                case "@0": 
                case "is": 
                case "@EQ": 
                case "true": 
                case "@diff": 
                case "false": 
            }
        }
        this.setResult(term);
    }

    private boolean isInfinite(Sort sort) {
        block12: {
            if (!sort.isInternal()) break block12;
            switch (sort.getName()) {
                case "Int": 
                case "Real": {
                    return true;
                }
                case "Array": {
                    Sort[] sortArray = sort.getArguments();
                    Sort sort2 = sortArray[0];
                    Sort sort3 = sortArray[1];
                    return sort3.isInternal() && this.isInfinite(sort2);
                }
            }
            return false;
        }
        return false;
    }

    public static final Rational constDiv(Rational rational, Rational rational2) {
        Rational rational3 = rational.div(rational2);
        return rational2.isNegative() ? rational3.ceil() : rational3.floor();
    }

    private static final Term getArrayStoreIdx(Term term) {
        ApplicationTerm applicationTerm;
        FunctionSymbol functionSymbol;
        if (term instanceof ApplicationTerm && (functionSymbol = (applicationTerm = (ApplicationTerm)term).getFunction()).isIntern() && functionSymbol.getName().equals("store")) {
            return applicationTerm.getParameters()[1];
        }
        return null;
    }

    public void postConvertMatch(MatchTerm matchTerm, Term term, Term[] termArray) {
        this.setResult(this.mTracker.match(matchTerm, term, termArray));
    }

    public void postConvertQuantifier(QuantifiedFormula quantifiedFormula, Term term) {
        Theory theory = quantifiedFormula.getTheory();
        if (!theory.getLogic().isQuantified()) {
            throw new SMTLIBException("Quantifier in quantifier-free logic");
        }
        this.setResult(this.mTracker.quantCong(quantifiedFormula, term));
    }

    public void postConvertAnnotation(AnnotatedTerm annotatedTerm, Annotation[] annotationArray, Term term) {
        if (this.mNames != null && term.getSort() == term.getTheory().getBooleanSort()) {
            Annotation[] annotationArray2;
            Annotation[] annotationArray3 = annotationArray2 = annotatedTerm.getAnnotations();
            int n = annotationArray2.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray3[n2];
                if (annotation.getKey().equals(":named")) {
                    Set<String> set = this.mNames.get(term);
                    if (set == null) {
                        set = new HashSet<String>();
                        this.mNames.put(term, set);
                    }
                    set.add(annotation.getValue().toString());
                }
                ++n2;
            }
        }
        this.setResult(this.mTracker.transitivity(this.mTracker.buildRewrite((Term)annotatedTerm, annotatedTerm.getSubterm(), ProofConstants.RW_STRIP), term));
    }

    public Term unifyPolynomial(Polynomial polynomial, Sort sort) {
        Term term2;
        int n = polynomial.hashCode() ^ sort.hashCode();
        for (Term term2 : this.mCanonicalPolys.iterateHashCode(n)) {
            if (term2.getSort() != sort || !polynomial.equals(new Polynomial(term2))) continue;
            return term2;
        }
        term2 = polynomial.toTerm(sort);
        this.mCanonicalPolys.put(n, (Object)term2);
        return term2;
    }

    static class TransitivityStep
    implements NonRecursive.Walker {
        final Term mFirst;

        public TransitivityStep(Term term) {
            this.mFirst = term;
        }

        public void walk(NonRecursive nonRecursive) {
            TermCompiler termCompiler = (TermCompiler)nonRecursive;
            Term term = termCompiler.getConverted();
            termCompiler.setResult(termCompiler.mTracker.transitivity(this.mFirst, term));
        }

        public String toString() {
            return "Transitivity[" + String.valueOf(this.mFirst) + "]";
        }
    }
}

