/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.output;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayStoreExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AtomicStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Axiom;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitVectorAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitvecLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BreakStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ConstDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.EnsuresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GotoStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.JoinStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Label;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LoopInvariantSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ModifiesSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ParentEdge;
import de.uni_freiburg.informatik.ultimate.boogie.ast.PrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.QuantifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RequiresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ReturnStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StringLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructConstructor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Trigger;
import de.uni_freiburg.informatik.ultimate.boogie.ast.TypeDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WildcardExpression;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import java.io.PrintWriter;

public class BoogieOutput {
    private static final String LINEBREAK = System.getProperty("line.separator");
    PrintWriter mWriter;

    public BoogieOutput(PrintWriter printWriter) {
        this.mWriter = printWriter;
    }

    public void printBoogieProgram(Unit unit) {
        Declaration[] declarationArray = unit.getDeclarations();
        int n = declarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Declaration declaration = declarationArray[n2];
            if (declaration instanceof TypeDeclaration) {
                this.printTypeDeclaration((TypeDeclaration)declaration);
            } else if (declaration instanceof ConstDeclaration) {
                this.printConstDeclaration((ConstDeclaration)declaration);
            } else if (declaration instanceof VariableDeclaration) {
                this.printVarDeclaration((VariableDeclaration)declaration, "");
            } else if (declaration instanceof FunctionDeclaration) {
                this.printFunctionDeclaration((FunctionDeclaration)declaration);
            } else if (declaration instanceof Axiom) {
                this.printAxiom((Axiom)declaration);
            } else if (declaration instanceof Procedure) {
                this.printProcedure((Procedure)declaration);
            }
            ++n2;
        }
    }

    private void appendExpression(StringBuilder stringBuilder, Expression expression, int n) {
        if (expression instanceof BinaryExpression) {
            int n2;
            int n3;
            String string;
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            int n4 = switch (binaryExpression.getOperator()) {
                case BinaryExpression.Operator.LOGICIFF -> {
                    string = " <==> ";
                    n3 = 0;
                    n2 = 1;
                    yield 0;
                }
                case BinaryExpression.Operator.LOGICIMPLIES -> {
                    string = " ==> ";
                    n3 = 1;
                    n2 = 2;
                    yield 1;
                }
                case BinaryExpression.Operator.LOGICOR -> {
                    string = " || ";
                    n3 = 3;
                    n2 = 5;
                    yield 3;
                }
                case BinaryExpression.Operator.LOGICAND -> {
                    if (n == 3) {
                        n = 5;
                    }
                    string = " && ";
                    n3 = 4;
                    n2 = 5;
                    yield 4;
                }
                case BinaryExpression.Operator.COMPEQ -> {
                    string = " == ";
                    n3 = 5;
                    n2 = 6;
                    yield 6;
                }
                case BinaryExpression.Operator.COMPNEQ -> {
                    string = " != ";
                    n3 = 5;
                    n2 = 6;
                    yield 6;
                }
                case BinaryExpression.Operator.COMPLT -> {
                    string = " < ";
                    n3 = 5;
                    n2 = 6;
                    yield 6;
                }
                case BinaryExpression.Operator.COMPLEQ -> {
                    string = " <= ";
                    n3 = 5;
                    n2 = 6;
                    yield 6;
                }
                case BinaryExpression.Operator.COMPGT -> {
                    string = " > ";
                    n3 = 5;
                    n2 = 6;
                    yield 6;
                }
                case BinaryExpression.Operator.COMPGEQ -> {
                    string = " >= ";
                    n3 = 5;
                    n2 = 6;
                    yield 6;
                }
                case BinaryExpression.Operator.COMPPO -> {
                    string = " <: ";
                    n3 = 5;
                    n2 = 6;
                    yield 6;
                }
                case BinaryExpression.Operator.BITVECCONCAT -> {
                    string = " ++ ";
                    n3 = 6;
                    n2 = 6;
                    yield 7;
                }
                case BinaryExpression.Operator.ARITHPLUS -> {
                    string = " + ";
                    n3 = 7;
                    n2 = 7;
                    yield 8;
                }
                case BinaryExpression.Operator.ARITHMINUS -> {
                    string = " - ";
                    n3 = 7;
                    n2 = 7;
                    yield 8;
                }
                case BinaryExpression.Operator.ARITHMUL -> {
                    string = " * ";
                    n3 = 8;
                    n2 = 8;
                    yield 9;
                }
                case BinaryExpression.Operator.ARITHDIV -> {
                    string = " / ";
                    n3 = 8;
                    n2 = 8;
                    yield 9;
                }
                case BinaryExpression.Operator.ARITHMOD -> {
                    string = " % ";
                    n3 = 8;
                    n2 = 8;
                    yield 9;
                }
                default -> throw new IllegalArgumentException(expression.toString());
            };
            if (n > n3) {
                stringBuilder.append("(");
            }
            this.appendExpression(stringBuilder, binaryExpression.getLeft(), n2);
            stringBuilder.append(string);
            this.appendExpression(stringBuilder, binaryExpression.getRight(), n4);
            if (n > n3) {
                stringBuilder.append(")");
            }
        } else if (expression instanceof UnaryExpression) {
            String string;
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            int n5 = switch (unaryExpression.getOperator()) {
                case UnaryExpression.Operator.ARITHNEGATIVE -> {
                    string = "-";
                    yield 9;
                }
                case UnaryExpression.Operator.LOGICNEG -> {
                    string = "!";
                    yield 9;
                }
                case UnaryExpression.Operator.OLD -> {
                    string = "old";
                    yield 11;
                }
                default -> throw new IllegalArgumentException(expression.toString());
            };
            if (n > n5) {
                stringBuilder.append("(");
            }
            stringBuilder.append(string);
            if (string == "old") {
                stringBuilder.append("(");
                this.appendExpression(stringBuilder, unaryExpression.getExpr(), 0);
                stringBuilder.append(")");
            } else {
                this.appendExpression(stringBuilder, unaryExpression.getExpr(), n5);
            }
            if (n > n5) {
                stringBuilder.append(")");
            }
        } else if (expression instanceof BitVectorAccessExpression) {
            BitVectorAccessExpression bitVectorAccessExpression = (BitVectorAccessExpression)expression;
            if (n > 10) {
                stringBuilder.append("(");
            }
            this.appendExpression(stringBuilder, bitVectorAccessExpression.getBitvec(), 10);
            stringBuilder.append("[").append(bitVectorAccessExpression.getEnd()).append(":");
            stringBuilder.append(bitVectorAccessExpression.getStart()).append("]");
            if (n > 10) {
                stringBuilder.append(")");
            }
        } else if (expression instanceof StructAccessExpression) {
            StructAccessExpression structAccessExpression = (StructAccessExpression)expression;
            if (n > 10) {
                stringBuilder.append("(");
            }
            this.appendExpression(stringBuilder, structAccessExpression.getStruct(), 10);
            stringBuilder.append("!");
            stringBuilder.append(structAccessExpression.getField());
            if (n > 10) {
                stringBuilder.append(")");
            }
        } else if (expression instanceof ArrayAccessExpression) {
            ArrayAccessExpression arrayAccessExpression = (ArrayAccessExpression)expression;
            if (n > 10) {
                stringBuilder.append("(");
            }
            this.appendExpression(stringBuilder, arrayAccessExpression.getArray(), 10);
            stringBuilder.append("[");
            String string = "";
            Expression[] expressionArray = arrayAccessExpression.getIndices();
            int n6 = expressionArray.length;
            int n7 = 0;
            while (n7 < n6) {
                Expression expression2 = expressionArray[n7];
                stringBuilder.append(string);
                this.appendExpression(stringBuilder, expression2, 0);
                string = ",";
                ++n7;
            }
            stringBuilder.append("]");
            if (n > 10) {
                stringBuilder.append(")");
            }
        } else if (expression instanceof ArrayStoreExpression) {
            ArrayStoreExpression arrayStoreExpression = (ArrayStoreExpression)expression;
            if (n > 10) {
                stringBuilder.append("(");
            }
            this.appendExpression(stringBuilder, arrayStoreExpression.getArray(), 10);
            stringBuilder.append("[");
            String string = "";
            Expression[] expressionArray = arrayStoreExpression.getIndices();
            int n8 = expressionArray.length;
            int n9 = 0;
            while (n9 < n8) {
                Expression expression3 = expressionArray[n9];
                stringBuilder.append(string);
                this.appendExpression(stringBuilder, expression3, 0);
                string = ",";
                ++n9;
            }
            stringBuilder.append(" := ");
            this.appendExpression(stringBuilder, arrayStoreExpression.getValue(), 0);
            stringBuilder.append("]");
            if (n > 10) {
                stringBuilder.append(")");
            }
        } else if (expression instanceof BitvecLiteral) {
            BitvecLiteral bitvecLiteral = (BitvecLiteral)expression;
            stringBuilder.append(bitvecLiteral.getValue()).append("bv").append(bitvecLiteral.getLength());
        } else if (expression instanceof IntegerLiteral) {
            stringBuilder.append(((IntegerLiteral)expression).getValue());
        } else if (expression instanceof RealLiteral) {
            String string;
            String string2 = ((RealLiteral)expression).getValue();
            try {
                string = String.valueOf(Double.parseDouble(string2));
            }
            catch (NumberFormatException numberFormatException) {
                string = string2;
            }
            stringBuilder.append(string);
        } else if (expression instanceof BooleanLiteral) {
            stringBuilder.append(((BooleanLiteral)expression).getValue());
        } else if (expression instanceof StringLiteral) {
            stringBuilder.append('\"').append(((StringLiteral)expression).getValue()).append('\"');
        } else if (expression instanceof StructConstructor) {
            StructConstructor structConstructor = (StructConstructor)expression;
            String string = "";
            stringBuilder.append("{ ");
            String[] stringArray = structConstructor.getFieldIdentifiers();
            Expression[] expressionArray = structConstructor.getFieldValues();
            int n10 = 0;
            while (n10 < stringArray.length) {
                stringBuilder.append(string).append(stringArray[n10]);
                stringBuilder.append(": ");
                this.appendExpression(stringBuilder, expressionArray[n10]);
                string = ", ";
                ++n10;
            }
            stringBuilder.append(" }");
        } else if (expression instanceof WildcardExpression) {
            stringBuilder.append("*");
        } else if (expression instanceof IdentifierExpression) {
            stringBuilder.append(((IdentifierExpression)expression).getIdentifier());
        } else if (expression instanceof FunctionApplication) {
            FunctionApplication functionApplication = (FunctionApplication)expression;
            stringBuilder.append(functionApplication.getIdentifier()).append("(");
            String string = "";
            Expression[] expressionArray = functionApplication.getArguments();
            int n11 = expressionArray.length;
            int n12 = 0;
            while (n12 < n11) {
                Expression expression4 = expressionArray[n12];
                stringBuilder.append(string);
                this.appendExpression(stringBuilder, expression4, 0);
                string = ", ";
                ++n12;
            }
            stringBuilder.append(")");
        } else if (expression instanceof IfThenElseExpression) {
            IfThenElseExpression ifThenElseExpression = (IfThenElseExpression)expression;
            stringBuilder.append("(if ");
            this.appendExpression(stringBuilder, ifThenElseExpression.getCondition(), 0);
            stringBuilder.append(" then ");
            this.appendExpression(stringBuilder, ifThenElseExpression.getThenPart(), 0);
            stringBuilder.append(" else ");
            this.appendExpression(stringBuilder, ifThenElseExpression.getElsePart(), 0);
            stringBuilder.append(")");
        } else if (expression instanceof QuantifierExpression) {
            QuantifierExpression quantifierExpression = (QuantifierExpression)expression;
            stringBuilder.append("(");
            stringBuilder.append(quantifierExpression.isUniversal() ? "forall" : "exists");
            String[] stringArray = quantifierExpression.getTypeParams();
            if (stringArray.length > 0) {
                stringBuilder.append(" <");
                String string = "";
                String[] stringArray2 = stringArray;
                int n13 = stringArray.length;
                int n14 = 0;
                while (n14 < n13) {
                    String string3 = stringArray2[n14];
                    stringBuilder.append(string).append(string3);
                    string = ",";
                    ++n14;
                }
                stringBuilder.append(">");
            }
            if (quantifierExpression.getParameters().length > 0) {
                stringBuilder.append(" ");
                this.appendVarList(stringBuilder, quantifierExpression.getParameters());
            }
            stringBuilder.append(" :: ");
            this.appendAttributes(stringBuilder, quantifierExpression.getAttributes());
            this.appendExpression(stringBuilder, quantifierExpression.getSubformula(), 0);
            stringBuilder.append(")");
        } else {
            stringBuilder.append(expression.toString());
        }
    }

    public void appendType(StringBuilder stringBuilder, ASTType aSTType, int n) {
        if (aSTType instanceof NamedType) {
            NamedType namedType = (NamedType)aSTType;
            ASTType[] aSTTypeArray = namedType.getTypeArgs();
            if (n > 0 && aSTTypeArray.length > 0) {
                stringBuilder.append("(");
            }
            stringBuilder.append(namedType.getName());
            int n2 = 0;
            while (n2 < aSTTypeArray.length) {
                stringBuilder.append(" ");
                this.appendType(stringBuilder, aSTTypeArray[n2], n2 < aSTTypeArray.length - 1 ? 2 : 1);
                ++n2;
            }
            if (n > 0 && aSTTypeArray.length > 0) {
                stringBuilder.append(")");
            }
        } else if (aSTType instanceof ArrayType) {
            String string;
            int n3;
            int n4;
            Object[] objectArray;
            String string2;
            ArrayType arrayType = (ArrayType)aSTType;
            if (n > 1) {
                stringBuilder.append("(");
            }
            if (arrayType.getTypeParams().length > 0) {
                string2 = "<";
                objectArray = arrayType.getTypeParams();
                n4 = objectArray.length;
                n3 = 0;
                while (n3 < n4) {
                    string = objectArray[n3];
                    stringBuilder.append(string2).append(string);
                    string2 = ",";
                    ++n3;
                }
                stringBuilder.append(">");
            }
            string2 = "[";
            objectArray = arrayType.getIndexTypes();
            n4 = objectArray.length;
            n3 = 0;
            while (n3 < n4) {
                string = objectArray[n3];
                stringBuilder.append(string2);
                this.appendType(stringBuilder, (ASTType)((Object)string), 0);
                string2 = ",";
                ++n3;
            }
            stringBuilder.append("]");
            this.appendType(stringBuilder, arrayType.getValueType(), 0);
            if (n > 1) {
                stringBuilder.append(")");
            }
        } else if (aSTType instanceof StructType) {
            StructType structType = (StructType)aSTType;
            if (n > 1) {
                stringBuilder.append("(");
            }
            stringBuilder.append("{ ");
            this.appendVarList(stringBuilder, structType.getFields());
            stringBuilder.append(" }");
            if (n > 1) {
                stringBuilder.append(")");
            }
        } else if (aSTType instanceof PrimitiveType) {
            stringBuilder.append(((PrimitiveType)aSTType).getName());
        }
    }

    public void appendAttributes(StringBuilder stringBuilder, Attribute[] attributeArray) {
        if (attributeArray == null) {
            return;
        }
        Attribute[] attributeArray2 = attributeArray;
        int n = attributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray2[n2];
            if (attribute instanceof NamedAttribute) {
                var7_7 = (NamedAttribute)attribute;
                stringBuilder.append("{ :").append(((NamedAttribute)((Object)var7_7)).getName());
                var8_8 = " ";
                Expression[] expressionArray = ((NamedAttribute)((Object)var7_7)).getValues();
                int n3 = expressionArray.length;
                var10_11 = 0;
                while (var10_11 < n3) {
                    Expression expression = expressionArray[var10_11];
                    stringBuilder.append((String)var8_8);
                    this.appendExpression(stringBuilder, expression, 0);
                    var8_8 = ",";
                    ++var10_11;
                }
                stringBuilder.append(" } ");
            } else if (attribute instanceof Trigger) {
                stringBuilder.append("{ ");
                var7_7 = "";
                Expression[] expressionArray = ((Trigger)attribute).getTriggers();
                var10_11 = expressionArray.length;
                int n4 = 0;
                while (n4 < var10_11) {
                    var8_8 = expressionArray[n4];
                    stringBuilder.append((String)var7_7);
                    this.appendExpression(stringBuilder, (Expression)((Object)var8_8), 0);
                    var7_7 = ",";
                    ++n4;
                }
                stringBuilder.append(" } ");
            }
            ++n2;
        }
    }

    public void appendExpression(StringBuilder stringBuilder, Expression expression) {
        this.appendExpression(stringBuilder, expression, 0);
    }

    public void appendVarList(StringBuilder stringBuilder, VarList[] varListArray) {
        String string = "";
        VarList[] varListArray2 = varListArray;
        int n = varListArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarList varList = varListArray2[n2];
            stringBuilder.append(string);
            if (varList.getIdentifiers().length > 0) {
                String string2 = "";
                String[] stringArray = varList.getIdentifiers();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String string3 = stringArray[n4];
                    stringBuilder.append(string2).append(string3);
                    string2 = ", ";
                    ++n4;
                }
                stringBuilder.append(" : ");
            }
            this.appendType(stringBuilder, varList.getType(), 0);
            if (varList.getWhereClause() != null) {
                stringBuilder.append(" where ");
                this.appendExpression(stringBuilder, varList.getWhereClause(), 0);
            }
            string = ", ";
            ++n2;
        }
    }

    public void printTypeDeclaration(TypeDeclaration typeDeclaration) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("type ");
        this.appendAttributes(stringBuilder, typeDeclaration.getAttributes());
        if (typeDeclaration.isFinite()) {
            stringBuilder.append("finite ");
        }
        stringBuilder.append(typeDeclaration.getIdentifier());
        String[] stringArray = typeDeclaration.getTypeParams();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray[n2];
            stringBuilder.append(" ").append((String)object);
            ++n2;
        }
        object = typeDeclaration.getSynonym();
        if (object != null) {
            stringBuilder.append(" = ");
            this.appendType(stringBuilder, (ASTType)((Object)object), 0);
        }
        stringBuilder.append(";");
        this.mWriter.println(stringBuilder.toString());
    }

    public void printFunctionDeclaration(FunctionDeclaration functionDeclaration) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("function ");
        this.appendAttributes(stringBuilder, functionDeclaration.getAttributes());
        stringBuilder.append(functionDeclaration.getIdentifier());
        if (functionDeclaration.getTypeParams().length > 0) {
            String string = "<";
            String[] stringArray = functionDeclaration.getTypeParams();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                stringBuilder.append(string).append(string2);
                string = ",";
                ++n2;
            }
            stringBuilder.append(">");
        }
        stringBuilder.append("(");
        this.appendVarList(stringBuilder, functionDeclaration.getInParams());
        stringBuilder.append(") returns (");
        this.appendVarList(stringBuilder, new VarList[]{functionDeclaration.getOutParam()});
        stringBuilder.append(")");
        if (functionDeclaration.getBody() != null) {
            stringBuilder.append(" { ");
            this.appendExpression(stringBuilder, functionDeclaration.getBody(), 0);
            stringBuilder.append(" }");
        } else {
            stringBuilder.append(";");
        }
        this.mWriter.println(stringBuilder.toString());
    }

    public void printProcedure(Procedure procedure) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendProcedure(stringBuilder, procedure);
        this.mWriter.print(stringBuilder.toString());
    }

    public void appendProcedure(StringBuilder stringBuilder, Procedure procedure) {
        int n;
        Object object;
        if (procedure.getSpecification() != null) {
            stringBuilder.append("procedure ");
        } else {
            stringBuilder.append("implementation ");
        }
        this.appendAttributes(stringBuilder, procedure.getAttributes());
        stringBuilder.append(procedure.getIdentifier());
        if (procedure.getTypeParams().length > 0) {
            object = "<";
            String[] stringArray = procedure.getTypeParams();
            int n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String string = stringArray[n];
                stringBuilder.append((String)object).append(string);
                object = ",";
                ++n;
            }
            stringBuilder.append(">");
        }
        stringBuilder.append("(");
        this.appendVarList(stringBuilder, procedure.getInParams());
        stringBuilder.append(") returns (");
        this.appendVarList(stringBuilder, procedure.getOutParams());
        stringBuilder.append(")");
        if (procedure.getBody() == null) {
            stringBuilder.append(";");
        }
        if (procedure.getSpecification() != null) {
            stringBuilder.append(LINEBREAK);
            Specification[] specificationArray = procedure.getSpecification();
            n = specificationArray.length;
            int n3 = 0;
            while (n3 < n) {
                object = specificationArray[n3];
                this.appendSpecification(stringBuilder, (Specification)((Object)object));
                ++n3;
            }
        }
        if (procedure.getBody() != null) {
            stringBuilder.append("{" + LINEBREAK);
            this.appendBody(stringBuilder, procedure.getBody());
            stringBuilder.append("}" + LINEBREAK);
        }
        stringBuilder.append(LINEBREAK);
    }

    public void printSpecification(Specification specification) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendSpecification(stringBuilder, specification);
        this.mWriter.print(stringBuilder.toString());
    }

    public void appendSpecification(StringBuilder stringBuilder, Specification specification) {
        if (specification.isFree()) {
            stringBuilder.append("free ");
        }
        if (specification instanceof RequiresSpecification) {
            stringBuilder.append("requires ");
            this.appendExpression(stringBuilder, ((RequiresSpecification)specification).getFormula(), 0);
        } else if (specification instanceof EnsuresSpecification) {
            stringBuilder.append("ensures ");
            this.appendExpression(stringBuilder, ((EnsuresSpecification)specification).getFormula(), 0);
        } else if (specification instanceof ModifiesSpecification) {
            stringBuilder.append("modifies ");
            String string = "";
            VariableLHS[] variableLHSArray = ((ModifiesSpecification)specification).getIdentifiers();
            int n = variableLHSArray.length;
            int n2 = 0;
            while (n2 < n) {
                VariableLHS variableLHS = variableLHSArray[n2];
                stringBuilder.append(string).append(variableLHS.getIdentifier());
                string = ", ";
                ++n2;
            }
        } else if (specification instanceof LoopInvariantSpecification) {
            stringBuilder.append("invariant ");
            this.appendExpression(stringBuilder, ((LoopInvariantSpecification)specification).getFormula(), 0);
        } else {
            throw new IllegalArgumentException(specification.toString());
        }
        stringBuilder.append(";").append(LINEBREAK);
    }

    public void printBody(Body body) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendBody(stringBuilder, body);
        this.mWriter.print(stringBuilder.toString());
    }

    public void appendBody(StringBuilder stringBuilder, Body body) {
        VariableDeclaration[] variableDeclarationArray = body.getLocalVars();
        int n = variableDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableDeclaration variableDeclaration = variableDeclarationArray[n2];
            this.appendVariableDeclaration(stringBuilder, variableDeclaration, "    ");
            ++n2;
        }
        if (body.getLocalVars().length > 0) {
            stringBuilder.append(LINEBREAK);
        }
        this.appendBlock(stringBuilder, body.getBlock(), "");
    }

    public void printBlock(Statement[] statementArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendBlock(stringBuilder, statementArray, string);
        this.mWriter.print(stringBuilder.toString());
    }

    public void appendBlock(StringBuilder stringBuilder, Statement[] statementArray) {
        this.appendBlock(stringBuilder, statementArray, "");
    }

    public void appendBlock(StringBuilder stringBuilder, Statement[] statementArray, String string) {
        String string2 = string + "    ";
        Statement[] statementArray2 = statementArray;
        int n = statementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray2[n2];
            if (statement instanceof Label) {
                Label label = (Label)statement;
                stringBuilder.append(string + "  " + label.getName());
                if (label.getAttributes() != null && label.getAttributes().length > 0) {
                    stringBuilder.append(' ');
                    this.appendAttributes(stringBuilder, label.getAttributes());
                }
                stringBuilder.append(":" + LINEBREAK);
            } else {
                this.appendStatement(stringBuilder, statement, string2);
            }
            ++n2;
        }
    }

    public void appendStatement(StringBuilder stringBuilder, Statement statement) {
        this.appendStatement(stringBuilder, statement, "");
    }

    public void appendStatement(StringBuilder stringBuilder, Statement statement, String string) {
        stringBuilder.append(string);
        if (statement instanceof AssertStatement) {
            AssertStatement assertStatement = (AssertStatement)statement;
            stringBuilder.append("assert ");
            this.appendAttributes(stringBuilder, assertStatement.getAttributes());
            this.appendExpression(stringBuilder, assertStatement.getFormula(), 0);
            stringBuilder.append(";");
        } else if (statement instanceof AssumeStatement) {
            AssumeStatement assumeStatement = (AssumeStatement)statement;
            stringBuilder.append("assume ");
            this.appendAttributes(stringBuilder, assumeStatement.getAttributes());
            this.appendExpression(stringBuilder, assumeStatement.getFormula(), 0);
            stringBuilder.append(";");
        } else if (statement instanceof HavocStatement) {
            HavocStatement havocStatement = (HavocStatement)statement;
            stringBuilder.append("havoc ");
            String string2 = "";
            VariableLHS[] variableLHSArray = havocStatement.getIdentifiers();
            int n = variableLHSArray.length;
            int n2 = 0;
            while (n2 < n) {
                VariableLHS variableLHS = variableLHSArray[n2];
                stringBuilder.append(string2).append(variableLHS.getIdentifier());
                string2 = ", ";
                ++n2;
            }
            stringBuilder.append(";");
        } else if (statement instanceof AssignmentStatement) {
            BoogieASTNode boogieASTNode;
            AssignmentStatement assignmentStatement = (AssignmentStatement)statement;
            String string3 = "";
            BoogieASTNode[] boogieASTNodeArray = assignmentStatement.getLhs();
            int n = boogieASTNodeArray.length;
            int n3 = 0;
            while (n3 < n) {
                boogieASTNode = boogieASTNodeArray[n3];
                stringBuilder.append(string3);
                this.appendLHS(stringBuilder, (LeftHandSide)boogieASTNode);
                string3 = ", ";
                ++n3;
            }
            stringBuilder.append(" := ");
            string3 = "";
            boogieASTNodeArray = assignmentStatement.getRhs();
            n = boogieASTNodeArray.length;
            n3 = 0;
            while (n3 < n) {
                boogieASTNode = boogieASTNodeArray[n3];
                stringBuilder.append(string3);
                this.appendExpression(stringBuilder, (Expression)boogieASTNode, 0);
                string3 = ", ";
                ++n3;
            }
            stringBuilder.append(";");
        } else if (statement instanceof CallStatement) {
            BoogieASTNode boogieASTNode;
            int n;
            int n4;
            BoogieASTNode[] boogieASTNodeArray;
            String string4;
            CallStatement callStatement = (CallStatement)statement;
            stringBuilder.append("call ");
            this.appendAttributes(stringBuilder, callStatement.getAttributes());
            if (callStatement.isForall()) {
                stringBuilder.append("forall ");
            }
            if (callStatement.getLhs().length > 0) {
                string4 = "";
                boogieASTNodeArray = callStatement.getLhs();
                n4 = boogieASTNodeArray.length;
                n = 0;
                while (n < n4) {
                    boogieASTNode = boogieASTNodeArray[n];
                    stringBuilder.append(string4).append(boogieASTNode.getIdentifier());
                    string4 = ", ";
                    ++n;
                }
                stringBuilder.append(" := ");
            }
            stringBuilder.append(callStatement.getMethodName());
            stringBuilder.append("(");
            string4 = "";
            boogieASTNodeArray = callStatement.getArguments();
            n4 = boogieASTNodeArray.length;
            n = 0;
            while (n < n4) {
                boogieASTNode = boogieASTNodeArray[n];
                stringBuilder.append(string4);
                this.appendExpression(stringBuilder, (Expression)boogieASTNode, 0);
                string4 = ", ";
                ++n;
            }
            stringBuilder.append(");");
        } else if (statement instanceof ForkStatement) {
            Expression expression;
            ForkStatement forkStatement = (ForkStatement)statement;
            String string5 = "";
            stringBuilder.append("fork ");
            Expression[] expressionArray = forkStatement.getThreadID();
            int n = expressionArray.length;
            int n5 = 0;
            while (n5 < n) {
                expression = expressionArray[n5];
                stringBuilder.append(string5);
                stringBuilder.append(BoogiePrettyPrinter.print(expression));
                string5 = ", ";
                ++n5;
            }
            stringBuilder.append(" ").append(forkStatement.getProcedureName());
            stringBuilder.append("(");
            string5 = "";
            expressionArray = forkStatement.getArguments();
            n = expressionArray.length;
            n5 = 0;
            while (n5 < n) {
                expression = expressionArray[n5];
                stringBuilder.append(string5);
                this.appendExpression(stringBuilder, expression, 0);
                string5 = ", ";
                ++n5;
            }
            stringBuilder.append(");");
        } else if (statement instanceof JoinStatement) {
            BoogieASTNode boogieASTNode;
            JoinStatement joinStatement = (JoinStatement)statement;
            String string6 = "";
            stringBuilder.append("join ");
            BoogieASTNode[] boogieASTNodeArray = joinStatement.getThreadID();
            int n = boogieASTNodeArray.length;
            int n6 = 0;
            while (n6 < n) {
                boogieASTNode = boogieASTNodeArray[n6];
                stringBuilder.append(string6).append(BoogiePrettyPrinter.print((Expression)boogieASTNode));
                string6 = ", ";
                ++n6;
            }
            if (joinStatement.getLhs().length > 0) {
                stringBuilder.append(" assign ");
                string6 = "";
                boogieASTNodeArray = joinStatement.getLhs();
                n = boogieASTNodeArray.length;
                n6 = 0;
                while (n6 < n) {
                    boogieASTNode = boogieASTNodeArray[n6];
                    stringBuilder.append(string6).append(((VariableLHS)boogieASTNode).getIdentifier());
                    string6 = ", ";
                    ++n6;
                }
            }
            stringBuilder.append(";");
        } else if (statement instanceof BreakStatement) {
            String string7 = ((BreakStatement)statement).getLabel();
            stringBuilder.append("break");
            if (string7 != null) {
                stringBuilder.append(" ").append(string7);
            }
            stringBuilder.append(";");
        } else if (statement instanceof ReturnStatement) {
            stringBuilder.append("return;");
        } else if (statement instanceof GotoStatement) {
            stringBuilder.append("goto ");
            String string8 = "";
            String[] stringArray = ((GotoStatement)statement).getLabels();
            int n = stringArray.length;
            int n7 = 0;
            while (n7 < n) {
                String string9 = stringArray[n7];
                stringBuilder.append(string8).append(string9);
                string8 = ", ";
                ++n7;
            }
            stringBuilder.append(";");
        } else if (statement instanceof IfStatement) {
            Statement[] statementArray;
            IfStatement ifStatement = (IfStatement)statement;
            while (true) {
                stringBuilder.append("if (");
                this.appendExpression(stringBuilder, ifStatement.getCondition(), 0);
                stringBuilder.append(") {" + LINEBREAK);
                this.appendBlock(stringBuilder, ifStatement.getThenPart(), string);
                stringBuilder.append(string).append("}");
                statementArray = ifStatement.getElsePart();
                if (statementArray.length != 1 || !(statementArray[0] instanceof IfStatement)) break;
                ifStatement = (IfStatement)statementArray[0];
                stringBuilder.append(" else ");
            }
            if (statementArray.length > 0) {
                stringBuilder.append(" else {" + LINEBREAK);
                this.appendBlock(stringBuilder, ifStatement.getElsePart(), string);
                stringBuilder.append(string).append("}");
            }
        } else if (statement instanceof WhileStatement) {
            WhileStatement whileStatement = (WhileStatement)statement;
            stringBuilder.append("while (");
            this.appendExpression(stringBuilder, whileStatement.getCondition(), 0);
            stringBuilder.append(")" + LINEBREAK);
            LoopInvariantSpecification[] loopInvariantSpecificationArray = whileStatement.getInvariants();
            int n = loopInvariantSpecificationArray.length;
            int n8 = 0;
            while (n8 < n) {
                LoopInvariantSpecification loopInvariantSpecification = loopInvariantSpecificationArray[n8];
                stringBuilder.append(string).append("    ");
                if (loopInvariantSpecification.isFree()) {
                    stringBuilder.append("free ");
                }
                stringBuilder.append("invariant ");
                this.appendExpression(stringBuilder, loopInvariantSpecification.getFormula(), 0);
                stringBuilder.append(";" + LINEBREAK);
                ++n8;
            }
            stringBuilder.append(string).append("{" + LINEBREAK);
            this.appendBlock(stringBuilder, whileStatement.getBody(), string);
            stringBuilder.append(string).append("}");
        } else if (statement instanceof Label) {
            stringBuilder.append(((Label)statement).getName()).append(":");
        } else if (statement instanceof AtomicStatement) {
            AtomicStatement atomicStatement = (AtomicStatement)statement;
            stringBuilder.append("atomic {").append(LINEBREAK);
            this.appendBlock(stringBuilder, atomicStatement.getBody(), string);
            stringBuilder.append(string).append("}");
        } else {
            throw new IllegalArgumentException(statement.toString());
        }
        stringBuilder.append(LINEBREAK);
    }

    private void appendLHS(StringBuilder stringBuilder, LeftHandSide leftHandSide) {
        if (leftHandSide instanceof VariableLHS) {
            stringBuilder.append(((VariableLHS)leftHandSide).getIdentifier());
        } else if (leftHandSide instanceof ArrayLHS) {
            ArrayLHS arrayLHS = (ArrayLHS)leftHandSide;
            this.appendLHS(stringBuilder, arrayLHS.getArray());
            stringBuilder.append("[");
            String string = "";
            Expression[] expressionArray = arrayLHS.getIndices();
            int n = expressionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression = expressionArray[n2];
                stringBuilder.append(string);
                this.appendExpression(stringBuilder, expression, 0);
                string = ",";
                ++n2;
            }
            stringBuilder.append("]");
        } else if (leftHandSide instanceof StructLHS) {
            StructLHS structLHS = (StructLHS)leftHandSide;
            this.appendLHS(stringBuilder, structLHS.getStruct());
            stringBuilder.append("!");
            stringBuilder.append(structLHS.getField());
        } else {
            throw new IllegalArgumentException(leftHandSide.toString());
        }
    }

    public void printAxiom(Axiom axiom) {
        this.mWriter.println(this.appendAxiom(new StringBuilder(), axiom).toString());
    }

    public StringBuilder appendAxiom(StringBuilder stringBuilder, Axiom axiom) {
        stringBuilder.append("axiom ");
        this.appendAttributes(stringBuilder, axiom.getAttributes());
        this.appendExpression(stringBuilder, axiom.getFormula(), 0);
        stringBuilder.append(";");
        return stringBuilder;
    }

    public void printVarDeclaration(VariableDeclaration variableDeclaration, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendVariableDeclaration(stringBuilder, variableDeclaration, string);
        this.mWriter.println(stringBuilder.toString());
    }

    protected void appendVariableDeclaration(StringBuilder stringBuilder, VariableDeclaration variableDeclaration, String string) {
        stringBuilder.append(string).append("var ");
        this.appendAttributes(stringBuilder, variableDeclaration.getAttributes());
        this.appendVarList(stringBuilder, variableDeclaration.getVariables());
        stringBuilder.append(";");
        stringBuilder.append(LINEBREAK);
    }

    public void appendVariableDeclaration(StringBuilder stringBuilder, VariableDeclaration variableDeclaration) {
        this.appendVariableDeclaration(stringBuilder, variableDeclaration, "");
    }

    public void printConstDeclaration(ConstDeclaration constDeclaration) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("const ");
        this.appendAttributes(stringBuilder, constDeclaration.getAttributes());
        if (constDeclaration.isUnique()) {
            stringBuilder.append("unique ");
        }
        this.appendVarList(stringBuilder, new VarList[]{constDeclaration.getVarList()});
        if (constDeclaration.getParentInfo() != null) {
            stringBuilder.append(" <:");
            String string = " ";
            ParentEdge[] parentEdgeArray = constDeclaration.getParentInfo();
            int n = parentEdgeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ParentEdge parentEdge = parentEdgeArray[n2];
                stringBuilder.append(string);
                if (parentEdge.isUnique()) {
                    stringBuilder.append("unique ");
                }
                stringBuilder.append(parentEdge.getIdentifier());
                string = ", ";
                ++n2;
            }
        }
        if (constDeclaration.isComplete()) {
            stringBuilder.append(" complete");
        }
        stringBuilder.append(";");
        this.mWriter.println(stringBuilder.toString());
    }
}

