/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.HoareAnnotationPositions;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.HoareProofSettings;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.IFloydHoareAnnotation;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.NwaHoareProofProducer;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.TransformFloydHoareAnnotation;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.cfg2automaton.Cfg2Automaton;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction.IInitialAbstractionProvider;
import java.util.Set;

public class NwaInitialAbstractionProvider<L extends IIcfgTransition<?>>
implements IInitialAbstractionProvider<L, INestedWordAutomaton<L, IPredicate>> {
    private final IUltimateServiceProvider mServices;
    private final IEmptyStackStateFactory<IPredicate> mStateFactory;
    private final boolean mInterprocedural;
    private final PredicateFactory mPredicateFactory;
    private final HoareProofSettings mPrefs;
    private INestedWordAutomaton<L, IPredicate> mAbstraction;
    private CfgSmtToolkit mCsToolkit;
    private Set<IPredicate> mHoareStates;

    public NwaInitialAbstractionProvider(IUltimateServiceProvider iUltimateServiceProvider, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory, boolean bl, PredicateFactory predicateFactory, HoareProofSettings hoareProofSettings) {
        this.mServices = iUltimateServiceProvider;
        this.mStateFactory = iEmptyStackStateFactory;
        this.mInterprocedural = bl;
        this.mPredicateFactory = predicateFactory;
        this.mPrefs = hoareProofSettings;
    }

    @Override
    public INestedWordAutomaton<L, IPredicate> getInitialAbstraction(IIcfg<? extends IcfgLocation> iIcfg, Set<? extends IcfgLocation> set) {
        if (this.mAbstraction == null) {
            this.mAbstraction = Cfg2Automaton.constructAutomatonWithSPredicates(this.mServices, iIcfg, this.mStateFactory, set, this.mInterprocedural, this.mPredicateFactory);
            this.mHoareStates = NwaHoareProofProducer.computeHoareStates(iIcfg, this.mAbstraction, (HoareAnnotationPositions)this.mPrefs.getHoarePositions());
            this.mCsToolkit = iIcfg.getCfgSmtToolkit();
        }
        return this.mAbstraction;
    }

    public NwaHoareProofProducer<L> getProofProducer() {
        if (!this.mPrefs.computeHoareAnnotation()) {
            return null;
        }
        if (this.mAbstraction == null) {
            throw new UnsupportedOperationException("Must create abstraction before creating proof producer");
        }
        return new NwaHoareProofProducer(this.mServices, this.mAbstraction, this.mCsToolkit, this.mPredicateFactory, this.mPrefs, this.mHoareStates);
    }

    public IFloydHoareAnnotation<IcfgLocation> backtranslateProof(IFloydHoareAnnotation<IPredicate> iFloydHoareAnnotation) {
        return TransformFloydHoareAnnotation.nwaToIcfg(iFloydHoareAnnotation, this.mAbstraction);
    }
}

