/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class FunctionDeclaration
extends Declaration {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(FunctionDeclaration.class);
    String identifier;
    String[] typeParams;
    VarList[] inParams;
    VarList outParam;
    Expression body;

    public FunctionDeclaration(ILocation iLocation, Attribute[] attributeArray, String string, String[] stringArray, VarList[] varListArray, VarList varList) {
        super(iLocation, attributeArray);
        this.identifier = string;
        this.typeParams = stringArray;
        this.inParams = varListArray;
        this.outParam = varList;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid FunctionDeclaration: " + String.valueOf((Object)this);
    }

    public FunctionDeclaration(ILocation iLocation, Attribute[] attributeArray, String string, String[] stringArray, VarList[] varListArray, VarList varList, Expression expression) {
        super(iLocation, attributeArray);
        this.identifier = string;
        this.typeParams = stringArray;
        this.inParams = varListArray;
        this.outParam = varList;
        this.body = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid FunctionDeclaration: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FunctionDeclaration").append('[');
        stringBuffer.append(this.identifier);
        stringBuffer.append(',');
        if (this.typeParams == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.typeParams.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.typeParams[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',');
        if (this.inParams == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.inParams.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.inParams[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',').append((Object)this.outParam);
        stringBuffer.append(',').append((Object)this.body);
        return stringBuffer.append(']').toString();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String[] getTypeParams() {
        return this.typeParams;
    }

    public VarList[] getInParams() {
        return this.inParams;
    }

    public VarList getOutParam() {
        return this.outParam;
    }

    public Expression getBody() {
        return this.body;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.inParams != null) {
            list.addAll(Arrays.asList(this.inParams));
        }
        list.add(this.outParam);
        list.add(this.body);
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Declaration)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this)) {
            BoogieASTNode boogieASTNode;
            int n;
            int n2;
            BoogieASTNode[] boogieASTNodeArray;
            if (this.inParams != null) {
                boogieASTNodeArray = this.inParams;
                n2 = this.inParams.length;
                n = 0;
                while (n < n2) {
                    boogieASTNode = boogieASTNodeArray[n];
                    ((VarList)boogieASTNode).accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
            if (this.outParam != null) {
                this.outParam.accept(generatedBoogieAstVisitor);
            }
            if (this.body != null) {
                this.body.accept(generatedBoogieAstVisitor);
            }
            if (this.attributes != null) {
                boogieASTNodeArray = this.attributes;
                n2 = this.attributes.length;
                n = 0;
                while (n < n2) {
                    boogieASTNode = boogieASTNodeArray[n];
                    ((Attribute)boogieASTNode).accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
        }
    }

    @Override
    public Declaration accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        VarList varList;
        Object object;
        Declaration declaration = generatedBoogieAstTransformer.transform(this);
        if (declaration != this) {
            return declaration;
        }
        boolean bl = false;
        ArrayList<VarList> arrayList = new ArrayList<VarList>();
        if (this.inParams != null) {
            object = this.inParams;
            int n = this.inParams.length;
            int n2 = 0;
            while (n2 < n) {
                varList = object[n2];
                VarList varList2 = varList.accept(generatedBoogieAstTransformer);
                bl = bl || varList2 != varList;
                arrayList.add(varList2);
                ++n2;
            }
        }
        varList = null;
        if (this.outParam != null) {
            varList = this.outParam.accept(generatedBoogieAstTransformer);
        }
        Expression expression = null;
        if (this.body != null) {
            expression = this.body.accept(generatedBoogieAstTransformer);
        }
        ArrayList<Attribute> arrayList2 = new ArrayList<Attribute>();
        if (this.attributes != null) {
            Attribute[] attributeArray = this.attributes;
            int n = this.attributes.length;
            int n3 = 0;
            while (n3 < n) {
                object = attributeArray[n3];
                Attribute attribute = ((Attribute)((Object)object)).accept(generatedBoogieAstTransformer);
                bl = bl || attribute != object;
                arrayList2.add(attribute);
                ++n3;
            }
        }
        if (bl || this.outParam != varList || this.body != expression) {
            return new FunctionDeclaration(this.loc, arrayList2.toArray(new Attribute[0]), this.identifier, this.typeParams, arrayList.toArray(new VarList[0]), varList, expression);
        }
        return this;
    }
}

