/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqAtomicBaseNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class EqNonAtomicBaseNode
extends EqNode {
    private final Set<EqNode> mSupportingNodes;

    public EqNonAtomicBaseNode(Term term, Set<EqNode> set, EqNodeAndFunctionFactory eqNodeAndFunctionFactory, boolean bl) {
        super(term, eqNodeAndFunctionFactory, bl);
        assert (!set.isEmpty());
        assert (set.stream().allMatch(eqNode -> eqNode instanceof EqAtomicBaseNode));
        this.mSupportingNodes = Collections.unmodifiableSet(set);
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public String toString() {
        return this.mTerm.toString();
    }

    public boolean isFunctionApplication() {
        return false;
    }

    public EqNode getAppliedFunction() {
        assert (false) : "check for isFunction() first";
        return null;
    }

    @Override
    public boolean isDependentNonFunctionApplication() {
        return true;
    }

    @Override
    public Set<EqNode> getSupportingNodes() {
        return this.mSupportingNodes;
    }

    public EqNode replaceSubNode(Map<EqNode, EqNode> map) {
        EqNode eqNode = map.get(this);
        if (eqNode != null) {
            return eqNode;
        }
        if (DataStructureUtils.intersection(this.getSupportingNodes(), map.keySet()).isEmpty()) {
            throw new UnsupportedOperationException("TODO: support this");
        }
        return this;
    }
}

