/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WildcardExpression;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.ExpressionTransformer;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctAssumeProcessor;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctPostOperator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class IfExpressionTree {
    private Expression mLeafExpr;
    private Expression mThenCondition;
    private IfExpressionTree mThenChild;
    private Expression mElseCondition;
    private IfExpressionTree mElseChild;

    public static IfExpressionTree buildTree(Expression expression, ExpressionTransformer expressionTransformer) {
        if (expression instanceof IfThenElseExpression) {
            return IfExpressionTree.treeFromIfExpr((IfThenElseExpression)expression, expressionTransformer);
        }
        if (expression instanceof BinaryExpression) {
            return IfExpressionTree.treeFromBinaryExpr((BinaryExpression)expression, expressionTransformer);
        }
        if (expression instanceof UnaryExpression) {
            return IfExpressionTree.treeFromUnaryExpr((UnaryExpression)expression, expressionTransformer);
        }
        return new IfExpressionTree(expression);
    }

    private static IfExpressionTree treeFromIfExpr(IfThenElseExpression ifThenElseExpression, ExpressionTransformer expressionTransformer) {
        Expression expression;
        Expression expression2 = ifThenElseExpression.getCondition();
        if (expression2 instanceof WildcardExpression) {
            expression2 = expression = new BooleanLiteral(expression2.getLocation(), (IBoogieType)BoogieType.TYPE_BOOL, true);
        } else {
            expression = expressionTransformer.logicNegCached(expression2);
        }
        return new IfExpressionTree(expression2, IfExpressionTree.buildTree(ifThenElseExpression.getThenPart(), expressionTransformer), expression, IfExpressionTree.buildTree(ifThenElseExpression.getElsePart(), expressionTransformer));
    }

    private static IfExpressionTree treeFromBinaryExpr(BinaryExpression binaryExpression, ExpressionTransformer expressionTransformer) {
        IfExpressionTree ifExpressionTree = IfExpressionTree.buildTree(binaryExpression.getLeft(), expressionTransformer);
        IfExpressionTree ifExpressionTree2 = IfExpressionTree.buildTree(binaryExpression.getRight(), expressionTransformer);
        ILocation iLocation = binaryExpression.getLocation();
        IBoogieType iBoogieType = binaryExpression.getType();
        BinaryExpression.Operator operator = binaryExpression.getOperator();
        ifExpressionTree.append(ifExpressionTree2, (expression, expression2) -> new BinaryExpression(iLocation, iBoogieType, operator, expression, expression2));
        return ifExpressionTree;
    }

    private static IfExpressionTree treeFromUnaryExpr(UnaryExpression unaryExpression, ExpressionTransformer expressionTransformer) {
        IfExpressionTree ifExpressionTree = IfExpressionTree.buildTree(unaryExpression.getExpr(), expressionTransformer);
        ILocation iLocation = unaryExpression.getLocation();
        IBoogieType iBoogieType = unaryExpression.getType();
        UnaryExpression.Operator operator = unaryExpression.getOperator();
        ifExpressionTree.mapLeafExprs(expression -> new UnaryExpression(iLocation, iBoogieType, operator, expression));
        return ifExpressionTree;
    }

    private IfExpressionTree(Expression expression) {
        this.mLeafExpr = expression;
    }

    private IfExpressionTree(Expression expression, IfExpressionTree ifExpressionTree, Expression expression2, IfExpressionTree ifExpressionTree2) {
        if (expression != null && expression == ifExpressionTree.mThenCondition) assert (false);
        this.mThenCondition = expression;
        this.mThenChild = ifExpressionTree;
        this.mElseCondition = expression2;
        this.mElseChild = ifExpressionTree2;
    }

    public IfExpressionTree deepCopy() {
        if (this.isLeaf()) {
            return new IfExpressionTree(this.mLeafExpr);
        }
        return new IfExpressionTree(this.mThenCondition, this.mThenChild.deepCopy(), this.mElseCondition, this.mElseChild.deepCopy());
    }

    public boolean isLeaf() {
        assert (this.compareNonLeafAttributesToNull(this.mLeafExpr == null));
        return this.mLeafExpr != null;
    }

    private boolean compareNonLeafAttributesToNull(boolean bl) {
        return bl ^ this.mThenCondition == null && bl ^ this.mThenChild == null && bl ^ this.mElseCondition == null && bl ^ this.mElseChild == null;
    }

    private void mapLeafExprs(Function<Expression, Expression> function) {
        if (this.isLeaf()) {
            this.mLeafExpr = function.apply(this.mLeafExpr);
        } else {
            this.mThenChild.mapLeafExprs(function);
            this.mElseChild.mapLeafExprs(function);
        }
    }

    private void append(IfExpressionTree ifExpressionTree, BiFunction<Expression, Expression, Expression> biFunction) {
        if (ifExpressionTree.isLeaf()) {
            this.mapLeafExprs(expression -> (Expression)biFunction.apply((Expression)expression, ifExpressionTree.mLeafExpr));
        } else {
            this.appendNonLeaf(ifExpressionTree, biFunction);
        }
    }

    private void appendNonLeaf(IfExpressionTree ifExpressionTree, BiFunction<Expression, Expression, Expression> biFunction) {
        if (this.isLeaf()) {
            assert (!ifExpressionTree.isLeaf());
            this.mThenCondition = ifExpressionTree.mThenCondition;
            this.mElseCondition = ifExpressionTree.mElseCondition;
            Function<Expression, Expression> function = expression -> (Expression)biFunction.apply(this.mLeafExpr, (Expression)expression);
            this.mThenChild = ifExpressionTree.mThenChild.deepCopy();
            this.mThenChild.mapLeafExprs(function);
            this.mElseChild = ifExpressionTree.mElseChild.deepCopy();
            this.mElseChild.mapLeafExprs(function);
            this.mLeafExpr = null;
        } else {
            this.mThenChild.appendNonLeaf(ifExpressionTree, biFunction);
            this.mElseChild.appendNonLeaf(ifExpressionTree, biFunction);
        }
    }

    public List<Pair<Expression, List<OctDomainState>>> assumeLeafs(OctPostOperator octPostOperator, List<OctDomainState> list) {
        if (this.isLeaf()) {
            return AbsIntUtil.singletonArrayList(new Pair((Object)this.mLeafExpr, list));
        }
        int n = octPostOperator.getMaxParallelStates();
        OctAssumeProcessor octAssumeProcessor = octPostOperator.getAssumeProcessor();
        List<OctDomainState> list2 = octAssumeProcessor.assume(this.mThenCondition, OctPostOperator.deepCopy(list));
        List<OctDomainState> list3 = octAssumeProcessor.assume(this.mElseCondition, list);
        if (list2.size() + list3.size() > n) {
            list2 = OctPostOperator.removeBottomStates(list2);
            list3 = OctPostOperator.removeBottomStates(list3);
        }
        if (list2.size() + list3.size() > n) {
            list2 = OctPostOperator.joinToSingleton(list2);
            list3 = OctPostOperator.joinToSingleton(list3);
        }
        if (list2.size() + list3.size() > n) {
            list2.addAll(list3);
            list2 = OctPostOperator.joinToSingleton(list2);
            list3 = OctPostOperator.deepCopy(list2);
        }
        List<Pair<Expression, List<OctDomainState>>> list4 = this.mThenChild.assumeLeafs(octPostOperator, list2);
        List<Pair<Expression, List<OctDomainState>>> list5 = this.mElseChild.assumeLeafs(octPostOperator, list3);
        list4.addAll(list5);
        return list4;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString("", stringBuilder);
        return stringBuilder.toString();
    }

    private void toString(String string, StringBuilder stringBuilder) {
        if (this.isLeaf()) {
            stringBuilder.append(string + "\u2514\u257c " + BoogiePrettyPrinter.print((Expression)this.mLeafExpr) + "\n");
        } else {
            stringBuilder.append(string + "\u251c\u2500 " + BoogiePrettyPrinter.print((Expression)this.mThenCondition) + "\n");
            this.mThenChild.toString(string + "\u2502  ", stringBuilder);
            stringBuilder.append(string + "\u2514\u2500 " + BoogiePrettyPrinter.print((Expression)this.mElseCondition) + "\n");
            this.mElseChild.toString(string + "   ", stringBuilder);
        }
    }
}

