/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.DatatypeCycleInterpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.Interpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorClauseInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.ArrayList;
import java.util.HashMap;

public class DatatypeInterpolator {
    private final Interpolator mInterpolator;
    private final Theory mTheory;
    private final int mNumInterpolants;
    private HashMap<SymmetricPair<Term>, Interpolator.LitInfo> mEqualityInfos;
    private HashMap<SymmetricPair<Term>, Interpolator.LitInfo> mDisequalityInfos;

    public DatatypeInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
        this.mTheory = interpolator.mTheory;
        this.mNumInterpolants = interpolator.mNumInterpolants;
    }

    public Term[] computeDatatypeInterpolants(InterpolatorClauseInfo interpolatorClauseInfo) {
        Term term;
        this.mEqualityInfos = new HashMap();
        this.mDisequalityInfos = new HashMap();
        Term[] termArray = interpolatorClauseInfo.getLiterals();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            term = termArray[n2];
            ApplicationTerm applicationTerm = (ApplicationTerm)this.mInterpolator.getAtom(term);
            Interpolator.LitInfo litInfo = this.mInterpolator.getAtomOccurenceInfo((Term)applicationTerm);
            Term term2 = applicationTerm.getParameters()[0];
            Term term3 = applicationTerm.getParameters()[1];
            SymmetricPair<Term> symmetricPair = new SymmetricPair<Term>(term2, term3);
            if (applicationTerm != term) {
                this.mEqualityInfos.put(symmetricPair, litInfo);
            } else {
                this.mDisequalityInfos.put(symmetricPair, litInfo);
            }
            ++n2;
        }
        term = (Term)interpolatorClauseInfo.getLemmaAnnotation();
        switch (interpolatorClauseInfo.getLemmaType()) {
            case ":dt-project": {
                return this.interpolateDTProject((Object[])term);
            }
            case ":dt-tester": {
                return this.interpolateDTTester((Object[])term);
            }
            case ":dt-constructor": {
                return this.interpolateDTConstructor((Object[])term);
            }
            case ":dt-injective": {
                return this.interpolateDTInjective((Object[])term);
            }
            case ":dt-disjoint": {
                return this.interpolateDTDisjoint((Object[])term);
            }
            case ":dt-unique": {
                return this.interpolateDTUnique((Object[])term);
            }
            case ":dt-cases": {
                return this.interpolateDTCases((Object[])term);
            }
            case ":dt-cycle": {
                return this.interpolateDTCycle((Object[])term);
            }
        }
        throw new UnsupportedOperationException("lemma unknown in datatype interpolator");
    }

    private Term[] interpolateDTUnique(Object[] objectArray) {
        ApplicationTerm applicationTerm = (ApplicationTerm)objectArray[0];
        Term term = applicationTerm.getParameters()[0];
        Interpolator.LitInfo litInfo = this.mEqualityInfos.get(new SymmetricPair<ApplicationTerm>(this.mTheory.mTrue, applicationTerm));
        ApplicationTerm applicationTerm2 = (ApplicationTerm)objectArray[1];
        Term term2 = applicationTerm2.getParameters()[0];
        Interpolator.LitInfo litInfo2 = this.mEqualityInfos.get(new SymmetricPair<ApplicationTerm>(this.mTheory.mTrue, applicationTerm2));
        Interpolator.LitInfo litInfo3 = term == term2 ? null : this.mEqualityInfos.get(new SymmetricPair<Term>(term, term2));
        Term[] termArray = new Term[this.mNumInterpolants];
        int n = 0;
        while (n < this.mNumInterpolants) {
            Object object;
            if (litInfo.isAorShared(n) && litInfo2.isAorShared(n)) {
                object = litInfo3 != null && litInfo3.isBLocal(n) ? this.mTheory.term("not", new Term[]{this.mTheory.term("=", new Term[]{term, term2})}) : this.mTheory.mFalse;
            } else if (litInfo.isBorShared(n) && litInfo2.isBorShared(n)) {
                object = litInfo3 != null && litInfo3.isALocal(n) ? this.mTheory.term("=", new Term[]{term, term2}) : this.mTheory.mTrue;
            } else {
                ApplicationTerm applicationTerm3;
                ApplicationTerm applicationTerm4 = applicationTerm3 = litInfo.isALocal(n) ? applicationTerm : applicationTerm2;
                if (litInfo3 == null || litInfo3.isBorShared(n)) {
                    object = applicationTerm3;
                } else if (litInfo3.isMixed(n)) {
                    object = this.mTheory.term(applicationTerm3.getFunction(), new Term[]{litInfo3.getMixedVar()});
                } else {
                    Term term3 = litInfo.isALocal(n) ? term2 : term;
                    object = this.mTheory.term(applicationTerm3.getFunction(), new Term[]{term3});
                }
            }
            termArray[n] = object;
            ++n;
        }
        return termArray;
    }

    private Term[] interpolateDTDisjoint(Object[] objectArray) {
        Term[] termArray = new Term[this.mNumInterpolants];
        SymmetricPair<Term> symmetricPair = this.mEqualityInfos.keySet().iterator().next();
        Interpolator.LitInfo litInfo = this.mEqualityInfos.get(symmetricPair);
        int n = 0;
        while (n < this.mNumInterpolants) {
            if (litInfo.isAorShared(n)) {
                termArray[n] = this.mTheory.mFalse;
            } else if (litInfo.isBLocal(n)) {
                termArray[n] = this.mTheory.mTrue;
            } else {
                assert (litInfo.isMixed(n));
                Interpolator.Occurrence occurrence = litInfo.getLhsOccur();
                Term term = occurrence.isALocal(n) ? symmetricPair.getFirst() : symmetricPair.getSecond();
                FunctionSymbol functionSymbol = ((ApplicationTerm)term).getFunction();
                termArray[n] = this.mTheory.term("is", new String[]{functionSymbol.getName()}, null, new Term[]{litInfo.getMixedVar()});
            }
            ++n;
        }
        return termArray;
    }

    private Term[] interpolateDTInjective(Object[] objectArray) {
        Term[] termArray = new Term[this.mNumInterpolants];
        ApplicationTerm applicationTerm = (ApplicationTerm)objectArray[0];
        Term[] termArray2 = applicationTerm.getParameters();
        assert (this.mDisequalityInfos.size() == 1);
        SymmetricPair<Term> symmetricPair = this.mDisequalityInfos.keySet().iterator().next();
        Interpolator.LitInfo litInfo = this.mDisequalityInfos.get(symmetricPair);
        ApplicationTerm applicationTerm2 = (ApplicationTerm)objectArray[2];
        ApplicationTerm applicationTerm3 = (ApplicationTerm)objectArray[3];
        Interpolator.LitInfo litInfo2 = this.mEqualityInfos.get(new SymmetricPair<ApplicationTerm>(applicationTerm2, applicationTerm3));
        String string = null;
        int n = 0;
        while (n < this.mNumInterpolants) {
            if (litInfo.isAorShared(n) && litInfo2.isAorShared(n)) {
                termArray[n] = this.mTheory.mFalse;
            } else if (litInfo.isBorShared(n) && litInfo2.isBorShared(n)) {
                termArray[n] = this.mTheory.mTrue;
            } else if (litInfo.isALocal(n) && litInfo2.isBLocal(n)) {
                termArray[n] = this.mTheory.term("not", new Term[]{applicationTerm});
            } else if (litInfo.isBLocal(n) && litInfo2.isALocal(n)) {
                termArray[n] = applicationTerm;
            } else {
                assert (litInfo2.isMixed(n));
                if (string == null) {
                    string = this.getSelectorForPair(applicationTerm2, applicationTerm3, termArray2);
                }
                Term term = this.mTheory.term(string, new Term[]{litInfo2.getMixedVar()});
                if (litInfo.isAorShared(n)) {
                    var13_13 = litInfo2.getLhsOccur().isALocal(n) ? symmetricPair.getSecond() : symmetricPair.getFirst();
                    termArray[n] = this.mTheory.term("not", new Term[]{this.mTheory.term("=", new Term[]{var13_13, term})});
                } else if (litInfo.isBLocal(n)) {
                    var13_13 = litInfo2.getLhsOccur().isALocal(n) ? symmetricPair.getFirst() : symmetricPair.getSecond();
                    termArray[n] = this.mTheory.term("=", new Term[]{var13_13, term});
                } else {
                    termArray[n] = this.mTheory.term("@EQ", new Term[]{litInfo.getMixedVar(), term});
                }
            }
            ++n;
        }
        return termArray;
    }

    private Term[] interpolateDTConstructor(Object[] objectArray) {
        Term[] termArray = new Term[this.mNumInterpolants];
        ApplicationTerm applicationTerm = (ApplicationTerm)objectArray[0];
        Term[] termArray2 = applicationTerm.getParameters();
        Interpolator.LitInfo litInfo = this.mDisequalityInfos.get(new SymmetricPair<Term>(termArray2[0], termArray2[1]));
        Term term = termArray2[0];
        FunctionSymbol functionSymbol = ((ApplicationTerm)termArray2[1]).getFunction();
        ApplicationTerm applicationTerm2 = (ApplicationTerm)this.mTheory.term("is", new String[]{functionSymbol.getName()}, null, new Term[]{term});
        Interpolator.LitInfo litInfo2 = this.mEqualityInfos.get(new SymmetricPair<ApplicationTerm>(applicationTerm2, this.mTheory.mTrue));
        int n = 0;
        while (n < this.mNumInterpolants) {
            if (litInfo2.isAorShared(n) && litInfo.isAorShared(n)) {
                termArray[n] = this.mTheory.mFalse;
            } else if (litInfo2.isBorShared(n) && litInfo.isBorShared(n)) {
                termArray[n] = this.mTheory.mTrue;
            } else if (litInfo2.isALocal(n) && litInfo.isBLocal(n)) {
                termArray[n] = applicationTerm2;
            } else if (litInfo2.isBLocal(n) && litInfo.isALocal(n)) {
                termArray[n] = this.mTheory.term("not", new Term[]{applicationTerm2});
            } else {
                throw new AssertionError();
            }
            ++n;
        }
        return termArray;
    }

    private Term[] interpolateDTTester(Object[] objectArray) {
        ApplicationTerm applicationTerm = (ApplicationTerm)objectArray[2];
        ApplicationTerm applicationTerm2 = (ApplicationTerm)objectArray[0];
        Term term = ((ApplicationTerm)applicationTerm2.getParameters()[0]).getParameters()[0];
        SymmetricPair<Term> symmetricPair = this.mDisequalityInfos.keySet().iterator().next();
        Interpolator.LitInfo litInfo = this.mDisequalityInfos.get(symmetricPair);
        Term[] termArray = new Term[this.mNumInterpolants];
        if (this.mEqualityInfos.size() == 0) {
            int n = 0;
            while (n < this.mNumInterpolants) {
                if (litInfo.isAorShared(n)) {
                    termArray[n] = this.mTheory.mFalse;
                } else {
                    assert (litInfo.isBLocal(n));
                    termArray[n] = this.mTheory.mTrue;
                }
                ++n;
            }
            return termArray;
        }
        assert (this.mEqualityInfos.size() == 1);
        SymmetricPair<Term> symmetricPair2 = this.mEqualityInfos.keySet().iterator().next();
        Interpolator.LitInfo litInfo2 = this.mEqualityInfos.get(symmetricPair2);
        int n = 0;
        while (n < this.mNumInterpolants) {
            if (litInfo.isAorShared(n) && litInfo2.isAorShared(n)) {
                termArray[n] = this.mTheory.mFalse;
            } else if (litInfo.isBorShared(n) && litInfo2.isBorShared(n)) {
                termArray[n] = this.mTheory.mTrue;
            } else {
                Term term2 = litInfo2.isMixed(n) ? litInfo2.getMixedVar() : term;
                termArray[n] = litInfo.isALocal(n) ? this.mTheory.term("not", new Term[]{this.mTheory.term("is", new String[]{applicationTerm.getFunction().getName()}, null, new Term[]{term2})}) : this.mTheory.term("is", new String[]{applicationTerm.getFunction().getName()}, null, new Term[]{term2});
            }
            ++n;
        }
        return termArray;
    }

    private Term[] interpolateDTProject(Object[] objectArray) {
        ApplicationTerm applicationTerm = (ApplicationTerm)objectArray[0];
        Term[] termArray = new Term[this.mNumInterpolants];
        if (this.mEqualityInfos.size() == 0) {
            Interpolator.LitInfo litInfo = this.mDisequalityInfos.values().iterator().next();
            int n = 0;
            while (n < this.mNumInterpolants) {
                if (litInfo.isAorShared(n)) {
                    termArray[n] = this.mTheory.mFalse;
                } else if (litInfo.isBLocal(n)) {
                    termArray[n] = this.mTheory.mTrue;
                } else {
                    assert (litInfo.isMixed(n));
                    Term term = applicationTerm.getParameters()[1];
                    termArray[n] = this.mTheory.term("@EQ", new Term[]{litInfo.getMixedVar(), term});
                }
                ++n;
            }
            return termArray;
        }
        assert (this.mEqualityInfos.size() == 1);
        if (this.mDisequalityInfos.size() == 0) {
            Interpolator.LitInfo litInfo = this.mDisequalityInfos.values().iterator().next();
            int n = 0;
            while (n < this.mNumInterpolants) {
                if (litInfo.isAorShared(n)) {
                    termArray[n] = this.mTheory.mFalse;
                } else if (litInfo.isBLocal(n)) {
                    termArray[n] = this.mTheory.mTrue;
                } else {
                    throw new AssertionError();
                }
                ++n;
            }
            return termArray;
        }
        assert (this.mDisequalityInfos.size() == 1);
        SymmetricPair<Term> symmetricPair = this.mDisequalityInfos.keySet().iterator().next();
        Interpolator.LitInfo litInfo = this.mDisequalityInfos.get(symmetricPair);
        SymmetricPair<Term> symmetricPair2 = this.mEqualityInfos.keySet().iterator().next();
        Interpolator.LitInfo litInfo2 = this.mEqualityInfos.get(symmetricPair2);
        int n = 0;
        while (n < this.mNumInterpolants) {
            if (litInfo2.isAorShared(n) && litInfo.isAorShared(n)) {
                termArray[n] = this.mTheory.mFalse;
            } else if (litInfo2.isBorShared(n) && litInfo.isBorShared(n)) {
                termArray[n] = this.mTheory.mTrue;
            } else {
                Term term;
                Term term2;
                if (litInfo2.isMixed(n)) {
                    TermVariable termVariable = litInfo2.getMixedVar();
                    ApplicationTerm applicationTerm2 = (ApplicationTerm)applicationTerm.getParameters()[0];
                    FunctionSymbol functionSymbol = applicationTerm2.getFunction();
                    term = term2 = this.mTheory.term(functionSymbol, new Term[]{termVariable});
                } else {
                    term = applicationTerm.getParameters()[0];
                    term2 = applicationTerm.getParameters()[1];
                }
                termArray[n] = litInfo.isMixed(n) ? this.mTheory.term("@EQ", new Term[]{litInfo.getMixedVar(), term2}) : (litInfo.isALocal(n) ? this.mTheory.term("not", new Term[]{this.mTheory.term("=", new Term[]{term, applicationTerm.getParameters()[1]})}) : this.mTheory.term("=", new Term[]{term, applicationTerm.getParameters()[1]}));
            }
            ++n;
        }
        return termArray;
    }

    private Term[] interpolateDTCases(Object[] objectArray) {
        Term[] termArray = new Term[this.mNumInterpolants];
        ApplicationTerm applicationTerm = (ApplicationTerm)objectArray[0];
        Term term = applicationTerm.getParameters()[0];
        Interpolator.LitInfo litInfo = this.mEqualityInfos.get(new SymmetricPair<ApplicationTerm>(this.mTheory.mFalse, applicationTerm));
        int n = 0;
        while (n < this.mNumInterpolants) {
            boolean bl = litInfo.isBorShared(n);
            ArrayList<Term> arrayList = new ArrayList<Term>();
            int n2 = 1;
            while (n2 < objectArray.length) {
                Term term2 = (Term)objectArray[n2];
                Term term3 = ((ApplicationTerm)term2).getParameters()[0];
                Interpolator.LitInfo litInfo2 = this.mEqualityInfos.get(new SymmetricPair<ApplicationTerm>((ApplicationTerm)term2, this.mTheory.mFalse));
                Interpolator.LitInfo litInfo3 = this.mEqualityInfos.get(new SymmetricPair<Term>(term3, term));
                FunctionSymbol functionSymbol = ((ApplicationTerm)term2).getFunction();
                if (bl ? litInfo2.isBorShared(n) : litInfo2.isAorShared(n)) {
                    assert (litInfo3 == null || !litInfo3.isMixed(n));
                    if (litInfo3 != null && (bl ? litInfo3.isALocal(n) : litInfo3.isBLocal(n))) {
                        var15_16 = this.mTheory.term("=", new Term[]{term, term3});
                        arrayList.add((Term)(bl ? var15_16 : this.mTheory.term("not", new Term[]{var15_16})));
                    }
                } else {
                    var15_16 = litInfo3 == null || (bl ? litInfo3.isALocal(n) : litInfo3.isBLocal(n)) ? term : (litInfo3.isMixed(n) ? litInfo3.getMixedVar() : term3);
                    Term term4 = this.mTheory.term(functionSymbol, new Term[]{var15_16});
                    arrayList.add(bl ? this.mTheory.term("not", new Term[]{term4}) : term4);
                }
                ++n2;
            }
            Term[] termArray2 = arrayList.toArray(new Term[arrayList.size()]);
            termArray[n] = bl ? this.mTheory.and(termArray2) : this.mTheory.or(termArray2);
            ++n;
        }
        return termArray;
    }

    private String getSelectorForPair(ApplicationTerm applicationTerm, ApplicationTerm applicationTerm2, Term[] termArray) {
        DataType dataType = (DataType)applicationTerm.getSort().getSortSymbol();
        DataType.Constructor constructor = dataType.findConstructor(applicationTerm.getFunction().getName());
        String[] stringArray = constructor.getSelectors();
        Term[] termArray2 = applicationTerm.getParameters();
        Term[] termArray3 = applicationTerm2.getParameters();
        int n = 0;
        while (n < termArray2.length) {
            if (termArray[0] == termArray2[n] && termArray[1] == termArray3[n]) {
                return stringArray[n];
            }
            ++n;
        }
        throw new AssertionError((Object)"child term not found in constructors");
    }

    private Term[] interpolateDTCycle(Object[] objectArray) {
        assert (objectArray[0] == ":cycle");
        Term[] termArray = (Term[])objectArray[1];
        assert (this.mDisequalityInfos.isEmpty());
        return new DatatypeCycleInterpolator(this.mInterpolator, this.mEqualityInfos).interpolateCycle(termArray);
    }
}

