/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class AffineFunction
implements Serializable {
    private static final long serialVersionUID = -3142354398708751882L;
    protected final Map<IProgramVar, BigInteger> mCoefficients = new LinkedHashMap<IProgramVar, BigInteger>();
    protected BigInteger mConstant = BigInteger.ZERO;

    public boolean isConstant() {
        return this.mCoefficients.isEmpty();
    }

    public BigInteger getConstant() {
        return this.mConstant;
    }

    public void setConstant(BigInteger bigInteger) {
        this.mConstant = bigInteger;
    }

    public Set<IProgramVar> getVariables() {
        return this.mCoefficients.keySet();
    }

    public BigInteger get(IProgramVar iProgramVar) {
        return this.mCoefficients.get(iProgramVar);
    }

    public void put(IProgramVar iProgramVar, BigInteger bigInteger) {
        if (bigInteger.equals(BigInteger.ZERO)) {
            this.mCoefficients.remove(iProgramVar);
        } else {
            this.mCoefficients.put(iProgramVar, bigInteger);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Map.Entry<IProgramVar, BigInteger> entry : this.mCoefficients.entrySet()) {
            if (!bl) {
                stringBuilder.append(entry.getValue().compareTo(BigInteger.ZERO) < 0 ? " - " : " + ");
            } else if (entry.getValue().compareTo(BigInteger.ZERO) < 0) {
                stringBuilder.append("-");
            }
            stringBuilder.append(entry.getValue().abs());
            stringBuilder.append("*");
            stringBuilder.append(entry.getKey());
            bl = false;
        }
        if (!this.mConstant.equals(BigInteger.ZERO) || bl) {
            if (!bl) {
                stringBuilder.append(this.mConstant.compareTo(BigInteger.ZERO) < 0 ? " - " : " + ");
                stringBuilder.append(this.mConstant.abs());
            } else {
                stringBuilder.append(this.mConstant);
            }
        }
        return stringBuilder.toString();
    }

    private static Term constructSummand(Script script, Term term, BigInteger bigInteger) {
        if (bigInteger.equals(BigInteger.ONE)) {
            return term;
        }
        return script.term("*", new Term[]{SmtUtils.constructIntValue((Script)script, (BigInteger)bigInteger), term});
    }

    public Term asTerm(Script script) throws SMTLIBException {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (Map.Entry<IProgramVar, BigInteger> entry : this.mCoefficients.entrySet()) {
            Term term = ReplacementVarUtils.getDefinition((IProgramVar)entry.getKey());
            arrayList.add(AffineFunction.constructSummand(script, term, entry.getValue()));
        }
        if (!this.mConstant.equals(BigInteger.ZERO)) {
            arrayList.add(SmtUtils.constructIntValue((Script)script, (BigInteger)this.mConstant));
        }
        return SmtUtils.sum((Script)script, (Sort)SmtSortUtils.getRealSort((Script)script), (Term[])arrayList.toArray(new Term[arrayList.size()]));
    }

    public Rational evaluate(Map<IProgramVar, Rational> map) {
        Rational rational = Rational.ZERO;
        for (Map.Entry<IProgramVar, BigInteger> entry : this.mCoefficients.entrySet()) {
            Rational rational2 = map.get(entry.getKey());
            if (rational2 == null) {
                rational2 = Rational.ZERO;
            }
            rational.add(rational2.mul(entry.getValue()));
        }
        rational.add(Rational.valueOf((BigInteger)this.mConstant, (BigInteger)BigInteger.ONE));
        return rational;
    }
}

