/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitvecLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BitvectorConstant;
import java.math.BigInteger;

public class BitvectorFactory {
    public static final String AUXILIARY_FUNCTION_PREFIX = "~";

    public static BitvectorConstant.BvOp getSupportedBitvectorOperation(String string) {
        try {
            return BitvectorConstant.BvOp.valueOf((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static String generateBoogieFunctionName(BitvectorConstant.BvOp bvOp, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        switch (bvOp) {
            case bvadd: 
            case bvsub: 
            case bvmul: 
            case bvudiv: 
            case bvurem: 
            case bvsdiv: 
            case bvsrem: 
            case bvsmod: 
            case bvand: 
            case bvor: 
            case bvxor: 
            case bvnot: 
            case bvneg: 
            case bvshl: 
            case bvlshr: 
            case bvashr: 
            case bvult: 
            case bvule: 
            case bvugt: 
            case bvuge: 
            case bvslt: 
            case bvsle: 
            case bvsgt: 
            case bvsge: {
                break;
            }
            case extract: 
            case concat: {
                throw new IllegalArgumentException("Boogie has native support for this operation.");
            }
            case sign_extend: 
            case zero_extend: {
                throw new IllegalArgumentException("Call method for extend.");
            }
            default: {
                throw new MatchException(null, null);
            }
        }
        return AUXILIARY_FUNCTION_PREFIX + bvOp.toString() + AUXILIARY_FUNCTION_PREFIX + n;
    }

    public static Expression constructUnaryOperation(ILocation iLocation, BitvectorConstant.BvOp bvOp, Expression expression) {
        if (expression instanceof BitvecLiteral) {
            BitvectorConstant bitvectorConstant = BitvectorFactory.toConstant((BitvecLiteral)expression);
            BitvectorConstant.BitvectorConstantOperationResult bitvectorConstantOperationResult = BitvectorConstant.apply((BitvectorConstant.BvOp)bvOp, (BitvectorConstant[])new BitvectorConstant[]{bitvectorConstant});
            return BitvectorFactory.toBitvectorLiteral(iLocation, bitvectorConstantOperationResult.getBvResult());
        }
        String string = BitvectorFactory.generateBoogieFunctionName(bvOp, BitvectorFactory.isBitvectorSort(expression.getType()));
        Expression expression2 = ExpressionFactory.constructFunctionApplication(iLocation, string, new Expression[]{expression}, (BoogieType)expression.getType());
        return expression2;
    }

    public static Expression constructBinaryOperationForMultipleArguments(ILocation iLocation, BitvectorConstant.BvOp bvOp, Expression ... expressionArray) {
        if (expressionArray.length <= 1) {
            throw new IllegalArgumentException("not binary");
        }
        Expression expression = expressionArray[0];
        int n = 1;
        while (n < expressionArray.length) {
            expression = BitvectorFactory.constructBinaryBitvectorOperation(iLocation, bvOp, expression, expressionArray[n]);
            ++n;
        }
        return expression;
    }

    @Deprecated
    public static String getBitvectorSmtFunctionNameFromCFunctionName(String string) {
        return string.substring(1).replaceAll("\\d+", "");
    }

    public static Expression constructExtendOperation(ILocation iLocation, BitvectorConstant.ExtendOperation extendOperation, BigInteger bigInteger, Expression expression) {
        if (expression instanceof BitvecLiteral) {
            BitvectorConstant bitvectorConstant = BitvectorFactory.toConstant((BitvecLiteral)expression);
            BitvectorConstant bitvectorConstant2 = switch (extendOperation) {
                case BitvectorConstant.ExtendOperation.sign_extend -> BitvectorConstant.sign_extend((BitvectorConstant)bitvectorConstant, (BigInteger)bigInteger);
                case BitvectorConstant.ExtendOperation.zero_extend -> BitvectorConstant.zero_extend((BitvectorConstant)bitvectorConstant, (BigInteger)bigInteger);
                default -> throw new MatchException(null, null);
            };
            return ExpressionFactory.createBitvecLiteral(iLocation, bitvectorConstant2.getValue().toString(), bitvectorConstant2.getIndex().intValueExact());
        }
        if (expression.getType() == null) {
            throw new UnsupportedOperationException("Need type to determine bitsize!");
        }
        int n = BitvectorFactory.isBitvectorSort(expression.getType());
        int n2 = BigInteger.valueOf(n).add(bigInteger).intValueExact();
        BoogieType boogieType = BoogieType.createBitvectorType(n2);
        String string = BitvectorFactory.generateBoogieFunctionNameForExtend(extendOperation, n, n2);
        return ExpressionFactory.constructFunctionApplication(iLocation, string, new Expression[]{expression}, boogieType);
    }

    public static String generateBoogieFunctionNameForExtend(BitvectorConstant.ExtendOperation extendOperation, int n, int n2) {
        return String.join((CharSequence)AUXILIARY_FUNCTION_PREFIX, "", extendOperation.toString(), Integer.toString(n2), Integer.toString(n));
    }

    public static Expression constructBinaryBitvectorOperation(ILocation iLocation, BitvectorConstant.BvOp bvOp, Expression ... expressionArray) {
        BitvectorConstant bitvectorConstant;
        BitvectorConstant bitvectorConstant2;
        assert (expressionArray.length == 2) : "Binary expression cannot have " + expressionArray.length + " arguments";
        if (expressionArray[0] instanceof BitvecLiteral) {
            bitvectorConstant2 = BitvectorFactory.toConstant((BitvecLiteral)expressionArray[0]);
            if (BitvectorFactory.isNeutralLeft(bvOp, bitvectorConstant2)) {
                return expressionArray[1];
            }
            if (BitvectorFactory.isAnnihilatingLeft(bvOp, bitvectorConstant2)) {
                return expressionArray[0];
            }
        } else {
            bitvectorConstant2 = null;
        }
        if (expressionArray[1] instanceof BitvecLiteral) {
            bitvectorConstant = BitvectorFactory.toConstant((BitvecLiteral)expressionArray[1]);
            if (BitvectorFactory.isNeutralRight(bvOp, bitvectorConstant)) {
                return expressionArray[0];
            }
            if (BitvectorFactory.isAnnihilatingRight(bvOp, bitvectorConstant)) {
                return expressionArray[1];
            }
        } else {
            bitvectorConstant = null;
        }
        if (bitvectorConstant2 != null && bitvectorConstant != null) {
            return BitvectorFactory.computeBinaryBitvectorExpression(iLocation, bvOp, bitvectorConstant2, bitvectorConstant);
        }
        if (bitvectorConstant2 == null && bitvectorConstant == null) {
            return BitvectorFactory.constructBitvectorFunctionApplication(iLocation, bvOp, expressionArray);
        }
        if (bvOp.isCommutative()) {
            return BitvectorFactory.simplifyBinaryAssociativeExpression(iLocation, bvOp, expressionArray, bitvectorConstant2, bitvectorConstant);
        }
        return BitvectorFactory.constructBitvectorFunctionApplication(iLocation, bvOp, expressionArray);
    }

    private static FunctionApplication simplifyBinaryAssociativeExpression(ILocation iLocation, BitvectorConstant.BvOp bvOp, Expression[] expressionArray, BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        Expression expression;
        FunctionApplication functionApplication;
        String string;
        BitvectorConstant.BvOp bvOp2;
        assert (bvOp != null);
        if (bitvectorConstant2 == null && expressionArray[1] instanceof FunctionApplication && bvOp == (bvOp2 = BitvectorFactory.getSupportedBitvectorOperation(BitvectorFactory.getBitvectorSmtFunctionNameFromCFunctionName(string = (functionApplication = (FunctionApplication)expressionArray[1]).getIdentifier()))) && (expression = functionApplication.getArguments()[0]) instanceof BitvecLiteral) {
            Expression expression2 = BitvectorFactory.computeBinaryBitvectorExpression(iLocation, bvOp, bitvectorConstant, BitvectorFactory.toConstant((BitvecLiteral)expression));
            return BitvectorFactory.constructBitvectorFunctionApplication(iLocation, bvOp, expression2, functionApplication.getArguments()[1]);
        }
        if (bitvectorConstant == null) {
            return BitvectorFactory.simplifyBinaryAssociativeExpression(iLocation, bvOp, new Expression[]{expressionArray[1], expressionArray[0]}, bitvectorConstant2, bitvectorConstant);
        }
        return BitvectorFactory.constructBitvectorFunctionApplication(iLocation, bvOp, expressionArray);
    }

    private static Expression computeBinaryBitvectorExpression(ILocation iLocation, BitvectorConstant.BvOp bvOp, BitvectorConstant bitvectorConstant, BitvectorConstant bitvectorConstant2) {
        if (bvOp.isBoolean()) {
            BitvectorConstant.BitvectorConstantOperationResult bitvectorConstantOperationResult = BitvectorConstant.apply((BitvectorConstant.BvOp)bvOp, (BitvectorConstant[])new BitvectorConstant[]{bitvectorConstant, bitvectorConstant2});
            assert (bitvectorConstantOperationResult.isBoolean());
            return BitvectorFactory.toBooleanLiteral(iLocation, bitvectorConstantOperationResult.getBooleanResult());
        }
        BitvectorConstant.BitvectorConstantOperationResult bitvectorConstantOperationResult = BitvectorConstant.apply((BitvectorConstant.BvOp)bvOp, (BitvectorConstant[])new BitvectorConstant[]{bitvectorConstant, bitvectorConstant2});
        assert (!bitvectorConstantOperationResult.isBoolean());
        return BitvectorFactory.toBitvectorLiteral(iLocation, bitvectorConstantOperationResult.getBvResult());
    }

    static BitvectorConstant toConstant(BitvecLiteral bitvecLiteral) {
        return new BitvectorConstant(new BigInteger(bitvecLiteral.getValue()), BigInteger.valueOf(bitvecLiteral.getLength()));
    }

    private static boolean isAnnihilatingLeft(BitvectorConstant.BvOp bvOp, BitvectorConstant bitvectorConstant) {
        return switch (bvOp) {
            case BitvectorConstant.BvOp.bvmul, BitvectorConstant.BvOp.bvudiv, BitvectorConstant.BvOp.bvurem, BitvectorConstant.BvOp.bvsdiv, BitvectorConstant.BvOp.bvsrem, BitvectorConstant.BvOp.bvshl, BitvectorConstant.BvOp.bvlshr -> bitvectorConstant.isZero();
            case BitvectorConstant.BvOp.zero_extend, BitvectorConstant.BvOp.extract, BitvectorConstant.BvOp.bvadd, BitvectorConstant.BvOp.bvsub, BitvectorConstant.BvOp.bvand, BitvectorConstant.BvOp.bvor, BitvectorConstant.BvOp.bvxor, BitvectorConstant.BvOp.bvnot, BitvectorConstant.BvOp.bvneg, BitvectorConstant.BvOp.bvashr, BitvectorConstant.BvOp.bvult, BitvectorConstant.BvOp.bvule, BitvectorConstant.BvOp.bvugt, BitvectorConstant.BvOp.bvuge, BitvectorConstant.BvOp.bvslt, BitvectorConstant.BvOp.bvsle, BitvectorConstant.BvOp.bvsgt, BitvectorConstant.BvOp.bvsge -> false;
            case BitvectorConstant.BvOp.sign_extend, BitvectorConstant.BvOp.concat, BitvectorConstant.BvOp.bvsmod -> throw new UnsupportedOperationException("Currently unsupported: " + String.valueOf(bvOp));
            default -> throw new MatchException(null, null);
        };
    }

    private static boolean isAnnihilatingRight(BitvectorConstant.BvOp bvOp, BitvectorConstant bitvectorConstant) {
        return switch (bvOp) {
            case BitvectorConstant.BvOp.bvadd, BitvectorConstant.BvOp.bvmul, BitvectorConstant.BvOp.bvand, BitvectorConstant.BvOp.bvor, BitvectorConstant.BvOp.bvxor -> BitvectorFactory.isAnnihilatingLeft(bvOp, bitvectorConstant);
            case BitvectorConstant.BvOp.zero_extend, BitvectorConstant.BvOp.extract, BitvectorConstant.BvOp.bvsub, BitvectorConstant.BvOp.bvudiv, BitvectorConstant.BvOp.bvurem, BitvectorConstant.BvOp.bvsdiv, BitvectorConstant.BvOp.bvsrem, BitvectorConstant.BvOp.bvnot, BitvectorConstant.BvOp.bvneg, BitvectorConstant.BvOp.bvshl, BitvectorConstant.BvOp.bvlshr, BitvectorConstant.BvOp.bvashr, BitvectorConstant.BvOp.bvult, BitvectorConstant.BvOp.bvule, BitvectorConstant.BvOp.bvugt, BitvectorConstant.BvOp.bvuge, BitvectorConstant.BvOp.bvslt, BitvectorConstant.BvOp.bvsle, BitvectorConstant.BvOp.bvsgt, BitvectorConstant.BvOp.bvsge -> false;
            case BitvectorConstant.BvOp.sign_extend, BitvectorConstant.BvOp.concat, BitvectorConstant.BvOp.bvsmod -> throw new UnsupportedOperationException("Currently unsupported: " + String.valueOf(bvOp));
            default -> throw new MatchException(null, null);
        };
    }

    private static boolean isNeutralLeft(BitvectorConstant.BvOp bvOp, BitvectorConstant bitvectorConstant) {
        return switch (bvOp) {
            case BitvectorConstant.BvOp.bvadd, BitvectorConstant.BvOp.bvor -> bitvectorConstant.isZero();
            case BitvectorConstant.BvOp.bvmul -> bitvectorConstant.isOne();
            case BitvectorConstant.BvOp.bvand -> bitvectorConstant.equals((Object)BitvectorConstant.maxValue((BigInteger)bitvectorConstant.getIndex()));
            case BitvectorConstant.BvOp.zero_extend, BitvectorConstant.BvOp.extract, BitvectorConstant.BvOp.bvsub, BitvectorConstant.BvOp.bvudiv, BitvectorConstant.BvOp.bvurem, BitvectorConstant.BvOp.bvsdiv, BitvectorConstant.BvOp.bvsrem, BitvectorConstant.BvOp.bvxor, BitvectorConstant.BvOp.bvnot, BitvectorConstant.BvOp.bvneg, BitvectorConstant.BvOp.bvshl, BitvectorConstant.BvOp.bvlshr, BitvectorConstant.BvOp.bvashr, BitvectorConstant.BvOp.bvult, BitvectorConstant.BvOp.bvule, BitvectorConstant.BvOp.bvugt, BitvectorConstant.BvOp.bvuge, BitvectorConstant.BvOp.bvslt, BitvectorConstant.BvOp.bvsle, BitvectorConstant.BvOp.bvsgt, BitvectorConstant.BvOp.bvsge -> false;
            case BitvectorConstant.BvOp.sign_extend, BitvectorConstant.BvOp.concat, BitvectorConstant.BvOp.bvsmod -> throw new UnsupportedOperationException("Currently unsupported: " + String.valueOf(bvOp));
            default -> throw new MatchException(null, null);
        };
    }

    private static boolean isNeutralRight(BitvectorConstant.BvOp bvOp, BitvectorConstant bitvectorConstant) {
        return switch (bvOp) {
            case BitvectorConstant.BvOp.bvadd, BitvectorConstant.BvOp.bvmul, BitvectorConstant.BvOp.bvand, BitvectorConstant.BvOp.bvor, BitvectorConstant.BvOp.bvxor -> BitvectorFactory.isNeutralLeft(bvOp, bitvectorConstant);
            case BitvectorConstant.BvOp.bvsub, BitvectorConstant.BvOp.bvshl, BitvectorConstant.BvOp.bvlshr, BitvectorConstant.BvOp.bvashr -> bitvectorConstant.isZero();
            case BitvectorConstant.BvOp.bvudiv, BitvectorConstant.BvOp.bvsdiv -> bitvectorConstant.isOne();
            case BitvectorConstant.BvOp.zero_extend, BitvectorConstant.BvOp.extract, BitvectorConstant.BvOp.bvurem, BitvectorConstant.BvOp.bvsrem, BitvectorConstant.BvOp.bvnot, BitvectorConstant.BvOp.bvneg, BitvectorConstant.BvOp.bvult, BitvectorConstant.BvOp.bvule, BitvectorConstant.BvOp.bvugt, BitvectorConstant.BvOp.bvuge, BitvectorConstant.BvOp.bvslt, BitvectorConstant.BvOp.bvsle, BitvectorConstant.BvOp.bvsgt, BitvectorConstant.BvOp.bvsge -> false;
            case BitvectorConstant.BvOp.sign_extend, BitvectorConstant.BvOp.concat, BitvectorConstant.BvOp.bvsmod -> throw new UnsupportedOperationException("Currently unsupported: " + String.valueOf(bvOp));
            default -> throw new MatchException(null, null);
        };
    }

    private static BooleanLiteral toBooleanLiteral(ILocation iLocation, boolean bl) {
        return new BooleanLiteral(iLocation, BoogieType.TYPE_BOOL, bl);
    }

    private static BitvecLiteral toBitvectorLiteral(ILocation iLocation, BitvectorConstant bitvectorConstant) {
        int n = bitvectorConstant.getIndex().intValueExact();
        return new BitvecLiteral(iLocation, BoogieType.createBitvectorType(n), bitvectorConstant.getValue().toString(), n);
    }

    private static int isBitvectorSort(IBoogieType iBoogieType) {
        BoogiePrimitiveType boogiePrimitiveType;
        int n = iBoogieType instanceof BoogiePrimitiveType ? ((boogiePrimitiveType = (BoogiePrimitiveType)iBoogieType).getTypeCode() > 0 ? boogiePrimitiveType.getTypeCode() : -1) : -1;
        return n;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static FunctionApplication constructBitvectorFunctionApplication(ILocation iLocation, BitvectorConstant.BvOp bvOp, Expression ... expressionArray) {
        if (bvOp.getArity() != expressionArray.length) {
            throw new IllegalArgumentException("Wrong number of arguments");
        }
        if (bvOp.isBoolean()) {
            BoogiePrimitiveType boogiePrimitiveType = BoogieType.TYPE_BOOL;
        } else {
            BoogieType boogieType = (BoogieType)expressionArray[0].getType();
        }
        switch (bvOp) {
            case bvadd: 
            case bvsub: 
            case bvmul: 
            case bvudiv: 
            case bvurem: 
            case bvsdiv: 
            case bvsrem: 
            case bvsmod: 
            case bvand: 
            case bvor: 
            case bvxor: 
            case bvnot: 
            case bvneg: 
            case bvshl: 
            case bvlshr: 
            case bvashr: 
            case bvult: 
            case bvule: 
            case bvugt: 
            case bvuge: 
            case bvslt: 
            case bvsle: 
            case bvsgt: 
            case bvsge: {
                void var3_5;
                String string = BitvectorFactory.generateBoogieFunctionName(bvOp, BitvectorFactory.isBitvectorSort(expressionArray[0].getType()));
                return new FunctionApplication(iLocation, (IBoogieType)var3_5, string, expressionArray);
            }
            case extract: 
            case concat: {
                throw new IllegalArgumentException("Boogie has native support for " + String.valueOf(bvOp));
            }
            case sign_extend: 
            case zero_extend: {
                throw new IllegalArgumentException("Should be handled by extend method." + String.valueOf(bvOp));
            }
        }
        throw new MatchException(null, null);
    }
}

