/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Axiom;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ConstDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.TypeDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CEnum;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CNamed;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CStructOrUnion;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.CDeclaration;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class StaticObjectsHandler {
    private final List<Statement> mStatementsForUltimateInit;
    private final List<ConstDeclaration> mConstDeclarations = new ArrayList<ConstDeclaration>();
    private final List<Axiom> mAxioms = new ArrayList<Axiom>();
    private boolean mIsFrozen = false;
    private int mDeclCounter;
    private final HashRelation<Pair<String, IASTNode>, Triple<VariableDeclaration, CDeclaration, Integer>> mGlobalVarsForCVars = new HashRelation();
    private final List<VariableDeclaration> mGlobalVarsWithoutCVar = new ArrayList<VariableDeclaration>();
    private final Map<TypeDeclaration, CDeclaration> mTypeDeclarationToCDeclaration;
    private final Map<String, TypeDeclaration> mIncompleteType2TypeDecl;
    private final ILogger mLogger;

    public StaticObjectsHandler(ILogger iLogger) {
        this.mStatementsForUltimateInit = new ArrayList<Statement>();
        this.mTypeDeclarationToCDeclaration = new LinkedHashMap<TypeDeclaration, CDeclaration>();
        this.mIncompleteType2TypeDecl = new HashMap<String, TypeDeclaration>();
        this.mLogger = iLogger;
    }

    public List<Declaration> getGlobalDeclarations() {
        assert (this.mIsFrozen);
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        arrayList.addAll(this.mTypeDeclarationToCDeclaration.keySet());
        arrayList.addAll(this.mConstDeclarations);
        arrayList.addAll(this.mAxioms);
        arrayList.addAll(this.mGlobalVarsWithoutCVar);
        for (Pair<VariableDeclaration, CDeclaration> pair : this.computeSuitableGlobalVarDecls()) {
            arrayList.add((Declaration)pair.getFirst());
        }
        return arrayList;
    }

    public List<Statement> getStatementsForUltimateInit() {
        assert (this.mIsFrozen);
        return this.mStatementsForUltimateInit;
    }

    public void freeze() {
        assert (!this.mIsFrozen) : "called freeze but is already frozen";
        this.mIsFrozen = true;
    }

    public void addGlobalTypeDeclaration(TypeDeclaration typeDeclaration, CDeclaration cDeclaration) {
        assert (typeDeclaration != null && cDeclaration != null) : "Part of global type declaration is null";
        this.mTypeDeclarationToCDeclaration.put(typeDeclaration, cDeclaration);
        ICType iCType = cDeclaration.getType();
        if (iCType.isIncomplete() && !cDeclaration.getType().isVoidType()) {
            if (iCType instanceof CStructOrUnion) {
                this.mIncompleteType2TypeDecl.put(((CStructOrUnion)iCType).getName(), typeDeclaration);
            } else if (iCType instanceof CEnum) {
                this.mIncompleteType2TypeDecl.put(((CEnum)iCType).getName(), typeDeclaration);
            } else if (!(iCType instanceof CNamed)) {
                throw new AssertionError((Object)("missing support for global incomplete " + String.valueOf(iCType)));
            }
        }
    }

    public void addGlobalVariableDeclaration(VariableDeclaration variableDeclaration, CDeclaration cDeclaration, IASTNode iASTNode) {
        this.mGlobalVarsForCVars.addPair((Object)new Pair((Object)cDeclaration.getName(), (Object)iASTNode), (Object)new Triple((Object)variableDeclaration, (Object)cDeclaration, (Object)this.mDeclCounter));
        ++this.mDeclCounter;
    }

    public List<Pair<VariableDeclaration, CDeclaration>> computeSuitableGlobalVarDecls() {
        ArrayList<Triple<VariableDeclaration, CDeclaration, Integer>> arrayList = new ArrayList<Triple<VariableDeclaration, CDeclaration, Integer>>();
        for (Pair pair : this.mGlobalVarsForCVars.getDomain()) {
            Set set = this.mGlobalVarsForCVars.getImage((Object)pair);
            Triple<VariableDeclaration, CDeclaration, Integer> triple2 = StaticObjectsHandler.computeSuitableVarDecl(set);
            arrayList.add(triple2);
        }
        return arrayList.stream().sorted(Comparator.comparingInt(Triple::getThird)).map(triple -> new Pair((Object)((VariableDeclaration)triple.getFirst()), (Object)((CDeclaration)triple.getSecond()))).collect(Collectors.toList());
    }

    private static Triple<VariableDeclaration, CDeclaration, Integer> computeSuitableVarDecl(Set<Triple<VariableDeclaration, CDeclaration, Integer>> set) {
        if (set.size() == 1) {
            return set.iterator().next();
        }
        Triple<VariableDeclaration, CDeclaration, Integer> triple = null;
        for (Triple<VariableDeclaration, CDeclaration, Integer> triple2 : set) {
            if (((CDeclaration)triple2.getSecond()).getInitializer() == null) continue;
            if (triple == null) {
                triple = triple2;
                continue;
            }
            throw new AssertionError((Object)("Two decls with initializer " + ((CDeclaration)triple2.getSecond()).getName()));
        }
        if (triple == null) {
            triple = set.iterator().next();
        }
        return triple;
    }

    public void addGlobalConstDeclaration(ConstDeclaration constDeclaration, CDeclaration cDeclaration, Axiom axiom) {
        this.mConstDeclarations.add(constDeclaration);
        if (axiom != null) {
            this.mAxioms.add(axiom);
        }
    }

    public void completeTypeDeclaration(String string, ICType iCType, ITypeHandler iTypeHandler) {
        TypeDeclaration typeDeclaration = this.mIncompleteType2TypeDecl.remove(string);
        if (typeDeclaration == null) {
            return;
        }
        CDeclaration cDeclaration = this.mTypeDeclarationToCDeclaration.get(typeDeclaration);
        assert (cDeclaration != null) : "We have a Boogie declaration, we should also have a C declaration: " + typeDeclaration.getIdentifier();
        TypeDeclaration typeDeclaration2 = new TypeDeclaration(typeDeclaration.getLocation(), typeDeclaration.getAttributes(), typeDeclaration.isFinite(), typeDeclaration.getIdentifier(), typeDeclaration.getTypeParams(), iTypeHandler.cType2AstType(typeDeclaration.getLocation(), iCType));
        this.mTypeDeclarationToCDeclaration.remove(typeDeclaration);
        this.addGlobalTypeDeclaration(typeDeclaration2, cDeclaration);
    }

    public void addGlobalVarDeclarationWithoutCDeclaration(VariableDeclaration variableDeclaration) {
        this.mGlobalVarsWithoutCVar.add(variableDeclaration);
    }

    public void addStatementsForUltimateInit(List<Statement> list) {
        assert (!this.mIsFrozen);
        this.mStatementsForUltimateInit.addAll(list);
    }
}

