/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Expression2Term;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.DefaultIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.SmtFunctionsAndAxioms;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ThreadInstance;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IForkActionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IJoinActionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgForkThreadCurrentTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgJoinThreadCurrentTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BidirectionalMap;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class ProcedureMultiplier {
    private final BasicIcfg<IcfgLocation> mIcfg;
    private final HashRelation<String, String> mCopyDirectives;
    private final ManagedScript mMgdScript;
    private final Set<String> mNewProcedures;
    private final DefaultIcfgSymbolTable mNewSymbolTable;
    private final Map<String, Map<ILocalProgramVar, ILocalProgramVar>> mLocalVariableMapping;
    private final Map<Term, Term> mVariableBacktranslationMapping = new HashMap<Term, Term>();
    private final BidirectionalMap<Pair<IcfgLocation, String>, IcfgLocation> mLocationMap = new BidirectionalMap();
    private final BidirectionalMap<Pair<IcfgEdge, String>, IcfgEdge> mEdgeMap = new BidirectionalMap();
    private final List<IcfgForkThreadCurrentTransition> mForkCurrentThreads = new ArrayList<IcfgForkThreadCurrentTransition>();
    private final List<IcfgJoinThreadCurrentTransition> mJoinCurrentThreads = new ArrayList<IcfgJoinThreadCurrentTransition>();

    public ProcedureMultiplier(IUltimateServiceProvider iUltimateServiceProvider, BasicIcfg<IcfgLocation> basicIcfg, List<ThreadInstance> list) {
        this(iUltimateServiceProvider, basicIcfg, ProcedureMultiplier.generateCopyDirectives(list));
    }

    public ProcedureMultiplier(IUltimateServiceProvider iUltimateServiceProvider, BasicIcfg<IcfgLocation> basicIcfg, HashRelation<String, String> hashRelation) {
        this.mIcfg = basicIcfg;
        this.mCopyDirectives = hashRelation;
        CfgSmtToolkit cfgSmtToolkit = basicIcfg.getCfgSmtToolkit();
        this.mNewProcedures = DataStructureUtils.union(cfgSmtToolkit.getProcedures(), (Set)hashRelation.projectToRange());
        this.mNewSymbolTable = new DefaultIcfgSymbolTable(cfgSmtToolkit.getSymbolTable(), this.mNewProcedures);
        this.mMgdScript = basicIcfg.getCfgSmtToolkit().getManagedScript();
        this.mLocalVariableMapping = this.duplicateVariables();
        for (String string : hashRelation.getDomain()) {
            this.duplicateProcedureEdges(string);
        }
    }

    public static void duplicateProcedures(IUltimateServiceProvider iUltimateServiceProvider, BasicIcfg<IcfgLocation> basicIcfg, List<ThreadInstance> list, BlockEncodingBacktranslator blockEncodingBacktranslator, Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>> map, List<IIcfgForkTransitionThreadCurrent<IcfgLocation>> list2, List<IIcfgJoinTransitionThreadCurrent<IcfgLocation>> list3) {
        ProcedureMultiplier procedureMultiplier = new ProcedureMultiplier(iUltimateServiceProvider, basicIcfg, list);
        list2.addAll(procedureMultiplier.mForkCurrentThreads);
        list3.addAll(procedureMultiplier.mJoinCurrentThreads);
        procedureMultiplier.updateThreadInstanceMap(map);
        procedureMultiplier.updateBacktranslator(blockEncodingBacktranslator);
    }

    public Map<ILocalProgramVar, ILocalProgramVar> getLocalVariableMapping(String string) {
        return Collections.unmodifiableMap(this.mLocalVariableMapping.get(string));
    }

    public IcfgLocation getOriginalLocation(IcfgLocation icfgLocation) {
        Pair pair = (Pair)this.mLocationMap.inverse().get((Object)icfgLocation);
        if (pair != null) {
            return (IcfgLocation)pair.getFirst();
        }
        return null;
    }

    public IcfgLocation getDuplicatedLocation(IcfgLocation icfgLocation, String string) {
        return (IcfgLocation)this.mLocationMap.get((Object)new Pair((Object)icfgLocation, (Object)string));
    }

    public IcfgEdge getOriginalEdge(IcfgEdge icfgEdge) {
        Pair pair = (Pair)this.mEdgeMap.inverse().get((Object)icfgEdge);
        if (pair != null) {
            return (IcfgEdge)pair.getFirst();
        }
        return null;
    }

    public IcfgEdge getDuplicatedEdge(IcfgEdge icfgEdge, String string) {
        return (IcfgEdge)this.mEdgeMap.get((Object)new Pair((Object)icfgEdge, (Object)string));
    }

    public void updateBacktranslator(BlockEncodingBacktranslator blockEncodingBacktranslator) {
        blockEncodingBacktranslator.setTermTranslator(term -> Substitution.apply((ManagedScript)this.mMgdScript, this.mVariableBacktranslationMapping, (Term)term));
        for (Map.Entry entry : this.mLocationMap.entrySet()) {
            blockEncodingBacktranslator.mapLocations((IcfgLocation)entry.getValue(), (IcfgLocation)((Pair)entry.getKey()).getFirst());
        }
        for (Map.Entry entry : this.mEdgeMap.entrySet()) {
            blockEncodingBacktranslator.mapEdges((IIcfgTransition<IcfgLocation>)((IIcfgTransition)entry.getValue()), (IIcfgTransition)((Pair)entry.getKey()).getFirst());
        }
    }

    public void updateThreadInstanceMap(Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>> map) {
        for (IcfgForkThreadCurrentTransition icfgForkThreadCurrentTransition : this.mForkCurrentThreads) {
            IIcfgForkTransitionThreadCurrent iIcfgForkTransitionThreadCurrent = (IIcfgForkTransitionThreadCurrent)((Pair)this.mEdgeMap.inverse().get((Object)icfgForkThreadCurrentTransition)).getFirst();
            List<ThreadInstance> list = map.get(iIcfgForkTransitionThreadCurrent);
            assert (list != null);
            map.put(icfgForkThreadCurrentTransition, list);
        }
    }

    private void duplicateProcedureEdges(String string) {
        IcfgLocation icfgLocation = this.mIcfg.getProcedureEntryNodes().get(string);
        List list = new IcfgEdgeIterator(icfgLocation.getOutgoingEdges()).asStream().collect(Collectors.toList());
        for (String string2 : this.mCopyDirectives.getImage((Object)string)) {
            Map<ILocalProgramVar, ILocalProgramVar> map = this.getLocalVariableMapping(string2);
            for (IcfgEdge icfgEdge : list) {
                IcfgLocation icfgLocation2 = this.getOrConstructLocationCopy((IcfgLocation)icfgEdge.getSource(), string2);
                IcfgLocation icfgLocation3 = this.getOrConstructLocationCopy((IcfgLocation)icfgEdge.getTarget(), string2);
                IcfgEdge icfgEdge2 = this.constructEdgeCopy(icfgEdge, icfgLocation2, icfgLocation3, map);
                IcfgEdge icfgEdge3 = (IcfgEdge)this.mEdgeMap.put((Object)new Pair((Object)icfgEdge, (Object)string2), (Object)icfgEdge2);
                assert (icfgEdge3 == null);
                ModelUtils.copyAnnotations((IElement)icfgEdge, (IElement)icfgEdge2);
                icfgLocation2.addOutgoing((IModifiableMultigraphEdge)icfgEdge2);
                icfgLocation3.addIncoming((IModifiableMultigraphEdge)icfgEdge2);
            }
        }
    }

    private Map<String, Map<ILocalProgramVar, ILocalProgramVar>> duplicateVariables() {
        Object object22;
        HashMap<String, Map<ILocalProgramVar, ILocalProgramVar>> hashMap = new HashMap<String, Map<ILocalProgramVar, ILocalProgramVar>>();
        CfgSmtToolkit cfgSmtToolkit = this.mIcfg.getCfgSmtToolkit();
        IIcfgSymbolTable iIcfgSymbolTable = cfgSmtToolkit.getSymbolTable();
        ProcedureMultiplier procedureMultiplier = this;
        HashRelation hashRelation = new HashRelation(cfgSmtToolkit.getModifiableGlobalsTable().getProcToGlobals());
        HashMap<String, List<ILocalProgramVar>> hashMap2 = new HashMap<String, List<ILocalProgramVar>>(cfgSmtToolkit.getInParams());
        HashMap<String, List<ILocalProgramVar>> hashMap3 = new HashMap<String, List<ILocalProgramVar>>(cfgSmtToolkit.getOutParams());
        this.mMgdScript.lock((Object)procedureMultiplier);
        for (Object object22 : this.mCopyDirectives.getDomain()) {
            assert (cfgSmtToolkit.getProcedures().contains(object22)) : "procedure " + (String)object22 + " missing";
            for (String string : this.mCopyDirectives.getImage(object22)) {
                Serializable serializable22;
                this.mIcfg.addProcedure(string);
                HashMap<ILocalProgramVar, ILocalProgramVar> hashMap4 = new HashMap<ILocalProgramVar, ILocalProgramVar>();
                ArrayList<ILocalProgramVar> arrayList = new ArrayList<ILocalProgramVar>();
                for (Serializable serializable22 : (List)hashMap2.get(object22)) {
                    Iterator<ILocalProgramVar> iterator = this.constructVariableCopy((ILocalProgramVar)serializable22, string, hashMap4);
                    arrayList.add((ILocalProgramVar)((Object)iterator));
                }
                hashMap2.put(string, arrayList);
                serializable22 = new ArrayList();
                for (ILocalProgramVar iLocalProgramVar : (List)hashMap3.get(object22)) {
                    ILocalProgramVar iLocalProgramVar2 = this.constructVariableCopy(iLocalProgramVar, string, hashMap4);
                    serializable22.add(iLocalProgramVar2);
                }
                hashMap3.put(string, (List<ILocalProgramVar>)((Object)serializable22));
                for (ILocalProgramVar iLocalProgramVar : iIcfgSymbolTable.getLocals((String)object22)) {
                    if (hashMap4.containsKey(iLocalProgramVar)) continue;
                    this.constructVariableCopy(iLocalProgramVar, string, hashMap4);
                }
                hashMap.put(string, hashMap4);
                hashRelation.getImage(object22).forEach(iProgramNonOldVar -> {
                    boolean bl = hashRelation.addPair((Object)string, iProgramNonOldVar);
                });
            }
        }
        this.mMgdScript.unlock((Object)procedureMultiplier);
        object22 = cfgSmtToolkit.getSmtFunctionsAndAxioms();
        CfgSmtToolkit cfgSmtToolkit2 = new CfgSmtToolkit(new ModifiableGlobalsTable((HashRelation<String, IProgramNonOldVar>)hashRelation), this.mMgdScript, this.mNewSymbolTable, this.mNewProcedures, hashMap2, hashMap3, cfgSmtToolkit.getIcfgEdgeFactory(), cfgSmtToolkit.getConcurrencyInformation(), (SmtFunctionsAndAxioms)object22);
        this.mIcfg.setCfgSmtToolkit(cfgSmtToolkit2);
        return hashMap;
    }

    private IcfgEdge constructEdgeCopy(IcfgEdge icfgEdge, IcfgLocation icfgLocation, IcfgLocation icfgLocation2, Map<ILocalProgramVar, ILocalProgramVar> map) {
        UnmodifiableTransFormula unmodifiableTransFormula = TransFormulaBuilder.constructCopy(this.mMgdScript, icfgEdge.getTransformula(), map);
        IcfgEdgeFactory icfgEdgeFactory = this.mIcfg.getCfgSmtToolkit().getIcfgEdgeFactory();
        if (icfgEdge instanceof IcfgInternalTransition) {
            UnmodifiableTransFormula unmodifiableTransFormula2 = TransFormulaBuilder.constructCopy(this.mMgdScript, ((IcfgInternalTransition)icfgEdge).getTransitionFormulaWithBranchEncoders(), map);
            return icfgEdgeFactory.createInternalTransition(icfgLocation, icfgLocation2, null, unmodifiableTransFormula, unmodifiableTransFormula2);
        }
        if (icfgEdge instanceof IcfgForkThreadCurrentTransition) {
            IcfgForkThreadCurrentTransition icfgForkThreadCurrentTransition = (IcfgForkThreadCurrentTransition)icfgEdge;
            IForkActionThreadCurrent.ForkSmtArguments forkSmtArguments = this.copyForkSmtArguments(icfgForkThreadCurrentTransition.getForkSmtArguments(), map);
            IcfgForkThreadCurrentTransition icfgForkThreadCurrentTransition2 = icfgEdgeFactory.createForkThreadCurrentTransition(icfgLocation, icfgLocation2, null, unmodifiableTransFormula, forkSmtArguments, icfgForkThreadCurrentTransition.getNameOfForkedProcedure());
            this.mForkCurrentThreads.add(icfgForkThreadCurrentTransition2);
            return icfgForkThreadCurrentTransition2;
        }
        if (icfgEdge instanceof IcfgJoinThreadCurrentTransition) {
            IJoinActionThreadCurrent.JoinSmtArguments joinSmtArguments = this.copyJoinSmtArguments(((IcfgJoinThreadCurrentTransition)icfgEdge).getJoinSmtArguments(), map);
            IcfgJoinThreadCurrentTransition icfgJoinThreadCurrentTransition = icfgEdgeFactory.createJoinThreadCurrentTransition(icfgLocation, icfgLocation2, null, unmodifiableTransFormula, joinSmtArguments);
            this.mJoinCurrentThreads.add(icfgJoinThreadCurrentTransition);
            return icfgJoinThreadCurrentTransition;
        }
        if (icfgEdge instanceof IcfgCallTransition) {
            throw new UnsupportedOperationException(String.format("%s does not support %s. Calls and returns should habe been removed by inlining. (Did the inlining fail because this program is recursive?)", ProcedureMultiplier.class.getSimpleName(), icfgEdge.getClass().getSimpleName()));
        }
        throw new UnsupportedOperationException(ProcedureMultiplier.class.getSimpleName() + " does not support " + icfgEdge.getClass().getSimpleName());
    }

    private IcfgLocation getOrConstructLocationCopy(IcfgLocation icfgLocation, String string) {
        return (IcfgLocation)this.mLocationMap.computeIfAbsent((Object)new Pair((Object)icfgLocation, (Object)string), this::constructLocationCopy);
    }

    private IcfgLocation constructLocationCopy(Pair<IcfgLocation, String> pair) {
        IcfgLocation icfgLocation = (IcfgLocation)pair.getFirst();
        String string = icfgLocation.getProcedure();
        String string2 = (String)pair.getSecond();
        IcfgLocation icfgLocation2 = new IcfgLocation(icfgLocation.getDebugIdentifier(), string2);
        ModelUtils.copyAnnotations((IElement)icfgLocation, (IElement)icfgLocation2);
        boolean bl = this.mIcfg.getInitialNodes().contains(icfgLocation);
        boolean bl2 = this.mIcfg.getProcedureErrorNodes().get(string).contains(icfgLocation);
        boolean bl3 = this.mIcfg.getProcedureEntryNodes().get(string).equals(icfgLocation);
        boolean bl4 = this.mIcfg.getProcedureExitNodes().get(string).equals(icfgLocation);
        boolean bl5 = this.mIcfg.getLoopLocations().contains(icfgLocation);
        boolean bl6 = this.mIcfg.getLocationsOfInterest().contains(icfgLocation);
        this.mIcfg.addLocation(icfgLocation2, bl, bl2, bl3, bl4, bl5, bl6);
        return icfgLocation2;
    }

    private ILocalProgramVar constructVariableCopy(ILocalProgramVar iLocalProgramVar, String string, Map<ILocalProgramVar, ILocalProgramVar> map) {
        ILocalProgramVar iLocalProgramVar2 = ProgramVarUtils.constructLocalProgramVar(iLocalProgramVar.getIdentifier(), string, iLocalProgramVar.getSort(), this.mMgdScript, this);
        map.put(iLocalProgramVar, iLocalProgramVar2);
        this.mVariableBacktranslationMapping.put((Term)iLocalProgramVar2.getTermVariable(), (Term)iLocalProgramVar.getTermVariable());
        this.mNewSymbolTable.add(iLocalProgramVar2);
        return iLocalProgramVar2;
    }

    private IForkActionThreadCurrent.ForkSmtArguments copyForkSmtArguments(IForkActionThreadCurrent.ForkSmtArguments forkSmtArguments, Map<ILocalProgramVar, ILocalProgramVar> map) {
        Map<Term, Term> map2 = ProcedureMultiplier.constructDefaultVariableMapping(map);
        Expression2Term.MultiTermResult multiTermResult = this.copyMultiTermResult(forkSmtArguments.getThreadIdArguments(), map2);
        Expression2Term.MultiTermResult multiTermResult2 = this.copyMultiTermResult(forkSmtArguments.getProcedureArguments(), map2);
        return new IForkActionThreadCurrent.ForkSmtArguments(multiTermResult, multiTermResult2);
    }

    private IJoinActionThreadCurrent.JoinSmtArguments copyJoinSmtArguments(IJoinActionThreadCurrent.JoinSmtArguments joinSmtArguments, Map<ILocalProgramVar, ILocalProgramVar> map) {
        Map<Term, Term> map2 = ProcedureMultiplier.constructDefaultVariableMapping(map);
        Expression2Term.MultiTermResult multiTermResult = this.copyMultiTermResult(joinSmtArguments.getThreadIdArguments(), map2);
        List<IProgramVar> list = joinSmtArguments.getAssignmentLhs().stream().map(iProgramVar -> iProgramVar.isGlobal() ? iProgramVar : (IProgramVar)map.get(iProgramVar)).collect(Collectors.toList());
        return new IJoinActionThreadCurrent.JoinSmtArguments(multiTermResult, list);
    }

    private Expression2Term.MultiTermResult copyMultiTermResult(Expression2Term.MultiTermResult multiTermResult, Map<Term, Term> map) {
        UnaryOperator unaryOperator = term -> Substitution.apply((ManagedScript)this.mMgdScript, (Map)map, (Term)term);
        Term[] termArray = (Term[])Arrays.stream(multiTermResult.terms()).map(unaryOperator).toArray(Term[]::new);
        Collection<TermVariable> collection = multiTermResult.auxiliaryVars();
        Map<String, ILocation> map2 = multiTermResult.overapproximations();
        Expression2Term.MultiTermResult multiTermResult2 = new Expression2Term.MultiTermResult(map2, collection, termArray);
        return multiTermResult2;
    }

    private static Map<Term, Term> constructDefaultVariableMapping(Map<ILocalProgramVar, ILocalProgramVar> map) {
        return map.entrySet().stream().collect(Collectors.toMap(entry -> ((ILocalProgramVar)entry.getKey()).getTermVariable(), entry -> ((ILocalProgramVar)entry.getValue()).getTermVariable()));
    }

    private static HashRelation<String, String> generateCopyDirectives(Collection<ThreadInstance> collection) {
        HashRelation hashRelation = new HashRelation();
        for (ThreadInstance threadInstance : collection) {
            hashRelation.addPair((Object)threadInstance.getThreadTemplateName(), (Object)threadInstance.getThreadInstanceName());
        }
        return hashRelation;
    }
}

