/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder.independence;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.ISymbolicIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IndependenceStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.Aggregate;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.PrettyPrint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class DisjunctiveConditionalIndependenceRelation<L, S, C extends Collection<S>>
implements IIndependenceRelation<C, L> {
    private final IIndependenceRelation<S, L> mUnderlying;
    private final Function<List<S>, C> mBuildCollection;
    private final IConditionMerger<L, S, C> mConditionMerger;
    private final DisjunctiveStatistics mStatistics;

    public DisjunctiveConditionalIndependenceRelation(IIndependenceRelation<S, L> iIndependenceRelation) {
        this(iIndependenceRelation, null, null);
    }

    public DisjunctiveConditionalIndependenceRelation(IIndependenceRelation<S, L> iIndependenceRelation, Function<List<S>, C> function, IConditionMerger<L, S, C> iConditionMerger) {
        assert (iIndependenceRelation.isConditional()) : "Only makes sense for conditional independence relations";
        this.mUnderlying = iIndependenceRelation;
        this.mBuildCollection = function;
        this.mConditionMerger = iConditionMerger;
        this.mStatistics = new DisjunctiveStatistics();
    }

    @Override
    public boolean isSymmetric() {
        return this.mUnderlying.isSymmetric();
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public IIndependenceRelation.Dependence isIndependent(C c, L l, L l2) {
        if (c == null || c.isEmpty()) {
            IIndependenceRelation.Dependence dependence = this.mUnderlying.isIndependent(null, l, l2);
            this.mStatistics.reportQuery(dependence, false);
            return dependence;
        }
        boolean bl = false;
        int n = 0;
        for (Object e : c) {
            this.mStatistics.reportQueriedIndex(n);
            IIndependenceRelation.Dependence dependence = this.mUnderlying.isIndependent(e, l, l2);
            if (dependence == IIndependenceRelation.Dependence.INDEPENDENT) {
                this.mStatistics.reportIndependentQuery(true);
                return IIndependenceRelation.Dependence.INDEPENDENT;
            }
            bl |= dependence == IIndependenceRelation.Dependence.UNKNOWN;
            ++n;
        }
        if (bl) {
            this.mStatistics.reportUnknownQuery(true);
            return IIndependenceRelation.Dependence.UNKNOWN;
        }
        this.mStatistics.reportDependentQuery(true);
        return IIndependenceRelation.Dependence.DEPENDENT;
    }

    @Override
    public ISymbolicIndependenceRelation<L, C> getSymbolicRelation() {
        if (this.mBuildCollection == null) {
            return null;
        }
        ISymbolicIndependenceRelation<L, S> iSymbolicIndependenceRelation = this.mUnderlying.getSymbolicRelation();
        if (iSymbolicIndependenceRelation == null) {
            return null;
        }
        return new SymbolicDisjunctiveIndependence(iSymbolicIndependenceRelation);
    }

    @Override
    public IStatisticsDataProvider getStatistics() {
        return this.mStatistics;
    }

    private class DisjunctiveStatistics
    extends IndependenceStatisticsDataProvider {
        public static final String MAX_QUERIED_INDEX = "Maximal queried relation";
        private int mMaxQueriedIndex;

        public DisjunctiveStatistics() {
            super(DisjunctiveConditionalIndependenceRelation.class, DisjunctiveConditionalIndependenceRelation.this.mUnderlying);
            this.mMaxQueriedIndex = -1;
            this.declare(MAX_QUERIED_INDEX, () -> this.mMaxQueriedIndex, Aggregate::intMax, PrettyPrint::keyColonData);
        }

        private void reportQueriedIndex(int n) {
            if (this.mMaxQueriedIndex < n) {
                this.mMaxQueriedIndex = n;
            }
        }
    }

    public static interface IConditionMerger<L, S, C extends Collection<S>> {
        public S merge(C var1, L var2, L var3);
    }

    private class SymbolicDisjunctiveIndependence
    implements ISymbolicIndependenceRelation<L, C> {
        private final ISymbolicIndependenceRelation<L, S> mUnderlyingSymbolic;

        public SymbolicDisjunctiveIndependence(ISymbolicIndependenceRelation<L, S> iSymbolicIndependenceRelation) {
            this.mUnderlyingSymbolic = iSymbolicIndependenceRelation;
        }

        @Override
        public C getCommutativityCondition(C c, L l, L l2) {
            if (c == null || c.isEmpty() || !this.isConditional()) {
                return this.getSingleCommutativityCondition(null, l, l2);
            }
            if (DisjunctiveConditionalIndependenceRelation.this.mConditionMerger != null) {
                return this.getSingleCommutativityCondition(DisjunctiveConditionalIndependenceRelation.this.mConditionMerger.merge(c, l, l2), l, l2);
            }
            ArrayList arrayList = new ArrayList();
            for (Object e : c) {
                Object s = this.mUnderlyingSymbolic.getCommutativityCondition(e, l, l2);
                if (s == null) continue;
                arrayList.add(s);
            }
            return (Collection)DisjunctiveConditionalIndependenceRelation.this.mBuildCollection.apply(arrayList);
        }

        private C getSingleCommutativityCondition(S s, L l, L l2) {
            Object s2 = this.mUnderlyingSymbolic.getCommutativityCondition(s, l, l2);
            if (s2 == null) {
                return null;
            }
            return (Collection)DisjunctiveConditionalIndependenceRelation.this.mBuildCollection.apply(List.of(s2));
        }

        @Override
        public boolean isSymmetric() {
            return this.mUnderlyingSymbolic.isSymmetric();
        }

        @Override
        public boolean isConditional() {
            return this.mUnderlyingSymbolic.isConditional();
        }
    }
}

