/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.xnf.Dnf;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.AbstractLinearInvariantPattern;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.AbstractTemplateIncreasingDimensionsStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.ILinearInequalityInvariantPatternStrategy;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.LinearPatternBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class LocationIndependentLinearInequalityInvariantPatternStrategy
implements ILinearInequalityInvariantPatternStrategy<Dnf<AbstractLinearInvariantPattern>> {
    private final int maxRounds;
    protected final Set<IProgramVar> mAllProgramVariables;
    protected final Set<IProgramVar> mPatternVariables;
    protected int mPrefixCounter;
    protected Map<IcfgLocation, Set<Term>> mLoc2PatternCoefficents;
    private final boolean mAlwaysStrictAndNonStrictCopies;
    private final boolean mUseStrictInequalitiesAlternatingly;
    protected AbstractTemplateIncreasingDimensionsStrategy mDimensionsStrategy;

    public LocationIndependentLinearInequalityInvariantPatternStrategy(AbstractTemplateIncreasingDimensionsStrategy abstractTemplateIncreasingDimensionsStrategy, int n, Set<IProgramVar> set, Set<IProgramVar> set2, boolean bl, boolean bl2) {
        this.mDimensionsStrategy = abstractTemplateIncreasingDimensionsStrategy;
        this.maxRounds = n;
        this.mAllProgramVariables = set;
        this.mPatternVariables = set2;
        this.mPrefixCounter = 0;
        this.mLoc2PatternCoefficents = new HashMap<IcfgLocation, Set<Term>>();
        this.mAlwaysStrictAndNonStrictCopies = bl;
        this.mUseStrictInequalitiesAlternatingly = bl2;
    }

    @Override
    public int getMaxRounds() {
        return this.maxRounds;
    }

    @Override
    public Dnf<AbstractLinearInvariantPattern> getInvariantPatternForLocation(IcfgLocation icfgLocation, int n, Script script, String string) {
        HashSet<Term> hashSet = new HashSet<Term>();
        int[] nArray = this.getDimensions(icfgLocation, n);
        Dnf dnf = new Dnf(nArray[0]);
        int n2 = 0;
        while (n2 < nArray[0]) {
            ArrayList<LinearPatternBase> arrayList = new ArrayList<LinearPatternBase>(nArray[1]);
            int n3 = 0;
            while (n3 < nArray[1]) {
                boolean[] blArray = new boolean[1];
                if (this.mUseStrictInequalitiesAlternatingly && n3 % 2 == 1) {
                    blArray = new boolean[]{true};
                }
                if (this.mAlwaysStrictAndNonStrictCopies) {
                    boolean[] blArray2 = new boolean[2];
                    blArray2[1] = true;
                    blArray = blArray2;
                }
                boolean[] blArray3 = blArray;
                int n4 = blArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    boolean bl = blArray3[n5];
                    LinearPatternBase linearPatternBase = new LinearPatternBase(script, this.getPatternVariablesForLocation(icfgLocation, n), string + "_" + this.newPrefix(), bl);
                    arrayList.add(linearPatternBase);
                    hashSet.addAll(linearPatternBase.getCoefficients());
                    ++n5;
                }
                ++n3;
            }
            dnf.add(arrayList);
            ++n2;
        }
        this.mLoc2PatternCoefficents.put(icfgLocation, hashSet);
        return dnf;
    }

    @Override
    public Set<Term> getPatternCoefficientsForLocation(IcfgLocation icfgLocation) {
        assert (this.mLoc2PatternCoefficents.containsKey(icfgLocation)) : "No coefficients available for the location: " + String.valueOf(icfgLocation);
        return Collections.unmodifiableSet(this.mLoc2PatternCoefficents.get(icfgLocation));
    }

    @Override
    public Dnf<AbstractLinearInvariantPattern> getInvariantPatternForLocation(IcfgLocation icfgLocation, int n, Script script, String string, Set<IProgramVar> set) {
        throw new UnsupportedOperationException("Location independent strategies do not support this kind of pattern construction.");
    }

    @Override
    public void setNumOfConjunctsForLocation(IcfgLocation icfgLocation, int n) {
        throw new UnsupportedOperationException("Location independent strategies do not support location-dependent pattern settings.");
    }

    @Override
    public void setNumOfDisjunctsForLocation(IcfgLocation icfgLocation, int n) {
        throw new UnsupportedOperationException("Location independent strategies do not support location-dependent pattern settings.");
    }

    @Override
    public void changePatternSettingForLocation(IcfgLocation icfgLocation, int n) {
        throw new UnsupportedOperationException("Location independent strategies do not support dynamic setting changes.");
    }

    @Override
    public void changePatternSettingForLocation(IcfgLocation icfgLocation, int n, Set<IcfgLocation> set) {
        throw new UnsupportedOperationException("Location independent strategies do not support dynamic setting changes.");
    }

    @Override
    public int[] getDimensions(IcfgLocation icfgLocation, int n) {
        return this.mDimensionsStrategy.getDimensions(icfgLocation, n);
    }

    @Override
    public void resetSettings() {
        this.mPrefixCounter = 0;
    }

    protected String newPrefix() {
        return Integer.toString(this.mPrefixCounter++);
    }

    @Override
    public Dnf<AbstractLinearInvariantPattern> getPatternForTransition(IcfgEdge icfgEdge, int n, Script script, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Term> getIntegerCoefficientsForTransition(IcfgEdge icfgEdge) {
        throw new UnsupportedOperationException();
    }
}

