/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.parser;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.parser.Activator;
import de.uni_freiburg.informatik.ultimate.boogie.parser.BoogieSymbolFactory;
import de.uni_freiburg.informatik.ultimate.boogie.parser.Lexer;
import de.uni_freiburg.informatik.ultimate.boogie.parser.Parser;
import de.uni_freiburg.informatik.ultimate.core.lib.models.WrapperNode;
import de.uni_freiburg.informatik.ultimate.core.model.ISource;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableAST;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class BoogieParser
implements ISource {
    protected String[] mFileTypes = new String[]{"bpl"};
    protected ILogger mLogger;
    protected List<String> mFileNames = new ArrayList<String>();
    protected Unit mPreludeUnit;
    private IUltimateServiceProvider mServices;

    public String getPluginID() {
        return this.getClass().getPackage().getName();
    }

    public void init() {
        this.mFileNames = new ArrayList<String>();
    }

    public String getPluginName() {
        return "Boogie PL CUP Parser";
    }

    public IElement parseAST(File[] fileArray) throws IOException {
        if (fileArray.length > 1) {
            WrapperNode wrapperNode = new WrapperNode(null, null);
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray2[n2];
                Unit unit = this.parseFile(file);
                wrapperNode.addOutgoing((IModifiableAST)new WrapperNode(wrapperNode, (Object)unit));
                ++n2;
            }
            return wrapperNode;
        }
        File file = fileArray[0];
        if (file.isDirectory()) {
            return this.parseAST(file.listFiles());
        }
        return this.parseFile(file);
    }

    private Unit parseFile(File file) throws IOException {
        this.mLogger.info((Object)("Parsing: '" + file.getAbsolutePath() + "'"));
        this.mFileNames.add(file.getAbsolutePath());
        return this.reflectiveParse(file.getAbsolutePath());
    }

    public File[] parseable(File[] fileArray) {
        List<File> list = Arrays.stream(fileArray).filter(this::parseable).collect(Collectors.toList());
        return list.toArray(new File[list.size()]);
    }

    private boolean parseable(File file) {
        String[] stringArray = this.getFileTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (file.getName().endsWith(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String[] getFileTypes() {
        return this.mFileTypes;
    }

    public ModelType getOutputDefinition() {
        try {
            return new ModelType(this.getPluginID(), ModelType.Type.AST, this.mFileNames);
        }
        catch (Exception exception) {
            this.mLogger.fatal((Object)("syntax error: " + exception.getMessage()));
            return null;
        }
    }

    private Unit reflectiveParse(String string) throws IOException {
        BoogieSymbolFactory boogieSymbolFactory = new BoogieSymbolFactory();
        Lexer lexer = new Lexer(new FileInputStream(string));
        lexer.setSymbolFactory(boogieSymbolFactory);
        Parser parser = new Parser(lexer, boogieSymbolFactory, this.mServices);
        parser.setFileName(string);
        try {
            return (Unit)parser.parse().value;
        }
        catch (Exception exception) {
            this.mLogger.fatal((Object)"syntax error: ", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    public IPreferenceInitializer getPreferences() {
        return null;
    }

    public void setServices(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
    }

    public void finish() {
    }
}

