/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.IDfsOrder;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors.IDfsVisitor;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors.WrapperVisitor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class BetterLockstepOrder<L extends IAction, S>
implements IDfsOrder<L, S> {
    private final Map<Object, L> mEntryEdge = new HashMap<Object, L>();
    private final Function<S, Object> mNormalizer;
    private final Comparator<L> mDefaultComparator = Comparator.comparing(IAction::getPrecedingProcedure).thenComparingInt(Object::hashCode);

    public BetterLockstepOrder() {
        this(null);
    }

    public BetterLockstepOrder(Function<S, Object> function) {
        this.mNormalizer = function;
    }

    public Comparator<L> getOrder(S s) {
        Object object = this.normalize(s);
        IAction iAction = (IAction)this.mEntryEdge.get(object);
        if (iAction == null) {
            return this.mDefaultComparator;
        }
        String string = iAction.getPrecedingProcedure();
        return new RoundRobinComparator<L>(string, this.mDefaultComparator);
    }

    private Object normalize(S s) {
        if (this.mNormalizer == null) {
            return s;
        }
        return this.mNormalizer.apply(s);
    }

    public boolean isPositional() {
        return true;
    }

    public <V extends IDfsVisitor<L, S>> WrapperVisitor<L, S, V> wrapVisitor(V v) {
        return new Visitor(this, v);
    }

    public static final class RoundRobinComparator<L extends IAction>
    implements Comparator<L> {
        private final String mLastThread;
        private final Comparator<L> mFallback;

        public RoundRobinComparator(String string, Comparator<L> comparator) {
            this.mLastThread = Objects.requireNonNull(string);
            this.mFallback = comparator;
        }

        @Override
        public int compare(L l, L l2) {
            boolean bl;
            String string = l.getPrecedingProcedure();
            boolean bl2 = this.mLastThread.compareTo(string) >= 0;
            String string2 = l2.getPrecedingProcedure();
            boolean bl3 = bl = this.mLastThread.compareTo(string2) >= 0;
            if (bl2 && !bl) {
                return 1;
            }
            if (bl && !bl2) {
                return -1;
            }
            return this.mFallback.compare(l, l2);
        }

        public int hashCode() {
            return Objects.hash(this.mFallback, this.mLastThread);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            RoundRobinComparator roundRobinComparator = (RoundRobinComparator)object;
            return Objects.equals(this.mFallback, roundRobinComparator.mFallback) && Objects.equals(this.mLastThread, roundRobinComparator.mLastThread);
        }
    }

    private static final class Visitor<V extends IDfsVisitor<L, S>>
    extends WrapperVisitor<L, S, V> {
        final /* synthetic */ BetterLockstepOrder this$0;

        private Visitor(V v) {
            this.this$0 = var1_1;
            super(v);
        }

        public boolean discoverTransition(S s, L l, S s2) {
            this.this$0.mEntryEdge.putIfAbsent(this.this$0.normalize(s2), l);
            return super.discoverTransition(s, l, s2);
        }
    }
}

