/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.cfg2automaton;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ThreadInstance;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadOther;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadOther;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgSummaryTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocationIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.SmtFreePredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Cfg2Automaton<LETTER extends IIcfgTransition<?>> {
    private static final boolean DEBUG_STORE_HISTORY = false;

    private Cfg2Automaton() {
    }

    public static <LETTER> INestedWordAutomaton<LETTER, IPredicate> constructAutomatonWithSPredicates(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<? extends IcfgLocation> iIcfg, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory, Collection<? extends IcfgLocation> collection, boolean bl, PredicateFactory predicateFactory) {
        VpAlphabet<LETTER> vpAlphabet = Cfg2Automaton.extractVpAlphabet(iIcfg, !bl);
        ManagedScript managedScript = iIcfg.getCfgSmtToolkit().getManagedScript();
        Function<IcfgLocation, IPredicate> function = Cfg2Automaton.constructSPredicateProvider(predicateFactory, managedScript);
        Function<IIcfgTransition<?>, LETTER> function2 = Cfg2Automaton.constructIdentityTransitionProvider();
        return Cfg2Automaton.constructAutomaton(iUltimateServiceProvider, iIcfg, iEmptyStackStateFactory, collection, bl, vpAlphabet, function, function2);
    }

    public static <LETTER> INestedWordAutomaton<LETTER, IPredicate> constructAutomatonWithDebugPredicates(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<? extends IcfgLocation> iIcfg, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory, Collection<? extends IcfgLocation> collection, boolean bl, VpAlphabet<LETTER> vpAlphabet, Map<IIcfgTransition<?>, IIcfgTransition<?>> map) {
        Function<IcfgLocation, IPredicate> function = Cfg2Automaton.constructDebugPredicateProvider();
        Function<IIcfgTransition<?>, LETTER> function2 = map == null ? Cfg2Automaton.constructIdentityTransitionProvider() : Cfg2Automaton.constructMapBasedTransitionProvider(map);
        return Cfg2Automaton.constructAutomaton(iUltimateServiceProvider, iIcfg, iEmptyStackStateFactory, collection, bl, vpAlphabet, function, function2);
    }

    public static <LETTER> BoundedPetriNet<LETTER, IPredicate> constructPetriNetWithSPredicates(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<? extends IcfgLocation> iIcfg, Collection<? extends IcfgLocation> collection, PredicateFactory predicateFactory) {
        VpAlphabet<LETTER> vpAlphabet = Cfg2Automaton.extractVpAlphabet(iIcfg, true);
        ManagedScript managedScript = iIcfg.getCfgSmtToolkit().getManagedScript();
        Function<IcfgLocation, IPredicate> function = Cfg2Automaton.constructSPredicateProvider(predicateFactory, managedScript);
        return Cfg2Automaton.constructPetriNet(iUltimateServiceProvider, iIcfg, collection, vpAlphabet, function, predicateFactory);
    }

    private static Function<IcfgLocation, IPredicate> constructSPredicateProvider(PredicateFactory predicateFactory, ManagedScript managedScript) {
        Term term = managedScript.getScript().term("true", new Term[0]);
        Function<IcfgLocation, IPredicate> function = icfgLocation -> predicateFactory.newSPredicate(icfgLocation, term);
        return function;
    }

    private static Function<IcfgLocation, IPredicate> constructDebugPredicateProvider() {
        SmtFreePredicateFactory smtFreePredicateFactory = new SmtFreePredicateFactory();
        return icfgLocation -> smtFreePredicateFactory.newDebugPredicate(icfgLocation.toString());
    }

    private static <LETTER> Function<IIcfgTransition<?>, LETTER> constructIdentityTransitionProvider() {
        return iIcfgTransition -> iIcfgTransition;
    }

    private static <LETTER> Function<IIcfgTransition<?>, LETTER> constructMapBasedTransitionProvider(Map<IIcfgTransition<?>, IIcfgTransition<?>> map) {
        return iIcfgTransition -> map.get(iIcfgTransition);
    }

    private static <LETTER> INestedWordAutomaton<LETTER, IPredicate> constructAutomaton(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<? extends IcfgLocation> iIcfg, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory, Collection<? extends IcfgLocation> collection, boolean bl, VpAlphabet<LETTER> vpAlphabet, Function<IcfgLocation, IPredicate> function, Function<IIcfgTransition<?>, LETTER> function2) {
        IcfgLocationIterator icfgLocationIterator = new IcfgLocationIterator(iIcfg);
        Set set = icfgLocationIterator.asStream().collect(Collectors.toSet());
        Set set2 = iIcfg.getInitialNodes();
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(new AutomataLibraryServices(iUltimateServiceProvider), vpAlphabet, iEmptyStackStateFactory);
        HashMap<IcfgLocation, Object> hashMap = new HashMap<IcfgLocation, Object>();
        for (IcfgLocation icfgLocation : set) {
            boolean bl2 = set2.contains(icfgLocation);
            boolean bl3 = collection.contains(icfgLocation);
            IPredicate iPredicate = function.apply(icfgLocation);
            nestedWordAutomaton.addState(bl2, bl3, (Object)iPredicate);
            hashMap.put(icfgLocation, iPredicate);
        }
        for (IcfgLocation icfgLocation : set) {
            IPredicate iPredicate = (IPredicate)hashMap.get(icfgLocation);
            if (icfgLocation.getOutgoingNodes() == null) continue;
            for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                IIcfgReturnTransition iIcfgReturnTransition;
                IcfgLocation icfgLocation2 = (IcfgLocation)icfgEdge.getTarget();
                IPredicate iPredicate2 = (IPredicate)hashMap.get(icfgLocation2);
                if (icfgEdge instanceof IIcfgCallTransition) {
                    if (!bl) continue;
                    nestedWordAutomaton.addCallTransition((Object)iPredicate, function2.apply((IIcfgTransition<?>)icfgEdge), (Object)iPredicate2);
                    continue;
                }
                if (icfgEdge instanceof IIcfgReturnTransition) {
                    IcfgLocation icfgLocation3;
                    if (!bl || !hashMap.containsKey(icfgLocation3 = (iIcfgReturnTransition = (IIcfgReturnTransition)icfgEdge).getCallerProgramPoint())) continue;
                    nestedWordAutomaton.addReturnTransition((Object)iPredicate, (Object)((IPredicate)hashMap.get(icfgLocation3)), function2.apply((IIcfgTransition<?>)iIcfgReturnTransition), (Object)iPredicate2);
                    continue;
                }
                if (icfgEdge instanceof IIcfgSummaryTransition) {
                    iIcfgReturnTransition = (IIcfgSummaryTransition)icfgEdge;
                    if (iIcfgReturnTransition.calledProcedureHasImplementation()) {
                        if (bl) continue;
                        nestedWordAutomaton.addInternalTransition((Object)iPredicate, function2.apply((IIcfgTransition<?>)iIcfgReturnTransition), (Object)iPredicate2);
                        continue;
                    }
                    nestedWordAutomaton.addInternalTransition((Object)iPredicate, function2.apply((IIcfgTransition<?>)iIcfgReturnTransition), (Object)iPredicate2);
                    continue;
                }
                if (icfgEdge instanceof IIcfgInternalTransition) {
                    nestedWordAutomaton.addInternalTransition((Object)iPredicate, function2.apply((IIcfgTransition<?>)icfgEdge), (Object)iPredicate2);
                    continue;
                }
                if (icfgEdge instanceof IIcfgForkTransitionThreadCurrent) {
                    throw new UnsupportedOperationException("analysis for sequential programs does not support fork/join");
                }
                if (icfgEdge instanceof IIcfgJoinTransitionThreadCurrent) {
                    throw new UnsupportedOperationException("analysis for sequential programs does not support fork/join");
                }
                throw new UnsupportedOperationException("unsupported edge " + icfgEdge.getClass().getSimpleName());
            }
        }
        return nestedWordAutomaton;
    }

    private static <LETTER> BoundedPetriNet<LETTER, IPredicate> constructPetriNet(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<? extends IcfgLocation> iIcfg, Collection<? extends IcfgLocation> collection, VpAlphabet<LETTER> vpAlphabet, Function<IcfgLocation, IPredicate> function, PredicateFactory predicateFactory) {
        Object object;
        Object object2;
        String string2;
        Object object3;
        Object object4;
        IPredicate iPredicate;
        IcfgLocation icfgLocation;
        ManagedScript managedScript;
        Object object5;
        IcfgLocation icfgLocation22;
        IcfgLocationIterator icfgLocationIterator = new IcfgLocationIterator(iIcfg);
        Set set = icfgLocationIterator.asStream().collect(Collectors.toSet());
        Set set2 = iIcfg.getInitialNodes();
        BoundedPetriNet boundedPetriNet = new BoundedPetriNet(new AutomataLibraryServices(iUltimateServiceProvider), vpAlphabet.getInternalAlphabet(), false);
        HashMap<IcfgLocation, Object> hashMap = new HashMap<IcfgLocation, Object>();
        for (IcfgLocation icfgLocation22 : set) {
            boolean bl = set2.contains(icfgLocation22);
            boolean bl2 = collection.contains(icfgLocation22);
            object5 = function.apply(icfgLocation22);
            boolean bl3 = boundedPetriNet.addPlace(object5, bl, bl2);
            if (!bl3) {
                throw new AssertionError((Object)("Must not add place twice: " + String.valueOf(object5)));
            }
            hashMap.put(icfgLocation22, object5);
        }
        icfgLocation22 = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap<String, IPredicate> hashMap3 = new HashMap<String, IPredicate>();
        HashMap<String, IPredicate> hashMap4 = new HashMap<String, IPredicate>();
        object5 = new HashMap();
        for (Map.Entry entry : iIcfg.getCfgSmtToolkit().getConcurrencyInformation().getThreadInstanceMap().entrySet()) {
            managedScript = iIcfg.getCfgSmtToolkit().getManagedScript();
            Term term = managedScript.getScript().term("true", new Term[0]);
            List list = (List)entry.getValue();
            icfgLocation = new ArrayList();
            iPredicate = new ArrayList();
            object4 = list.iterator();
            while (object4.hasNext()) {
                object3 = (ThreadInstance)object4.next();
                string2 = object3.getThreadInstanceName();
                object2 = hashMap3.computeIfAbsent(string2, string -> Cfg2Automaton.createThreadNotInUsePredicate(string, boundedPetriNet, predicateFactory, term));
                object = hashMap4.computeIfAbsent(string2, string -> Cfg2Automaton.createThreadInUsePredicate(string, boundedPetriNet, predicateFactory, term));
                icfgLocation.add(object2);
                iPredicate.add(object);
            }
            icfgLocation22.put((IIcfgForkTransitionThreadCurrent)entry.getKey(), icfgLocation);
            hashMap2.put((IIcfgForkTransitionThreadCurrent)entry.getKey(), iPredicate);
        }
        for (Map.Entry entry : iIcfg.getCfgSmtToolkit().getConcurrencyInformation().getInUseErrorNodeMap().entrySet()) {
            object5.put(Cfg2Automaton.getIncomingEdge((IcfgLocation)entry.getValue()), (IIcfgForkTransitionThreadCurrent)entry.getKey());
        }
        for (IcfgLocation icfgLocation3 : set) {
            managedScript = (IPredicate)hashMap.get(icfgLocation3);
            if (icfgLocation3.getOutgoingNodes() == null) continue;
            for (Term term : icfgLocation3.getOutgoingEdges()) {
                Object object6;
                Object object7;
                icfgLocation = (IcfgLocation)term.getTarget();
                iPredicate = (IPredicate)hashMap.get(icfgLocation);
                if (term instanceof IIcfgInternalTransition) {
                    if (object5.containsKey(term)) {
                        object3 = (List)hashMap2.get(object5.get(term));
                        object4 = new HashSet(object3);
                        object4.add(managedScript);
                        boundedPetriNet.addTransition((Object)term, ImmutableSet.of((Set)object4), ImmutableSet.singleton((Object)iPredicate));
                        continue;
                    }
                    boundedPetriNet.addTransition((Object)term, ImmutableSet.singleton((Object)managedScript), ImmutableSet.singleton((Object)iPredicate));
                    continue;
                }
                if (term instanceof IIcfgForkTransitionThreadCurrent) continue;
                if (term instanceof IIcfgForkTransitionThreadOther) {
                    object3 = ((IIcfgForkTransitionThreadOther)term).getCorrespondingIIcfgForkTransitionCurrentThread();
                    object4 = object3.getTarget();
                    string2 = (IPredicate)hashMap.get(object4);
                    object2 = (List)hashMap2.get(object3);
                    object = (List)icfgLocation22.get(object3);
                    int n = Cfg2Automaton.getThreadInstanceNumber(object3, term.getSucceedingProcedure(), iIcfg.getCfgSmtToolkit().getConcurrencyInformation().getThreadInstanceMap());
                    object7 = new HashSet<IPredicate>(Arrays.asList(managedScript, (IPredicate)object.get(n)));
                    object6 = new HashSet<IPredicate>(Arrays.asList(string2, iPredicate, (IPredicate)object2.get(n)));
                    int n2 = 0;
                    while (n2 < n) {
                        object7.add((IPredicate)object2.get(n2));
                        object6.add((IPredicate)object2.get(n2));
                        ++n2;
                    }
                    boundedPetriNet.addTransition((Object)term, ImmutableSet.of((Set)object7), ImmutableSet.of((Set)object6));
                    continue;
                }
                if (term instanceof IIcfgJoinTransitionThreadCurrent) continue;
                if (term instanceof IIcfgJoinTransitionThreadOther) {
                    object3 = ((IIcfgJoinTransitionThreadOther)term).getCorrespondingIIcfgJoinTransitionCurrentThread();
                    object4 = object3.getSource();
                    string2 = (IPredicate)hashMap.get(object4);
                    if (string2 == null) continue;
                    object7 = term.getPrecedingProcedure();
                    object6 = (IPredicate)hashMap3.get(object7);
                    IPredicate iPredicate2 = (IPredicate)hashMap4.get(object7);
                    object2 = Set.of(string2, managedScript, iPredicate2);
                    object = Set.of(iPredicate, object6);
                    boundedPetriNet.addTransition((Object)term, ImmutableSet.of((Set)object2), ImmutableSet.of((Set)object));
                    continue;
                }
                if (term instanceof IIcfgCallTransition) {
                    throw new UnsupportedOperationException("unsupported for concurrent analysis " + term.getClass().getSimpleName());
                }
                if (term instanceof IIcfgReturnTransition) {
                    throw new UnsupportedOperationException("unsupported for concurrent analysis " + term.getClass().getSimpleName());
                }
                if (term instanceof IIcfgSummaryTransition) {
                    throw new UnsupportedOperationException("unsupported for concurrent analysis " + term.getClass().getSimpleName());
                }
                throw new UnsupportedOperationException("unknown kind of edge " + term.getClass().getSimpleName());
            }
        }
        return boundedPetriNet;
    }

    private static IcfgEdge getIncomingEdge(IcfgLocation icfgLocation) {
        IcfgEdge icfgEdge = null;
        for (IcfgEdge icfgEdge2 : icfgLocation.getIncomingEdges()) {
            if (((IcfgLocation)icfgEdge2.getSource()).equals((Object)icfgLocation)) continue;
            if (icfgEdge != null) {
                throw new UnsupportedOperationException(String.valueOf(icfgLocation) + " has no unique incoming edge");
            }
            icfgEdge = icfgEdge2;
        }
        return icfgEdge;
    }

    private static <LETTER> IPredicate createThreadNotInUsePredicate(String string, BoundedPetriNet<LETTER, IPredicate> boundedPetriNet, PredicateFactory predicateFactory, Term term) {
        String cfr_ignored_0 = string + "NotInUse";
        BasicPredicate basicPredicate = predicateFactory.newPredicate(term);
        boundedPetriNet.addPlace((Object)basicPredicate, true, false);
        return basicPredicate;
    }

    private static <LETTER> IPredicate createThreadInUsePredicate(String string, BoundedPetriNet<LETTER, IPredicate> boundedPetriNet, PredicateFactory predicateFactory, Term term) {
        String cfr_ignored_0 = string + "InUse";
        BasicPredicate basicPredicate = predicateFactory.newPredicate(term);
        boundedPetriNet.addPlace((Object)basicPredicate, false, false);
        return basicPredicate;
    }

    private static int getThreadInstanceNumber(IIcfgForkTransitionThreadCurrent<?> iIcfgForkTransitionThreadCurrent, String string, Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>> map) {
        List<ThreadInstance> list = map.get(iIcfgForkTransitionThreadCurrent);
        int n = 0;
        for (ThreadInstance threadInstance : list) {
            if (threadInstance.getThreadInstanceName().equals(string)) {
                return n;
            }
            ++n;
        }
        throw new IllegalStateException("did not find thread instance " + string);
    }

    public static <LETTER> VpAlphabet<LETTER> extractVpAlphabet(IIcfg<? extends IcfgLocation> iIcfg, boolean bl) {
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<IcfgEdge> hashSet2 = new HashSet<IcfgEdge>();
        HashSet<IcfgEdge> hashSet3 = new HashSet<IcfgEdge>();
        IcfgLocationIterator icfgLocationIterator = new IcfgLocationIterator(iIcfg);
        while (icfgLocationIterator.hasNext()) {
            IcfgLocation icfgLocation = icfgLocationIterator.next();
            if (icfgLocation.getOutgoingNodes() == null) continue;
            for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                if (icfgEdge instanceof IIcfgInternalTransition) {
                    hashSet.add(icfgEdge);
                    continue;
                }
                if (icfgEdge instanceof IIcfgCallTransition) {
                    if (bl) continue;
                    hashSet2.add(icfgEdge);
                    continue;
                }
                if (icfgEdge instanceof IIcfgReturnTransition) {
                    if (bl) continue;
                    hashSet3.add(icfgEdge);
                    continue;
                }
                if (icfgEdge instanceof IIcfgSummaryTransition) {
                    IIcfgSummaryTransition iIcfgSummaryTransition = (IIcfgSummaryTransition)icfgEdge;
                    if (iIcfgSummaryTransition.calledProcedureHasImplementation()) {
                        if (!bl) continue;
                        hashSet.add(iIcfgSummaryTransition);
                        continue;
                    }
                    hashSet.add(iIcfgSummaryTransition);
                    continue;
                }
                if (icfgEdge instanceof IIcfgForkTransitionThreadCurrent) continue;
                if (icfgEdge instanceof IIcfgForkTransitionThreadOther) {
                    hashSet.add(icfgEdge);
                    continue;
                }
                if (icfgEdge instanceof IIcfgJoinTransitionThreadCurrent) continue;
                if (icfgEdge instanceof IIcfgJoinTransitionThreadOther) {
                    hashSet.add(icfgEdge);
                    continue;
                }
                throw new UnsupportedOperationException("unknown kind of edge " + icfgEdge.getClass().getSimpleName());
            }
        }
        return new VpAlphabet(hashSet, hashSet2, hashSet3);
    }
}

