/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.IInterpolatingTraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.QualifiedTracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.ITraceCheckPreferences;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.taskidentifier.TaskIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.pdr.Pdr;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolatingTraceCheckCraig;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckSpWp;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.InterpolatingTraceCheckPathInvariantsWithFallback;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.InvariantSynthesisSettings;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.AssertionOrderModulation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpTcStrategyModuleTraceCheck;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.TaCheckAndRefinementPreferences;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;

public final class IpTcStrategyModulePreferences<L extends IIcfgTransition<?>>
extends IpTcStrategyModuleTraceCheck<IInterpolatingTraceCheck<L>, L> {
    private final InterpolationTechnique mInterpolationTechnique;
    private final Class<L> mTransitionClazz;

    public IpTcStrategyModulePreferences(TaskIdentifier taskIdentifier, IUltimateServiceProvider iUltimateServiceProvider, TaCheckAndRefinementPreferences<L> taCheckAndRefinementPreferences, Counterexample<L> counterexample, IPredicate iPredicate, IPredicate iPredicate2, AssertionOrderModulation<L> assertionOrderModulation, IPredicateUnifier iPredicateUnifier, PredicateFactory predicateFactory, Class<L> clazz) {
        super(taskIdentifier, iUltimateServiceProvider, taCheckAndRefinementPreferences, counterexample, iPredicate, iPredicate2, assertionOrderModulation, iPredicateUnifier, predicateFactory);
        this.mInterpolationTechnique = this.mPrefs.getInterpolationTechnique();
        if (this.mInterpolationTechnique == null) {
            throw new UnsupportedOperationException("Cannot interpolate without a technique");
        }
        this.mTransitionClazz = clazz;
    }

    @Override
    protected IInterpolatingTraceCheck<L> construct() {
        ITraceCheckPreferences.AssertCodeBlockOrder assertCodeBlockOrder = this.mAssertionOrderModulation.get(this.mCounterexample.getWord(), this.mInterpolationTechnique);
        SmtUtils.SimplificationTechnique simplificationTechnique = this.mPrefs.getSimplificationTechnique();
        TreeMap<Integer, IPredicate> treeMap = new TreeMap<Integer, IPredicate>();
        ManagedScript managedScript = this.constructManagedScript();
        switch (this.mInterpolationTechnique) {
            case Craig_NestedInterpolation: 
            case Craig_TreeInterpolation: {
                return new InterpolatingTraceCheckCraig(this.mPrecondition, this.mPostcondition, treeMap, this.mCounterexample, this.mServices, this.mPrefs.getCfgSmtToolkit(), managedScript, this.mPredicateFactory, this.mPredicateUnifier, assertCodeBlockOrder, this.mPrefs.computeCounterexample(), this.mPrefs.collectInterpolantStatistics(), this.mInterpolationTechnique, true, simplificationTechnique, false);
            }
            case ForwardPredicates: 
            case BackwardPredicates: 
            case FPandBP: 
            case FPandBPonlyIfFpWasNotPerfect: {
                return new TraceCheckSpWp(this.mPrecondition, this.mPostcondition, treeMap, this.mCounterexample, this.mPrefs.getCfgSmtToolkit(), assertCodeBlockOrder, this.mPrefs.getUnsatCores(), this.mPrefs.getUseLiveVariables(), this.mServices, this.mPrefs.computeCounterexample(), this.mPredicateFactory, this.mPredicateUnifier, this.mInterpolationTechnique, managedScript, simplificationTechnique, this.mPrefs.collectInterpolantStatistics());
            }
            case PathInvariants: {
                IIcfg<?> iIcfg = this.mPrefs.getIcfgContainer();
                boolean bl = this.mPrefs.getUseNonlinearConstraints();
                boolean bl2 = this.mPrefs.getUseVarsFromUnsatCore();
                boolean bl3 = this.mPrefs.getUseAbstractInterpretation();
                boolean bl4 = this.mPrefs.getUseWeakestPreconditionForPathInvariants();
                SolverBuilder.SolverSettings solverSettings = this.mPrefs.constructSolverSettings(this.mTaskIdentifier).setUseFakeIncrementalScript(false).setUseExternalSolver(SolverBuilder.ExternalSolver.Z3, 12000L);
                InvariantSynthesisSettings invariantSynthesisSettings = new InvariantSynthesisSettings(solverSettings, bl, bl2, bl3, bl4, true);
                return new InterpolatingTraceCheckPathInvariantsWithFallback(this.mPrecondition, this.mPostcondition, treeMap, this.mCounterexample, this.mPrefs.getCfgSmtToolkit(), assertCodeBlockOrder, this.mServices, this.mPrefs.computeCounterexample(), this.mPredicateFactory, this.mPredicateUnifier, invariantSynthesisSettings, simplificationTechnique, iIcfg, this.mPrefs.collectInterpolantStatistics());
            }
            case PDR: {
                return new Pdr(this.mServices, this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID), (ITraceCheckPreferences)this.mPrefs, this.mPredicateUnifier, this.mPrecondition, this.mPostcondition, this.mCounterexample.getWord().asList(), this.mTransitionClazz);
            }
        }
        throw new UnsupportedOperationException("Unsupported interpolation technique: " + String.valueOf(this.mInterpolationTechnique));
    }

    private ManagedScript constructManagedScript() throws AssertionError {
        if (this.mInterpolationTechnique == InterpolationTechnique.PathInvariants) {
            return null;
        }
        if (this.mPrefs.getUseSeparateSolverForTracechecks()) {
            SolverBuilder.SolverSettings solverSettings = this.mPrefs.constructSolverSettings(this.mTaskIdentifier);
            return this.mPrefs.getCfgSmtToolkit().createFreshManagedScript(this.mServices, solverSettings);
        }
        return this.mPrefs.getCfgSmtToolkit().getManagedScript();
    }

    @Override
    public Collection<QualifiedTracePredicates> getPerfectInterpolantSequences() {
        Object t = this.getOrConstruct();
        if (t instanceof TraceCheckSpWp) {
            TraceCheckSpWp traceCheckSpWp = (TraceCheckSpWp)t;
            ArrayList<QualifiedTracePredicates> arrayList = new ArrayList<QualifiedTracePredicates>();
            if (traceCheckSpWp.wasForwardPredicateComputationRequested() && traceCheckSpWp.isForwardSequencePerfect()) {
                arrayList.add(new QualifiedTracePredicates(traceCheckSpWp.getForwardIpp(), traceCheckSpWp.getClass(), true));
            }
            if (traceCheckSpWp.wasBackwardSequenceConstructed() && traceCheckSpWp.isBackwardSequencePerfect()) {
                arrayList.add(new QualifiedTracePredicates(traceCheckSpWp.getBackwardIpp(), traceCheckSpWp.getClass(), true));
            }
            return arrayList;
        }
        return super.getPerfectInterpolantSequences();
    }

    @Override
    public Collection<QualifiedTracePredicates> getImperfectInterpolantSequences() {
        Object t = this.getOrConstruct();
        if (t instanceof TraceCheckSpWp) {
            TraceCheckSpWp traceCheckSpWp = (TraceCheckSpWp)t;
            ArrayList<QualifiedTracePredicates> arrayList = new ArrayList<QualifiedTracePredicates>();
            if (traceCheckSpWp.wasForwardPredicateComputationRequested() && !traceCheckSpWp.isForwardSequencePerfect()) {
                arrayList.add(new QualifiedTracePredicates(traceCheckSpWp.getForwardIpp(), traceCheckSpWp.getClass(), false));
            }
            if (traceCheckSpWp.wasBackwardSequenceConstructed() && !traceCheckSpWp.isBackwardSequencePerfect()) {
                arrayList.add(new QualifiedTracePredicates(traceCheckSpWp.getBackwardIpp(), traceCheckSpWp.getClass(), false));
            }
            return arrayList;
        }
        return super.getImperfectInterpolantSequences();
    }
}

