/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.ArrayTemplate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.ArrayWrite;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.MapTemplate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.UFTemplate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonTheorySymbolFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class MapEliminationPreAnalysis {
    private final Script mScript;
    private final ManagedScript mManagedScript;
    private final HashRelation<Term, ArrayIndex> mVariablesToIndices;
    private final HashRelation<MapTemplate, ArrayIndex> mMapsToIndices;
    private final HashRelation<ArrayIndex, MapTemplate> mIndicesToMaps;
    private final Set<Doubleton<Term>> mRelatedArays;
    private final Set<String> mUninterpretedFunctions;
    private final Map<ModifiableTransFormula, HashRelation<MapTemplate, ArrayIndex>> mTransFormulasToLocalIndices;
    private final Set<Doubleton<Term>> mDoubletons;

    public MapEliminationPreAnalysis(ManagedScript managedScript, Collection<ModifiableTransFormula> collection) {
        this.mScript = managedScript.getScript();
        this.mManagedScript = managedScript;
        this.mTransFormulasToLocalIndices = new HashMap<ModifiableTransFormula, HashRelation<MapTemplate, ArrayIndex>>();
        this.mVariablesToIndices = new HashRelation();
        this.mMapsToIndices = new HashRelation();
        this.mIndicesToMaps = new HashRelation();
        this.mRelatedArays = new HashSet<Doubleton<Term>>();
        this.mUninterpretedFunctions = new HashSet<String>();
        this.findAllIndices(collection);
        this.mDoubletons = this.getIndexDoubletons(this.mMapsToIndices);
    }

    private void findAllIndices(Collection<ModifiableTransFormula> collection) {
        Object object;
        for (ModifiableTransFormula object22 : collection) {
            this.mTransFormulasToLocalIndices.put(object22, (HashRelation<MapTemplate, ArrayIndex>)new HashRelation());
            this.findIndices(object22);
        }
        UnionFind unionFind = new UnionFind();
        HashMap hashMap = new HashMap();
        for (Doubleton<Term> doubleton : this.mRelatedArays) {
            object = (Term)doubleton.getOneElement();
            Term term = (Term)doubleton.getOtherElement();
            hashMap.put(object, new ArrayTemplate((Term)object, this.mScript));
            hashMap.put(term, new ArrayTemplate(term, this.mScript));
            unionFind.findAndConstructEquivalenceClassIfNeeded(object);
            unionFind.findAndConstructEquivalenceClassIfNeeded((Object)term);
            unionFind.union(object, (Object)term);
        }
        for (Set set : unionFind.getAllEquivalenceClasses()) {
            object = new HashSet();
            for (Term term : set) {
                object.addAll(this.mMapsToIndices.getImage((Object)((MapTemplate)hashMap.get(term))));
            }
            for (Term term : set) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    ArrayIndex arrayIndex = (ArrayIndex)iterator.next();
                    this.mMapsToIndices.addPair((Object)((MapTemplate)hashMap.get(term)), (Object)arrayIndex);
                    this.mIndicesToMaps.addPair((Object)arrayIndex, (Object)((MapTemplate)hashMap.get(term)));
                }
            }
        }
    }

    private void findIndices(ModifiableTransFormula modifiableTransFormula) {
        ArrayIndex arrayIndex;
        Object object;
        Object object2;
        Term term = modifiableTransFormula.getFormula();
        for (MultiDimensionalSelect multiDimensionalSelect : MultiDimensionalSelect.extractSelectDeep((Term)term)) {
            object2 = new ArrayWrite(multiDimensionalSelect.getArray(), this.mScript);
            this.findIndicesArrayWrite((ArrayWrite)object2, modifiableTransFormula);
            this.addArrayAccessToRelation(((ArrayWrite)object2).getOldArray(), multiDimensionalSelect.getIndex(), modifiableTransFormula);
        }
        for (MultiDimensionalSelect multiDimensionalSelect : SmtUtils.extractApplicationTerms((String)"=", (Term)term, (boolean)false)) {
            Term term2;
            if (!((ApplicationTerm)multiDimensionalSelect).getParameters()[0].getSort().isArraySort()) continue;
            object2 = new ArrayWrite((Term)multiDimensionalSelect, this.mScript);
            object = new ArrayWrite(((ArrayWrite)object2).getNewArray(), this.mScript);
            this.findIndicesArrayWrite((ArrayWrite)object2, modifiableTransFormula);
            this.findIndicesArrayWrite((ArrayWrite)object, modifiableTransFormula);
            Term term3 = ((ArrayWrite)object2).getOldArray();
            Term term4 = ((ArrayWrite)object).getOldArray();
            if (!ModifiableTransFormulaUtils.allVariablesAreVisible(term3, modifiableTransFormula) || !ModifiableTransFormulaUtils.allVariablesAreVisible(term4, modifiableTransFormula) || (arrayIndex = ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(this.mManagedScript, modifiableTransFormula, term3)) == (term2 = ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(this.mManagedScript, modifiableTransFormula, term4))) continue;
            this.mRelatedArays.add((Doubleton<Term>)new Doubleton((Object)arrayIndex, (Object)term2));
        }
        for (MultiDimensionalSelect multiDimensionalSelect : new NonTheorySymbolFinder().findNonTheorySymbols(term)) {
            object2 = multiDimensionalSelect.getSymbol();
            if (!(object2 instanceof FunctionSymbol)) continue;
            object = ((FunctionSymbol)object2).getName();
            for (Term term3 : SmtUtils.extractApplicationTerms((String)object, (Term)term, (boolean)false)) {
                arrayIndex = new ArrayIndex(Arrays.asList(((ApplicationTerm)term3).getParameters()));
                this.addCallToRelation((String)object, arrayIndex, modifiableTransFormula);
            }
        }
    }

    private void findIndicesArrayWrite(ArrayWrite arrayWrite, ModifiableTransFormula modifiableTransFormula) {
        for (Pair<ArrayIndex, Term> pair : arrayWrite.getIndexValuePairs()) {
            this.addArrayAccessToRelation(arrayWrite.getOldArray(), (ArrayIndex)pair.getFirst(), modifiableTransFormula);
        }
    }

    private void addArrayAccessToRelation(Term term, ArrayIndex arrayIndex, ModifiableTransFormula modifiableTransFormula) {
        Term term22;
        if (!ModifiableTransFormulaUtils.allVariablesAreVisible(term, modifiableTransFormula) || arrayIndex.size() != SmtUtils.getDimension((Sort)term.getSort())) {
            return;
        }
        for (Term term22 : arrayIndex) {
            if (!SmtUtils.containsFunctionApplication((Term)term22, (String)"store")) continue;
            return;
        }
        term22 = ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(this.mManagedScript, modifiableTransFormula, term);
        this.mTransFormulasToLocalIndices.get(modifiableTransFormula).addPair((Object)new ArrayTemplate(term22, this.mScript), (Object)arrayIndex);
        if (ModifiableTransFormulaUtils.allVariablesAreVisible((List<Term>)arrayIndex, modifiableTransFormula)) {
            Object object2;
            Iterator iterator = new ArrayIndex(ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(this.mManagedScript, modifiableTransFormula, (List<Term>)arrayIndex));
            for (Object object2 : iterator.getFreeVars()) {
                this.mVariablesToIndices.addPair(object2, (Object)iterator);
            }
            object2 = new ArrayTemplate(term22, this.mScript);
            this.mMapsToIndices.addPair(object2, (Object)iterator);
            this.mIndicesToMaps.addPair((Object)iterator, object2);
        }
    }

    private void addCallToRelation(String string, ArrayIndex arrayIndex, ModifiableTransFormula modifiableTransFormula) {
        Object object2;
        if (arrayIndex.isEmpty()) {
            return;
        }
        for (Object object2 : arrayIndex) {
            if (!SmtUtils.containsFunctionApplication((Term)object2, (String)"store")) continue;
            return;
        }
        object2 = new UFTemplate(string, this.mScript);
        this.mTransFormulasToLocalIndices.get(modifiableTransFormula).addPair(object2, (Object)arrayIndex);
        this.mUninterpretedFunctions.add(string);
        if (ModifiableTransFormulaUtils.allVariablesAreVisible((List<Term>)arrayIndex, modifiableTransFormula)) {
            Iterator iterator = new ArrayIndex(ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(this.mManagedScript, modifiableTransFormula, (List<Term>)arrayIndex));
            for (TermVariable termVariable : iterator.getFreeVars()) {
                this.mVariablesToIndices.addPair((Object)termVariable, (Object)iterator);
            }
            this.mMapsToIndices.addPair(object2, (Object)iterator);
            this.mIndicesToMaps.addPair((Object)iterator, object2);
        }
    }

    public Set<MapTemplate> getAllTemplates() {
        return this.mMapsToIndices.getDomain();
    }

    public Set<MapTemplate> getTemplate(ArrayIndex arrayIndex) {
        return this.mIndicesToMaps.getImage((Object)arrayIndex);
    }

    public Set<ArrayIndex> getIndices(MapTemplate mapTemplate) {
        return this.mMapsToIndices.getImage((Object)mapTemplate);
    }

    public Set<ArrayIndex> getIndicesWithVariable(Term term) {
        return this.mVariablesToIndices.getImage((Object)term);
    }

    public HashRelation<MapTemplate, ArrayIndex> getLocalIndices(ModifiableTransFormula modifiableTransFormula) {
        return this.mTransFormulasToLocalIndices.get(modifiableTransFormula);
    }

    public Stream<Term> findMapReads(Term term) {
        Stream<ApplicationTerm> stream = SmtUtils.extractApplicationTerms((String)"select", (Term)term, (boolean)true).stream().filter(applicationTerm -> !applicationTerm.getSort().isArraySort());
        Stream stream2 = this.mUninterpretedFunctions.stream().flatMap(string -> SmtUtils.extractApplicationTerms((String)string, (Term)term, (boolean)true).stream());
        return Stream.concat(stream, stream2);
    }

    public Set<Doubleton<Term>> getIndexDoubletons(HashRelation<MapTemplate, ArrayIndex> hashRelation) {
        HashSet<Doubleton<Term>> hashSet = new HashSet<Doubleton<Term>>();
        for (MapTemplate mapTemplate : hashRelation.getDomain()) {
            Set set = hashRelation.getImage((Object)mapTemplate);
            ArrayIndex[] arrayIndexArray = set.toArray(new ArrayIndex[set.size()]);
            int n = 0;
            while (n < arrayIndexArray.length) {
                int n2 = n + 1;
                while (n2 < arrayIndexArray.length) {
                    ArrayIndex arrayIndex = arrayIndexArray[n];
                    ArrayIndex arrayIndex2 = arrayIndexArray[n2];
                    int n3 = 0;
                    while (n3 < arrayIndex.size()) {
                        Term term;
                        Term term2 = arrayIndex.get(n3);
                        if (term2 != (term = arrayIndex2.get(n3))) {
                            hashSet.add((Doubleton<Term>)new Doubleton((Object)term2, (Object)term));
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return hashSet;
    }

    public Set<Doubleton<Term>> getAllDoubletons() {
        return this.mDoubletons;
    }
}

