/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

public final class CopySubnet<LETTER, PLACE> {
    private final IPetriNet<LETTER, PLACE> mSuperNet;
    private final boolean mKeepSuccessorPlaces;
    private final Set<Transition<LETTER, PLACE>> mTransitionSubset;
    private final BoundedPetriNet<LETTER, PLACE> mResult;

    private CopySubnet(AutomataLibraryServices automataLibraryServices, IPetriNet<LETTER, PLACE> iPetriNet, Set<Transition<LETTER, PLACE>> set, Set<LETTER> set2, boolean bl) {
        this.mSuperNet = iPetriNet;
        this.mKeepSuccessorPlaces = bl;
        this.mTransitionSubset = set;
        this.mResult = new BoundedPetriNet(automataLibraryServices, set2, false);
        this.copySubnet();
    }

    public static <LETTER, PLACE> BoundedPetriNet<LETTER, PLACE> copy(AutomataLibraryServices automataLibraryServices, IPetriNet<LETTER, PLACE> iPetriNet, Set<Transition<LETTER, PLACE>> set, Set<LETTER> set2, boolean bl) {
        return new CopySubnet<LETTER, PLACE>(automataLibraryServices, iPetriNet, set, set2, bl).getResult();
    }

    public static <LETTER, PLACE> BoundedPetriNet<LETTER, PLACE> copy(AutomataLibraryServices automataLibraryServices, IPetriNet<LETTER, PLACE> iPetriNet, Set<Transition<LETTER, PLACE>> set, Set<LETTER> set2) {
        return CopySubnet.copy(automataLibraryServices, iPetriNet, set, set2, false);
    }

    public static <LETTER, PLACE> BoundedPetriNet<LETTER, PLACE> copy(AutomataLibraryServices automataLibraryServices, IPetriNet<LETTER, PLACE> iPetriNet, Set<Transition<LETTER, PLACE>> set) {
        return CopySubnet.copy(automataLibraryServices, iPetriNet, set, iPetriNet.getAlphabet());
    }

    public BoundedPetriNet<LETTER, PLACE> getResult() {
        return this.mResult;
    }

    private void copySubnet() {
        this.requiredPlaces().forEach(this::rebuildPlace);
        this.mTransitionSubset.forEach(this::rebuildTransition);
    }

    private void rebuildPlace(PLACE PLACE) {
        boolean bl;
        boolean bl2 = this.mSuperNet.getInitialPlaces().contains(PLACE);
        boolean bl3 = this.mResult.addPlace(PLACE, bl2, bl = this.mSuperNet.getAcceptingPlaces().contains(PLACE));
        if (!bl3) {
            throw new AssertionError((Object)("Must not add place twice: " + String.valueOf(PLACE)));
        }
    }

    private void rebuildTransition(Transition<LETTER, PLACE> transition) {
        Set set = DataStructureUtils.intersection(transition.getSuccessors(), this.mResult.getPlaces());
        this.mResult.addTransition(transition.getSymbol(), transition.getPredecessors(), ImmutableSet.of((Set)set));
    }

    private Set<PLACE> requiredPlaces() {
        HashSet<PLACE> hashSet = new HashSet<PLACE>();
        for (Transition<LETTER, PLACE> transition : this.mTransitionSubset) {
            hashSet.addAll((Collection<PLACE>)transition.getPredecessors());
            if (!this.mKeepSuccessorPlaces) continue;
            hashSet.addAll((Collection<PLACE>)transition.getSuccessors());
        }
        this.acceptingSuccPlaces().forEach(hashSet::add);
        this.alwaysAcceptingPlaces().forEach(hashSet::add);
        return hashSet;
    }

    private Stream<PLACE> acceptingSuccPlaces() {
        return this.mSuperNet.getAcceptingPlaces().stream().filter(object -> DataStructureUtils.haveNonEmptyIntersection(this.mSuperNet.getPredecessors(object), this.mTransitionSubset));
    }

    private Stream<PLACE> alwaysAcceptingPlaces() {
        return CopySubnet.acceptingInitialPlaces(this.mSuperNet).filter(object -> DataStructureUtils.haveEmptyIntersection(this.mSuperNet.getSuccessors(object), this.mTransitionSubset));
    }

    private static <LETTER, PLACE> Stream<PLACE> acceptingInitialPlaces(IPetriNet<LETTER, PLACE> iPetriNet) {
        return iPetriNet.getAcceptingPlaces().stream().filter(iPetriNet.getInitialPlaces()::contains);
    }
}

