/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.walker;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.walker.SCC;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class Tarjan {
    private HashMap<IcfgLocation, VerticeDecorator> mVerticeIndices;
    private HashSet<IcfgLocation> mUnfinishedVertices;
    private int mCurrentIndex;
    private Stack<IcfgLocation> mCurrentComponent;
    private LinkedList<SCC> mComponents;
    private HashSet<IcfgEdge> mForbiddenEdges;

    public Tarjan() {
        this.init();
    }

    public Tarjan(List<IcfgEdge> list) {
        this.init();
        this.mForbiddenEdges.addAll(list);
    }

    private void init() {
        this.mVerticeIndices = new HashMap();
        this.mUnfinishedVertices = new HashSet();
        this.mCurrentIndex = 0;
        this.mCurrentComponent = new Stack();
        this.mComponents = new LinkedList();
        this.mForbiddenEdges = new HashSet();
    }

    public LinkedList<SCC> computeStronglyConnectedComponents(IcfgLocation icfgLocation) {
        if (!this.mComponents.isEmpty()) {
            this.init();
        }
        this.computeVertices(icfgLocation);
        for (IcfgLocation icfgLocation2 : this.mUnfinishedVertices) {
            VerticeDecorator verticeDecorator = this.mVerticeIndices.get(icfgLocation2);
            if (verticeDecorator.index != -1) continue;
            this.computeComponents(icfgLocation2, verticeDecorator);
        }
        return this.mComponents;
    }

    private void computeVertices(IcfgLocation icfgLocation) {
        if (this.mUnfinishedVertices.contains(icfgLocation)) {
            return;
        }
        this.mUnfinishedVertices.add(icfgLocation);
        this.mVerticeIndices.put(icfgLocation, new VerticeDecorator());
        for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
            if (this.mForbiddenEdges.contains(icfgEdge)) continue;
            this.computeVertices((IcfgLocation)icfgEdge.getTarget());
        }
    }

    private void computeComponents(IcfgLocation icfgLocation, VerticeDecorator verticeDecorator) {
        verticeDecorator.index = this.mCurrentIndex;
        verticeDecorator.lowlink = this.mCurrentIndex++;
        this.mCurrentComponent.push(icfgLocation);
        for (Object object : icfgLocation.getOutgoingEdges()) {
            if (!this.isAdmissible((IcfgEdge)object)) continue;
            IcfgLocation icfgLocation2 = (IcfgLocation)object.getTarget();
            VerticeDecorator verticeDecorator2 = this.mVerticeIndices.get(icfgLocation2);
            if (verticeDecorator2.index == -1) {
                this.computeComponents(icfgLocation2, verticeDecorator2);
                verticeDecorator.lowlink = Math.min(verticeDecorator.lowlink, verticeDecorator2.lowlink);
                continue;
            }
            if (!this.mCurrentComponent.contains(icfgLocation2)) continue;
            verticeDecorator.lowlink = Math.min(verticeDecorator.lowlink, verticeDecorator2.index);
        }
        if (verticeDecorator.lowlink == verticeDecorator.index) {
            Object object;
            object = new SCC();
            IcfgLocation icfgLocation3 = null;
            while (icfgLocation3 != icfgLocation) {
                icfgLocation3 = this.mCurrentComponent.pop();
                ((SCC)object).add(icfgLocation3);
            }
            this.mComponents.add((SCC)object);
        }
    }

    private boolean isAdmissible(IcfgEdge icfgEdge) {
        if (icfgEdge instanceof Summary) {
            return false;
        }
        return !this.mForbiddenEdges.contains(icfgEdge);
    }

    private static final class VerticeDecorator {
        public int index = -1;
        public int lowlink = -1;

        VerticeDecorator() {
        }
    }
}

