/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class RewriteEqualityTransformer
extends TermTransformer {
    private static final Set<String> SUPPORTED_SORTS = new HashSet<String>(Arrays.asList("Int", "Real"));
    private final Script mScript;

    public RewriteEqualityTransformer(Script script) {
        assert (script != null);
        this.mScript = script;
    }

    protected void convert(Term term) {
        if (!(term instanceof ApplicationTerm)) {
            super.convert(term);
            return;
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        String string = applicationTerm.getFunction().getName();
        if (!"=".equals(string) && !"distinct".equals(string)) {
            super.convert(term);
            return;
        }
        String string2 = applicationTerm.getParameters()[0].getSort().getName();
        if (!SUPPORTED_SORTS.contains(string2)) {
            this.setResult(term);
            return;
        }
        if ("=".equals(string)) {
            assert (applicationTerm.getParameters().length == 2) : "equality with more than two parameters not yet supported";
            Term term2 = this.mScript.term("<=", applicationTerm.getParameters());
            Term term3 = this.mScript.term(">=", applicationTerm.getParameters());
            this.setResult(this.mScript.term("and", new Term[]{term2, term3}));
        } else if ("distinct".equals(string)) {
            assert (applicationTerm.getParameters().length == 2) : "distinct with more than two parameters not yet supported";
            Term term4 = this.mScript.term("<", applicationTerm.getParameters());
            Term term5 = this.mScript.term(">", applicationTerm.getParameters());
            this.setResult(this.mScript.term("or", new Term[]{term4, term5}));
        }
    }
}

