/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitvecLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CArray;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CStructOrUnion;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionListResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LocalLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.INameHandler;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;

public class CTranslationUtil {
    private CTranslationUtil() {
    }

    public static LocalLValue constructArrayAccessLhs(ILocation iLocation, LocalLValue localLValue, List<Integer> list, TypeSizes typeSizes) {
        CArray cArray = (CArray)localLValue.getCType().getUnderlyingType();
        Expression[] expressionArray = new Expression[list.size()];
        CArray cArray2 = cArray;
        int n = 0;
        while (n < list.size()) {
            CPrimitive cPrimitive = (CPrimitive)cArray.getBound().getCType().getUnderlyingType();
            expressionArray[n] = typeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, new BigInteger(list.get(n).toString()));
            ICType iCType = cArray2.getValueType().getUnderlyingType();
            if (iCType instanceof CArray) {
                cArray2 = (CArray)iCType;
            } else assert (n == list.size() - 1);
            ++n;
        }
        ArrayLHS arrayLHS = ExpressionFactory.constructNestedArrayLHS((ILocation)iLocation, (LeftHandSide)localLValue.getLhs(), (Expression[])expressionArray);
        return new LocalLValue((LeftHandSide)arrayLHS, cArray.getValueType(), null);
    }

    public static LocalLValue constructArrayAccessLhs(ILocation iLocation, LocalLValue localLValue, Integer n, TypeSizes typeSizes) {
        CArray cArray = (CArray)localLValue.getCType().getUnderlyingType();
        CPrimitive cPrimitive = (CPrimitive)cArray.getBound().getCType();
        Expression expression = typeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, new BigInteger(n.toString()));
        ArrayLHS arrayLHS = ExpressionFactory.constructNestedArrayLHS((ILocation)iLocation, (LeftHandSide)localLValue.getLhs(), (Expression[])new Expression[]{expression});
        ICType iCType = cArray.getValueType();
        return new LocalLValue((LeftHandSide)arrayLHS, iCType, null);
    }

    public static boolean isVarlengthArray(CArray cArray, TypeSizes typeSizes) {
        CArray cArray2 = cArray;
        while (true) {
            if (typeSizes.extractIntegerValue(cArray2.getBound()) == null) {
                return true;
            }
            ICType iCType = cArray2.getValueType().getUnderlyingType();
            if (!(iCType instanceof CArray)) break;
            cArray2 = (CArray)iCType;
        }
        return false;
    }

    public static boolean isToplevelVarlengthArray(CArray cArray, TypeSizes typeSizes) {
        return typeSizes.extractIntegerValue(cArray.getBound()) == null;
    }

    public static List<Integer> getConstantDimensionsOfArray(CArray cArray, TypeSizes typeSizes) {
        if (CTranslationUtil.isVarlengthArray(cArray, typeSizes)) {
            throw new IllegalArgumentException("only call this for non-varlength array types");
        }
        CArray cArray2 = cArray;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (true) {
            arrayList.add(Integer.parseUnsignedInt(typeSizes.extractIntegerValue(cArray2.getBound()).toString()));
            ICType iCType = cArray2.getValueType().getUnderlyingType();
            if (!(iCType instanceof CArray)) break;
            cArray2 = (CArray)iCType;
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static boolean isAggregateType(ICType iCType) {
        ICType iCType2 = iCType.getUnderlyingType();
        return iCType2 instanceof CStructOrUnion && ((CStructOrUnion)iCType2).isStructOrUnion() == CStructOrUnion.StructOrUnion.STRUCT || iCType2 instanceof CArray;
    }

    public static boolean isAggregateOrUnionType(ICType iCType) {
        ICType iCType2 = iCType.getUnderlyingType();
        return CTranslationUtil.isAggregateType(iCType2) || CTranslationUtil.isUnionType(iCType2);
    }

    private static boolean isUnionType(ICType iCType) {
        ICType iCType2 = iCType.getUnderlyingType();
        return iCType2 instanceof CStructOrUnion && ((CStructOrUnion)iCType2).isStructOrUnion() == CStructOrUnion.StructOrUnion.UNION;
    }

    public static int getConstantFirstDimensionOfArray(CArray cArray, TypeSizes typeSizes) {
        RValue rValue = cArray.getBound();
        BigInteger bigInteger = typeSizes.extractIntegerValue(rValue);
        if (bigInteger == null) {
            throw new IllegalArgumentException("only call this for non-varlength first dimension types");
        }
        if (bigInteger.equals(BigInteger.valueOf(-1234567L))) {
            throw new IllegalArgumentException("This array type is incomplete! Cannot extract actual dimensions.");
        }
        int n = Integer.parseUnsignedInt(bigInteger.toString());
        return n;
    }

    public static ExpressionResult convertExpressionListToExpressionResultIfNecessary(ExpressionResultTransformer expressionResultTransformer, ILocation iLocation, Result result, IASTNode iASTNode) {
        assert (result instanceof ExpressionListResult || result instanceof ExpressionResult);
        if (result instanceof ExpressionResult) {
            return (ExpressionResult)result;
        }
        ExpressionListResult expressionListResult = (ExpressionListResult)result;
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        for (ExpressionResult expressionResult : expressionListResult.getList()) {
            expressionResultBuilder.addAllExceptLrValue(expressionResultTransformer.switchToRValue(expressionResult, iLocation, iASTNode));
        }
        expressionResultBuilder.setLrValue(expressionListResult.getLast().getLrValue());
        return expressionResultBuilder.build();
    }

    public static int findIndexOfStructField(CStructOrUnion cStructOrUnion, String string) {
        int n = 0;
        while (n < cStructOrUnion.getFieldCount()) {
            if (cStructOrUnion.getFieldIds()[n].equals(string)) {
                return n;
            }
            ++n;
        }
        throw new AssertionError((Object)"designator does not occur in struct type");
    }

    public static LocalLValue constructOffHeapStructAccessLhs(ILocation iLocation, LocalLValue localLValue, int n) {
        CStructOrUnion cStructOrUnion = (CStructOrUnion)localLValue.getCType().getUnderlyingType();
        String string = cStructOrUnion.getFieldIds()[n];
        StructLHS structLHS = ExpressionFactory.constructStructAccessLhs((ILocation)iLocation, (LeftHandSide)localLValue.getLhs(), (String)string);
        return new LocalLValue((LeftHandSide)structLHS, cStructOrUnion.getFieldTypes()[n], null);
    }

    public static Expression convertLhsToExpression(LeftHandSide leftHandSide) {
        if (leftHandSide instanceof VariableLHS) {
            VariableLHS variableLHS = (VariableLHS)leftHandSide;
            return ExpressionFactory.constructIdentifierExpression((ILocation)variableLHS.getLoc(), (BoogieType)((BoogieType)variableLHS.getType()), (String)variableLHS.getIdentifier(), (DeclarationInformation)variableLHS.getDeclarationInformation());
        }
        if (leftHandSide instanceof ArrayLHS) {
            ArrayLHS arrayLHS = (ArrayLHS)leftHandSide;
            Expression expression = CTranslationUtil.convertLhsToExpression(arrayLHS.getArray());
            return ExpressionFactory.constructNestedArrayAccessExpression((ILocation)arrayLHS.getLocation(), (Expression)expression, (Expression[])arrayLHS.getIndices());
        }
        if (leftHandSide instanceof StructLHS) {
            StructLHS structLHS = (StructLHS)leftHandSide;
            Expression expression = CTranslationUtil.convertLhsToExpression(structLHS.getStruct());
            return ExpressionFactory.constructStructAccessExpression((ILocation)structLHS.getLocation(), (Expression)expression, (String)structLHS.getField());
        }
        throw new AssertionError((Object)("Strange LeftHandSide " + String.valueOf(leftHandSide)));
    }

    public static List<HavocStatement> createHavocsForAuxVars(Set<AuxVarInfo> set) {
        ArrayList<HavocStatement> arrayList = new ArrayList<HavocStatement>();
        for (AuxVarInfo auxVarInfo : set) {
            HavocStatement havocStatement = new HavocStatement(auxVarInfo.getVarDec().getLoc(), new VariableLHS[]{auxVarInfo.getLhs()});
            arrayList.add(havocStatement);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static boolean isAuxVarMapComplete(INameHandler iNameHandler, ExpressionResultBuilder expressionResultBuilder) {
        return CTranslationUtil.isAuxVarMapComplete(iNameHandler, expressionResultBuilder.getDeclarations(), expressionResultBuilder.getAuxVars());
    }

    public static boolean isAuxVarMapComplete(INameHandler iNameHandler, List<Declaration> list, Set<AuxVarInfo> set) {
        boolean bl = true;
        for (Declaration declaration : list) {
            assert (declaration instanceof VariableDeclaration);
            VariableDeclaration variableDeclaration = (VariableDeclaration)declaration;
            assert (variableDeclaration.getVariables().length == 1) : "there are never two auxvars declared in one declaration, right??";
            VarList varList = variableDeclaration.getVariables()[0];
            assert (varList.getIdentifiers().length == 1) : "there are never two auxvars declared in one declaration, right??";
            String string = varList.getIdentifiers()[0];
            if (!iNameHandler.isTempVar(string)) continue;
            boolean bl2 = false;
            for (AuxVarInfo auxVarInfo : set) {
                if (!auxVarInfo.getVarDec().equals(variableDeclaration)) continue;
                bl2 = true;
                break;
            }
            bl &= bl2;
        }
        return bl;
    }

    public static LeftHandSide convertExpressionToLHS(Expression expression) {
        if (expression instanceof IdentifierExpression) {
            IdentifierExpression identifierExpression = (IdentifierExpression)expression;
            return ExpressionFactory.constructVariableLHS((ILocation)identifierExpression.getLoc(), (BoogieType)((BoogieType)identifierExpression.getType()), (String)identifierExpression.getIdentifier(), (DeclarationInformation)identifierExpression.getDeclarationInformation());
        }
        if (expression instanceof ArrayAccessExpression) {
            throw new UnsupportedOperationException("todo: implement");
        }
        if (expression instanceof StructAccessExpression) {
            throw new UnsupportedOperationException("todo: implement");
        }
        throw new IllegalArgumentException("expression cannot be converted to a LeftHandSide: " + String.valueOf(expression));
    }

    @Deprecated
    public static BigInteger computeConstantValue(Expression expression) {
        if (expression instanceof IntegerLiteral) {
            return new BigInteger(((IntegerLiteral)expression).getValue());
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            switch (unaryExpression.getOperator()) {
                case ARITHNEGATIVE: {
                    return CTranslationUtil.computeConstantValue(unaryExpression.getExpr()).negate();
                }
            }
            throw new UnsupportedOperationException("could not compute constant value");
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            switch (binaryExpression.getOperator()) {
                case ARITHDIV: {
                    return CTranslationUtil.computeConstantValue(binaryExpression.getLeft()).divide(CTranslationUtil.computeConstantValue(binaryExpression.getRight()));
                }
                case ARITHMINUS: {
                    return CTranslationUtil.computeConstantValue(binaryExpression.getLeft()).subtract(CTranslationUtil.computeConstantValue(binaryExpression.getRight()));
                }
                case ARITHMOD: {
                    return CTranslationUtil.computeConstantValue(binaryExpression.getLeft()).mod(CTranslationUtil.computeConstantValue(binaryExpression.getRight()));
                }
                case ARITHMUL: {
                    return CTranslationUtil.computeConstantValue(binaryExpression.getLeft()).multiply(CTranslationUtil.computeConstantValue(binaryExpression.getRight()));
                }
                case ARITHPLUS: {
                    return CTranslationUtil.computeConstantValue(binaryExpression.getLeft()).add(CTranslationUtil.computeConstantValue(binaryExpression.getRight()));
                }
            }
            throw new UnsupportedOperationException("could not compute constant value");
        }
        throw new UnsupportedOperationException("could not compute constant value");
    }

    public static BigInteger extractIntegerValue(Expression expression) {
        BigInteger bigInteger = expression instanceof IntegerLiteral ? new BigInteger(((IntegerLiteral)expression).getValue()) : (expression instanceof BitvecLiteral ? new BigInteger(((BitvecLiteral)expression).getValue()) : null);
        return bigInteger;
    }

    public static ICType getValueTypeOfNestedArray(CArray cArray) {
        ICType iCType = cArray.getValueType().getUnderlyingType();
        while (iCType instanceof CArray) {
            iCType = ((CArray)iCType).getValueType().getUnderlyingType();
        }
        return iCType;
    }

    public static Set<ICType> extractNonAggregateNonUnionTypes(ICType iCType) {
        assert (CTranslationUtil.isAggregateOrUnionType(iCType)) : "not an aggregate or union type";
        ICType iCType2 = iCType.getUnderlyingType();
        if (iCType2 instanceof CArray) {
            ICType iCType3 = CTranslationUtil.getValueTypeOfNestedArray((CArray)iCType2).getUnderlyingType();
            if (CTranslationUtil.isAggregateOrUnionType(iCType3)) {
                return CTranslationUtil.extractNonAggregateNonUnionTypes(iCType3);
            }
            return Collections.singleton(iCType3.getUnderlyingType());
        }
        if (iCType2 instanceof CStructOrUnion) {
            HashSet<ICType> hashSet = new HashSet<ICType>();
            ICType[] iCTypeArray = ((CStructOrUnion)iCType2).getFieldTypes();
            int n = iCTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICType iCType4 = iCTypeArray[n2];
                if (CTranslationUtil.isAggregateOrUnionType(iCType4)) {
                    hashSet.addAll(CTranslationUtil.extractNonAggregateNonUnionTypes(iCType4.getUnderlyingType()));
                } else {
                    hashSet.add(iCType4.getUnderlyingType());
                }
                ++n2;
            }
            return hashSet;
        }
        throw new AssertionError();
    }

    public static String getSmtSortStringForBoogieType(BoogieType boogieType) {
        if (boogieType instanceof BoogiePrimitiveType) {
            BoogiePrimitiveType boogiePrimitiveType = (BoogiePrimitiveType)boogieType;
            if (boogiePrimitiveType.getTypeCode() == -2) {
                return "Int";
            }
            if (boogiePrimitiveType.getTypeCode() == -3) {
                return "Real";
            }
            if (boogiePrimitiveType.getTypeCode() == -1) {
                return "Bool";
            }
            if (boogiePrimitiveType.getTypeCode() >= 0) {
                return String.format("(_ BitVec %s)", boogiePrimitiveType.getTypeCode());
            }
            throw new AssertionError((Object)"missing case");
        }
        if (boogieType instanceof BoogieArrayType) {
            BoogieArrayType boogieArrayType = (BoogieArrayType)boogieType;
            String string = CTranslationUtil.getSmtSortStringForBoogieType(boogieArrayType.getValueType());
            int n = boogieArrayType.getIndexCount() - 1;
            while (n >= 0) {
                string = String.format("(Array %s %s)", CTranslationUtil.getSmtSortStringForBoogieType(boogieArrayType.getIndexType(n)), string);
                --n;
            }
            return string;
        }
        throw new AssertionError((Object)"missing case");
    }

    public static String getSmtZeroStringForBoogieType(BoogieType boogieType) {
        if (boogieType instanceof BoogiePrimitiveType) {
            BoogiePrimitiveType boogiePrimitiveType = (BoogiePrimitiveType)boogieType;
            if (boogiePrimitiveType.getTypeCode() == -2) {
                return "0";
            }
            if (boogiePrimitiveType.getTypeCode() == -3) {
                return "0.0";
            }
            if (boogiePrimitiveType.getTypeCode() == -1) {
                return "false";
            }
            if (boogiePrimitiveType.getTypeCode() >= 0) {
                return String.format("(_ bv0 %s)", boogiePrimitiveType.getTypeCode());
            }
            throw new AssertionError((Object)"missing case");
        }
        throw new AssertionError((Object)"missing case");
    }

    public static IASTNode findExpressionHook(IASTNode iASTNode) {
        if (iASTNode instanceof IGNUASTCompoundStatementExpression) {
            IASTCompoundStatement iASTCompoundStatement = ((IGNUASTCompoundStatementExpression)iASTNode).getCompoundStatement();
            IASTStatement iASTStatement = iASTCompoundStatement.getStatements()[iASTCompoundStatement.getStatements().length - 1];
            return CTranslationUtil.findExpressionHook((IASTNode)iASTStatement);
        }
        return iASTNode;
    }

    public static boolean hasAttribute(IASTDeclSpecifier iASTDeclSpecifier, String string) {
        return Arrays.stream(iASTDeclSpecifier.getAttributes()).map(iASTAttribute -> String.valueOf(iASTAttribute.getName())).anyMatch(string::equals);
    }
}

