/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.preprocessor;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.annotation.LTLPropertyCheck;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayStoreExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AtomicStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Axiom;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitVectorAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitvecLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BreakStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ConstDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.EnsuresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GotoStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.JoinStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Label;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LoopInvariantSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ModifiesSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ParentEdge;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.QuantifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RequiresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ReturnStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StringLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructConstructor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Trigger;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WildcardExpression;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.Activator;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieFunctionSignature;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieStructType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.boogie.typechecker.FunctionInfo;
import de.uni_freiburg.informatik.ultimate.boogie.typechecker.ITypeErrorReporter;
import de.uni_freiburg.informatik.ultimate.boogie.typechecker.ProcedureInfo;
import de.uni_freiburg.informatik.ultimate.boogie.typechecker.TypeCheckHelper;
import de.uni_freiburg.informatik.ultimate.boogie.typechecker.TypeManager;
import de.uni_freiburg.informatik.ultimate.boogie.typechecker.TypeParameters;
import de.uni_freiburg.informatik.ultimate.boogie.typechecker.VariableInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.observers.BaseObserver;
import de.uni_freiburg.informatik.ultimate.core.lib.results.TypeErrorResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TypeChecker
extends BaseObserver {
    private TypeManager mTypeManager;
    private HashMap<String, FunctionInfo> mDeclaredFunctions;
    private HashMap<String, ProcedureInfo> mDeclaredProcedures;
    private HashMap<String, VariableInfo> mDeclaredVars;
    private ScopedHashMap<String, VariableInfo> mVarScopes;
    private final Map<String, Set<String>> mProc2ModfiedGlobals = new HashMap<String, Set<String>>();
    private String mCurrentProcedure;
    private final Set<String> mGlobals = new HashSet<String>();
    private Set<String> mInParams;
    private Set<String> mOutParams;
    private Set<String> mLocalVars;
    private final IUltimateServiceProvider mServices;
    private final Map<Expression, BoogieType> mCache;
    private final ILogger mLogger;

    public TypeChecker(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mCache = new HashMap<Expression, BoogieType>();
    }

    private VariableInfo findVariable(String string) {
        VariableInfo variableInfo = (VariableInfo)this.mVarScopes.get((Object)string);
        if (variableInfo == null) {
            return this.mDeclaredVars.get(string);
        }
        return variableInfo;
    }

    private BoogieType typecheckExpression(Expression expression2) {
        TypeErrorReporter typeErrorReporter = new TypeErrorReporter((BoogieASTNode)expression2);
        BoogieType boogieType = this.mCache.get(expression2);
        if (boogieType == null) {
            if (expression2 instanceof BinaryExpression) {
                BinaryExpression binaryExpression = (BinaryExpression)expression2;
                boogieType = TypeCheckHelper.typeCheckBinaryExpression((BinaryExpression.Operator)binaryExpression.getOperator(), (BoogieType)this.typecheckExpression(binaryExpression.getLeft()), (BoogieType)this.typecheckExpression(binaryExpression.getRight()), (ITypeErrorReporter)new TypeErrorReporter((BoogieASTNode)binaryExpression));
            } else if (expression2 instanceof UnaryExpression) {
                UnaryExpression unaryExpression = (UnaryExpression)expression2;
                boogieType = TypeCheckHelper.typeCheckUnaryExpression((UnaryExpression.Operator)unaryExpression.getOperator(), (BoogieType)this.typecheckExpression(unaryExpression.getExpr()), (ITypeErrorReporter)new TypeErrorReporter((BoogieASTNode)expression2));
            } else if (expression2 instanceof BitVectorAccessExpression) {
                BitVectorAccessExpression bitVectorAccessExpression = (BitVectorAccessExpression)expression2;
                BoogieType boogieType2 = this.typecheckExpression(bitVectorAccessExpression.getBitvec());
                boogieType = TypeCheckHelper.typeCheckBitVectorAccessExpression((int)TypeCheckHelper.getBitVecLength((BoogieType)boogieType2), (int)bitVectorAccessExpression.getEnd(), (int)bitVectorAccessExpression.getStart(), (BoogieType)boogieType2, (ITypeErrorReporter)new TypeErrorReporter((BoogieASTNode)expression2));
            } else if (expression2 instanceof StructAccessExpression) {
                StructAccessExpression structAccessExpression = (StructAccessExpression)expression2;
                boogieType = TypeCheckHelper.typeCheckStructAccessExpressionOrLhs((BoogieType)this.typecheckExpression(structAccessExpression.getStruct()).getUnderlyingType(), (String)structAccessExpression.getField(), (ITypeErrorReporter)typeErrorReporter);
            } else if (expression2 instanceof ArrayAccessExpression) {
                ArrayAccessExpression arrayAccessExpression = (ArrayAccessExpression)expression2;
                BoogieType boogieType3 = this.typecheckExpression(arrayAccessExpression.getArray()).getUnderlyingType();
                List list = Arrays.stream(arrayAccessExpression.getIndices()).map(expression -> this.typecheckExpression((Expression)expression)).collect(Collectors.toList());
                boogieType = TypeCheckHelper.typeCheckArrayAccessExpressionOrLhs((BoogieType)boogieType3, list, (ITypeErrorReporter)typeErrorReporter);
            } else if (expression2 instanceof ArrayStoreExpression) {
                ArrayStoreExpression arrayStoreExpression = (ArrayStoreExpression)expression2;
                BoogieType boogieType4 = this.typecheckExpression(arrayStoreExpression.getArray()).getUnderlyingType();
                Expression[] expressionArray = arrayStoreExpression.getIndices();
                ArrayList arrayList = new ArrayList();
                Arrays.stream(expressionArray).forEachOrdered(expression -> {
                    boolean bl = arrayList.add(this.typecheckExpression((Expression)expression));
                });
                assert (arrayList.size() == expressionArray.length);
                BoogieType boogieType5 = this.typecheckExpression(arrayStoreExpression.getValue());
                boogieType = TypeCheckHelper.typeCheckArrayStoreExpression((BoogieType)boogieType4, arrayList, (BoogieType)boogieType5, (ITypeErrorReporter)typeErrorReporter);
            } else if (expression2 instanceof BooleanLiteral) {
                boogieType = BoogieType.TYPE_BOOL;
            } else if (expression2 instanceof IntegerLiteral) {
                boogieType = BoogieType.TYPE_INT;
            } else if (expression2 instanceof RealLiteral) {
                boogieType = BoogieType.TYPE_REAL;
            } else if (expression2 instanceof BitvecLiteral) {
                BitvecLiteral bitvecLiteral = (BitvecLiteral)expression2;
                boogieType = BoogieType.createBitvectorType((int)bitvecLiteral.getLength());
            } else if (expression2 instanceof StructConstructor) {
                StructConstructor structConstructor = (StructConstructor)expression2;
                Expression[] expressionArray = structConstructor.getFieldValues();
                BoogieType[] boogieTypeArray = new BoogieType[expressionArray.length];
                boolean bl = false;
                int n = 0;
                while (n < expressionArray.length) {
                    boogieTypeArray[n] = this.typecheckExpression(expressionArray[n]);
                    bl |= boogieTypeArray[n] == BoogieType.TYPE_ERROR;
                    ++n;
                }
                boogieType = bl ? BoogieType.TYPE_ERROR : BoogieType.createStructType((String[])structConstructor.getFieldIdentifiers(), (BoogieType[])boogieTypeArray);
            } else if (expression2 instanceof IdentifierExpression) {
                IdentifierExpression identifierExpression = (IdentifierExpression)expression2;
                String string = identifierExpression.getIdentifier();
                VariableInfo variableInfo = this.findVariable(string);
                if (variableInfo == null) {
                    this.typeError((BoogieASTNode)expression2, "Undeclared identifier " + string + " in " + String.valueOf(expression2));
                    boogieType = BoogieType.TYPE_ERROR;
                } else {
                    DeclarationInformation declarationInformation = identifierExpression.getDeclarationInformation();
                    if (declarationInformation == null) {
                        identifierExpression.setDeclarationInformation(variableInfo.getDeclarationInformation());
                    } else {
                        TypeChecker.checkExistingDeclarationInformation(string, declarationInformation, variableInfo.getDeclarationInformation());
                    }
                    boogieType = variableInfo.getType().getUnderlyingType();
                }
            } else if (expression2 instanceof FunctionApplication) {
                FunctionApplication functionApplication = (FunctionApplication)expression2;
                String string = functionApplication.getIdentifier();
                FunctionInfo functionInfo = this.mDeclaredFunctions.get(string);
                if (functionInfo == null) {
                    this.typeError((BoogieASTNode)expression2, "Undeclared function " + string + " in " + String.valueOf(expression2));
                    boogieType = BoogieType.TYPE_ERROR;
                } else {
                    BoogieFunctionSignature boogieFunctionSignature = functionInfo.getSignature();
                    BoogieType[] boogieTypeArray = new BoogieType[boogieFunctionSignature.getTypeArgCount()];
                    Expression[] expressionArray = functionApplication.getArguments();
                    if (expressionArray.length != boogieFunctionSignature.getParamCount()) {
                        this.typeError((BoogieASTNode)expression2, "Type check failed (wrong number of arguments): " + String.valueOf(expression2));
                    } else {
                        int n = 0;
                        while (n < expressionArray.length) {
                            BoogieType boogieType6 = this.typecheckExpression(expressionArray[n]);
                            if (!boogieType6.equals((Object)BoogieType.TYPE_ERROR) && !boogieFunctionSignature.getParamType(n).unify(boogieType6, boogieTypeArray)) {
                                this.typeError((BoogieASTNode)expression2, "Type check failed (index " + n + "): " + String.valueOf(expression2));
                            }
                            ++n;
                        }
                    }
                    boogieType = boogieFunctionSignature.getResultType().substitutePlaceholders(boogieTypeArray);
                }
            } else if (expression2 instanceof IfThenElseExpression) {
                IfThenElseExpression ifThenElseExpression = (IfThenElseExpression)expression2;
                BoogieType boogieType7 = this.typecheckExpression(ifThenElseExpression.getCondition());
                BoogieType boogieType8 = this.typecheckExpression(ifThenElseExpression.getThenPart());
                BoogieType boogieType9 = this.typecheckExpression(ifThenElseExpression.getElsePart());
                boogieType = TypeCheckHelper.typeCheckIfThenElseExpression((BoogieType)boogieType7, (BoogieType)boogieType8, (BoogieType)boogieType9, (ITypeErrorReporter)typeErrorReporter);
            } else if (expression2 instanceof QuantifierExpression) {
                VarList varList;
                QuantifierExpression quantifierExpression = (QuantifierExpression)expression2;
                TypeParameters typeParameters = new TypeParameters(quantifierExpression.getTypeParams());
                this.mTypeManager.pushTypeScope(typeParameters);
                DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.QUANTIFIED, null);
                VarList[] varListArray = quantifierExpression.getParameters();
                this.mVarScopes.beginScope();
                VarList[] varListArray2 = varListArray;
                int n = varListArray.length;
                int n2 = 0;
                while (n2 < n) {
                    varList = varListArray2[n2];
                    BoogieType boogieType10 = this.mTypeManager.resolveType(varList.getType());
                    String[] stringArray = varList.getIdentifiers();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String string = stringArray[n4];
                        this.mVarScopes.put((Object)string, (Object)new VariableInfo(true, null, string, boogieType10, declarationInformation));
                        ++n4;
                    }
                    ++n2;
                }
                if (!typeParameters.fullyUsed()) {
                    this.typeError((BoogieASTNode)expression2, "Type args not fully used in variable types: " + String.valueOf(expression2));
                }
                this.typecheckAttributes(quantifierExpression.getAttributes());
                varList = this.typecheckExpression(quantifierExpression.getSubformula());
                if (!varList.equals((Object)BoogieType.TYPE_ERROR) && !varList.equals((Object)BoogieType.TYPE_BOOL)) {
                    this.typeError((BoogieASTNode)expression2, "Type check error in: " + String.valueOf(expression2));
                }
                this.mVarScopes.endScope();
                this.mTypeManager.popTypeScope();
                boogieType = BoogieType.TYPE_BOOL;
            } else if (expression2 instanceof WildcardExpression) {
                boogieType = BoogieType.TYPE_BOOL;
            } else {
                throw new IllegalStateException("Unknown expression node " + String.valueOf(expression2));
            }
            expression2.setType((IBoogieType)boogieType);
            this.mCache.put(expression2, boogieType);
        }
        assert (expression2.getType().equals(boogieType));
        return boogieType;
    }

    private static void checkExistingDeclarationInformation(String string, DeclarationInformation declarationInformation, DeclarationInformation declarationInformation2) {
        if (!declarationInformation.equals((Object)declarationInformation2)) {
            TypeCheckHelper.internalError((String)("Incorrect DeclarationInformation of \"" + string + "\". Expected: " + String.valueOf(declarationInformation2) + "   Found: " + String.valueOf(declarationInformation)));
        }
    }

    private BoogieType typecheckLeftHandSide(LeftHandSide leftHandSide) {
        BoogieType boogieType;
        TypeErrorReporter typeErrorReporter = new TypeErrorReporter((BoogieASTNode)leftHandSide);
        if (leftHandSide instanceof VariableLHS) {
            VariableLHS variableLHS = (VariableLHS)leftHandSide;
            String string = variableLHS.getIdentifier();
            boogieType = this.checkVarModification((BoogieASTNode)leftHandSide, string);
            VariableInfo variableInfo = this.findVariable(string);
            if (variableInfo != null) {
                DeclarationInformation declarationInformation = variableLHS.getDeclarationInformation();
                if (declarationInformation == null) {
                    variableLHS.setDeclarationInformation(variableInfo.getDeclarationInformation());
                } else {
                    TypeChecker.checkExistingDeclarationInformation(string, declarationInformation, variableInfo.getDeclarationInformation());
                }
            }
        } else if (leftHandSide instanceof StructLHS) {
            StructLHS structLHS = (StructLHS)leftHandSide;
            BoogieType boogieType2 = this.typecheckLeftHandSide(structLHS.getStruct()).getUnderlyingType();
            if (!(boogieType2 instanceof BoogieStructType)) {
                if (!boogieType2.equals((Object)BoogieType.TYPE_ERROR)) {
                    this.typeError((BoogieASTNode)leftHandSide, "Type check failed (not a struct): " + String.valueOf(leftHandSide));
                }
                boogieType = BoogieType.TYPE_ERROR;
            } else {
                BoogieStructType boogieStructType = (BoogieStructType)boogieType2;
                boogieType = null;
                int n = 0;
                while (n < boogieStructType.getFieldCount()) {
                    if (boogieStructType.getFieldIds()[n].equals(structLHS.getField())) {
                        boogieType = boogieStructType.getFieldType(n);
                    }
                    ++n;
                }
                if (boogieType == null) {
                    this.typeError((BoogieASTNode)leftHandSide, "Type check failed (field " + structLHS.getField() + " not in struct): " + String.valueOf(leftHandSide));
                    boogieType = BoogieType.TYPE_ERROR;
                }
            }
        } else if (leftHandSide instanceof ArrayLHS) {
            ArrayLHS arrayLHS = (ArrayLHS)leftHandSide;
            BoogieType boogieType3 = this.typecheckLeftHandSide(arrayLHS.getArray()).getUnderlyingType();
            ArrayList<BoogieType> arrayList = new ArrayList<BoogieType>();
            int n = 0;
            while (n < arrayLHS.getIndices().length) {
                arrayList.add(this.typecheckExpression(arrayLHS.getIndices()[n]));
                ++n;
            }
            boogieType = TypeCheckHelper.typeCheckArrayAccessExpressionOrLhs((BoogieType)boogieType3, arrayList, (ITypeErrorReporter)typeErrorReporter);
        } else {
            TypeCheckHelper.internalError((String)("Unknown LHS: " + String.valueOf(leftHandSide)));
            boogieType = BoogieType.TYPE_ERROR;
        }
        leftHandSide.setType((IBoogieType)boogieType);
        return boogieType;
    }

    private void typecheckAttributes(Attribute[] attributeArray) {
        if (attributeArray == null) {
            return;
        }
        Attribute[] attributeArray2 = attributeArray;
        int n = attributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Expression[] expressionArray;
            Attribute attribute = attributeArray2[n2];
            if (attribute instanceof Trigger) {
                expressionArray = ((Trigger)attribute).getTriggers();
            } else if (attribute instanceof NamedAttribute) {
                expressionArray = ((NamedAttribute)attribute).getValues();
            } else {
                throw new IllegalStateException("Unknown Attribute " + String.valueOf(attribute));
            }
            Expression[] expressionArray2 = expressionArray;
            int n3 = expressionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Expression expression = expressionArray2[n4];
                if (!(expression instanceof StringLiteral)) {
                    this.typecheckExpression(expression);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void processVariableDeclaration(VariableDeclaration variableDeclaration) {
        DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.GLOBAL, null);
        VarList[] varListArray = variableDeclaration.getVariables();
        int n = varListArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarList varList = varListArray[n2];
            BoogieType boogieType = this.mTypeManager.resolveType(varList.getType());
            String[] stringArray = varList.getIdentifiers();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string = stringArray[n4];
                this.mDeclaredVars.put(string, new VariableInfo(false, (Declaration)variableDeclaration, string, boogieType, declarationInformation));
                this.mGlobals.add(string);
                ++n4;
            }
            ++n2;
        }
    }

    private void processConstDeclaration(ConstDeclaration constDeclaration) {
        DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.GLOBAL, null);
        VarList varList = constDeclaration.getVarList();
        BoogieType boogieType = this.mTypeManager.resolveType(varList.getType());
        String[] stringArray = varList.getIdentifiers();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.mDeclaredVars.put(string, new VariableInfo(true, (Declaration)constDeclaration, string, boogieType, declarationInformation));
            ++n2;
        }
    }

    private void checkConstDeclaration(ConstDeclaration constDeclaration) {
        ParentEdge[] parentEdgeArray = constDeclaration.getParentInfo();
        if (parentEdgeArray == null) {
            return;
        }
        BoogieType boogieType = (BoogieType)constDeclaration.getVarList().getType().getBoogieType();
        ParentEdge[] parentEdgeArray2 = parentEdgeArray;
        int n = parentEdgeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParentEdge parentEdge = parentEdgeArray2[n2];
            VariableInfo variableInfo = this.mDeclaredVars.get(parentEdge.getIdentifier());
            if (variableInfo == null || !variableInfo.isRigid()) {
                this.typeError((BoogieASTNode)constDeclaration, String.valueOf(constDeclaration) + ": parent is not a const");
            } else if (!(boogieType.equals((Object)variableInfo.getType()) || variableInfo.getType().equals((Object)BoogieType.TYPE_ERROR) || boogieType.equals((Object)BoogieType.TYPE_ERROR))) {
                this.typeError((BoogieASTNode)constDeclaration, String.valueOf(constDeclaration) + ": parent is not of same type");
            }
            ++n2;
        }
    }

    private void processFunctionDeclaration(FunctionDeclaration functionDeclaration) {
        String[] stringArray;
        String string = functionDeclaration.getIdentifier();
        TypeParameters typeParameters = new TypeParameters(functionDeclaration.getTypeParams());
        this.mTypeManager.pushTypeScope(typeParameters);
        VarList[] varListArray = functionDeclaration.getInParams();
        String[] stringArray2 = new String[varListArray.length];
        BoogieType[] boogieTypeArray = new BoogieType[varListArray.length];
        int n = 0;
        while (n < varListArray.length) {
            stringArray = varListArray[n].getIdentifiers();
            if (stringArray.length > 0) {
                stringArray2[n] = stringArray[0];
            }
            boogieTypeArray[n] = this.mTypeManager.resolveType(varListArray[n].getType());
            ++n;
        }
        if (!typeParameters.fullyUsed()) {
            this.typeError((BoogieASTNode)functionDeclaration, "Type args not fully used in function parameter: " + String.valueOf(functionDeclaration));
        }
        String string2 = null;
        stringArray = functionDeclaration.getOutParam().getIdentifiers();
        BoogieType boogieType = this.mTypeManager.resolveType(functionDeclaration.getOutParam().getType());
        if (stringArray.length > 0) {
            string2 = stringArray[0];
        }
        this.mTypeManager.popTypeScope();
        BoogieFunctionSignature boogieFunctionSignature = new BoogieFunctionSignature(functionDeclaration.getTypeParams().length, stringArray2, boogieTypeArray, string2, boogieType);
        this.mDeclaredFunctions.put(string, new FunctionInfo(functionDeclaration, string, typeParameters, boogieFunctionSignature));
    }

    private void processFunctionDefinition(FunctionDeclaration functionDeclaration) {
        if (functionDeclaration.getBody() == null) {
            return;
        }
        String string = functionDeclaration.getIdentifier();
        FunctionInfo functionInfo = this.mDeclaredFunctions.get(string);
        TypeParameters typeParameters = functionInfo.getTypeParameters();
        DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string);
        this.mTypeManager.pushTypeScope(typeParameters);
        BoogieFunctionSignature boogieFunctionSignature = functionInfo.getSignature();
        this.mVarScopes.beginScope();
        int n = boogieFunctionSignature.getParamCount();
        int n2 = 0;
        while (n2 < n) {
            String string2 = boogieFunctionSignature.getParamName(n2);
            if (string2 != null) {
                this.mVarScopes.put((Object)string2, (Object)new VariableInfo(true, null, boogieFunctionSignature.getParamName(n2), boogieFunctionSignature.getParamType(n2), declarationInformation));
            }
            ++n2;
        }
        BoogieType boogieType = this.typecheckExpression(functionDeclaration.getBody());
        if (!boogieType.equals((Object)BoogieType.TYPE_ERROR) && !boogieType.equals((Object)boogieFunctionSignature.getResultType())) {
            this.typeError((BoogieASTNode)functionDeclaration, "Return type of function doesn't match body");
        }
        this.mVarScopes.endScope();
        this.mTypeManager.popTypeScope();
    }

    public void processProcedureDeclaration(Procedure procedure) {
        int n;
        String[] stringArray;
        Object object;
        VarList varList;
        if (procedure.getSpecification() == null) {
            return;
        }
        String string = procedure.getIdentifier();
        TypeParameters typeParameters = new TypeParameters(procedure.getTypeParams());
        this.mTypeManager.pushTypeScope(typeParameters);
        DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, procedure.getIdentifier());
        LinkedList<VariableInfo> linkedList = new LinkedList<VariableInfo>();
        VarList[] varListArray = procedure.getInParams();
        int n2 = varListArray.length;
        int n3 = 0;
        while (n3 < n2) {
            varList = varListArray[n3];
            BoogieType boogieType = this.mTypeManager.resolveType(varList.getType());
            String[] stringArray2 = varList.getIdentifiers();
            int n4 = stringArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                object = stringArray2[n5];
                linkedList.add(new VariableInfo(true, (Declaration)procedure, (String)object, boogieType, declarationInformation));
                ++n5;
            }
            ++n3;
        }
        if (!typeParameters.fullyUsed()) {
            this.typeError((BoogieASTNode)procedure, "Type args not fully used in procedure parameter: " + String.valueOf(procedure));
        }
        varList = new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, procedure.getIdentifier());
        LinkedList<VariableInfo> linkedList2 = new LinkedList<VariableInfo>();
        object = procedure.getOutParams();
        int n6 = ((VarList[])object).length;
        int n7 = 0;
        while (n7 < n6) {
            VarList varList2 = object[n7];
            BoogieType boogieType = this.mTypeManager.resolveType(varList2.getType());
            stringArray = varList2.getIdentifiers();
            n = stringArray.length;
            int n8 = 0;
            while (n8 < n) {
                String string2 = stringArray[n8];
                linkedList2.add(new VariableInfo(false, (Declaration)procedure, string2, boogieType, (DeclarationInformation)varList));
                ++n8;
            }
            ++n7;
        }
        this.mVarScopes.beginScope();
        for (VariableInfo variableInfo : linkedList) {
            this.mVarScopes.put((Object)variableInfo.getName(), (Object)variableInfo);
        }
        for (VariableInfo variableInfo : linkedList2) {
            this.mVarScopes.put((Object)variableInfo.getName(), (Object)variableInfo);
        }
        object = procedure.getInParams();
        n6 = ((VarList[])object).length;
        int n9 = 0;
        while (n9 < n6) {
            BoogieType boogieType;
            VarList varList3 = object[n9];
            if (varList3.getWhereClause() != null && !(boogieType = this.typecheckExpression(varList3.getWhereClause())).equals((Object)BoogieType.TYPE_BOOL) && !boogieType.equals((Object)BoogieType.TYPE_ERROR)) {
                this.typeError((BoogieASTNode)varList3.getWhereClause(), "Where clause is not boolean: " + String.valueOf(varList3.getWhereClause()));
            }
            ++n9;
        }
        object = procedure.getOutParams();
        n6 = ((VarList[])object).length;
        n9 = 0;
        while (n9 < n6) {
            BoogieType boogieType;
            VarList varList4 = object[n9];
            if (varList4.getWhereClause() != null && !(boogieType = this.typecheckExpression(varList4.getWhereClause())).equals((Object)BoogieType.TYPE_BOOL) && !boogieType.equals((Object)BoogieType.TYPE_ERROR)) {
                this.typeError((BoogieASTNode)varList4.getWhereClause(), "Where clause is not boolean: " + String.valueOf(varList4.getWhereClause()));
            }
            ++n9;
        }
        this.mProc2ModfiedGlobals.put(string, new HashSet());
        object = procedure.getSpecification();
        n6 = ((Specification[])object).length;
        n9 = 0;
        while (n9 < n6) {
            VarList varList5 = object[n9];
            if (varList5 instanceof RequiresSpecification) {
                BoogieType boogieType = this.typecheckExpression(((RequiresSpecification)varList5).getFormula());
                if (!boogieType.equals((Object)BoogieType.TYPE_BOOL) && !boogieType.equals((Object)BoogieType.TYPE_ERROR)) {
                    this.typeError((BoogieASTNode)varList5, "Requires clause is not boolean: " + String.valueOf(varList5));
                }
            } else if (varList5 instanceof EnsuresSpecification) {
                BoogieType boogieType = this.typecheckExpression(((EnsuresSpecification)varList5).getFormula());
                if (!boogieType.equals((Object)BoogieType.TYPE_BOOL) && !boogieType.equals((Object)BoogieType.TYPE_ERROR)) {
                    this.typeError((BoogieASTNode)varList5, "Ensures clause is not boolean: " + String.valueOf(varList5));
                }
            } else if (varList5 instanceof ModifiesSpecification) {
                Set<String> set = this.mProc2ModfiedGlobals.get(string);
                stringArray = ((ModifiesSpecification)varList5).getIdentifiers();
                n = stringArray.length;
                int n10 = 0;
                while (n10 < n) {
                    String string3 = stringArray[n10];
                    DeclarationInformation declarationInformation2 = new DeclarationInformation(DeclarationInformation.StorageClass.GLOBAL, null);
                    if (string3.getDeclarationInformation() == null) {
                        string3.setDeclarationInformation(declarationInformation2);
                    } else {
                        TypeChecker.checkExistingDeclarationInformation(string3.getIdentifier(), string3.getDeclarationInformation(), declarationInformation2);
                    }
                    String string4 = string3.getIdentifier();
                    if (this.mGlobals.contains(string4)) {
                        set.add(string4);
                        string3.setType((IBoogieType)this.findVariable(string4).getType());
                    } else {
                        this.typeError((BoogieASTNode)varList5, "Modifies clause contains " + string4 + " which is not a global variable");
                    }
                    ++n10;
                }
            } else {
                TypeCheckHelper.internalError((String)("Unknown Procedure specification: " + String.valueOf(varList5)));
            }
            ++n9;
        }
        this.mVarScopes.endScope();
        this.mTypeManager.popTypeScope();
        ProcedureInfo procedureInfo = new ProcedureInfo(procedure, typeParameters, linkedList.toArray(new VariableInfo[linkedList.size()]), linkedList2.toArray(new VariableInfo[linkedList2.size()]));
        this.mDeclaredProcedures.put(string, procedureInfo);
    }

    private void processLabels(HashSet<String> hashSet, Statement[] statementArray) {
        Statement[] statementArray2 = statementArray;
        int n = statementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray2[n2];
            if (statement instanceof Label) {
                hashSet.add(((Label)statement).getName());
            } else if (statement instanceof IfStatement) {
                this.processLabels(hashSet, ((IfStatement)statement).getThenPart());
                this.processLabels(hashSet, ((IfStatement)statement).getElsePart());
            } else if (statement instanceof WhileStatement) {
                this.processLabels(hashSet, ((WhileStatement)statement).getBody());
            } else if (statement instanceof AtomicStatement) {
                this.processLabels(hashSet, ((AtomicStatement)statement).getBody());
            }
            ++n2;
        }
    }

    private void typecheckStatement(Stack<String> stack, HashSet<String> hashSet, Statement statement) {
        TypeErrorReporter typeErrorReporter = new TypeErrorReporter((BoogieASTNode)statement);
        Statement statement2 = statement;
        Objects.requireNonNull(statement2);
        Statement statement3 = statement2;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AssumeStatement.class, AssertStatement.class, BreakStatement.class, HavocStatement.class, AssignmentStatement.class, GotoStatement.class, Label.class, ReturnStatement.class, IfStatement.class, WhileStatement.class, AtomicStatement.class, CallStatement.class, ForkStatement.class, JoinStatement.class}, (Object)statement3, 0)) {
            case 0: {
                AssumeStatement assumeStatement = (AssumeStatement)statement3;
                BoogieType boogieType = this.typecheckExpression(assumeStatement.getFormula());
                if (!boogieType.equals((Object)BoogieType.TYPE_BOOL) && !boogieType.equals((Object)BoogieType.TYPE_ERROR)) {
                    this.typeError((BoogieASTNode)statement, "Assume is not boolean: " + String.valueOf(statement));
                }
                this.typecheckAttributes((Attribute[])assumeStatement.getAttributes());
                break;
            }
            case 1: {
                AssertStatement assertStatement = (AssertStatement)statement3;
                BoogieType boogieType = this.typecheckExpression(assertStatement.getFormula());
                if (!boogieType.equals((Object)BoogieType.TYPE_BOOL) && !boogieType.equals((Object)BoogieType.TYPE_ERROR)) {
                    this.typeError((BoogieASTNode)statement, "Assert is not boolean: " + String.valueOf(statement));
                }
                this.typecheckAttributes((Attribute[])assertStatement.getAttributes());
                break;
            }
            case 2: {
                BreakStatement breakStatement = (BreakStatement)statement3;
                String string = breakStatement.getLabel();
                if (stack.contains(string == null ? "*" : string)) break;
                this.typeError((BoogieASTNode)statement, "Break label not found: " + String.valueOf(statement));
                break;
            }
            case 3: {
                HavocStatement havocStatement = (HavocStatement)statement3;
                VariableLHS[] variableLHSArray = havocStatement.getIdentifiers();
                int n = variableLHSArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VariableLHS variableLHS = variableLHSArray[n2];
                    this.typecheckLeftHandSide((LeftHandSide)variableLHS);
                    ++n2;
                }
                break;
            }
            case 4: {
                AssignmentStatement assignmentStatement = (AssignmentStatement)statement3;
                LeftHandSide[] leftHandSideArray = assignmentStatement.getLhs();
                Expression[] expressionArray = assignmentStatement.getRhs();
                String[] stringArray = new String[leftHandSideArray.length];
                BoogieType[] boogieTypeArray = new BoogieType[leftHandSideArray.length];
                BoogieType[] boogieTypeArray2 = new BoogieType[expressionArray.length];
                int n = 0;
                while (n < leftHandSideArray.length) {
                    stringArray[n] = TypeCheckHelper.getLeftHandSideIdentifier((LeftHandSide)leftHandSideArray[n]);
                    boogieTypeArray[n] = this.typecheckLeftHandSide(leftHandSideArray[n]);
                    boogieTypeArray2[n] = this.typecheckExpression(expressionArray[n]);
                    ++n;
                }
                TypeCheckHelper.typeCheckAssignStatement((String[])stringArray, (BoogieType[])boogieTypeArray, (BoogieType[])boogieTypeArray2, (ITypeErrorReporter)typeErrorReporter);
                break;
            }
            case 5: {
                GotoStatement gotoStatement = (GotoStatement)statement3;
                String[] stringArray = gotoStatement.getLabels();
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String string = stringArray[n3];
                    if (!hashSet.contains(string)) {
                        this.typeError((BoogieASTNode)statement, "Goto label not found: " + String.valueOf(statement));
                    }
                    ++n3;
                }
                break;
            }
            case 6: {
                Label label = (Label)statement3;
                break;
            }
            case 7: {
                ReturnStatement returnStatement = (ReturnStatement)statement3;
                break;
            }
            case 8: {
                IfStatement ifStatement = (IfStatement)statement3;
                BoogieType boogieType = this.typecheckExpression(ifStatement.getCondition());
                if (!boogieType.equals((Object)BoogieType.TYPE_BOOL) && !boogieType.equals((Object)BoogieType.TYPE_ERROR)) {
                    this.typeError((BoogieASTNode)statement, "Condition is not boolean: " + String.valueOf(statement));
                }
                this.typecheckBlock(stack, hashSet, ifStatement.getThenPart());
                this.typecheckBlock(stack, hashSet, ifStatement.getElsePart());
                break;
            }
            case 9: {
                WhileStatement whileStatement = (WhileStatement)statement3;
                BoogieType boogieType = this.typecheckExpression(whileStatement.getCondition());
                if (!boogieType.equals((Object)BoogieType.TYPE_BOOL) && !boogieType.equals((Object)BoogieType.TYPE_ERROR)) {
                    this.typeError((BoogieASTNode)statement, "Condition is not boolean: " + String.valueOf(statement));
                }
                LoopInvariantSpecification[] loopInvariantSpecificationArray = whileStatement.getInvariants();
                int n = loopInvariantSpecificationArray.length;
                int n4 = 0;
                while (n4 < n) {
                    LoopInvariantSpecification loopInvariantSpecification = loopInvariantSpecificationArray[n4];
                    if (loopInvariantSpecification instanceof LoopInvariantSpecification) {
                        BoogieType boogieType2 = this.typecheckExpression(loopInvariantSpecification.getFormula());
                        if (!boogieType2.equals((Object)BoogieType.TYPE_BOOL) && !boogieType2.equals((Object)BoogieType.TYPE_ERROR)) {
                            this.typeError((BoogieASTNode)statement, "Loop invariant is not boolean: " + String.valueOf(statement));
                        }
                    } else {
                        TypeCheckHelper.internalError((String)("Unknown while specification: " + String.valueOf(loopInvariantSpecification)));
                    }
                    ++n4;
                }
                stack.push("*");
                this.typecheckBlock(stack, hashSet, whileStatement.getBody());
                stack.pop();
                break;
            }
            case 10: {
                AtomicStatement atomicStatement = (AtomicStatement)statement3;
                this.typecheckBlock(stack, hashSet, atomicStatement.getBody());
                break;
            }
            case 11: {
                Specification specification;
                int n;
                VariableLHS[] variableLHSArray;
                VariableLHS[] variableLHSArray2;
                CallStatement callStatement = (CallStatement)statement3;
                ProcedureInfo procedureInfo = this.mDeclaredProcedures.get(callStatement.getMethodName());
                if (procedureInfo == null) {
                    this.typeError((BoogieASTNode)statement, "Calling undeclared procedure " + String.valueOf(callStatement));
                    return;
                }
                this.checkModifiesTransitive(callStatement, callStatement.getMethodName());
                if (callStatement.isForall()) {
                    variableLHSArray = variableLHSArray2 = procedureInfo.getDeclaration().getSpecification();
                    n = variableLHSArray.length;
                    int n5 = 0;
                    while (n5 < n) {
                        specification = variableLHSArray[n5];
                        if (specification instanceof ModifiesSpecification && !specification.isFree()) {
                            this.typeError((BoogieASTNode)statement, "call forall on method with checked modifies: " + String.valueOf(statement));
                            break;
                        }
                        ++n5;
                    }
                }
                variableLHSArray2 = new BoogieType[procedureInfo.getTypeParameters().getCount()];
                specification = procedureInfo.getInParams();
                Expression[] expressionArray = callStatement.getArguments();
                if (expressionArray.length != ((VariableInfo[])specification).length) {
                    this.typeError((BoogieASTNode)statement, "Procedure called with wrong number of arguments: " + String.valueOf(callStatement));
                    return;
                }
                n = 0;
                while (n < expressionArray.length) {
                    if (callStatement.isForall() && expressionArray[n] instanceof WildcardExpression) {
                        expressionArray[n].setType((IBoogieType)specification[n].getType());
                    } else {
                        variableLHSArray = this.typecheckExpression(expressionArray[n]);
                        if (!specification[n].getType().unify((BoogieType)variableLHSArray, (BoogieType[])variableLHSArray2)) {
                            this.typeError((BoogieASTNode)statement, "Wrong parameter type at index " + n + ": " + String.valueOf(callStatement));
                        }
                    }
                    ++n;
                }
                VariableInfo[] variableInfoArray = procedureInfo.getOutParams();
                variableLHSArray = callStatement.getLhs();
                if (variableLHSArray.length != variableInfoArray.length) {
                    this.typeError((BoogieASTNode)statement, "Number of output variables do not match in " + String.valueOf(statement));
                    break;
                }
                int n6 = 0;
                while (n6 < variableLHSArray.length) {
                    int n7 = 0;
                    while (n7 < n6) {
                        if (variableLHSArray[n6].getIdentifier().equals(variableLHSArray[n7].getIdentifier())) {
                            this.typeError((BoogieASTNode)statement, "Variable appears multiple times in assignment: " + String.valueOf(statement));
                        }
                        ++n7;
                    }
                    BoogieType boogieType = this.typecheckLeftHandSide((LeftHandSide)variableLHSArray[n6]);
                    if (!variableInfoArray[n6].getType().unify(boogieType, (BoogieType[])variableLHSArray2)) {
                        this.typeError((BoogieASTNode)statement, "Type mismatch (output parameter " + n6 + ") in " + String.valueOf(statement));
                    }
                    ++n6;
                }
                break;
            }
            case 12: {
                ForkStatement forkStatement = (ForkStatement)statement3;
                ProcedureInfo procedureInfo = this.mDeclaredProcedures.get(forkStatement.getProcedureName());
                if (procedureInfo == null) {
                    this.typeError((BoogieASTNode)statement, "Forking undeclared procedure " + String.valueOf(forkStatement));
                    return;
                }
                this.checkModifiesTransitive(forkStatement, forkStatement.getProcedureName());
                BoogieType[] boogieTypeArray = new BoogieType[procedureInfo.getTypeParameters().getCount()];
                VariableInfo[] variableInfoArray = procedureInfo.getInParams();
                Expression[] expressionArray = forkStatement.getArguments();
                if (expressionArray.length != variableInfoArray.length) {
                    this.typeError((BoogieASTNode)statement, "Procedure forked with wrong number of arguments: " + String.valueOf(forkStatement));
                    return;
                }
                int n = 0;
                while (n < expressionArray.length) {
                    BoogieType boogieType = this.typecheckExpression(expressionArray[n]);
                    if (!variableInfoArray[n].getType().unify(boogieType, boogieTypeArray)) {
                        this.typeError((BoogieASTNode)statement, "Wrong parameter type at index " + n + ": " + String.valueOf(forkStatement));
                    }
                    ++n;
                }
                Expression[] expressionArray2 = forkStatement.getThreadID();
                int n8 = expressionArray2.length;
                int n9 = 0;
                while (n9 < n8) {
                    Expression expression = expressionArray2[n9];
                    this.typecheckExpression(expression);
                    ++n9;
                }
                break;
            }
            case 13: {
                JoinStatement joinStatement = (JoinStatement)statement3;
                Expression[] expressionArray = joinStatement.getThreadID();
                int n = expressionArray.length;
                int n10 = 0;
                while (n10 < n) {
                    Expression expression = expressionArray[n10];
                    if (expression == null) {
                        this.typeError((BoogieASTNode)statement, "Expression " + String.valueOf(expression) + " does not exist.");
                    }
                    this.typecheckExpression(expression);
                    ++n10;
                }
                int n11 = 0;
                while (n11 < joinStatement.getLhs().length) {
                    this.typecheckLeftHandSide((LeftHandSide)joinStatement.getLhs()[n11]);
                    ++n11;
                }
                break;
            }
            default: {
                throw new MatchException(null, null);
            }
        }
    }

    private void typecheckBlock(Stack<String> stack, HashSet<String> hashSet, Statement[] statementArray) {
        int n = 0;
        Statement[] statementArray2 = statementArray;
        int n2 = statementArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Statement statement = statementArray2[n3];
            if (statement instanceof Label) {
                stack.push(((Label)statement).getName());
                ++n;
            } else {
                this.typecheckStatement(stack, hashSet, statement);
                while (n-- > 0) {
                    stack.pop();
                }
            }
            ++n3;
        }
    }

    private BoogieType checkVarModification(BoogieASTNode boogieASTNode, String string) {
        if (this.mInParams.contains(string)) {
            String string2 = "Local variable " + string + " modified in  procedure " + this.mCurrentProcedure + " but is an in-parameter of this procedure";
            this.typeError(boogieASTNode, string2);
            return this.findVariable(string).getType();
        }
        if (this.mOutParams.contains(string)) {
            return this.findVariable(string).getType();
        }
        if (this.mLocalVars.contains(string)) {
            return this.findVariable(string).getType();
        }
        if (this.mGlobals.contains(string)) {
            Set<String> set = this.mProc2ModfiedGlobals.get(this.mCurrentProcedure);
            if (!set.contains(string)) {
                String string3 = "Global variable " + string + " modified in  procedure " + this.mCurrentProcedure + " but not contained in procedures modifies clause.";
                this.typeError(boogieASTNode, string3);
            }
            return this.findVariable(string).getType();
        }
        String string4 = "Variable " + string + " modified in procedure " + this.mCurrentProcedure + " but not declared";
        this.typeError(boogieASTNode, string4);
        return BoogieType.TYPE_ERROR;
    }

    private void checkModifiesTransitive(CallStatement callStatement, String string) {
        this.checkModifiesTransitive((Statement)callStatement, string);
    }

    private void checkModifiesTransitive(ForkStatement forkStatement, String string) {
        this.checkModifiesTransitive((Statement)forkStatement, string);
    }

    private void checkModifiesTransitive(Statement statement, String string) {
        String string2 = this.mCurrentProcedure;
        Set<String> set = this.mProc2ModfiedGlobals.get(string);
        Set<String> set2 = this.mProc2ModfiedGlobals.get(string2);
        for (String string3 : set) {
            if (set2.contains(string3)) continue;
            String string4 = "Procedure " + string + " may modify " + string3 + " procedure " + string2 + " must not modify " + string3 + ". " + String.valueOf(statement) + " calls " + string + ". Modifies not transitive";
            this.typeError((BoogieASTNode)statement, string4);
        }
    }

    private void processBody(Body body, String string) {
        BoogieType boogieType;
        VarList varList;
        int n;
        int n2;
        VarList[] varListArray;
        Object object;
        DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.LOCAL, string);
        this.mVarScopes.beginScope();
        VariableDeclaration[] variableDeclarationArray = body.getLocalVars();
        int n3 = variableDeclarationArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object = variableDeclarationArray[n4];
            varListArray = object.getVariables();
            n2 = varListArray.length;
            n = 0;
            while (n < n2) {
                varList = varListArray[n];
                assert (varList.getType() != null) : "Variable list without type";
                boogieType = this.mTypeManager.resolveType(varList.getType());
                if (boogieType.equals((Object)BoogieType.TYPE_ERROR)) {
                    this.typeError((BoogieASTNode)varList, "VarList has unresolveable type " + String.valueOf(varList.getType()));
                }
                String[] stringArray = varList.getIdentifiers();
                int n5 = stringArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    String string2 = stringArray[n6];
                    this.checkIfAlreadyInOutLocal(varList, string2);
                    this.mLocalVars.add(string2);
                    this.mVarScopes.put((Object)string2, (Object)new VariableInfo(false, (Declaration)object, string2, boogieType, declarationInformation));
                    ++n6;
                }
                ++n;
            }
            ++n4;
        }
        variableDeclarationArray = body.getLocalVars();
        n3 = variableDeclarationArray.length;
        n4 = 0;
        while (n4 < n3) {
            object = variableDeclarationArray[n4];
            varListArray = object.getVariables();
            n2 = varListArray.length;
            n = 0;
            while (n < n2) {
                varList = varListArray[n];
                if (varList.getWhereClause() != null && !(boogieType = this.typecheckExpression(varList.getWhereClause())).equals((Object)BoogieType.TYPE_BOOL) && !boogieType.equals((Object)BoogieType.TYPE_ERROR)) {
                    this.typeError((BoogieASTNode)varList.getWhereClause(), "Where clause is not boolean: " + String.valueOf(object));
                }
                ++n;
            }
            ++n4;
        }
        object = new HashSet();
        this.processLabels((HashSet<String>)object, body.getBlock());
        this.typecheckBlock(new Stack<String>(), (HashSet<String>)object, body.getBlock());
        this.mVarScopes.endScope();
    }

    private void processImplementation(Procedure procedure) {
        String string;
        int n;
        int n2;
        String[] stringArray;
        BoogieType boogieType;
        VarList varList;
        DeclarationInformation declarationInformation;
        DeclarationInformation declarationInformation2;
        boolean bl;
        if (procedure.getBody() == null) {
            return;
        }
        ProcedureInfo procedureInfo = this.mDeclaredProcedures.get(procedure.getIdentifier());
        if (procedureInfo == null) {
            this.typeError((BoogieASTNode)procedure, "Implementation without procedure: " + procedure.getIdentifier());
            return;
        }
        TypeParameters typeParameters = new TypeParameters(procedure.getTypeParams());
        this.mTypeManager.pushTypeScope(typeParameters);
        this.mCurrentProcedure = procedure.getIdentifier();
        this.mInParams = new HashSet<String>();
        this.mOutParams = new HashSet<String>();
        this.mLocalVars = new HashSet<String>();
        boolean bl2 = bl = procedureInfo.getDeclaration() != procedure;
        if (bl) {
            declarationInformation2 = new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, procedure.getIdentifier());
            declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, procedure.getIdentifier());
        } else {
            declarationInformation2 = new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, procedure.getIdentifier());
            declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, procedure.getIdentifier());
        }
        this.mVarScopes.beginScope();
        VariableInfo[] variableInfoArray = procedureInfo.getInParams();
        VariableInfo[] variableInfoArray2 = procedureInfo.getOutParams();
        int n3 = 0;
        VarList[] varListArray = procedure.getInParams();
        int n4 = varListArray.length;
        int n5 = 0;
        while (n5 < n4) {
            varList = varListArray[n5];
            boogieType = this.mTypeManager.resolveType(varList.getType());
            stringArray = varList.getIdentifiers();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                string = stringArray[n];
                if (n3 >= variableInfoArray.length) {
                    this.typeError((BoogieASTNode)varList, "Too many input parameters in " + String.valueOf(procedure));
                } else if (!variableInfoArray[n3++].getType().equals((Object)boogieType)) {
                    this.typeError((BoogieASTNode)varList, "Type differs at parameter " + string + " in " + String.valueOf(procedure));
                }
                this.checkIfAlreadyInOutLocal(varList, string);
                this.mInParams.add(string);
                this.mVarScopes.put((Object)string, (Object)new VariableInfo(true, (Declaration)procedure, string, boogieType, declarationInformation2));
                ++n;
            }
            ++n5;
        }
        if (n3 < variableInfoArray.length) {
            this.typeError((BoogieASTNode)procedure, "Too few input parameters in " + String.valueOf(procedure));
        }
        if (!typeParameters.fullyUsed()) {
            this.typeError((BoogieASTNode)procedure, "Type args not fully used in implementation: " + String.valueOf(procedure));
        }
        n3 = 0;
        varListArray = procedure.getOutParams();
        n4 = varListArray.length;
        n5 = 0;
        while (n5 < n4) {
            varList = varListArray[n5];
            boogieType = this.mTypeManager.resolveType(varList.getType());
            stringArray = varList.getIdentifiers();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                string = stringArray[n];
                if (n3 >= variableInfoArray2.length) {
                    this.typeError((BoogieASTNode)varList, "Too many output parameters in " + String.valueOf(procedure));
                } else if (!variableInfoArray2[n3++].getType().equals((Object)boogieType)) {
                    this.typeError((BoogieASTNode)varList, "Type differs at parameter " + string + " in " + String.valueOf(procedure));
                }
                this.checkIfAlreadyInOutLocal(varList, string);
                this.mOutParams.add(string);
                this.mVarScopes.put((Object)string, (Object)new VariableInfo(false, (Declaration)procedure, string, boogieType, declarationInformation));
                ++n;
            }
            ++n5;
        }
        if (n3 < variableInfoArray2.length) {
            this.typeError((BoogieASTNode)procedure, "Too few output parameters in " + String.valueOf(procedure));
        }
        this.processBody(procedure.getBody(), procedure.getIdentifier());
        this.mVarScopes.endScope();
        this.mTypeManager.popTypeScope();
    }

    private void checkIfAlreadyInOutLocal(VarList varList, String string) {
        if (this.mInParams.contains(string)) {
            this.typeError((BoogieASTNode)varList, string + " already declared as in parameter");
        }
        if (this.mOutParams.contains(string)) {
            this.typeError((BoogieASTNode)varList, string + " already declared as out parameter");
        }
        if (this.mLocalVars.contains(string)) {
            this.typeError((BoogieASTNode)varList, string + " already declared as local variable");
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean process(IElement iElement) {
        if (iElement instanceof Unit) {
            LTLPropertyCheck lTLPropertyCheck;
            void variableDeclaration;
            Unit unit = (Unit)iElement;
            this.mDeclaredVars = new HashMap();
            this.mDeclaredFunctions = new HashMap();
            this.mDeclaredProcedures = new HashMap();
            this.mVarScopes = new ScopedHashMap();
            this.mTypeManager = new TypeManager(unit.getDeclarations(), this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID));
            this.mTypeManager.init();
            Declaration[] declarationArray = unit.getDeclarations();
            int n = declarationArray.length;
            boolean n2 = false;
            while (variableDeclaration < n) {
                lTLPropertyCheck = declarationArray[variableDeclaration];
                if (lTLPropertyCheck instanceof FunctionDeclaration) {
                    this.processFunctionDeclaration((FunctionDeclaration)lTLPropertyCheck);
                } else if (lTLPropertyCheck instanceof VariableDeclaration) {
                    this.processVariableDeclaration((VariableDeclaration)lTLPropertyCheck);
                } else if (lTLPropertyCheck instanceof ConstDeclaration) {
                    this.processConstDeclaration((ConstDeclaration)lTLPropertyCheck);
                }
                ++variableDeclaration;
            }
            lTLPropertyCheck = LTLPropertyCheck.getAnnotation((IElement)unit);
            if (lTLPropertyCheck != null) {
                for (VariableDeclaration entry : lTLPropertyCheck.getGlobalDeclarations()) {
                    this.processVariableDeclaration(entry);
                }
                for (Map.Entry declaration : lTLPropertyCheck.getCheckableAtomicPropositions().entrySet()) {
                    this.typecheckExpression(((LTLPropertyCheck.CheckableExpression)declaration.getValue()).getExpression());
                }
            }
            Declaration[] declarationArray2 = unit.getDeclarations();
            int n3 = declarationArray2.length;
            n = 0;
            while (n < n3) {
                Declaration declaration = declarationArray2[n];
                this.typecheckAttributes(declaration.getAttributes());
                if (declaration instanceof ConstDeclaration) {
                    this.checkConstDeclaration((ConstDeclaration)declaration);
                } else if (declaration instanceof FunctionDeclaration) {
                    this.processFunctionDefinition((FunctionDeclaration)declaration);
                } else if (declaration instanceof Axiom) {
                    this.typecheckExpression(((Axiom)declaration).getFormula());
                } else if (declaration instanceof Procedure) {
                    this.processProcedureDeclaration((Procedure)declaration);
                } else if (declaration instanceof VariableDeclaration) {
                    VarList[] varListArray = ((VariableDeclaration)declaration).getVariables();
                    int n4 = varListArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        BoogieType boogieType;
                        VarList varList = varListArray[n5];
                        if (varList.getWhereClause() != null && !(boogieType = this.typecheckExpression(varList.getWhereClause())).equals((Object)BoogieType.TYPE_BOOL) && !boogieType.equals((Object)BoogieType.TYPE_ERROR)) {
                            this.typeError((BoogieASTNode)varList.getWhereClause(), "Where clause is not boolean: " + String.valueOf(declaration));
                        }
                        ++n5;
                    }
                }
                ++n;
            }
            declarationArray2 = unit.getDeclarations();
            n3 = declarationArray2.length;
            n = 0;
            while (n < n3) {
                Declaration declaration = declarationArray2[n];
                if (declaration instanceof Procedure) {
                    this.processImplementation((Procedure)declaration);
                }
                ++n;
            }
            return false;
        }
        return true;
    }

    private void typeError(BoogieASTNode boogieASTNode, String string) {
        TypeErrorResult typeErrorResult = new TypeErrorResult((IElement)boogieASTNode, Activator.PLUGIN_ID, this.mServices.getBacktranslationService(), string);
        this.mLogger.error((Object)(String.valueOf(boogieASTNode.getLocation()) + ": " + string));
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)typeErrorResult);
        this.mServices.getProgressMonitorService().cancelToolchain();
    }

    public class TypeErrorReporter
    implements ITypeErrorReporter<String> {
        private final BoogieASTNode mReportNode;

        TypeErrorReporter(BoogieASTNode boogieASTNode) {
            this.mReportNode = boogieASTNode;
        }

        public void report(Function<String, String> function) {
            String string = this.mReportNode instanceof Expression ? BoogiePrettyPrinter.print((Expression)((Expression)this.mReportNode)) : (this.mReportNode instanceof Statement ? BoogiePrettyPrinter.print((Statement)((Statement)this.mReportNode)) : this.mReportNode.toString());
            TypeChecker.this.typeError(this.mReportNode, function.apply(string));
        }
    }
}

