/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.loopaccelerator;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Backbone;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Loop;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.LoopAcceleratorLite;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.loopaccelerator.IAccelerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayDeque;
import java.util.Collection;

public class AcceleratorWernerOverapprox
implements IAccelerator {
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final IUltimateServiceProvider mServices;
    private boolean mFoundAcceleration;
    private final IIcfgSymbolTable mSymbolTable;
    private final boolean mIsOverapprox;

    public AcceleratorWernerOverapprox(ILogger iLogger, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, IIcfgSymbolTable iIcfgSymbolTable) {
        this.mLogger = iLogger;
        this.mScript = managedScript;
        this.mServices = iUltimateServiceProvider;
        this.mFoundAcceleration = false;
        this.mSymbolTable = iIcfgSymbolTable;
        this.mIsOverapprox = true;
    }

    @Override
    public UnmodifiableTransFormula accelerateLoop(UnmodifiableTransFormula unmodifiableTransFormula, IcfgLocation icfgLocation) {
        Loop loop = new Loop(icfgLocation, this.mScript);
        loop.setFormula(unmodifiableTransFormula);
        Backbone backbone = new Backbone(unmodifiableTransFormula);
        ArrayDeque<Backbone> arrayDeque = new ArrayDeque<Backbone>();
        arrayDeque.add(backbone);
        loop.setBackbones(arrayDeque);
        loop.addExitCondition(unmodifiableTransFormula);
        UnmodifiableTransFormula unmodifiableTransFormula2 = TransFormulaUtils.computeGuard((UnmodifiableTransFormula)unmodifiableTransFormula, (ManagedScript)this.mScript, (IUltimateServiceProvider)this.mServices);
        loop.setCondition(unmodifiableTransFormula2.getFormula());
        LoopAcceleratorLite loopAcceleratorLite = new LoopAcceleratorLite(this.mScript, this.mServices, this.mLogger, this.mSymbolTable);
        UnmodifiableTransFormula unmodifiableTransFormula3 = loopAcceleratorLite.summarizeLoop(loop);
        Term term = SmtUtils.quantifier((Script)this.mScript.getScript(), (int)0, (Collection)unmodifiableTransFormula3.getAuxVars(), (Term)unmodifiableTransFormula3.getFormula());
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(unmodifiableTransFormula3.getInVars(), unmodifiableTransFormula3.getOutVars(), true, null, true, null, true);
        transFormulaBuilder.setFormula(term);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        unmodifiableTransFormula3 = transFormulaBuilder.finishConstruction(this.mScript);
        this.mFoundAcceleration = true;
        this.mLogger.debug((Object)"Quantified Werner Acceleration");
        return unmodifiableTransFormula3;
    }

    @Override
    public boolean accelerationFinishedCorrectly() {
        return this.mFoundAcceleration;
    }

    @Override
    public boolean isOverapprox() {
        return this.mIsOverapprox;
    }
}

