/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.domain;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.AbstractNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraintFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.FormulaToEqDisjunctiveConstraintConverter;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqSettings;
import de.uni_freiburg.informatik.ultimate.lib.sifa.SymbolicTools;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.EqState;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.StateBasedDomain;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public class EqDomain
extends StateBasedDomain<EqState> {
    private static final boolean DISABLE_WEAK_EQUIVALENCES = true;

    public EqDomain(SymbolicTools symbolicTools, int n, IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, Supplier<IProgressAwareTimer> supplier) {
        super(symbolicTools, n, iLogger, supplier, new EqStateProvider(iUltimateServiceProvider, symbolicTools.getManagedScript()));
    }

    private static class EqStateProvider
    implements StateBasedDomain.IStateProvider<EqState> {
        private final EqConstraintFactory<EqNode> mEqConstraintFactory;
        private final EqNodeAndFunctionFactory mEqFactory;
        private final ManagedScript mManagedScript;
        private final FormulaToEqDisjunctiveConstraintConverter.StoreChainSquisher mTermTransformer;
        private final EqState mTopState;

        public EqStateProvider(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript) {
            this.mManagedScript = managedScript;
            this.mEqFactory = new EqNodeAndFunctionFactory(iUltimateServiceProvider, managedScript, Set.of(), null, Set.of());
            WeqSettings weqSettings = new WeqSettings();
            weqSettings.setDeactivateWeakEquivalences(true);
            this.mEqConstraintFactory = new EqConstraintFactory((AbstractNodeAndFunctionFactory)this.mEqFactory, iUltimateServiceProvider, managedScript, weqSettings, false, Set.of());
            this.mTermTransformer = new FormulaToEqDisjunctiveConstraintConverter.StoreChainSquisher(managedScript);
            this.mTopState = new EqState((EqConstraint<EqNode>)this.mEqConstraintFactory.getEmptyConstraint(false));
        }

        @Override
        public EqState toState(Term[] termArray) {
            Object object;
            EqConstraint eqConstraint = this.mEqConstraintFactory.getEmptyConstraint(true);
            Term[] termArray2 = termArray;
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = termArray2[n2];
                if (object instanceof ApplicationTerm) {
                    ApplicationTerm applicationTerm = (ApplicationTerm)object;
                    String string = applicationTerm.getFunction().getName();
                    Term[] termArray3 = applicationTerm.getParameters();
                    if ("=".equals(string)) {
                        this.handleEquality(termArray3[0], termArray3[1], (EqConstraint<EqNode>)eqConstraint);
                    } else if (List.of("<", ">", "distinct").contains(string)) {
                        this.handleDisequality(termArray3[0], termArray3[1], (EqConstraint<EqNode>)eqConstraint);
                    } else if ("not".equals(string) && SmtUtils.isFunctionApplication((Term)termArray3[0], (String)"=")) {
                        Term[] termArray4 = ((ApplicationTerm)termArray3[0]).getParameters();
                        this.handleDisequality(termArray4[0], termArray4[1], (EqConstraint<EqNode>)eqConstraint);
                    }
                    if (eqConstraint.isInconsistent()) {
                        return new EqState((EqConstraint<EqNode>)this.mEqConstraintFactory.getBottomConstraint());
                    }
                }
                ++n2;
            }
            eqConstraint.freezeIfNecessary();
            object = this.mTermTransformer.getReplacementTermVariables();
            if (!object.isEmpty()) {
                eqConstraint = this.mEqConstraintFactory.projectExistentially((Collection)object, eqConstraint, false);
            }
            return new EqState((EqConstraint<EqNode>)eqConstraint);
        }

        private void handleEquality(Term term, Term term2, EqConstraint<EqNode> eqConstraint) {
            EqNode eqNode;
            EqNode eqNode2;
            ApplicationTerm applicationTerm;
            if (EqStateProvider.isStore(term)) {
                assert (!EqStateProvider.isStore(term2));
                applicationTerm = (ApplicationTerm)term;
                eqNode2 = this.mEqFactory.getOrConstructNode(term2);
                eqNode = this.mEqFactory.getOrConstructNode(applicationTerm.getParameters()[0]);
            } else if (EqStateProvider.isStore(term2)) {
                assert (!EqStateProvider.isStore(term));
                applicationTerm = (ApplicationTerm)term2;
                eqNode2 = this.mEqFactory.getOrConstructNode(term);
                eqNode = this.mEqFactory.getOrConstructNode(applicationTerm.getParameters()[0]);
            } else {
                applicationTerm = null;
                eqNode2 = this.mEqFactory.getOrConstructNode(term);
                eqNode = this.mEqFactory.getOrConstructNode(term2);
            }
            if (applicationTerm == null) {
                eqConstraint.reportEqualityInPlace((IEqNodeIdentifier)eqNode2, (IEqNodeIdentifier)eqNode);
                return;
            }
            EqNode eqNode3 = this.mEqFactory.getOrConstructNode(applicationTerm.getParameters()[1]);
            EqNode eqNode4 = this.mEqFactory.getOrConstructNode(applicationTerm.getParameters()[2]);
            this.mManagedScript.lock((Object)this);
            Term term3 = this.mManagedScript.term((Object)this, "select", new Term[]{eqNode2.getTerm(), applicationTerm.getParameters()[1]});
            this.mManagedScript.unlock((Object)this);
            EqNode eqNode5 = this.mEqFactory.getOrConstructNode(term3);
            eqConstraint.reportWeakEquivalenceInPlace((IEqNodeIdentifier)eqNode5, (IEqNodeIdentifier)eqNode4, (IEqNodeIdentifier)eqNode3);
        }

        private void handleDisequality(Term term, Term term2, EqConstraint<EqNode> eqConstraint) {
            if (EqStateProvider.isStore(term) || EqStateProvider.isStore(term2)) {
                return;
            }
            EqNode eqNode = this.mEqFactory.getOrConstructNode(term);
            EqNode eqNode2 = this.mEqFactory.getOrConstructNode(term2);
            eqConstraint.reportDisequalityInPlace((IEqNodeIdentifier)eqNode, (IEqNodeIdentifier)eqNode2);
        }

        private static boolean isStore(Term term) {
            return SmtUtils.isFunctionApplication((Term)term, (String)"store");
        }

        @Override
        public EqState getTopState() {
            return this.mTopState;
        }

        @Override
        public Term preprocessTerm(Term term) {
            ArrayList<Term> arrayList = new ArrayList<Term>();
            arrayList.add(this.mTermTransformer.transform(term));
            arrayList.addAll(this.mTermTransformer.getReplacementEquations());
            return SmtUtils.and((Script)this.mManagedScript.getScript(), arrayList);
        }
    }
}

